#if HAVE_NETDB_H
#include "../itext.h"
#include "ijp_net.h"

static itext_table_t * _table_data_alloc();
static void _table_data_add(itext_table_t **,itext_table_t **,itext_table_t *);
static int _check_html_key(int,int *,char *);
static int _del_n(char *,int);

void 
_table_data_free(itext_table_t **head,itext_table_t **tail)
{
	itext_table_t *ta,*taa;

	if(*head == NULL) return;

	for(ta = *head;ta!=NULL;ta=taa){
		taa = ta->next;

		if(ta->name != NULL) free(ta->name);
		if(ta->data != NULL && ta->mall == 1) free(ta->data);

		if(ta->head != NULL) _table_data_free(&(ta->head),&(ta->tail));

		free(ta);
	}
	*head = NULL;
	*tail = NULL;
}
static void 
_table_data_add(itext_table_t **head,itext_table_t **tail,itext_table_t *im)
{
	if(*tail){im->next = NULL;im->prev = *tail;(*tail)->next = im; *tail = im;}
        else{im->next = NULL;im->prev = NULL;*tail = im; *head = im;}
}
static itext_table_t * _table_data_alloc()
{
	itext_table_t *tb;

	if((tb = (itext_table_t *)malloc(sizeof(itext_table_t))) == NULL) return NULL;

	tb->name = NULL;
	tb->data = NULL;
	tb->head = NULL;
	tb->tail = NULL;
	tb->mall = 0;
	return tb;
}
static int _check_html_key(int n,int *f,char *key)
{
	if(n == *(key + *f))
		*f += 1;
	else
		*f = 0;

	if(strlen(key) == *f){
		*f = 0;
	       	return 1;
	}
	return 0;
}
static int _del_n(char *buf,int len)
{
	char *p,temp[BUFSIZ];
	int i=0;

	for(p=buf;*p;p++){
		if(*p == '\n') continue;
		temp[i++] = *p;
	}
	temp[i] = '\0';
	strcpy(buf,temp);
	return 0;
}
int itextGetTableData(	itext_table_t **table_head,
			itext_table_t **table_tail,
			char *fname,
			char  *data_str		)
{
	itext_table_t *ta_p,*tr_p,*td_p;

	char *href_key = "<a href=\"";
	char *summary_key = "summary=\"";
	char *table_key = "<table",*table_e_key = "</table";
	char *tr_key = "<tr",*tr_e_key = "</tr";
	char *td_key = "<td",*td_e_key = "</td";
	FILE *fp;
	char buf[BUFSIZ],sum[256],hr[256],*hr_p = NULL;
	int i,s,h,n;
	int href_s = 0,href_e = 0;
	int summary_s = 0,summary_e = 0;
	int table_s = 0,tr_s = 0,td_s = 0;
	int table_e = 0,tr_e = 0,td_e = 0;
	int HREF = 0,SUMMARY = 0,TABLE = 0,TR = 0,TD = 0,KD = 0;

	if(*table_head != NULL) _table_data_free(table_head,table_tail);
	if((fp = fopen(fname,"r")) == NULL) return -1;

	i = 0;
	s = 0;
	h = 0;
	while((n = (int)fgetc(fp)) > 0){
		if(_check_html_key(n,&table_s,table_key)){
			TABLE = 1;

			ta_p = (itext_table_t *)_table_data_alloc();
			if(data_str != NULL) ta_p->data = data_str;
			continue;
		}
		if(_check_html_key(n,&table_e,table_e_key) && TABLE){
			TABLE = 0;
			_table_data_add(table_head,table_tail,ta_p);
			continue;
		}
		if(_check_html_key(n,&summary_s,summary_key) && TABLE){
			SUMMARY = 1;
			continue;
		}
		if(n == '\"' && SUMMARY){
			sum[s] = '\0';
			if((ta_p->name = (char *)malloc(s+2)) != NULL){
				strcpy(ta_p->name,sum);
			}

			s = 0;
			SUMMARY = 0;
			continue;
		}
		if(_check_html_key(n,&tr_s,tr_key) && TABLE){
			TR = 1;

			tr_p = (itext_table_t *)_table_data_alloc();
			continue;
		}
		if(_check_html_key(n,&tr_e,tr_e_key) && TR){
			TR = 0;

			_table_data_add(&(ta_p->head),&(ta_p->tail),tr_p);
			continue;
		}
		if(_check_html_key(n,&td_s,td_key) && TR){
			TD = 1;

			td_p = (itext_table_t *)_table_data_alloc();
			continue;
		}
		if(_check_html_key(n,&td_e,td_e_key) && TD){
			buf[i] = '\0';
			_del_n(buf,i);

			if((td_p->name = (char *)malloc(i+10)) != NULL)
				sprintf(td_p->name,"%s  ",buf);

			if(hr_p != NULL){td_p->data = hr_p;td_p->mall = 1;hr_p = NULL;}

			_table_data_add(&(tr_p->head),&(tr_p->tail),td_p);

			i = 0;
			TD = 0;
			continue;
		}
		if(_check_html_key(n,&href_s,href_key) && TD){
			HREF = 1;
			continue;
		}
		if(n == '\"' && HREF){
			hr[h] = '\0';
			if((hr_p = (char *)malloc(h+2)) != NULL) strcpy(hr_p,hr);
			h = 0;
			HREF = 0;
			continue;
		}
		if(n == '<' && KD == 0){
			KD = 1;
			continue;
		}else if(n == '>' && KD == 1){
			KD = 0;
			continue;
		}
		if(TD && KD == 0) buf[i++] = n;
		if(SUMMARY) sum[s++] = n;
		if(HREF) hr[h++] = n;
	}
	fclose(fp);
	return 0;
}
#endif
