#include "../xjp.h"
#include "xjp_other.h"
#include <unistd.h>
#include <pwd.h>
#define MAX 10

extern Display *disp;
extern my_window_t *main_win;

int other_exec(void *data0,int data1)
{
	int i,pid;
	char *p,*exec,*c_line[MAX],filename[128];

	other_prog_t *op = (other_prog_t *)data0;
	sprintf(filename,"%s/%s/%s",(getpwuid(getuid()))->pw_dir,OTHER_FILE_DIR,op->data);
	if((exec = (char *)malloc(strlen(op->exec)+2)) == NULL){
		fprintf(stderr,"False other_exec() (malloc())\n") ;
		return 1;
	}
	strcpy(exec,op->exec);

	i = 0;
	c_line[i++] = exec;
	for(p=exec;*p;p++){
		if(isspace(*p)){
			*p++ = '\0';
			c_line[i++] = p;
			if(i > MAX - 1){
				fprintf(stderr,"False other_exec().\n");
				return 1;
			}
		}
	}
	*p = '\0';
	c_line[i] = NULL;

	i = 0;
	do{
		if(strcmp(c_line[i],"$@") == 0)
		       	c_line[i] = filename;

	}while(c_line[++i] != NULL);

	if((pid = fork()) < 0){
		fprintf(stderr,"False other_exec() (fork()) \n");
		return 1;
	}
	if(pid == 0){
		execv(c_line[0],c_line);
		exit(1);
	}
	free(exec);
	return 1;
}
int other_function(void *data0,int data1)
{
	sub_window_t *exec_head = NULL, *exec_tail = NULL;
	other_prog_t *ohead,*op;
	char *result;
	int percent = 40;

	ohead = (other_prog_t *)data0;
	xtextOtherExec2Sub(&exec_head,&exec_tail,ohead);
        if((result = (char *)xtextSubWindow(disp,main_win,exec_head,exec_tail,percent,1)) == NULL)
		return -1;
	if(strcmp(result,XJP_CANCEL) == 0 || strcmp(result,XJP_OK) == 0) return 0;
	return 1;
}
int other_win(ICONTENT_T *main_book,xtext_conf_t *xconf)
{
        IOTHER_T *ot, *o_head;
	other_prog_t *op, *op_head;
        sub_window_t *other_head = NULL, *other_tail = NULL;
        char *result;
        int percent = 90;

	if(main_book->o_head == NULL || xconf->other_head == NULL) return 0;
        o_head = main_book->o_head;
	op_head = xconf->other_head;
        xtextOtherData2Sub(&other_head,&other_tail,o_head,op_head);
        if((result = (char *)xtextSubWindow(disp,main_win,other_head,other_tail,percent,0)) == NULL)
		return -1;
	if(strcmp(result,XJP_CANCEL) == 0 || strcmp(result,XJP_OK) == 0) return 0;
        return 1;
}
