#if HAVE_ATEXIT
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include "../itext_file.h"
#include "itext_rast.h"

static void _debug(rast_error_t *);
static void _debug_status(apr_status_t);
static int memory_error(int);

static void _debug(rast_error_t *er)
{
#if DEBUG
	fprintf(stderr,"MES: %s\n",er->message);
#endif
	rast_error_destroy(er);
}
static void _debug_status(apr_status_t status)
{
#if DEBUG
	char buf[1024];
	apr_strerror(status,buf,sizeof(buf));
	fprintf(stderr,"MESSAGE: %s\n",apr_strerror(status,buf,sizeof(buf)));
#endif
}
static int memory_error(int retcode)
{
	abort();
	return -1;
}
int itextCreateRastData(char *path)
{
	apr_pool_t *pool;
	rast_db_create_option_t *options;
	rast_error_t *error;
	rast_property_t iprops[] = {
	{	"filename0",
		RAST_TYPE_STRING,
		RAST_PROPERTY_FLAG_SEARCH | RAST_PROPERTY_FLAG_UNIQUE},
	{	"filename1",
		RAST_TYPE_STRING,
		RAST_PROPERTY_FLAG_TEXT_SEARCH | RAST_PROPERTY_FLAG_FULL_TEXT_SEARCH},
	{	"title",
		RAST_TYPE_STRING,
		RAST_PROPERTY_FLAG_TEXT_SEARCH | RAST_PROPERTY_FLAG_FULL_TEXT_SEARCH},
	{	"person",
		RAST_TYPE_STRING,
		RAST_PROPERTY_FLAG_TEXT_SEARCH | RAST_PROPERTY_FLAG_FULL_TEXT_SEARCH},
	/*
	{	"last_modified",
		RAST_TYPE_DATE,
		RAST_PROPERTY_FLAG_SEARCH},
		*/
	{	"filesize",
		RAST_TYPE_UINT,
		RAST_PROPERTY_FLAG_SEARCH},
};

	apr_initialize();
	atexit(apr_terminate);
	if((error = rast_initialize()) != RAST_OK){
		_debug(error);
		return -1;
	}
	atexit(rast_finalize);
	apr_pool_create_ex(&pool,NULL,memory_error,NULL);
	options = rast_db_create_option_create(pool);
	options->preserve_text = 1;
	options->encoding = "euc_jp";
	options->properties = iprops;
	options->num_properties = 5;
	if((error = rast_db_create(path,options,pool)) != RAST_OK){
		_debug(error);
		return -2;
	}
	return 0;
}
int itextRegisterRastData(char *dbpath,char *fname0,char *fname1,char *ofname,char *title,char *person)
{
	apr_pool_t *pool;
	rast_db_t *db;
	rast_error_t *er;
	apr_finfo_t finfo;
	apr_file_t *file;
	apr_status_t status;
	char *s;
	apr_size_t len;
	apr_time_exp_t last_mod;
	rast_value_t prop[5];
	rast_doc_id_t doc_id;
	rast_property_t *pp;
	int ppp = 1;

	apr_initialize();
	atexit(apr_terminate);
	if((er = rast_initialize()) != RAST_OK){
		_debug(er);
		return -1;
	}
	atexit(rast_finalize);
	apr_pool_create_ex(&pool,NULL,memory_error,NULL);
	if((status = apr_stat(&finfo,ofname,APR_FINFO_SIZE|APR_FINFO_MTIME,pool)) != APR_SUCCESS){
		_debug_status(status);
		return -2;
	}
	if((status = apr_file_open(&file,ofname,APR_READ,APR_OS_DEFAULT,pool)) != APR_SUCCESS){
		_debug_status(status);
		return -3;
	}
	len = finfo.size;
	s = (char *)apr_palloc(pool,len);
	if((status = apr_file_read(file,s,&len)) != APR_SUCCESS){
		_debug_status(status);
		apr_file_close(file);
		return -4;
	}
	apr_file_close(file);
	rast_value_set_string(&prop[0],fname0);
	rast_value_set_string(&prop[1],fname1);
	rast_value_set_string(&prop[2],title);
	rast_value_set_string(&prop[3],person);
	rast_value_set_uint(&prop[4],len);
	if((er = rast_db_open(&db,dbpath,RAST_DB_RDWR,NULL,pool)) != RAST_OK){
		_debug(er);
		return -5;
	}
	if((er = rast_db_register(db,s,len,prop,&doc_id)) != RAST_OK){
		_debug(er);
		rast_db_close(db);
		return -6;
	}
	rast_db_close(db);
	/*
	unlink(ofname);
	*/
	return 0;
}
rast_result_t * itextGetRastData(char *dbpath,char *keyname)
{
	apr_pool_t *pool;
	rast_db_t *db;
	rast_search_option_t *options;
	rast_result_t *result;
	rast_error_t *er;
	char *query = "\" \" ";
	char *prop[1];

	if(dbpath == NULL || keyname == NULL) return NULL;
	prop[0] = keyname;
	apr_initialize();
	atexit(apr_terminate);
	if((er = rast_initialize()) != RAST_OK){
		_debug(er);
		return NULL;
	}
	atexit(rast_finalize);
	apr_pool_create_ex(&pool,NULL,memory_error,NULL);
	if((er = rast_db_open(&db,dbpath,RAST_DB_RDONLY,NULL,pool)) != RAST_OK){
		_debug(er);
		return NULL;
	}
	options = rast_search_option_create(pool);
	options->num_items = RAST_RESULT_ALL_ITEMS;
        options->need_summary = 0;
        options->properties = (const char **)prop;
	options->num_properties = 1;
	options->score_method = RAST_SCORE_METHOD_NONE;
	if((er = rast_db_search(db,query,options,&result,pool)) != RAST_OK){
		rast_db_close(db);
		_debug(er);
		return NULL;
	}
	rast_db_close(db);
	return result;
}
rast_result_t * itextSearchRastData(char *dbpath,char *query)
{
	apr_pool_t *pool;
	rast_db_t *db;
	rast_search_option_t *options;
	rast_result_t *result;
	rast_error_t *er;
	int i;
	const char *prop[] = {
				"filename0",
				"filename1",
				"title",
				"person",
				"filesize"
				};

	apr_initialize();
	atexit(apr_terminate);
	if((er = rast_initialize()) != RAST_OK){
		_debug(er);
		return NULL;
	}
	atexit(rast_finalize);
	apr_pool_create_ex(&pool,NULL,memory_error,NULL);
	if((er = rast_db_open(&db,dbpath,RAST_DB_RDONLY,NULL,pool)) != RAST_OK){
		_debug(er);
		return NULL;
	}
	options = rast_search_option_create(pool);
	options->num_items = RAST_RESULT_ALL_ITEMS;
        options->need_summary = 1;
	options->summary_nchars = 40;
        options->properties = prop;
	options->num_properties = 5;
	if((er = rast_db_search(db,query,options,&result,pool)) != RAST_OK){
		rast_db_close(db);
		_debug(er);
		return NULL;
	}
	rast_db_close(db);
	return result;
}
#endif
