#if HAVE_ATEXIT
#include <stdio.h>
#include <stdlib.h>
#include "../itext.h"
#include "../itext_file.h"

#include <zlib.h>
#include "../src/unzip/unzip.h"
#define BUF_SIZE 8192
static int _txt_file(char *file_path,char *o_txt)
{
	FILE *fp,*op;
	iconv_t icon;
	unsigned char *buf=NULL, *euc=NULL, *tmp=NULL;
	int len,size,tmp_size=0;

	if((fp = fopen(file_path,"r")) == NULL) return -1;
	if((op = fopen(o_txt,"w")) == NULL) return -1;
	icon = itextConvOpen(fp,NULL);

	if(itextBufferAlloc(&buf,&euc,BUF_SIZE) < 0) return -1;

	fseek(fp,0L,SEEK_SET);
	while(fgets(buf,BUF_SIZE,fp) != NULL){
		size = strlen(buf);
		if(itextBufferOver(buf,size,BUF_SIZE)){
			if(itextBufferAlloc(&tmp,&euc,tmp_size += BUF_SIZE*2) < 0)
			       	return -1;
			sprintf(tmp,"%s%s",tmp,buf);
			continue;
		}
		if(tmp != NULL)   size = itextBufferCat(&tmp,&buf,&euc,&tmp_size);

		if(icon == NULL){
			fprintf(op,"%s",buf);
		}else{
			len = itextConvKanjiCode(icon,euc,buf,size);
			fprintf(op,"%s",euc);
		}
	}
	fclose(fp);
	fclose(op);
	free(buf);
	free(euc);

	return 0;
}
int itextGetRastFile(char *file_path,char *o_txt)
{
	ftype_t code;

	code = itextCheckFileType(file_path);
	if(code == F_ZIP){
		IOTHER_T *ot,*ott,*ot_h=NULL;
		char *de_txt=NULL;

		if(itextUnZipFile(file_path,&de_txt,&ot_h) < 0) return -1;
		if(_txt_file(de_txt,o_txt) < 0) return -1;

		unlink(de_txt);
		if(de_txt!=NULL)free(de_txt);
		for(ot=ot_h;ot!=NULL;ot=ott){
			ott = ot->next;
			unlink(ot->fname);
			free(ot);
		}

	}else if(code == F_TXT){
		if(_txt_file(file_path,o_txt) < 0) return -1;

	}else{
		return -1;
	}

	return 0;
}
#endif
