#if HAVE_ATEXIT
#include "xjp_rast.h"
#include "itext_rast.h"
#include "unistd.h"
#include "../xjp.h"

extern Display *disp;
extern my_window_t *main_win;

int rast_add(void *data0,int data1)
{
	IBOOK_T *book;
	int pid;

	if(data0 == NULL) return 0;
	book = (IBOOK_T *)data0;
	if(book->dbpath == NULL || book->bookdir == NULL) return 1;
	if((pid = fork()) < 0){
		fprintf(stderr,"False rast_exec()(fork())\n");
		return 1;
	}
	if(pid == 0){
		execlp(		XJP_RAST_NAME,XJP_RAST_NAME,
				"-a",SELECTOR_FONT_NAME,
				"-b",book->dbpath,
				"-c",SELECTOR_BACKGROUND_COLOR,
				"-d",book->bookdir,
				"-e",SELECTOR_FOREGROUND_COLOR,
				NULL					);
		exit(1);
	}
	return 1;
}
int rast_win_reg(IBOOK_T *save_book)
{
	char *result;

	sub_window_t *shead = NULL, *stail = NULL;

	if(save_book == NULL) return 0;
	xtextRMenuData2Sub(&shead,&stail,save_book);
	if((result = (char *)xtextSubWindow(disp,main_win,shead,stail,80,1)) == NULL)
		return -1;
	if(strcmp(result,XJP_CANCEL) == 0 || strcmp(result,XJP_OK) == 0) return 0;
	return 1;
}
int rast_search_data(void *data0,int data1)
{
	IBOOK_T *bhead=NULL, *btail=NULL, *bh;
	rast_result_t *rast;
	char *result,*dbpath;
	int i,percent=80;

	if(data0 == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[21]);
	       	return 0;
	}
	if(data1 != 0) percent = (int)data1;
	dbpath = (char *)data0;
	if((result = (char *)xtextInputWindow(disp,main_win,S_NAME2,S_NAME3,percent)) == NULL) return 0;
	if((rast = (rast_result_t *)itextSearchRastData(dbpath,result)) == NULL)
		return 0;
	if(rast->hit_count == 0){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[17]);
		return 0;
	}
	for(i=0;i<rast->num_items;i++){
		if((bh = (IBOOK_T *)book_link_alloc()) == NULL) continue;
		strcpy(bh->fullpath,rast_value_string(rast->items[i]->properties+0));
		sprintf(bh->filename,"SCORE:%d",rast->items[i]->score);
		strcpy(bh->title,rast_value_string(rast->items[i]->properties+2));
		strcpy(bh->person,rast_value_string(rast->items[i]->properties+3));
		bh->summary = rast->items[i]->summary;
		bh->size = 0;
		bh->code = 0;
		bh->fno = 0;
		bh->siori = NULL;
		book_link_add(&bhead,&btail,bh);
        }
	if(select_book_data(bhead,1) == 0){
		book_link_free(&bhead,&btail);
		return 0;
	}
	book_link_free(&bhead,&btail);
	return 1;
}
#endif
