#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <dirent.h>
#include <pwd.h>
#include <locale.h>
#include <X11/Intrinsic.h>
#include <X11/keysym.h>
#if HAVE_LIBXFT
#include <X11/Xft/Xft.h>
#include <X11/extensions/Xrender.h>
#endif
#include <pthread.h>
#include <signal.h>
#define XJP_THREAD
#include "xjp_rast.h"
#include "../xjp.h"
#define XJP_FILE
#include "../xjp_file.h"

extern int opterr;
extern int optind;
extern char *optarg;
extern int getopt(int,char * const * ,const char *);
static pthread_t pth;
static pthread_mutex_t mutex;
static Display *disp;
static Window mwin,pwin;
static XFontSet font;
static GC gc;
static Pixmap ptr_pix[4];
#if HAVE_LIBXFT
static XftFont *xfont;
static XftDraw *xdraw;
static XftColor xcolor;
#endif
static XEvent event;
static char *mes[] = {	"ڳ(s)ۡڰ(p)ۡ(q)",
			"IndexѤ:",
			"IndexԤ:",
			"ե:",
			"RAST-DB :",
			"ե:",
			"̾  :",
			"λ",
			"߽"
						};
static struct {
	int mes_x[9];
	int mes_y[9];
	int mes_xx[9];
}gem;
static void _xinit(char *,char *,char *);
static int  _xloop(XEvent,xjp_rast_data_t *);
static void _xepos(xjp_rast_data_t *);
static void _xdraw(xjp_rast_data_t *);
static xjp_rast_data_t * _bdata(char *,char *);

static void 
_xinit(char *f,char *b,char *c)
{
	Window root;
	Colormap cmap;
	XColor c1,c0;
	XRectangle ink,log;
	char **miss,*def,*t,tmp[128],*fntstr="-*-*-*-*-*-*-14-*-*-*-*-*-*-*";
	unsigned long bg,fg;
	int width,height,n_miss,h = 0,y = 0,i;

	setlocale(LC_ALL,"");

	if((disp = XOpenDisplay(NULL)) == NULL){
		fprintf(stderr,"False open_display()\n");
		exit(1);
	}
	root = DefaultRootWindow(disp);
	cmap = DefaultColormap(disp,0);
	if(f == NULL)
		strcpy(tmp,fntstr);
	else
		strcpy(tmp,f);
	if((font = XCreateFontSet(disp,tmp,&miss,&n_miss,&def)) == NULL){
		fprintf(stderr,"False open_font()\n");
		exit(1);
	}
	if(b == NULL)
		strcpy(tmp,"White");
	else
		strcpy(tmp,b);
	XAllocNamedColor(disp,cmap,tmp,&c1,&c0);
	bg = c1.pixel;
	if(c == NULL)
		strcpy(tmp,"Black");
	else
		strcpy(tmp,c);
	XAllocNamedColor(disp,cmap,tmp,&c1,&c0);
	fg = c1.pixel;

	sprintf(tmp,"%s%s%s",mes[1],mes[2],mes[3]);
	XmbTextExtents(font,tmp,strlen(tmp),&ink,&log);
	width = log.width + 150;
	height = log.height * 5 + 25;

	mwin = XCreateSimpleWindow(disp,root,0,0,width,height,0,fg,bg);
	XSelectInput(disp,mwin,ExposureMask|StructureNotifyMask|KeyPressMask);
	gc = XCreateGC(disp,root,0,0);
	XSetForeground(disp,gc,fg);
	XSetBackground(disp,gc,bg);

	sprintf(tmp,"%s Version %s",XJP_RAST_NAME,XJP_RAST_VERSION);
	XStoreName(disp,mwin,tmp);

	XmbTextExtents(font,mes[0],strlen(mes[0]),&ink,&log);
	h = log.height;
	gem.mes_x[0] = (width - log.width) / 2;
	gem.mes_y[0] = (y += (h+2));
	gem.mes_xx[0] = -1;
	XmbTextExtents(font,mes[1],strlen(mes[1]),&ink,&log);
	gem.mes_x[1] = 10;
	gem.mes_y[1] = (y += (h+5));
	gem.mes_xx[1] = gem.mes_x[1] + log.width + 2;
	XmbTextExtents(font,mes[2],strlen(mes[2]),&ink,&log);
	gem.mes_x[2] = width / 3;
	gem.mes_y[2] = gem.mes_y[1];
	gem.mes_xx[2] = gem.mes_x[2] + log.width + 2;
	XmbTextExtents(font,mes[3],strlen(mes[3]),&ink,&log);
	gem.mes_x[3] = width * 2 / 3;
	gem.mes_y[3] = gem.mes_y[1];
	gem.mes_xx[3] = gem.mes_x[3] + log.width + 2;
	XmbTextExtents(font,mes[4],strlen(mes[4]),&ink,&log);
	gem.mes_x[4] = 10;
	gem.mes_y[4] = (y += (h+5));
	gem.mes_xx[4] = gem.mes_x[4] + log.width + 2;
	XmbTextExtents(font,mes[5],strlen(mes[5]),&ink,&log);
	gem.mes_x[5] = 10;
	gem.mes_y[5] = (y += (h+5));
	gem.mes_xx[5] = gem.mes_x[5] + log.width + 2;
	XmbTextExtents(font,mes[6],strlen(mes[6]),&ink,&log);
	gem.mes_x[6] = 10;
	gem.mes_y[6] = (y += (h+2));
	gem.mes_xx[6] = gem.mes_x[6] + log.width + 2;
	XmbTextExtents(font,mes[7],strlen(mes[7]),&ink,&log);
	gem.mes_x[7] = (width - log.width) / 2 + gem.mes_x[6];
	gem.mes_y[7] = gem.mes_y[6];
	gem.mes_xx[7] = -1;

	XMapWindow(disp,mwin);

	for(i=0;i<4;i++){
		if((ptr_pix[i] = XCreatePixmapFromBitmapData(disp,mwin,circle_data[i],
				CIRCLE_WIDTH,CIRCLE_HEIGHT,fg,bg,DefaultDepth(disp,0))) == 0)
			fprintf(stderr,"False ptr_pix()\n");
	}
	gem.mes_x[8] = width - (CIRCLE_WIDTH +5);
	gem.mes_y[8] = height - (CIRCLE_HEIGHT + 5);
}
static int 
_xloop(XEvent ev,xjp_rast_data_t *bdata)
{
	char *key;
	switch(ev.type){
		case Expose: 
			_xdraw(bdata);
		break;
		case KeyPress:
			key = (char *)XKeysymToString(XLookupKeysym(&ev.xkey,0));
			pthread_mutex_lock(&mutex);
			if(strcmp(key,"s") == 0){count = 1;}
			else if(strcmp(key,"p") == 0){count = 0;}
			else if(strcmp(key,"q") == 0){count = 0;p_end = 1;}
			pthread_mutex_unlock(&mutex);
			_xdraw(bdata);
		break;
	}
	return 0;
}
static void 
_xdraw(xjp_rast_data_t *bdata)
{
	int i;
	char tmp[256];

	XClearWindow(disp,mwin);
	for(i=0;i<7;i++){
		XmbDrawString(disp,mwin,font,gc,
				gem.mes_x[i],gem.mes_y[i],mes[i],strlen(mes[i]));
	}
	pthread_mutex_lock(&mutex);

	sprintf(tmp,"%d",e_index);
	XmbDrawString(disp,mwin,font,gc,
			gem.mes_xx[1],gem.mes_y[1],tmp,strlen(tmp));
	sprintf(tmp,"%d",w_index);
	XmbDrawString(disp,mwin,font,gc,
			gem.mes_xx[2],gem.mes_y[2],tmp,strlen(tmp));
	sprintf(tmp,"%d",bdata->total);
	XmbDrawString(disp,mwin,font,gc,
			gem.mes_xx[3],gem.mes_y[3],tmp,strlen(tmp));
	XmbDrawString(disp,mwin,font,gc,
			gem.mes_xx[4],gem.mes_y[4],bdata->dbpath,strlen(bdata->dbpath));

	if(count){
		if(bookfile != NULL)
			XmbDrawString(disp,mwin,font,gc,
					gem.mes_xx[5],gem.mes_y[5],bookfile,strlen(bookfile));
		sprintf(tmp,"%s (%s)",title,person);
		XmbDrawString(disp,mwin,font,gc,
				gem.mes_xx[6],gem.mes_y[6],tmp,strlen(tmp));
	}else{
		if(p_end)
			XmbDrawImageString(disp,mwin,font,gc,
					gem.mes_x[7],gem.mes_y[7],mes[7],strlen(mes[7]));
		else
			XmbDrawImageString(disp,mwin,font,gc,
					gem.mes_x[7],gem.mes_y[7],mes[8],strlen(mes[8]));
	}
	pthread_mutex_unlock(&mutex);
}
static void 
_xepos(xjp_rast_data_t *bdata)
{
	static int c,n;
	pthread_mutex_lock(&mutex);
	if(proc){
		if(c++ >= 3) c = 0;
		if(ptr_pix[c])
			XCopyArea(disp,ptr_pix[c],mwin,gc,0,0,CIRCLE_WIDTH,CIRCLE_HEIGHT,
							gem.mes_x[8],gem.mes_y[8]);
	}
	pthread_mutex_unlock(&mutex);
	if(n % 10 == 0)
		_xdraw(bdata);
	if(n++ > 1000000) n = 0;
	return;
}
static xjp_rast_data_t * 
_bdata(char *dbpath,char *bookdir)
{
	xjp_rast_book_t *bhead = NULL, *btail = NULL;
	xjp_rast_data_t *bd = NULL;
	int total;
	char *p;

	p = bookdir + (strlen(bookdir) - 1);
	if(*p == '/') *p = '\0';
	if((bd = (xjp_rast_data_t *)malloc(sizeof(xjp_rast_data_t))) == NULL){
		fprintf(stderr,"False xjp_rast_data_t(malloc())\n");
		return NULL;
	}
	bd->dbpath = dbpath;
	if((total=xjpGetBookData(bookdir,&bhead,&btail)) <= 0){
		fprintf(stderr,"False xjp_rast_book_t(get())\n");
		return NULL;
	}
	bd->total = total; bd->head = bhead; bd->tail = btail;
	return bd;
}
static void _usage()
{
	fprintf(stderr,"\n");
        fprintf(stderr,
"	-b <path> : data_base(RAST) path \n \
	-d <path> : book_dir path	\n \
					");
	fprintf(stderr,"\n");
	exit(1);
}
int main(int argc,char *argv[])
{
	xjp_rast_data_t *bdata = NULL;
	char *dbpath=NULL,*bookdir=NULL,*font=NULL,*bg=NULL,*fg=NULL;
	int option;

	signal(SIGINT,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGTSTP,SIG_IGN);
	while(1){
		if((option = getopt(argc,argv,"b:d:a:c:e:")) == -1) break;
		switch(option){
			case 'a': font = optarg;break;
			case 'b': dbpath = optarg; break;
			case 'c': bg = optarg;break;
			case 'd': bookdir = optarg; break;
			case 'e': fg = optarg;break;
		}
	}
	if(dbpath == NULL || bookdir == NULL) _usage();

	_xinit(font,bg,fg);

	bdata = (xjp_rast_data_t *)_bdata(dbpath,bookdir);
	pthread_mutex_init(&mutex,NULL);
	pthread_create(&pth,NULL,xjpRastData,(void *)bdata);
	while(1){
		if(c_end == 1) goto _end;
		_xepos(bdata);
		while(XPending(disp)){
			XNextEvent(disp,&event);
			if(_xloop(event,bdata)) goto _end;
		}
		usleep(500000);
	}
_end:
	pthread_mutex_destroy(&mutex);
	XCloseDisplay(disp);
	return 0;
}
