#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <pwd.h>
#include <pthread.h>

#include "../xjp.h"
#include "../itext_file.h"
#include "../rast/itext_rast.h"
#include "xjp_rast.h"

static xjp_rast_book_t * _rast_book_alloc();
static void _rast_book_add(xjp_rast_book_t **,xjp_rast_book_t **,xjp_rast_book_t *);
static int _rast_book_insert(xjp_rast_book_t **,xjp_rast_book_t **,char *,char *);

static xjp_rast_book_t * _rast_book_alloc()
{
	xjp_rast_book_t *rb;
	if((rb = (xjp_rast_book_t *)malloc(sizeof(xjp_rast_book_t))) == NULL){
		fprintf(stderr,"False _book_t (malloc())\n");
		return NULL;
	}
	return rb;
}
static void _rast_book_add(xjp_rast_book_t **head,xjp_rast_book_t **tail,xjp_rast_book_t *im)
{
        if(*tail){im->next = NULL;im->prev = *tail;(*tail)->next = im;*tail = im;}
        else{ im->next = NULL;im->prev = NULL; *tail = im;*head = im;}
}
static int _rast_book_insert(xjp_rast_book_t **head,xjp_rast_book_t **tail,char *path,char *fname)
{
	xjp_rast_book_t *rb;
	if((rb = (xjp_rast_book_t *)_rast_book_alloc()) == NULL) return -1;
	strncpy(rb->bookpath,path,254);
	strncpy(rb->bookfile,fname,254);
	_rast_book_add(head,tail,rb);
	return 0;
}
int xjpGetBookData(char *path,xjp_rast_book_t **head,xjp_rast_book_t **tail)
{
	DIR *dp;
	struct dirent *dir;
	char book_path[256];
	int total=0;
	ftype_t ftype;

	if((dp = opendir(path)) == NULL) return -1;
	while((dir = readdir(dp)) != NULL){
		if(strcmp(dir->d_name,".")==0 || strcmp(dir->d_name,"..")==0) continue;
		sprintf(book_path,"%s/%s",path,dir->d_name);
		ftype = itextCheckFileType(book_path);
		if(ftype == F_TXT || ftype == F_ZIP){
			if(_rast_book_insert(head,tail,book_path,dir->d_name) < 0) continue;	
			total++;
		}
	}
	closedir(dp);
	return total;
}
int xjpMatchBookData(rast_result_t *result,char *key)
{
	int i;
	if(result == NULL) return 1;
	for(i=0;i<result->num_items;i++){
		if(strcmp(rast_value_string(result->items[i]->properties+0),key) == 0)
			return 0;
	}
	return 1;
}
void * xjpRastData(void *data0)
{
	FILE *fp;
	DIR *dp;
	char buf[1024], rastpath[256];
	int len;
	xjp_rast_data_t *rd;
	xjp_rast_book_t *rb;
	pthread_mutex_t *mutex;
	rast_result_t *result;

	if(data0 == NULL) return NULL;
	sprintf(rastpath,"%s/%s",getpwuid(getuid())->pw_dir,RAST_TEMP_FILE);
	mutex = (pthread_mutex_t *)xjpRastData;

	rd = (xjp_rast_data_t *)data0;
	if((dp = opendir(rd->dbpath)) == NULL)
		if(itextCreateRastData(rd->dbpath) < 0) return NULL;
	close(dp);

	result = (rast_result_t *)itextGetRastData(rd->dbpath,"filename0");

	pthread_mutex_lock(mutex);
	e_index = result->num_items;
	w_index = rd->total - result->num_items;
	pthread_mutex_unlock(mutex);
	for(rb=rd->head;rb!=NULL;rb=rb->next){
		if(count == 0){
			while(1){
			       	if(p_end == 1) goto _end;
				if(count > 0) break;
		       		usleep(50000);
			}
		}
		if(xjpMatchBookData(result,rb->bookpath)){
			if(itextGetRastFile(rb->bookpath,rastpath) < 0) continue;
			if((fp = fopen(rastpath,"r")) == NULL) continue;
			if((len = fread(buf,sizeof(char),sizeof(buf),fp)) <= 0) continue;
			buf[len] = '\0';
			fclose(fp);

			pthread_mutex_lock(mutex);
			itextGetTitlePerson(buf,title,person);
			bookfile = rb->bookfile;
			e_index += 1;
			w_index -= 1;
			if(count > 0)count++;
			proc = 1;
			pthread_mutex_unlock(mutex);

			itextRegisterRastData(rd->dbpath,rb->bookpath,rb->bookfile,rastpath,title,person);
			unlink(rastpath);
			pthread_mutex_lock(mutex);
			proc = 0;
			pthread_mutex_unlock(mutex);
		}
		if(p_end) goto _end;
	}
_end:
	pthread_mutex_lock(mutex);
	c_end = 1;
	pthread_mutex_unlock(mutex);
	return NULL;
}
