#include "itext.h"
#include "xtext.h"
#include "xjp.h"

XImage *bimg;
static page_data_t *_page_data_alloc();
static void *_page_data_add(page_data_t **,page_data_t **,page_data_t *);
static int _xtext_get_normalfont_size(my_window_t *,char_data_t *);
static int _xtext_get_antifont_size(Display *,my_window_t *,char_data_t *);
static draw_data_t * _xtext_get_draw_data(my_window_t *,char_data_t *,int,int);

void char_data_free(char_data_t *cd)
{
	if(cd == NULL) return;
	if(cd->head != NULL) page_data_free(&(cd->head),&(cd->tail));
	if(cd->find_head != NULL) page_data_free(&(cd->find_head),&(cd->find_tail));
	if(cd->im_head != NULL) xtext_image_data_free(&(cd->im_head),&(cd->im_tail));
	free(cd);
}
char_data_t * char_data_alloc()
{
	char_data_t *cd;

	if((cd = (char_data_t *)malloc(sizeof(char_data_t))) == NULL){
		xprint("char_data_alloc() (malloc())\n"); return NULL; }
	cd->charSize = 0;cd->charSize_s = 0;cd->charSize_e = 0;cd->charSize_r = 0;
	cd->m_off = 0;cd->s_off = 0;cd->e_off = 0;
	cd->xpad = 1;cd->ypad = 1;cd->xpos = -1;cd->ypos = -1;
	cd->draw = NULL;cd->book = NULL;cd->head = NULL;cd->tail = NULL;
	cd->find_head = NULL;cd->find_tail = NULL;cd->im_head = NULL;cd->im_tail = NULL;
	return cd;
}
void  page_data_free(page_data_t **start,page_data_t **end)
{
	page_data_t *pt,*ptt;
	if(*start == NULL) return;
	for(pt = *start; pt != NULL; pt = ptt){
		ptt = pt->next; free(pt);  }
	*start = NULL; *end = NULL;
}
static page_data_t * _page_data_alloc()
{
	page_data_t *pt;

	if((pt = (page_data_t *)malloc(sizeof(page_data_t))) == NULL){
		fprintf(stderr,"False _page_()(malloc())\n"); return NULL; }
	pt->char_no = 0; return pt;
}
static void *_page_data_add(page_data_t **start,page_data_t **end,page_data_t *mg)
{
        if(*end){mg->next = NULL;mg->prev = *end;(*end)->next = mg;*end = mg;}
        else{mg->next = NULL;mg->prev = NULL;*end = mg;*start = mg;}
	return NULL;
}
int page_data_insert(page_data_t **start,page_data_t **end,int n,int np)
{
	page_data_t *pt;

	if((pt = (page_data_t *)_page_data_alloc()) == NULL) return -1;
	pt->char_no = n; pt->page_no = np+1; _page_data_add(start,end,pt); return 0;
}
static int _xtext_get_normalfont_size(my_window_t *win,char_data_t *ct)
{
	unsigned char *str = "";
	char *str_e = "W";
	XRectangle ink,log;
	XmbTextExtents(win->fs,str,strlen(str),&ink,&log);
	ct->charSize = log.width >= log.height ? log.width+2 : log.height+2;
	XmbTextExtents(win->fs_s,str,strlen(str),&ink,&log);
	ct->charSize_s = log.width >= log.height ? log.width+2 : log.height+2;
	XmbTextExtents(win->fs_e,str_e,strlen(str_e),&ink,&log);
	ct->charSize_e = log.width+2;
	XmbTextExtents(win->rubi_fs,str,strlen(str),&ink,&log);
	ct->charSize_r = log.width >= log.height ? log.width : log.height;
	return 0;
}
static int _xtext_get_antifont_size(Display *disp,my_window_t *win,char_data_t *ct)
{
#if HAVE_LIBXFT
	unsigned char *str = "";
	char *str_e = "W";

	XGlyphInfo gi;
	char *utf8;

	utf8 = (char *)euc2utf8(XJP_CONV,str,strlen(str));
	XftTextExtentsUtf8(disp,win->font,utf8,strlen(utf8),&gi);
	ct->charSize = gi.width >= gi.height ? gi.width+2 : gi.height+2;
	XftTextExtentsUtf8(disp,win->font_s,utf8,strlen(utf8),&gi);
	ct->charSize_s = gi.width >= gi.height ? gi.width+2 : gi.height+2;
	XftTextExtents8(disp,win->font_e,str_e,strlen(str_e),&gi);
	ct->charSize_e = gi.width+2;
	if(utf8) free(utf8);

	utf8 = (char *)euc2utf8(XJP_CONV,str,strlen(str));
	XftTextExtentsUtf8(disp,win->font_rubi,utf8,strlen(utf8),&gi);
	ct->charSize_r = gi.width >= gi.height ? gi.width : gi.height;
	if(utf8) free(utf8);
#else
	_xtext_get_normalfont_size(win,ct);

#endif

	return 0;
}
static draw_data_t * _xtext_get_draw_data(my_window_t *win,char_data_t *ct,int header,int footer)
{
	draw_data_t *dt;
	int one_line;

	if(win == NULL || ct == NULL) return NULL;
	if((dt = (draw_data_t *)malloc(sizeof(draw_data_t))) == NULL){
		fprintf(stderr,"False _get_draw_data()(malloc())\n"); return NULL; }

	one_line = ct->charSize + ct->xpad + ct->charSize_r;
	if(ct->xpos >= 0 || ct->ypos >= 0){
		dt->start_line = win->width - one_line - ct->xpos;
		dt->end_line = 2;
		dt->start_low = ct->charSize + ct->ypos;
		dt->end_low = win->height - ct->charSize;
		dt->char_header = 0;
		dt->char_footer = 0;
	}else{
		dt->start_line = win->width - one_line;
		dt->end_line = 2;
		dt->start_low = ct->charSize * header;
		dt->end_low = win->height - ct->charSize * footer;
		dt->char_header = header;
		dt->char_footer = footer;
	}
	dt->one_line = one_line;
	return dt;
}
int xtext_Init_Text(Display *disp,my_window_t *win,ICONTENT_T *book,char_data_t *ct)
{
	IBUF_T *ib;
	ITEXT_T *it;
	draw_data_t *dt;

	int KINSOKU = 0,CHAR_HEADER = 0,CHAR_FOOTER = 0;
	int page_char_no = 0, total_page = 0;
	int type,x,y,h;

	if(win->fs == NULL){
		fprintf(stderr,"False  _init_text(font)\n"); exit(1); }
	if(ct->book != NULL) xtext_usage(NULL,0,5);
	if(ct->head != NULL) page_data_free(&ct->head,&ct->tail);
	if(ct->draw != NULL) free(ct->draw);
	if(win->change_font){
		if(ct->im_head != NULL)
	       		xtext_image_data_free(&ct->im_head,&ct->im_tail);
		if(win->anti == 0)
			_xtext_get_normalfont_size(win,ct);
		else
			_xtext_get_antifont_size(disp,win,ct);
		if(bimg) XDestroyImage(bimg);
		bimg = (XImage *)xtext_get_bimage(disp,win,ct);
		win->change_font = 0;
	}
	CHAR_HEADER = 3;
	switch(KINSOKU = win->kinsc){
		case 0: CHAR_FOOTER = 1;break;
		case 1: CHAR_FOOTER = 2;break;
		case 2: CHAR_FOOTER = 3;break;
	}	
	if((dt = (draw_data_t *)_xtext_get_draw_data(win,ct,CHAR_HEADER,CHAR_FOOTER)) == NULL) return -1;
	ct->draw = dt; x = dt->start_line; y = dt->start_low;

	page_data_insert(&ct->head,&ct->tail,0,total_page++);

	for(ib=book->b_head;ib!=NULL;ib=ib->next){
		if(ct->book != NULL)
			xtext_usage(XJP_MESSAGE[8],(double)ib->line/book->total_line,5);
		for(it=ib->i_head;it!=NULL;it=it->next){

			if((type = xtext_check_image_data(it)) > 0){
				OnFlag(it->flag,_FND);
				xtext_image_data_insert(disp,win,ct,it,type);
				OfFlag(it->flag,_FND);
				xtext_image_data_insert(disp,win,ct,it,type);
			}
			if(ChFlag(it->flag,_LST) || ChFlag(it->flag,_TOP)) 
				y = xtext_get_low_pos(it,ct,y);

			h = xtext_get_low_space(it,ct);
			page_char_no++;

			if((y += h) > dt->end_low){
				if(xtext_next_kuten(it,ct,KINSOKU) == 0){
					if((x -= dt->one_line) <= dt->end_line){
						page_data_insert(&ct->head,&ct->tail,page_char_no,total_page++);
						x = dt->start_line;
					}
					if(xtext_prev_kuten(it,ct,KINSOKU) == 1){
						it=it->prev; page_char_no--;
					}
					y = dt->start_low;
				}
			}
		}
		if((x -= dt->one_line) <= dt->end_line){
			page_data_insert(&ct->head,&ct->tail,page_char_no,total_page++);
			x = dt->start_line;
		}
		y = dt->start_low;
	}
	if(ct->book != NULL){
		ct->book->total_page = total_page;
		xtext_usage(NULL,0,5);
	}
	return total_page;
}
page_data_t * xtext_Redraw_Text(	Display *disp,
					my_window_t *win,
					ICONTENT_T *book,
					char_data_t *char_d,
					int npc			)
{
	page_data_t *char_p;

        if(book->b_head == NULL) return NULL;

        xtext_Init_Text(disp,win,book,char_d);
	for(char_p=char_d->head;char_p!=NULL;char_p=char_p->next){
		if(char_p->next == NULL) return char_p;
		if(npc >= char_p->char_no && npc < char_p->next->char_no) return char_p;
	}
	return char_d->head;
}
page_data_t *  xtext_Init_Book(		Display *disp,
					my_window_t *win,	
					ICONTENT_T *main_book,
					char_data_t *char_d,
					offset_data_t *offset,
					xtext_conf_t *xconf,
					char *book_name,
					int npc			)
{
	page_data_t *char_p;
	char *p;
        int total_line;

	if(book_name == NULL){
		fprintf(stderr,"False _init_book()\n"); return NULL; }
	if(main_book->filename != NULL){
		free(main_book->filename); main_book->filename = NULL; }
	if(main_book->titlename != NULL){ 
		free(main_book->titlename); main_book->titlename = NULL; }
        if(main_book->b_head != NULL) ibuf_data_free(main_book);
        if(char_d->book != NULL){
                if(char_d->book->book_title_utf8 != NULL) 
			free(char_d->book->book_title_utf8);
		free(char_d->book);
		char_d->book = NULL;
	}

	if((main_book->filename = (char *)malloc(strlen(book_name) + 3)) == NULL){
		fprintf(stderr,"False _init_book()(malloc(filename))\n"); return NULL; }

	strcpy(main_book->filename,book_name);
	for(p=main_book->filename+(strlen(main_book->filename) - 1); *p; p--){
		if(*p == '/') break;
	}
	p = p + 1;

	main_book->titlename = NULL;
        if((total_line = itextGetTextData(main_book,xconf->ruby_on,xconf->max_line))<0){
		fprintf(stderr,"False _init_book() (total_line)\n");
		if(main_book->filename != NULL) free(main_book->filename);
		if(main_book->titlename != NULL) free(main_book->titlename);
		main_book->filename = NULL;
		main_book->titlename = NULL;
	       	return NULL;
	}
        main_book->total_line = total_line;
        xtext_set_offset(main_book->b_head,main_book->b_tail,offset);
        if((char_d->book = (book_data_t *)malloc(sizeof(book_data_t))) == NULL){
		fprintf(stderr,"False char_d->book()(malloc())\n"); exit(1); }

	char_d->book->book = NULL; char_d->book->book_path = NULL; 
	char_d->book->book_title = NULL; char_d->book->book_title_utf8 = NULL;
	char_d->book->book = p; char_d->book->book_path = main_book->filename;
	if(main_book->titlename != NULL){
        	char_d->book->book_title = main_book->titlename;
        	char_d->book->book_title_utf8 = (char *)euc2utf8(XJP_CONV,main_book->titlename,strlen(main_book->titlename));
	}
        char_p = (page_data_t *)xtext_Redraw_Text(disp,win,main_book,char_d,npc);
	return char_p;
}
