#include "itext.h"
#include "xtext.h"
#include "xtext_color.h"
#include "xjp.h"

static int TRUE_TYPE = 0;

static xtext_font_t * _font_match(xtext_font_t *head,char **name,int n)
{
	xtext_font_t *xfd;
	int i;

	if(head == NULL ) return NULL;

	for(xfd=head,i=0;xfd!=NULL;xfd=xfd->next,i++){

		if(i == n){
			*name = xfd->name;
			return xfd;
		}
	}

	return NULL;
}
static xtext_efont_t * _font_match_e(xtext_efont_t *head,char **name,int n)
{
	xtext_efont_t *xfd;
	int i;

	if(head == NULL) return NULL;

	for(xfd=head,i=0;xfd!=NULL;xfd=xfd->next,i++){
		if(i == n){
			*name = xfd->name;
			return xfd;
		}
	}

	return NULL;
}
static int _get_font_data(	xtext_font_t *head,
				xtext_efont_t *e_head,
				char **fnd,
				char **fmy,
				char **other,
				char **pixel,
				char **point,
				char **xres,
				char **yres,
				char **enc,
				font_select_t *fsel	)
{
	xtext_font_t *xfd;
	int i;

	if(_font_match_e(e_head,enc,fsel->point[0]) == NULL) return -1;

	if((xfd = _font_match(head,fnd,fsel->point[1])) == NULL) return -1;

	if((xfd = _font_match(xfd->head,fmy,fsel->point[2])) == NULL) return -1;

	if((xfd = _font_match(xfd->head,other,fsel->point[3])) == NULL) return -1;

	if(xtext_pixel[fsel->point[4]] == NULL) return -1;
	*pixel = xtext_pixel[fsel->point[4]];

	if(xtext_point[fsel->point[5]] == NULL) return -1;
	*point = xtext_point[fsel->point[5]];

	if(xtext_res[fsel->point[6]] == NULL) return -1;
	*xres = xtext_res[fsel->point[6]];

	if(xtext_res[fsel->point[7]] == NULL) return -1;
	*yres = xtext_res[fsel->point[7]];

	return 0;
}
static int _set_font_no(font_select_t *fsel,int fw)
{
	int i;

	if(fw == 0) return 0;

	for(i=fw+1;i<8;i++){
		fsel->point[i] = 0;
	}

	return 0;
}
static int _set_font_point(char *other,char *point,int no)
{
	char *p,*p1,temp[80];
	int i,c,f;

	i = 0;
	c = 0;
	f = 0;
	for(p=other;*p;p++){
		if(*p == '-'){
			c++;
		       	if(c == no){
				temp[i++] = *p;
				for(p1=point;*p1;p1++){
					temp[i++] = *p1;
				}
			       	f = 1;
		       	}else if(c == (no+1)){
				f = 0;
			}
		}
		if(f == 0) temp[i++] = *p;
	}
	temp[i] = '\0';

	strcpy(other,temp);

	return 0;
}
static int _get_font_select(char *string,xtext_font_t *head,xtext_efont_t *ehead,font_select_t fsel)
{
	char *fnd,*fmy,*other,*pixel,*point,*xres,*yres,*enc;
	char *p;
	int i;

	if(_get_font_data(head,ehead,&fnd,&fmy,&other,&pixel,&point,&xres,&yres,&enc,&fsel)<0) return -1;

	if(TRUE_TYPE > 0){
		for(i=0;i<TRUE_TYPE;i++){
			if(i == 0){
				p = pixel;
			}else if(i == 1){
				p = point;
			}else if(i == 2){
				p = xres;
			}else if(i == 3){
				p = yres;
			}
			_set_font_point(other,p,i+5);
		}
	}

	sprintf(string,"-%s-%s%s",fnd,fmy,other);

	return 0;
}
static int _check_font_truetype(char *other)
{
	char *p,*pp = NULL;
	int flag;

	flag = 0;
	for(p=other;*p;p++){
		if(*p == '-'){
			if(++flag == 2){pp = p; break;}
		}else{
			flag = 0;
		}
	}
	if(pp == NULL) return 0;

	flag = 0;
	if(*(pp+1) == '0')
		flag++;
	else
		return 0;

	if(*(pp+3) == '0')
		flag++;
	else
		return flag;

	if(*(pp+5) == '0')
		flag++;
	else
		return flag;

	if(*(pp+7) == '0')
		flag++;
	else
		return flag;


	return flag;
}
static int _check_font_registry(xtext_font_t *fhead,xtext_efont_t *ehead,font_select_t *fsel,int fw)
{
	char *fnd,*fmy,*other,*pixel,*point,*xres,*yres,*enc,reg[50];

	if(fw != 3) return 0;

	if(_get_font_data(fhead,ehead,&fnd,&fmy,&other,&pixel,&point,&xres,&yres,&enc,fsel) < 0){

		if(fsel->point[fw]-- <= 0){fsel->point[fw] = 0;}
		while(_check_font_registry(fhead,ehead,fsel,fw)){
			if(fsel->point[fw]-- <= 0){fsel->point[fw] = 0;break;}
		}
	       	return 0;
	}
	if(strcmp(enc,"*") == 0) return 0;

	parse_xlfd_No(other,reg,11);

	if(strcmp(reg,"*") == 0){
		return 0;
	}else{
		if(strcmp(reg,enc) == 0) return 0;
	}

	return 1;
}
static int _get_str_size(XFontStruct *fs,char *str,int len,int *w,int *h)
{
	XCharStruct cs;
	int dir,as,ds;

	XTextExtents(fs,str,len,&dir,&as,&ds,&cs);

	*w = cs.rbearing - cs.lbearing;
	*h = cs.ascent + cs.descent;

	return 0;
}
static int _draw_window_font(	Display *disp,
				Window win,
				GC gc,
				GC color_gc,
				XFontStruct *fs,
				XFontStruct *fs_s,
				int width,
				int height,
				xtext_font_t *f_head,
				xtext_efont_t *e_head,
				font_select_t *fsel,
				int *fw			)
{
	int x,y,w,h,h_0,len;
	int i,on;

	char temp[50],*fnd,*fmy,*other,*pixel,*point,*xres,*yres,*enc;

	if(_get_font_data(f_head,e_head,&fnd,&fmy,&other,&pixel,&point,&xres,&yres,&enc,fsel) < 0) return 0;

	TRUE_TYPE = _check_font_truetype(other);


	XClearWindow(disp,win);
	h_0 = height/2;

	len = strlen(message_font);
	_get_str_size(fs,message_font,len,&w,&h);
	x = (width - w)/2;
	y = h+2;
	XDrawString(disp,win,gc,x,y,message_font,len);

	strcpy(temp,"Match CharsetRegistry -> ");
	len = strlen(temp);
	_get_str_size(fs_s,temp,len,&w,&h);
	x = 2;
	y = h_0 - 10;
	XDrawString(disp,win,color_gc,x,y,temp,len);
	x = w + 10;
	y = h_0 - 10;
	sprintf(temp,"( %s )",enc);
	if(*fw == 0)
		XDrawImageString(disp,win,color_gc,x,y,temp,strlen(temp));
	else
		XDrawString(disp,win,color_gc,x,y,temp,strlen(temp));


	sprintf(temp,"-%s",fnd);
	len = strlen(temp);
	_get_str_size(fs_s,temp,len,&w,&h);
	x = 2;
	y = h_0 + h;
	XDrawString(disp,win,color_gc,x,y,"-",1);
	if(*fw == 1)
		XDrawImageString(disp,win,color_gc,x+7,y,temp+1,len-1);
	else
		XDrawString(disp,win,color_gc,x+7,y,temp+1,len-1);

	x = x + w + 1;

	sprintf(temp,"-%s",fmy);
	len = strlen(temp);
	_get_str_size(fs_s,temp,len,&w,&h);
	XDrawString(disp,win,color_gc,x,y,"-",1);
	if(*fw == 2)
		XDrawImageString(disp,win,color_gc,x+7,y,temp+1,len-1);
	else
		XDrawString(disp,win,color_gc,x+7,y,temp+1,len-1);
	x = x + w + 1;

	len = strlen(other);
	_get_str_size(fs_s,other,len,&w,&h);
	if(*fw == 3)
		XDrawImageString(disp,win,color_gc,x,y,other,len);
	else
		XDrawString(disp,win,color_gc,x,y,other,len);


	x = 10;
	y = y + h + 10;
	for(i=0;i<TRUE_TYPE;i++){
		on = 0;
		if(i == 0){
			strcpy(temp,"TrueType >");
			len = strlen(temp);
			_get_str_size(fs_s,temp,len,&w,&h);
			XDrawString(disp,win,color_gc,x,y,temp,len);
			x = x + w + 10;

			sprintf(temp,"pix_size( %s )",pixel);
			if(*fw == 4) on = 1;

		}else if(i == 1){
			sprintf(temp,"pnt_size( %s )",point);
			if(*fw == 5) on = 1;

		}else if(i == 2){
			sprintf(temp,"x_res( %s )",xres);
			if(*fw == 6) on = 1;

		}else if(i == 3){
			sprintf(temp,"y_res( %s )",yres);
			if(*fw == 7) on = 1;
		}

		len = strlen(temp);
		_get_str_size(fs_s,temp,len,&w,&h);
		if(on)
			XDrawImageString(disp,win,color_gc,x,y,temp,len);
		else
			XDrawString(disp,win,color_gc,x,y,temp,len);
		x = x + w + 5;
	}

	return 1;

}
static void _draw_window(	Display *disp,
				Window win,
				GC gc,
				GC color_gc,
				Colormap cmap,
				XFontStruct *fs,
				int width,
				int height,
				int color_no,
				int type		)
{
	XCharStruct cs;
	int dir,as,ds;

	int x,y,w,h,len;

	if(type == XJP_COL){
		if(xtext_color[color_no] == NULL) return;
	}else if(type == XJP_CHA){
		if(xtext_key[color_no] == NULL) return;
	}

	XClearWindow(disp,win);

	len = strlen(message);
	XTextExtents(fs,message,len,&dir,&as,&ds,&cs);
	w = cs.rbearing - cs.lbearing;
	h = cs.ascent + cs.descent;
	x = (width - w)/2;
	y = h+2;
	XDrawString(disp,win,gc,x,y,message,strlen(message));

	if(type == XJP_COL){
		XColor g0,g1;

		XAllocNamedColor(disp,cmap,xtext_color[color_no],&g1,&g0);
		XSetForeground(disp,color_gc,g1.pixel);

		x = ((width*2 - width)/4)/2;
		y = y+5;
		w = width/4;
		h = height/2;
		XFillRectangle(disp,win,color_gc,x,y,w,h);

		len = strlen(xtext_color[color_no]);
		XTextExtents(fs,xtext_color[color_no],len,&dir,&as,&ds,&cs);
		w = cs.rbearing - cs.lbearing;
		h = cs.ascent + cs.descent;

		x = width/2;
		y = height/2 + h + 2;
		XDrawString(disp,win,gc,x,y,xtext_color[color_no],len);

	}else if(type == XJP_CHA || type == XJP_INT){
		char str[10];

		if(type == XJP_CHA){
			sprintf(str,"        %s     key  ",xtext_key[color_no]);
		}else if(type == XJP_INT){
			sprintf(str,"        %s     pix  ",xtext_num[color_no]);
		}

		len = strlen(str);
		XTextExtents(fs,str,len,&dir,&as,&ds,&cs);
		w = cs.rbearing - cs.lbearing;
		h = cs.ascent + cs.descent;

		x = (width - w) / 2;
		y = height/2 + h + 2;
		XDrawImageString(disp,win,gc,x,y,str,len);
	}
}
char * xtext_Selector_Window(char *select_string,int type)
{
	font_select_t fsel = {{0,0,0,0,0,0,0,0}}; 
	int fw = 0;

	Display *disp;
	Window root,win;
	Colormap cmap;

	XFontStruct *fs;
	GC gc;
	GC color_gc;
	XColor fg0,fg1;
	XColor bg0,bg1;
	XColor rg0,rg1;

	XEvent event;
	KeySym keysym;

	XFontStruct *fs_s;
	xtext_font_t *f_head = NULL, *f_tail = NULL;
	xtext_efont_t *e_head = NULL, *e_tail = NULL,*et;
	char **xlfd_str;
	int xlfd_max;

	int DW,DH,width,height;
	int select_no = 0;
	int loop = 1;
	int i,result = 0;

	disp = XOpenDisplay(NULL);
	root = DefaultRootWindow(disp);
	cmap = DefaultColormap(disp,0);
	gc = XCreateGC(disp,root,0,0);
	color_gc = XCreateGC(disp,root,0,0);
	fs = XLoadQueryFont(disp,"-*-*-medium-*-*-*-14-*-*-*-*-*-iso8859-*");

	if(SELECTOR_FOREGROUND_COLOR != NULL){
		XAllocNamedColor(disp,cmap,SELECTOR_FOREGROUND_COLOR,&fg1,&fg0);
	}else{
		XAllocNamedColor(disp,cmap,"snow",&fg1,&fg0);
	}
	if(SELECTOR_BACKGROUND_COLOR != NULL){
		XAllocNamedColor(disp,cmap,SELECTOR_BACKGROUND_COLOR,&bg1,&bg0);
	}else{
		XAllocNamedColor(disp,cmap,"RoyalBlue4",&bg1,&bg0);
	}
	if(SELECTOR_SELECTFONT_COLOR != NULL){
		XAllocNamedColor(disp,cmap,SELECTOR_SELECTFONT_COLOR,&rg1,&rg0);
	}else{
		XAllocNamedColor(disp,cmap,"salmon4",&rg1,&rg0);
	}

	DW = DisplayWidth(disp,0);
	DH = DisplayHeight(disp,0);

	width = 320;
	height = 50;

	XSetFont(disp,gc,fs->fid);
	XSetForeground(disp,gc,fg1.pixel);
	XSetBackground(disp,gc,rg1.pixel);
	win = XCreateSimpleWindow(disp,root,0,0,width,height,0,fg1.pixel,bg1.pixel);
	XSelectInput(disp,win,ExposureMask|KeyPressMask);
	XMapWindow(disp,win);

	if(type == XJP_COL){
		XStoreName(disp,win,"XJP Color Selector");
	}else if(type == XJP_CHA){
		XStoreName(disp,win,"XJP Function_Key Selector");
	}else if(type == XJP_INT){
		XStoreName(disp,win,"XJP Number_Key Selector");
	}else if(type == XJP_FONT){
		char temp[50];

		width = 550;
		height = 100;
		XResizeWindow(disp,win,width,height);

		fs_s = XLoadQueryFont(disp,"-*-*-*-*-*-*-16-*-*-*-*-*-iso8859-*");
		XSetFont(disp,color_gc,fs_s->fid);
		XSetForeground(disp,color_gc,fg1.pixel);
		XSetBackground(disp,color_gc,rg1.pixel);

		xlfd_str = (char **)XListFonts(disp,"-*-*-*-*-*--*-*-*-*-*-*-*-*",99999,&xlfd_max);
		for(i=0;i<xlfd_max;i++){
			xtext_xlfd_create(&f_head,&f_tail,*(xlfd_str+i));
			xtext_xlfd_getenco(&e_head,&e_tail,*(xlfd_str+i));
		}
		sprintf(temp,"XJP X-Font Selector  (%d)",xlfd_max);
		XStoreName(disp,win,temp);

	}

	while(loop){
		XNextEvent(disp,&event);
		switch(event.type){
			case Expose:
				if(type == XJP_FONT){
					_draw_window_font(disp,win,gc,color_gc,fs,fs_s,width,height,f_head,e_head,&fsel,&fw);
				}else{
					_draw_window(disp,win,gc,color_gc,cmap,fs,width,height,select_no,type);
				}
			break;
			case KeyPress:
				keysym = XLookupKeysym(&event.xkey,0);
				switch(keysym){
					case XK_Return:
						if(type == XJP_COL){
							strcpy(select_string,xtext_color[select_no]);
						}else if(type == XJP_CHA){
							strcpy(select_string,xtext_key[select_no]);
						}else if(type == XJP_INT){
							*select_string = (int )atoi(xtext_num[select_no]);
						}else if(type == XJP_FONT){
							_get_font_select(select_string,f_head,e_head,fsel);
						}
						result = 1; loop = 0;
					break;
					case XK_q:
						loop = 0;
					break;
					case XK_Up:
						if(type == XJP_FONT){
							if(fsel.point[fw]-- <= 0) fsel.point[fw] = 0;
							_set_font_no(&fsel,fw);
							while(_check_font_registry(f_head,e_head,&fsel,fw)){
								if(fsel.point[fw]-- <= 0){fsel.point[fw]=0;break;}
							}
							_draw_window_font(disp,win,gc,color_gc,fs,fs_s,width,height,f_head,e_head,&fsel,&fw);
						}else{
							select_no--;
							if(select_no <= 0) select_no=0;
							_draw_window(disp,win,gc,color_gc,cmap,fs,width,height,select_no,type);
						}
					break;
					case XK_Down:
						if(type == XJP_FONT){
							fsel.point[fw]++;
							_set_font_no(&fsel,fw);
							while(_check_font_registry(f_head,e_head,&fsel,fw)){fsel.point[fw]++;}
							if(_draw_window_font(disp,win,gc,color_gc,fs,fs_s,width,height,f_head,e_head,&fsel,&fw) <= 0){fsel.point[fw]--;}

						}else{
							select_no++;
							if(type == XJP_COL){
								if(xtext_color[select_no] == NULL)select_no--;
							}else if(type == XJP_CHA){
								if(xtext_key[select_no] == NULL) select_no--;
							}else if(type == XJP_INT){
								if(xtext_num[select_no] == NULL) select_no--;
							}
							_draw_window(disp,win,gc,color_gc,cmap,fs,width,height,select_no,type);
						}

					break;
					case XK_Tab:
						if(type == XJP_FONT){
							if(fw++ >= (3+TRUE_TYPE)) fw = 0;
							_draw_window_font(disp,win,gc,color_gc,fs,fs_s,width,height,f_head,e_head,&fsel,&fw);
						}
					break;
				}
			break;
		}

	}
	XDestroyWindow(disp,win);
	XCloseDisplay(disp);

	if(type == XJP_COL){
		if(result)
			return xtext_color[select_no];
		else
			return XJP_CANCEL;
	}else if(type == XJP_CHA){
		if(result)
			return xtext_key[select_no];
		else
			return XJP_CANCEL;
	}else if(type == XJP_INT){
		if(result)
			return xtext_num[select_no];
		else
			return XJP_CANCEL;
	}else if(type == XJP_FONT){
		xtext_xlfd_free(f_head);
		xtext_xlfd_free_e(e_head);
		if(result)
			return XJP_OK;
		else
			return XJP_CANCEL;
	}
}

