#include "itext.h"
#include "xtext.h"
#include "xjp.h"
#include "xjp_file.h"

extern Display 		*disp;
extern my_window_t 	*main_win;
extern xtext_conf_t	xconf;
extern offset_data_t	*off_head, *off_tail;
extern page_data_t 	*char_p;
extern char_data_t	*char_d;
extern ICONTENT_T	*main_book;

void xprint(char *str)
{
#if DEBUG
	fprintf(stderr,"%s\n",str);
#endif
}
void xtext_usage(char *usage,double per,int no)
{
	XSetWindowAttributes at;

	static Window uwin; static Pixmap cpix[4];
	static int width,height,w,h,count,c;
	int i,len;

	if(usage == NULL){
		if(uwin == 0){
			XRectangle ink,log;
			unsigned char *base = "";
			int x,y,hh;

			for(i = 0; i<4; i++)
				cpix[i] = XCreatePixmapFromBitmapData(disp,main_win->win,
						circle_data[i],CIRCLE_WIDTH,CIRCLE_HEIGHT,
						main_win->fg_pixel,main_win->bg_pixel,
						DefaultDepth(disp,0));


			XClearWindow(disp,main_win->win);
			XmbTextExtents(main_win->fs_s,base,strlen(base),&ink,&log);
			w = main_win->width / 2;
			if((hh = log.height) < CIRCLE_HEIGHT) hh = CIRCLE_HEIGHT;
			h = hh * 2;
			x = main_win->width / 4; y = (main_win->height - h) / 2;
			uwin = XCreateSimpleWindow(disp,main_win->win,x,y,w,h,1,main_win->fg_pixel,main_win->bg_pixel);
			XMapRaised(disp,uwin);
			count = 0;
		}else{
			for(i = 0; i<4; i++)
				if(cpix[i]) XFreePixmap(disp,cpix[i]);

			XDestroyWindow(disp,uwin);
			uwin = 0;
			width = 0;
			count = 0;
		}
	}else{
		if(uwin == 0) return;
		if(no) if((count++ % no) != 0) return;
		if(width == 0){
			XRectangle ink,log;
			len = strlen(usage);
			XmbTextExtents(main_win->fs_s,usage,len,&ink,&log);
			width = log.width;
			XmbDrawString(disp,uwin,main_win->fs_s,main_win->gc,(w-width)/2,h/2-2,usage,len);
		}
		if(per){
			int x,x1,y,y1;
			x = 2; y = h / 2 + 7; y1 = h / 5;
			x1 = ((w - CIRCLE_WIDTH) - 4) * (double)per;
			XFillRectangle(disp,uwin,main_win->gc,x,y,x1,y1);
		}
		if(c++ >= 3) c = 0;
		if(cpix[c]) XCopyArea(disp,cpix[c],uwin,main_win->gc,
						0,0,CIRCLE_WIDTH,CIRCLE_HEIGHT,
								w - CIRCLE_WIDTH,h /2);
	}
	XFlush(disp);
}
int select_person_data(void *data0,int data1)
{
	IBOOK_T *bhead, *ib;
	IPERSON_T *phead = NULL, *ptail = NULL, *ip;
	sub_window_t *book_head = NULL, *book_tail = NULL;
	char *result;

	bhead = (IBOOK_T *)data0;
	ibookGetPersonData(&phead,&ptail,bhead);
	xtextPerson2Sub(&book_head,&book_tail,phead);
	if((result = (char *)xtextSubWindow(disp,main_win,book_head,book_tail,90,0)) == NULL){
		person_link_free(phead);
		return 0;
	}
	person_link_free(phead);
	if(strcmp(result,XJP_CANCEL) == 0)
	       	return 0;
	return 1;
}
int select_book_data(void *data0,int data1)
{
	IBOOK_T *bhead;
	sub_window_t *book_head = NULL,*book_tail = NULL,*bh;
	char *book_path;
	int percent = 85;

	if(data0 == NULL) return -1;
	bhead = (IBOOK_T *)data0;
	xtextBookData2Sub(&book_head,&book_tail,bhead,data1);
	if(book_head == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[1]);
		return -1;
	}
	if(data1 == 1) percent = 95;
	if((book_path = (char *)xtextSubWindow(disp,main_win,book_head,book_tail,percent,0)) == NULL)
		return -1;
	if(strcmp(book_path,XJP_CANCEL) == 0 || strcmp(book_path,XJP_OK) == 0)
	       	return 0;
	if((char_p = (page_data_t *)xtext_Init_Book(disp,main_win,main_book,char_d,off_head,&xconf,book_path,0)) == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[1]);
	       	return -1;
	}
	return 1;
}
int select_serch_data(void *data0,int data1)
{
	IBOOK_T *bhead,*bh = NULL, *bt = NULL;
	int percent = 80;
	char *result;

	if(data0 == NULL)
	       	return 0;
	if(data1 != 0) percent = (int)data1;
	bhead = (IBOOK_T *)data0;
	if((result = (char *)xtextInputWindow(disp,main_win,S_NAME0,S_NAME1,percent)) == NULL) 
		return 0;
	if(ibookMatchFileData(&bh,&bt,bhead,result) < 0) 
		return 0;
	if(bh == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[17]);
	       	return 0;
	}
	if(select_book_data(bh,1) == 0){
		book_link_free(&bh,&bt);
		return 0;
	}
	book_link_free(&bh,&bt);
	return 1;
}
int select_siori_data(void *data0,int data1)
{
	sub_window_t *si_head = NULL,*si_tail = NULL;
	char *book_path;
	int percent = 90;
	ISIORI_T *si_h,*si;

	if(data1 != 0) percent = data1;
	si_h = (ISIORI_T *)data0;
	xtextSioriData2Sub(&si_head,&si_tail,si_h);
	if(si_head == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[2]);
		return -1;
	}
	if((book_path = (char *)xtextSubWindow(disp,main_win,si_head,si_tail,percent,0)) == NULL) 
		return -1;
	if(strcmp(book_path,XJP_CANCEL) == 0 || strcmp(book_path,XJP_OK) == 0)
	       	return 0;

	for(si=si_h;si!=NULL;si=si->next){
		if(strcmp(si->book_path,book_path)==0){
			if((char_p = (page_data_t *)xtext_Init_Book(disp,main_win,main_book,char_d,off_head,&xconf,book_path,si->NPC)) == NULL){
				xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[1]);
				return 0;

			}
			break;
		}
	}
	return 1;
}
int select_conf_key(void *data0,int data1)
{
	sub_window_t *s_head = NULL, *s_tail = NULL; xtext_func_t *xfunc;
	int percent = 90; char *result;

	if(data0 == NULL) return 0;
	xfunc = (xtext_func_t *)data0;
	if(data1 != 0) percent = data1;

	xfunc->func(&s_head,&s_tail,xfunc->xconf);
	/*
	xtextConfKeyData2Sub(&s_head,&s_tail,xconf);
	*/
	result = (char *)xtextSubWindow(disp,main_win,s_head,s_tail,percent,0); 
	if(strcmp(result,XJP_CANCEL) == 0 || strcmp(result,XJP_OK) == 0)
	       	return 0;
	return 0;
}
