#include "itext.h"
#include "xtext.h"
#if HAVE_ATEXIT
	#include "rast/xjp_rast.h"
#endif
#include <dirent.h>
#if HAVE_NETDB_H
	#include "net/xjp_net.h"
	extern xtext_net_t xnet;
#endif
static unsigned char *k_title = "[  ]";
static unsigned char *w_title = "[ ɥ ]";
static unsigned char *f_title = "[ ե ]";
static unsigned char *s_title = "[  ]";
static unsigned char *si_title = "--   --";
static unsigned char *c_title = "--   -- ";
static unsigned char *bo_title = "--  ¸޽  --";
static unsigned char *pe_title = "--  ¸޽  --";
static unsigned char *kn0[18] = {"ڡ:","ڡ:","ڡ:","ٵϿ:","٥˥塼:","˥塼:","λ:","ȥON-OFF:","ǡɽON-OFF:","٥ѹ:","ɥON-OFF:","ɲ:","ڴ:","¾źեե:","FINDϲ:","FINDڡ:","FINDڡ:","RASTǽ:"};
static unsigned char *kn1[12] = {"طʿ:","ᥤʸ:","FINDʸ:","ʸ:","˥塼طʿ:","˥塼ʸ:","ʸƿ:"," طʿ:"," ʸ:"," :","ߥɥ:","ߥɥ:"};
static unsigned char *kn2[7] = {"ե(J):","ե(small):","ե(E):","ӥե:","Դ:","ʸ:","Ĺ:"};
static unsigned char *kn3[7] = {"ꥢ:","ȥɽ:","ǡɽ:","٥:","ɽ:",":"};
static unsigned char *kn4[8] = {"(ȿ)","(󥻥)","(¸)","¸ʸ:","RAST-DB:","¾ץ:","ĶʸURL:","ĶʸLIST:"};
static unsigned char *kn5[7] = {"()","()","(ꥹ)","(RAST)","(ñ)","()","()"};

sub_window_t * subwindow_data_alloc()
{
	sub_window_t *sw;
	if((sw = (sub_window_t *)malloc(sizeof(sub_window_t))) == NULL){
		fprintf(stderr,"False _subwindow_()(malloc())\n"); return NULL; }

	sw->line_str = NULL; sw->line_data = NULL; sw->line_data1 = NULL;
	sw->re_str = NULL; sw->func = NULL; sw->func_data0 = NULL;sw->func_data1 = -1;
	sw->type = XJP_NONE; sw->line_no = -1; sw->mdata = 0; sw->mstr = 0;
	sw->head = NULL; sw->tail = NULL;

	return sw;
}
void * subwindow_data_free(sub_window_t **head,sub_window_t **tail)
{
	sub_window_t *sw,*sww;
	if(*head == NULL) return NULL;
	for(sw = *head;sw!=NULL;sw=sww){
		sww = sw->next;
		if(sw->head != NULL) subwindow_data_free(&(sw->head),&(sw->tail));
		if(sw->mstr && sw->line_str != NULL) free(sw->line_str);
		if(sw->mdata && sw->line_data != NULL) free(sw->line_data);
		free(sw);
	}
	*head = NULL; *tail = NULL; return NULL;
}
static void subwindow_data_add0(sub_window_t **head,sub_window_t **tail,sub_window_t *im)
{
	if(*tail){im->next = NULL;im->prev = *tail;(*tail)->next = im;*tail = im;}
        else{im->next = NULL;im->prev = NULL;*tail = im;*head = im;}
}
void * subwindow_data_add(sub_window_t **head,sub_window_t **tail,sub_window_t *im)
{
	static int po;
	if(*head == NULL){ 
		po = 0;  
	}else{
		if(po == im->line_no){
		       	subwindow_data_add0(&(*tail)->head,&(*tail)->tail,im);return NULL;
		}
	}
	subwindow_data_add0(head,tail,im); po = im->line_no; return NULL;
}
void subwindow_data_insert(	sub_window_t **head,
				sub_window_t **tail,
				char *line_str,
				char *line_data,
				char *re_str,
				int (*func)(),
				void * data0,
				int data1,
				int type,
				int line_no	)
{
	sub_window_t *sw;

	if((sw = (sub_window_t *)subwindow_data_alloc()) == NULL) return;
	if(line_str != NULL){
		if((sw->line_str=(char *)malloc(strlen(line_str)+1)) != NULL){
			strcpy(sw->line_str,line_str); sw->mstr = 1; }
	}
	sw->line_data = line_data;
	if(re_str != NULL){
		if((sw->re_str = (char *)malloc(strlen(re_str)+1)) != NULL)
			strcpy(sw->re_str,re_str);
	}
	sw->func = func;
	sw->func_data0 = data0;
	sw->func_data1 = data1;
	sw->line_no = line_no;
	sw->type = type;
	subwindow_data_add(head,tail,sw);
	return ;
}
int xtextConfInitData2Sub(sub_window_t **head,sub_window_t **tail,xtext_conf_t *xconf)
{
	struct { unsigned char *n; int *k; }ks[7];
	int i, j = 1;

	ks[0].n = kn3[0]; ks[0].k = &xconf->anti;
	ks[1].n = kn3[1]; ks[1].k = &xconf->title_on;
	ks[2].n = kn3[2]; ks[2].k = &xconf->page_on;
	ks[3].n = kn3[3]; ks[3].k = &xconf->kinsc;
	ks[4].n = kn3[4]; ks[4].k = &xconf->chuki;
	ks[5].n = kn3[5]; ks[5].k = &xconf->cursor;

	subwindow_data_insert(head,tail,T_NAME,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,X_CANCEL,NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,"",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,s_title,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	for(i = 0; i < 6; i++){
		if(i % 2 == 0)
			subwindow_data_insert(head,tail,ks[i].n,(char *)ks[i].k,NULL,xtext_conf_change,ks[i].k,XJP_INT,XJP_INT,j);
		else
			subwindow_data_insert(head,tail,ks[i].n,(char *)ks[i].k,NULL,xtext_conf_change,ks[i].k,XJP_INT,XJP_INT,j++);
	}
	return 0;
}
int xtextConfFontData2Sub(sub_window_t **head,sub_window_t **tail,xtext_conf_t *xconf)
{
	struct { unsigned char *n; char *k; }ks[6];
	int i, j = 1;

	ks[0].n = kn2[0]; ks[0].k = xconf->main_font_j;
	ks[1].n = kn2[1]; ks[1].k = xconf->main_font_s;
	ks[2].n = kn2[2]; ks[2].k = xconf->main_font_e;
	ks[3].n = kn2[3]; ks[3].k = xconf->rubi_font;
	ks[4].n = kn2[4]; ks[4].k = NULL;
	ks[5].n = kn2[5]; ks[5].k = NULL;
	ks[6].n = kn2[6]; ks[6].k = NULL;

	subwindow_data_insert(head,tail,T_NAME,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,X_CANCEL,NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,"",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,f_title,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	for(i = 0; i < 7; i++){
		if(i == 4){
			subwindow_data_insert(head,tail,ks[i].n,(char *)&xconf->line_space,NULL,xtext_conf_change,(int *)&xconf->line_space,XJP_INT,XJP_INT,j);
		}else if(i == 5){
			subwindow_data_insert(head,tail,ks[i].n,(char *)&xconf->row_space,NULL,xtext_conf_change,(int *)&xconf->row_space,XJP_INT,XJP_INT,j);
		}else if(i == 6){
			subwindow_data_insert(head,tail,ks[i].n,(char *)&xconf->max_line,NULL,xtext_conf_change,(int *)&xconf->max_line,XJP_INT,XJP_INT,j++);
		}else{
			subwindow_data_insert(head,tail,ks[i].n,ks[i].k,NULL,xtext_conf_change,ks[i].k,XJP_FONT,XJP_FONT,j++);
		}
	}
	return 0;
}
int xtextConfWinData2Sub(sub_window_t **head,sub_window_t **tail,xtext_conf_t *xconf)
{
	struct { unsigned char *n; char *k; }ks[10];
	unsigned char str[48]; int i, j = 1;

	ks[0].n = kn1[0]; ks[0].k = xconf->main_window_color;
	ks[1].n = kn1[1]; ks[1].k = xconf->main_font_color;
	ks[2].n = kn1[2]; ks[2].k = xconf->find_font_color;
	ks[3].n = kn1[3]; ks[3].k = xconf->rubi_font_color;
	ks[4].n = kn1[4]; ks[4].k = xconf->menu_window_color;
	ks[5].n = kn1[5]; ks[5].k = xconf->menu_font_color;
	ks[6].n = kn1[6]; ks[6].k = xconf->main_shadow_color;
	ks[7].n = kn1[7]; ks[7].k = xconf->select_window_color;
	ks[8].n = kn1[8]; ks[8].k = xconf->select_font_color;
	ks[9].n = kn1[9]; ks[9].k = xconf->select_font_background_color;

	subwindow_data_insert(head,tail,T_NAME,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,X_CANCEL,NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,"",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,w_title,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	sprintf(str,"%s %d",kn1[10],xconf->main_window_width);
	subwindow_data_insert(head,tail,str,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	sprintf(str,"%s %d",kn1[11],xconf->main_window_height);
	subwindow_data_insert(head,tail,str,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	for(i = 0; i < 10; i++){
		subwindow_data_insert(head,tail,ks[i].n,ks[i].k,NULL,xtext_conf_change,ks[i].k,XJP_COL,XJP_COL,j++);
	}
	return 0;
}
int xtextConfKeyData2Sub(sub_window_t **head,sub_window_t **tail,xtext_conf_t *xconf)
{
	struct { unsigned char *n; char *k; }ks[18];
	int i, j = 1;

	ks[0].n = kn0[0]; ks[0].k = xconf->page_next;
	ks[1].n = kn0[1]; ks[1].k = xconf->page_prev; 
	ks[2].n = kn0[2]; ks[2].k = xconf->conf_page; 
	ks[3].n = kn0[3]; ks[3].k = xconf->book_mark; 
	ks[4].n = kn0[4]; ks[4].k = xconf->siori_menu; 
	ks[5].n = kn0[5]; ks[5].k = xconf->menu; 
	ks[6].n = kn0[6]; ks[6].k = xconf->quit; 
	ks[7].n = kn0[7]; ks[7].k = xconf->title_key; 
	ks[8].n = kn0[8]; ks[8].k = xconf->page_key; 
	ks[9].n = kn0[9]; ks[9].k = xconf->kinsc_key; 
	ks[10].n = kn0[10]; ks[10].k = xconf->chuki_key; 
	ks[11].n = kn0[11]; ks[11].k = xconf->net_key; 
	ks[12].n = kn0[12]; ks[12].k = xconf->cursor_key; 
	ks[13].n = kn0[13]; ks[13].k = xconf->other_key; 
	ks[14].n = kn0[14]; ks[14].k = xconf->find_key; 
	ks[15].n = kn0[15]; ks[15].k = xconf->find_next; 
	ks[16].n = kn0[16]; ks[16].k = xconf->find_prev; 
	ks[17].n = kn0[17]; ks[17].k = xconf->rast_key; 

	subwindow_data_insert(head,tail,T_NAME,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,X_CANCEL,NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,"",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	subwindow_data_insert(head,tail,k_title,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,j++);
	for(i = 0; i < 18; i++){
		if(i == 11){
#if HAVE_NETDB_H
			subwindow_data_insert(head,tail,ks[i].n,ks[i].k,NULL,xtext_conf_change,ks[i].k,XJP_CHA,XJP_CHA,j++);
#endif
			continue;
		}else if(i == 17){
#if HAVE_ATEXIT
			subwindow_data_insert(head,tail,ks[i].n,ks[i].k,NULL,xtext_conf_change,ks[i].k,XJP_CHA,XJP_CHA,j++);
#endif
			continue;
		}else{
			subwindow_data_insert(head,tail,ks[i].n,ks[i].k,NULL,xtext_conf_change,ks[i].k,XJP_CHA,XJP_CHA,j++);
		}
	}
	return 0;
}
int xtextHelpData2Sub(sub_window_t **head,sub_window_t **tail,xtext_conf_t *xconf)
{
	other_prog_t *op; xtext_func_t *xfunc[4]; int i = 1;

	if(*head != NULL) subwindow_data_free(head,tail);

	subwindow_data_insert(head,tail,T_NAME,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,kn4[0],NULL,NULL,xtext_conf_quit,(char *)XJP_OK,XJP_NONE,XJP_NONE,i);
	subwindow_data_insert(head,tail,kn4[1],NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,i);
	subwindow_data_insert(head,tail,kn4[2],NULL,NULL,xtext_conf_save,(xtext_conf_t *)xconf,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,c_title,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,kn4[3],xconf->book_dir,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
#if HAVE_NETDB_H
	if(xconf->ao_url != NULL)
		subwindow_data_insert(head,tail,kn4[6],xconf->ao_url,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	if(xconf->ao_list != NULL)
		subwindow_data_insert(head,tail,kn4[7],xconf->ao_list,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
#endif
#if HAVE_ATEXIT
	if(xconf->rast_db != NULL)
		subwindow_data_insert(head,tail,kn4[4],xconf->rast_db,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
#endif
	for(op=xconf->other_head;op!=NULL;op=op->next)
		subwindow_data_insert(head,tail,kn4[5],op->exec,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,"",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);

	if((xfunc[0] = (xtext_func_t *)malloc(sizeof(xtext_func_t))) != NULL){
		xfunc[0]->func = xtextConfKeyData2Sub; xfunc[0]->xconf = xconf;
		subwindow_data_insert(head,tail,k_title,NULL,NULL,select_conf_key,xfunc[0],0,XJP_NONE,i++);
	}
	if((xfunc[1] = (xtext_func_t *)malloc(sizeof(xtext_func_t))) != NULL){
		xfunc[1]->func = xtextConfWinData2Sub; xfunc[1]->xconf = xconf;
		subwindow_data_insert(head,tail,w_title,NULL,NULL,select_conf_key,xfunc[1],0,XJP_NONE,i++);
	}
	if((xfunc[2] = (xtext_func_t *)malloc(sizeof(xtext_func_t))) != NULL){
		xfunc[2]->func = xtextConfFontData2Sub; xfunc[2]->xconf = xconf;
		subwindow_data_insert(head,tail,f_title,NULL,NULL,select_conf_key,xfunc[2],0,XJP_NONE,i++);
	}
	if((xfunc[3] = (xtext_func_t *)malloc(sizeof(xtext_func_t))) != NULL){
		xfunc[3]->func = xtextConfInitData2Sub; xfunc[3]->xconf = xconf;
		subwindow_data_insert(head,tail,s_title,NULL,NULL,select_conf_key,xfunc[3],0,XJP_NONE,i++);
	}
	return 0;
}
int xtextSioriData2Sub(sub_window_t **head,sub_window_t **tail,ISIORI_T *s_head)
{
	sub_window_t *sw;
	ISIORI_T *si; int i = 1;

	if(s_head == NULL) return -1;
	if(*head != NULL) subwindow_data_free(head,tail);
	subwindow_data_insert(head,tail,T_NAME,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,X_CANCEL,NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,si_title,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	for(si=s_head;si!=NULL;si=si->next){
		sw = (sub_window_t *) subwindow_data_alloc();
		sw->line_str = si->book_title;
		sw->line_data = si->book_time;
		sw->re_str = si->book_path;
		sw->func_data1 = XJP_STR;
		sw->line_no = i++;
		subwindow_data_add(head,tail,sw);
	}
	return 0;
}
int xtextPerson2Sub(sub_window_t **head,sub_window_t **tail,IPERSON_T *phead)
{
	IPERSON_T *ip;
	sub_window_t *sw;
	int i = 1;

	if(*head != NULL) subwindow_data_free(head,tail);
	subwindow_data_insert(head,tail,T_NAME,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,X_CANCEL,NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,pe_title,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	for(ip=phead;ip!=NULL;ip=ip->next){
		sw = (sub_window_t *) subwindow_data_alloc();
		sw->line_str = ip->person;
		sw->line_data = &(ip->no);
		sw->type = XJP_INT;
		sw->func = select_book_data;
		sw->func_data0 = (IBOOK_T *)ip->head;
		sw->func_data1 = 1;
		sw->line_no = i++;
		subwindow_data_add(head,tail,sw);
	}
	return 0;
}
int xtextBookData2Sub(sub_window_t **head,sub_window_t **tail,IBOOK_T *bhead,int type)
{
	sub_window_t *sw; IBOOK_T *ib; int i = 1;

	if(bhead == NULL) return 0;
	if(*head != NULL) subwindow_data_free(head,tail);
	subwindow_data_insert(head,tail,T_NAME,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
	subwindow_data_insert(head,tail,X_CANCEL,NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,i);
	if(type == 0){
		subwindow_data_insert(head,tail,kn5[0],NULL,NULL,config_win,NULL,0,XJP_INT,i);
		subwindow_data_insert(head,tail,kn5[1],NULL,NULL,select_siori_data,(ISIORI_T *)bhead->siori,95,XJP_INT,i);
#if HAVE_NETDB_H
		subwindow_data_insert(head,tail,kn5[2],NULL,NULL,net_win,NULL,0,XJP_INT,i++);
#endif
#if HAVE_ATEXIT
		subwindow_data_insert(head,tail,kn5[3],NULL,NULL,rast_search_data,(char *)bhead->dbpath,65,XJP_INT,i);
#endif
		subwindow_data_insert(head,tail,kn5[4],NULL,NULL,select_serch_data,(IBOOK_T *)bhead,60,XJP_INT,i++);
		subwindow_data_insert(head,tail,kn5[5],NULL,NULL,menu_win,XJP_CANCEL,XJP_NONE,XJP_NONE,i);
		subwindow_data_insert(head,tail,kn5[6],NULL,NULL,select_person_data,(IBOOK_T *)bhead,0,XJP_INT,i++);
		subwindow_data_insert(head,tail,bo_title,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
		for(ib=bhead;ib!=NULL;ib=ib->next){
			sw = (sub_window_t *) subwindow_data_alloc();
			sw->line_str = ib->title;
			sw->line_data = ib->filename;
			sw->re_str=ib->fullpath;
			sw->func_data1 = XJP_STR;
			sw->line_no = i++;
			subwindow_data_add(head,tail,sw);
		}
	}else{
		char temp[512];
		IPERSON_T *phead=NULL, *ptail=NULL, *ip;

		ibookGetPersonData(&phead,&ptail,bhead);
		i++;
		for(ip=phead;ip!=NULL;ip=ip->next){
			sprintf(temp,"-- %s--",ip->person);
			subwindow_data_insert(head,tail,temp,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);
			for(ib=ip->head;ib!=NULL;ib=ib->next){
				sw = (sub_window_t *) subwindow_data_alloc();
				sw->line_str = ib->title;
				sw->line_data = ib->filename;
				sw->line_data1 = ib->summary;
				sw->re_str=ib->fullpath;
				sw->func_data1 = XJP_STR;
				sw->line_no = i++;
				subwindow_data_add(head,tail,sw);
			}
		}
		person_link_free(phead);
	}
	return 0;
}
int xtextQuitData2Sub(sub_window_t **head,sub_window_t **tail)
{
	if(*head != NULL) subwindow_data_free(head,tail);
	subwindow_data_insert(head,tail,X_QUIT,NULL,NULL,xtext_conf_quit,(char *)XJP_OK,XJP_NONE,XJP_NONE,0);
	subwindow_data_insert(head,tail,X_CANCEL,NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,1);
	return 0;
}

