#include "itext.h"
#include "itext_file.h"
#include "itext_f2.h"
#include "xtext.h"
#include "xjp.h"

static int CHU_NO = 0;
static int RUBY_YPOS = 0;
static int XtextDrawString(Display *,my_window_t *,char_data_t *,ITEXT_T *,int,int);
static int XtextDrawAntiString(Display *,my_window_t *,char_data_t *,ITEXT_T *,int,int);
static int XtextDrawImageString(Display *,my_window_t *,char_data_t *,ITEXT_T *,int,int);
static int XtextDrawChuString(Display *,my_window_t *,char_data_t *,ITEXT_T *,int,int);
static int XtextDrawRubiString(Display *,my_window_t *,char_data_t *,ITEXT_T *,int,int);
static int XtextDrawBoutenString(Display *,my_window_t *,char_data_t *,int,int,int);
static int XtextDrawBousenString(Display *,my_window_t *,char_data_t *,int,int,int);
static int XtextDrawKunString(Display *,my_window_t *,char_data_t *,ITEXT_T *,int,int);
static int XtextDrawKunString_t(Display *,my_window_t *,char_data_t *,ITEXT_T *,int,int);
static int _Draw_Page(Display *,my_window_t *,char_data_t *,page_data_t *);
static int _Draw_Title(Display *,my_window_t *,char_data_t *);
static int _Draw_Other(Display *,my_window_t *,IOTHER_T *);
static int _Draw_String(Display *,my_window_t *,char_data_t *,ITEXT_T *,int,int);

static int XtextDrawKunString(		Display *disp,
					my_window_t *win,
					char_data_t *char_d,
					ITEXT_T *it,
					int x,
					int y		)
{
	ITEXTR_T *kt;
	int cx,cy;
	char utf8[10];
	unsigned char tmp[3];

	if(it == NULL || char_d == NULL) return -1;
	cx = x - (char_d->charSize_r / 3);
	cy = y + char_d->charSize_r + 1;
	for(kt=it->chu_head;kt!=NULL;kt=kt->next){
		if(kt->c1 == SHARP_1 && kt->c2 == SHARP_2) continue;
		if(kt->c1 == SKAKO_1 && kt->c2 == EKAKO_2) continue;
		if(kt->c1 == SKAKO_1 && kt->c2 == SKAKO_2){
			int xx;
			xx = char_d->charSize;
			if(ChFlag(it->flag,_SML)) xx = char_d->charSize_s;
			cx = (x + xx) - (char_d->charSize_r); 
		       	continue;
		}

		tmp[0] = kt->c1; tmp[1] = kt->c2; tmp[2] = '\0';
		if(win->anti){
#if HAVE_LIBXFT
			euc2utf8_c(XJP_CONV,utf8,tmp,2);
			XftDrawStringUtf8(win->draw,&(win->fg_color),win->font_rubi,cx,cy,utf8,strlen(utf8));
#else
			XmbDrawString(disp,win->win,win->rubi_fs,win->gc,cx,cy,tmp,strlen(tmp));
#endif
		}else{
			XmbDrawString(disp,win->win,win->rubi_fs,win->gc,cx,cy,tmp,strlen(tmp));
		}
		cy += char_d->charSize_r + 1;
	}
	return 0;
}
static int XtextDrawString(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x,
				int y		)
{
	GC gc;
	XFontSet fs;
	unsigned char text[3];
	int xpad,ypad;

	text[0] = it->c1; text[1] = it->c2; text[2] = '\0';
	gc = win->gc;
	fs = win->fs;
	if(ChFlag(it->flag,_CHU)) gc = win->rubi_gc;
	if(ChFlag(it->flag,_SML)) fs = win->fs_s;
	GetOffset(it->off,&xpad,&ypad);
	XmbDrawString(disp,win->win,fs,gc,x+xpad,y+ypad,text,strlen(text));
	if(ChFlag(it->flag,_KUN))
		XtextDrawKunString(disp,win,char_d,it,x+xpad,y+ypad);
	return 0;
}
static int XtextDrawAntiString(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x,
				int y		)
{
#if HAVE_LIBXFT
	XftFont *font;
	XftColor color;
	XGlyphInfo gi;
	int xoff = 0;
	int yoff = 0;
	int xpad,ypad;
	int charSize;
	char utf8[10];
	unsigned char temp[3];

	temp[0] = it->c1; temp[1] = it->c2; temp[2] = '\0';
	euc2utf8_c(XJP_CONV,utf8,temp,2);

	font = win->font;
	color = win->fg_color;
	charSize = char_d->charSize;
	GetOffset(it->off,&xpad,&ypad);
	if(ChFlag(it->flag,_CHU)) color = win->rubi_color;
	if(ChFlag(it->flag,_FND)) color = win->find_color;
	if(ChFlag(it->flag,_SML)){
		font = win->font_s; charSize = char_d->charSize_s; }

	XftTextExtentsUtf8(disp,font,utf8,strlen(utf8),&gi);
	xoff = (charSize - gi.xOff)/2; yoff = 0;
	XftDrawStringUtf8(win->draw,&color,font,x+xoff+xpad,y+yoff+ypad,utf8,strlen(utf8));
	if(ChFlag(it->flag,_KUN))
		XtextDrawKunString(disp,win,char_d,it,x+xoff+xpad,y+yoff+ypad);
#else
	XtextDrawString(disp,win,char_d,it,x,y);
#endif
	return 0;
}
static int XtextDrawImageString(	Display *disp,
					my_window_t *win,
					char_data_t *char_d,
					ITEXT_T *it,
					int x0,
					int y0	)
{
	XImage *image_str = NULL;
	image_data_t *im;
	int x,y;
	int charSize;

	for(im=char_d->im_head;im!=NULL;im=im->next){
		if(	im->c1 == it->c1 					&& 
			im->c2 == it->c2 					&& 
			ChFlag(im->flag,_CHU) == ChFlag(it->flag,_CHU) 		&& 
			ChFlag(im->flag,_SML) == ChFlag(it->flag,_SML)		&&	
			ChFlag(im->flag,_FND) == ChFlag(it->flag,_FND)		){
				image_str = im->char_image;
				break;
		}
	}
	if(image_str == NULL) return -1;
	charSize = char_d->charSize;
	if(ChFlag(it->flag,_SML)) 
		charSize = char_d->charSize_s;
	x = x0; y = y0 - charSize + 1;
	XPutImage(disp,win->win,win->gc,image_str,
				0,0,x,y,image_str->width,image_str->height);
	return 0;
}
static int XtextDrawChuString(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x0,
				int y0	)
{
	XRectangle ink,log;
	char temp[BUFSIZ];
	int w,x,y;

	if(it == NULL) return -1;
	if(it->chu_string == NULL) return -1;
	sprintf(temp,"(%d)",++CHU_NO);
	w = XmbTextExtents(win->rubi_fs,temp,strlen(temp),&ink,&log);	
	x = x0 + (char_d->charSize - w)/2 + 1;
	y = y0 + char_d->charSize_r+1;
	XmbDrawString(disp,win->win,win->rubi_fs,win->sgc,x,y,temp,strlen(temp));
	sprintf(temp,"(%d) %s",CHU_NO,it->chu_string);
	xtextChuMessage(disp,win,char_d,temp);
	return 0;
}
static int XtextDrawRubiString(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x0,
				int y0	)
{
	ITEXT_T *ib;
	ITEXTR_T *rb;
	unsigned char text[3];
	char utf8[10];
	int k_len=0,r_len=0;
	int x,y,i,tail_y;

	if(win->anti == 0){
		if(win->rubi_fs == NULL) return -1;
	}else{
#if HAVE_LIBXFT
		if(win->font_rubi == NULL) return -1;
#else
		if(win->rubi_fs == NULL) return -1;
#endif
	}
	if(ChFlag(it->flag,_RUB)){
		int m;
		GetFlag(it->flag,m);
		for(i=1;i<m;i++)
			k_len = k_len + (char_d->charSize + char_d->ypad);
	}else{
		for(ib=it;ib!=NULL;ib=ib->prev){
			if(!(ib->c1 >= 0xb0) && k_len != 0) break;
			k_len = k_len + (char_d->charSize + char_d->ypad);
		}
	}
	for(rb=it->rubi_head;rb!=NULL;rb=rb->next)
		r_len = r_len + char_d->charSize_r;
	if(k_len >= r_len)
		y = y0;
	else
		if((y = y0 + ((r_len - k_len)/2)) > win->height-2) y = y0;

	if(y - r_len < 0) y = r_len + char_d->charSize_r;
	if(y - r_len < RUBY_YPOS) y = RUBY_YPOS + r_len + char_d->charSize_r;
	RUBY_YPOS = y;
	x = x0 + char_d->charSize - 1;
	for(rb=it->rubi_tail;rb!=NULL;rb=rb->prev){
		text[0] = rb->c1; text[1] = rb->c2; text[2] = '\0';
		if(win->anti == 0){
			XmbDrawString(disp,win->win,win->rubi_fs,win->rubi_gc,
								x,y,text,strlen(text));
		}else{
#if HAVE_LIBXFT
			euc2utf8_c(XJP_CONV,utf8,text,2);
			XftDrawStringUtf8(win->draw,&(win->rubi_color),win->font_rubi,
								x,y,utf8,strlen(utf8));
#else
			XmbDrawString(disp,win->win,win->rubi_fs,win->rubi_gc,
								x,y,text,strlen(text));
#endif
		}
		y = y - char_d->charSize_r;
	}
	return 0;
}
static int XtextDrawBoutenString(	Display *disp,
					my_window_t *win,
					char_data_t *char_d,
					int btype,
					int x0,
					int y0			)
{
	int x,y,x1,y1;

	if(win == NULL) return -1;
	if(char_d == NULL) return -1;
	x = x0 + char_d->charSize;
	x1 = x + char_d->charSize_r;
	y = y0 - char_d->charSize;
	y1 = y0;
	xtextDrawArc(disp,win,x,y,x1,y1,btype);
	return 0;
}
static int XtextDrawBousenString(	Display *disp,
					my_window_t *win,
					char_data_t *char_d,
					int btype,
					int x0,
					int y0			)
{
	int x,y,x1,y1;

	if(win == NULL) return -1;
	if(char_d == NULL) return -1;
	x = x0 + char_d->charSize + 1; x1 = x;
	y = y0 - char_d->charSize + 2; y1 = y0 + 2;
	xtextDrawLine(disp,win,x,y,x1,y1,btype);
	return 0;
}
static int _Draw_Page(Display *disp,my_window_t *win,char_data_t *char_d,page_data_t *char_p)
{
	char page_str[20];
	int width,height;

	sprintf(page_str,"(%d/%d)",char_p->page_no,char_d->book->total_page);
	xtext_get_string_size(disp,win,page_str,page_str,&width,&height,1);
	xtextDrawPageTitleString(disp,win,page_str,page_str,(win->width-width)/2,win->height-2,1);

	return 0;
}
static int _Draw_Title(Display *disp,my_window_t *win,char_data_t *char_d)
{
	char level_str[2][20];
	int width,height;

	if(char_d->book->book_title != NULL && char_d->book->book_title_utf8 != NULL){
		xtext_get_string_size(disp,win,char_d->book->book_title,char_d->book->book_title_utf8,&width,&height,1);
		xtextDrawPageTitleString(disp,win,char_d->book->book_title,char_d->book->book_title_utf8,2,height,1);
	}
	switch(win->kinsc){
		case 0: strcpy(level_str[0],""); break;
		case 1: strcpy(level_str[0],""); break;
		case 2: strcpy(level_str[0],""); break;
	}
	euc2utf8_c(XJP_CONV,level_str[1],level_str[0],strlen(level_str[0]));
	xtext_get_string_size(disp,win,level_str[0],level_str[1],&width,&height,1);
	xtextDrawPageTitleString(disp,win,level_str[0],level_str[1],win->width-width-5,height,1);

	if(char_d->book->book == NULL) return 0;
	xtext_get_string_size(disp,win,char_d->book->book,char_d->book->book,&width,&height,2);
	xtextDrawPageTitleString(disp,win,char_d->book->book,char_d->book->book,win->width-width-2,win->height-2,2);
	return 0;
}
static int _Draw_Other(Display *disp,my_window_t *win,IOTHER_T *o_head)
{
	IOTHER_T *op;
	int i,width,height;
	char *utf8,temp[32];

	if(o_head == NULL) return -1;
	i=0;
	for(op=o_head;op!=NULL;op=op->next)
		i++;
	sprintf(temp,"%s(%d)",XJP_MESSAGE[20],i);
	utf8 = (char *)euc2utf8(XJP_CONV,temp,strlen(temp));
	xtextDrawPageTitleString(disp,win,temp,utf8,2,win->height-1,0);
	free(utf8);
	return 0;
}
static int _Draw_String(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x,
				int y	)
{
	if(ChFlag(it->flag,_EJC)){
		if(XtextDrawImageString(disp,win,char_d,it,x,y) < 0){
			if(win->anti == 0)
				XtextDrawString(disp,win,char_d,it,x,y);
			else
				XtextDrawAntiString(disp,win,char_d,it,x,y);

			if(win->page_on){
				int m;

				if(ChFlag(it->flag,_TEN)){
					GetFlag(it->flag,m);
				       	XtextDrawBoutenString(disp,win,char_d,m,x,y);
				}
				if(ChFlag(it->flag,_SEN)){
					GetFlag(it->flag,m);
				       	XtextDrawBousenString(disp,win,char_d,m,x,y);
				}
				if(it->rubi_head != NULL) XtextDrawRubiString(disp,win,char_d,it,x,y);
			}
		}
	}else{
		XtextDrawImageString(disp,win,char_d,it,x,y);
	}
	if(it->chu_string != NULL) XtextDrawChuString(disp,win,char_d,it,x,y);
	return 0;
}
int xtext_Draw_Text(	Display *disp,
			my_window_t *win,
			ICONTENT_T *book,
			char_data_t *char_d,
			page_data_t *char_p	)
{
	IBUF_T *ib;
	ITEXT_T *it;

	int kin = 0, sc = 0, sc_max = 0,flag = 0;
	int x,y,h,width,height;
	int one_line,start_line,end_line,start_low,end_low;
	if(book == NULL) return -1;
	if(book->b_head == NULL) return -1;
	if(char_d == NULL) return -1;
       	if(char_d->draw == NULL) return -1;
	if(char_p != NULL) sc_max = char_p->char_no; else sc_max = 0;
	CHU_NO = 0;
	RUBY_YPOS = 0;
	
	XClearWindow(disp,win->win);
	xtextClearChuWindow(disp,win,char_d);
	if(char_p != NULL){
		if(book->o_head != NULL) _Draw_Other(disp,win,book->o_head);
		if(win->title_on) _Draw_Title(disp,win,char_d); 
		if(win->page_on) _Draw_Page(disp,win,char_d,char_p);
	}

	kin = win->kinsc;
	one_line = char_d->draw->one_line;
	start_line = char_d->draw->start_line;
	end_line = char_d->draw->end_line;
	start_low = char_d->draw->start_low;
	end_low = char_d->draw->end_low;
	x = start_line;
	y = start_low;
	for(ib=book->b_head;ib!=NULL;ib=ib->next){
		for(it=ib->i_head;it!=NULL;it=it->next){
			if(sc++ >= sc_max) flag++;
			if(flag){
				if(ChFlag(it->flag,_LST) || ChFlag(it->flag,_TOP)) 
					y = xtext_get_low_pos(it,char_d,y);

				_Draw_String(disp,win,char_d,it,x,y);
				h = xtext_get_low_space(it,char_d);

				if((y += h) > end_low){
					if(xtext_next_kuten(it,char_d,kin) == 0){
						if((x -= one_line) <= end_line) goto _draw_end;
						if(xtext_prev_kuten(it,char_d,kin) == 1){
					       		it = it->prev;
							XClearArea(disp,win->win,x+one_line,y-h*2,h+char_d->xpad+char_d->charSize_r+1,win->height,False);
						}
						y = start_low;
						RUBY_YPOS = 0;
					}
				}
			}
		}
		if(flag){
			if((x -= one_line) <= end_line) goto _draw_end;
			y = start_low;
			RUBY_YPOS = 0;
		}
	}
_draw_end:
	if(char_p != NULL)
		return char_p->char_no;
	else
		return 0;
}
int xtext_Draw_Text_v(     	Display *disp,
                        	my_window_t *win,
                        	unsigned char *str[],
                        	int no,
                        	int xpos,
                        	int ypos		)                
{
        ITEXT_T *ihead = NULL, *itail = NULL;
        ICONTENT_T *line;
        char_data_t *char_d;
        int i,r,c,s;

	if(disp == NULL || win == NULL) return 0;
        win->change_font = 1;

	if((line = (ICONTENT_T *)content_link_alloc()) == NULL) return 0;
	if((char_d = (char_data_t *)char_data_alloc()) == NULL) return 0;
        char_d->xpos = xpos; char_d->ypos = ypos;
        for(i=0;i<no;i++){
		ihead = NULL; itail = NULL; r = 0; c = 0; s = 0;
		itextGetStrData(str[i],&ihead,&itail,&r,&c,&s,1);
                _ibuf_add(&(line->b_head),&(line->b_tail),ihead,itail,no);
        }
        xtext_Init_Text(disp,win,line,char_d);
        xtext_Draw_Text(disp,win,line,char_d,NULL);
        win->change_font = 1;
        ibuf_data_free(line);
	char_data_free(char_d);
        return 0;
}
