#include "itext.h"
#include "xtext.h"
#include "xjp.h"
#include <dirent.h>
#define XJP_FILE
#include "xjp_file.h"
#define LOW_SPACE	5
#define COL_SPACE	50	

typedef struct SUBWINDOWPOS{
	int x0,x1,y0,y1;
	int px,py;
	sub_window_t *scw;
	struct SUBWINDOWPOS *next,*prev;
}sub_window_pos_t;

static int _get_line_str(char *,sub_window_t *);
static int _check_hilight(sub_window_t *sw);
static int _get_subwindow_size(Display *,my_subwindow_t *,sub_window_t *,int *,int *);
static int _Draw_SubWindow_Text(Display *,my_subwindow_t *,Pixmap,Pixmap,
							int,int,int,int,XSegment *seg);
static void _sub_window_pos_add(sub_window_pos_t **,sub_window_pos_t **, sub_window_pos_t *); 
static void _sub_window_pos_free(sub_window_pos_t *);
static sub_window_pos_t *_sub_window_pos_alloc();
static sub_window_t * _get_subwindow_func(sub_window_pos_t *,sub_window_pos_t *,int,int);
static Pixmap _get_pointer_pix(Display *,my_subwindow_t *);
static Pixmap _get_subwindow_pix(Display *,my_subwindow_t *,sub_window_t *,
				sub_window_pos_t **,sub_window_pos_t **,int,int);

static sub_window_pos_t *
_sub_window_pos_alloc()
{
	sub_window_pos_t *sp;
	if((sp = (sub_window_pos_t *)malloc(sizeof(sub_window_pos_t))) == NULL){
		fprintf(stderr,"False _window_pos()(malloc())\n");
		return NULL;
	}
	sp->x0 = 0; sp->x1 = 0; sp->y0 = 0; sp->y1 = 0;
	sp->scw = NULL;
	return sp;
}
static void 
_sub_window_pos_add(	sub_window_pos_t **start,
			sub_window_pos_t **end,
			sub_window_pos_t *mg		)
{
        if(*end){mg->next = NULL;mg->prev = *end;(*end)->next = mg;*end = mg;}
        else{mg->next = NULL;mg->prev = NULL;*end = mg;*start = mg;}
}
static void 
_sub_window_pos_free(sub_window_pos_t *head)
{
	sub_window_pos_t *sp,*spp;
	if(head == NULL) return;
	for(sp=head;sp!=NULL;sp=spp){
		spp = sp->next;
		free(sp);
	}
}
static int 
_get_line_str(char *line,sub_window_t *sw)
{
	if(sw == NULL) return -1;
	if(sw->line_data == NULL){
		strcpy(line,sw->line_str);
	}else{
		if(sw->type == XJP_INT){
			sprintf(line,"%s  (%d)",sw->line_str,*((int *)sw->line_data));
		}else if(sw->type == XJP_ONF){
			if(*(int *)sw->line_data)
				sprintf(line,"%s  (*)",sw->line_str);
			else
				sprintf(line,"%s  ( )",sw->line_str);
		}else{
			if((char *)sw->line_data1 == NULL)
				sprintf(line,"%s  (%s)",sw->line_str,(char *)sw->line_data);
			else
				sprintf(line,"%s  (%s) [%s]",sw->line_str,(char *)sw->line_data,(char *)sw->line_data1);
		}
	}
	return 0;
}
static int 
_check_hilight(sub_window_t *sw)
{
	if(sw == NULL) return 0;
	if(sw->func==NULL && sw->func_data0==NULL && sw->func_data1==XJP_NONE) return 1;
	return 0;
}
static int 
_get_subwindow_size(	Display *disp,
			my_subwindow_t *win,
			sub_window_t *head,
			int *max_w,int *max_h	)
{
	XRectangle ink,log;
	sub_window_t *st,*st1;
	char line_str[1024],utf8[2048];
	int w,h;

	if(head == NULL) return -1;
	*max_w = 0; *max_h = 0;
	if(win->anti){
#if HAVE_LIBXFT
		XGlyphInfo gi;
		for(st = head;st != NULL;st = st->next){
			_get_line_str(line_str,st);
			euc2utf8_c(XJP_CONV,utf8,line_str,strlen(line_str));
			XftTextExtentsUtf8(disp,win->font,utf8,strlen(utf8),&gi);
			w = gi.width + 30;
			for(st1 = head->head; st1 != NULL; st1 = st1->next){
				_get_line_str(line_str,st1);
				euc2utf8_c(XJP_CONV,utf8,line_str,strlen(line_str));
				XftTextExtentsUtf8(disp,win->font,utf8,strlen(utf8),&gi);
				w += gi.width + 30;
			}
			if(*max_w < w) *max_w = w;
			*max_h += (gi.height + LOW_SPACE + 2);
		}
		return 0;
#else
	goto _no_anti;
#endif
	}
_no_anti:
	for(st = head;st != NULL;st = st->next){
		_get_line_str(line_str,st);
		XmbTextExtents(win->fs,line_str,strlen(line_str),&ink,&log);
		w = ink.width + 30;
		for(st1 = head->head; st1 != NULL; st1 = st1->next){
			_get_line_str(line_str,st1);
			XmbTextExtents(win->fs,line_str,strlen(line_str),&ink,&log);
			w += ink.width + 30;
		}
		if(*max_w < w) *max_w = w;
		*max_h += (ink.height + LOW_SPACE + 2);
	}
	return 0;
}
static Pixmap
_get_pointer_pix(	Display *disp,
			my_subwindow_t *win	)
{
	Pixmap pix;

	if((pix = XCreatePixmapFromBitmapData(disp,win->win,arrow_data,
						ARROW_WIDTH,ARROW_HEIGHT,
						win->fg_pixel,win->bg_pixel,
						DefaultDepth(disp,0))) == 0	)
		return 0;

	return pix;
}
static int
_draw_subwindow_pix(	Display *disp,
			Pixmap	pix,
			my_subwindow_t *win,
			sub_window_t *sw,
			sub_window_pos_t **phead,sub_window_pos_t **ptail,
			int *x, int *y, int type				)
{
	sub_window_pos_t *sp;
	char utf8[2048],line_str[1024];
	int sx = *x + ARROW_WIDTH + 2;

	if(type == 1){
		XGlyphInfo gi; XftFont *font;
		_get_line_str(line_str,sw);
		euc2utf8_c(XJP_CONV,utf8,line_str,strlen(line_str));
		if(_check_hilight(sw))
			font = win->font_s;
		else
			font = win->font;

		XftTextExtentsUtf8(disp,font,utf8,strlen(utf8),&gi);
		*y += gi.height + LOW_SPACE;

		XftDrawStringUtf8(win->draw,&(win->menu_fg_color),font,
							sx,*y,utf8,strlen(utf8));
		sp = (sub_window_pos_t *)_sub_window_pos_alloc();
		sp->scw = sw;
		sp->x0 = sx; sp->x1 = sx + gi.width + 2;
 		sp->y0 = *y - gi.height; sp->y1 = *y + 1; 	
		sp->px = *x; sp->py = (sp->y0 + (sp->y1 - sp->y0) / 2) - (ARROW_HEIGHT / 2);
		_sub_window_pos_add(phead,ptail,sp);
	}else{
		XRectangle ink,log; XFontSet fs;
		_get_line_str(line_str,sw);
		if(_check_hilight(sw))
			fs = win->fs_s;
		else
			fs = win->fs;

		XmbTextExtents(fs,line_str,strlen(line_str),&ink,&log);
		*y += log.height + LOW_SPACE;
		XmbDrawString(disp,pix,fs,win->fgc,sx,*y,line_str,strlen(line_str));

		sp = (sub_window_pos_t *)_sub_window_pos_alloc();
		sp->scw = sw;
		sp->x0 = sx; sp->x1 = sx + log.width + 2;
	      	sp->y0 = *y - log.height; sp->y1 = *y + 1; 	
		sp->px = *x; sp->py = (sp->y0 + (sp->y1 - sp->y0) / 2) - (ARROW_HEIGHT / 2);
		_sub_window_pos_add(phead,ptail,sp);
	}
	*x = sp->x1;
	return 0;
}
static Pixmap 
_get_subwindow_pix(	Display *disp,	
			my_subwindow_t *win,
			sub_window_t *head,
			sub_window_pos_t **phead, sub_window_pos_t **ptail,
			int max_w, int max_h					)
{
	Pixmap pix;
	sub_window_t *sw,*sw1;
	int x,y,x0,y0,x00,y00;

	if((pix = XCreatePixmap(disp,win->win,max_w,max_h,DefaultDepth(disp,0))) == 0)
		return 0;
	if(win->anti){
#if HAVE_LIBXFT
		win->draw = XftDrawCreate(disp,pix,win->visual,win->cmap);
		XftDrawRect(win->draw,&(win->menu_bg_color),0,0,max_w,max_h);
		y = 0;
		for(sw=head;sw!=NULL;sw=sw->next){
			x = 0; y00 = y;
			_draw_subwindow_pix(disp,pix,win,sw,phead,ptail,&x,&y,1);

			x0 = x;
			for(sw1 = sw->head; sw1 != NULL; sw1 = sw1->next){
				y0 = y00; _draw_subwindow_pix(disp,pix,win,sw1,phead,ptail,&x0,&y0,1); }
		}
		return pix;
#else
		goto _no_anti;
#endif
	}
_no_aniti:
	XFillRectangle(disp,pix,win->rfgc,0,0,max_w,max_h);
	y = 0;
	for(sw=head;sw!=NULL;sw=sw->next){
		x = 0; y00 = y;
		_draw_subwindow_pix(disp,pix,win,sw,phead,ptail,&x,&y,0);

		x0 = x;
		for(sw1 = sw->head; sw1 != NULL; sw1 = sw1->next){
			y0 = y00; _draw_subwindow_pix(disp,pix,win,sw1,phead,ptail,&x0,&y0,0); }
	}
	return pix;
}
static sub_window_t *
_get_subwindow_func(sub_window_pos_t *head,sub_window_pos_t *tail,int x,int y)
{
	sub_window_pos_t *sp;
	sub_window_t *sw;
	if(head == NULL) return NULL;
	for(sp=head;sp!=NULL;sp=sp->next){
		if( (x >= sp->x0 && x < sp->x1)	&& (y >= sp->y0 && y < sp->y1) ){
			return sp->scw;
		}
	}
	return NULL;
}
static int 
_Draw_SubWindow_Text(	Display *disp,
			my_subwindow_t *win,
			Pixmap sub_pix,Pixmap ptr_pix,
			int sx,int sy,int px,int py,
			XSegment *seg			)
{
	if(sub_pix == 0 || ptr_pix == 0) return 0;
	XCopyArea(disp,sub_pix,win->win,win->gc,sx,sy,win->width,win->height,0,0);
	XCopyArea(disp,ptr_pix,win->win,win->gc,0,0,ARROW_WIDTH,ARROW_HEIGHT,px,py);
	if(seg == NULL) return 0;
	XDrawSegments(disp,win->win,win->fgc,seg,1);
	return 0;
}
static char * 
_sub_return(Display *disp,my_window_t *win,sub_window_pos_t *psw)
{
	sub_window_t *csw;

	if((csw = psw->scw) == NULL) return NULL;

	if(csw->func == NULL && csw->re_str != NULL){
		return csw->re_str;
	}else if(csw->func != NULL && csw->re_str == NULL){

		switch(csw->func(csw->func_data0,csw->func_data1)){
			case -8:
		 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[22]); break;
			case -7:
		 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[13]); break;
			case -6:
		 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[12]); break;
			case -5:
		 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[11]); break;
			case -4:
			case -3:
		 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[5]); break;
			case -2:
		 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[4]); break;
			case -1:
		       		return XJP_CANCEL; break;
			case 1:
			 	return XJP_OK; break;
			case 2:
			 	xtextSubWindow_Message(disp,win,XJP_MESSAGE[3]); break;
			case 3:
				return XJP_NOOP; break;
		 }
	}
	return NULL;
}
char * xtextSubWindow(	Display *disp,
			my_window_t *win,
			sub_window_t *head,
			sub_window_t *tail,
			int percent,
			int center		)
{
	my_subwindow_t swin;
	XSegment seg,*seg_p;
	Pixmap sub_pix,ptr_pix;
	XEvent event; KeySym keysym;
	sub_window_t *csw;
	sub_window_pos_t *phead = NULL, *ptail = NULL, *psw;
	int max_w,max_h,sx,sy,px,py,loop = 1; char *result = NULL;
	int (*end_func)(); void *end_func_data0; int end_func_data1;

	if(head == NULL) return NULL;
	swin.fs = win->fs;
	swin.fs_s = win->fs_s;
	swin.gc = win->gc;
	swin.bgc = win->bgc;
	swin.fgc = win->fgc;
	swin.rfgc = win->rfgc;
	swin.sgc = win->sgc;
	swin.fg_pixel = win->menu_fg_pixel;
	swin.bg_pixel = win->menu_bg_pixel;
	swin.visual = win->visual;
	swin.cmap = win->cmap;
	swin.parent_win = win->win;
	swin.anti = win->anti;
#if HAVE_LIBXFT
	swin.draw = NULL;
	swin.font = win->font;
	swin.font_s = win->font_s;
	swin.menu_fg_color = win->menu_fg_color;
	swin.menu_bg_color = win->menu_bg_color;
#endif
	_get_subwindow_size(disp,&swin,head,&max_w,&max_h);
	swin.width = (win->width * percent) / 100;
	if(swin.width > max_w) swin.width = max_w;
	swin.height = (win->height * percent) / 100;
	if(swin.height > max_h) swin.height = max_h;
	swin.x = (win->width - swin.width) / 2;
	swin.y = (win->height - swin.height) / 2;
	swin.win = XCreateSimpleWindow(disp,swin.parent_win,swin.x,swin.y,swin.width,swin.height,2,swin.fg_pixel,swin.bg_pixel);
	XSelectInput(disp,swin.win,ExposureMask|KeyPressMask);
	XMapRaised(disp,swin.win);
	if((ptr_pix = _get_pointer_pix(disp,&swin)) == 0) 
		goto _end;
	if((sub_pix = _get_subwindow_pix(disp,&swin,head,&phead,&ptail,max_w,max_h)) == 0) 
		goto _end;
	psw = phead;
	px = 0;
	py = psw->y0;
	sx = 0; sy = 0;
	if(_check_hilight(psw->scw)){
		seg_p = NULL;
	}else{
		seg.x1 = psw->x0; seg.x2 = psw->x1;
		seg.y1 = psw->y1; seg.y2 = psw->y1;
		seg_p = &seg;
	}
	while(loop){
		XNextEvent(disp,&event);
		switch(event.type){
			case Expose:
				if(event.xexpose.count == 0)
					_Draw_SubWindow_Text(disp,&swin,
								sub_pix,ptr_pix,
									sx,sy,px,py,seg_p);
			break;
			case KeyPress:
				keysym = XLookupKeysym(&event.xkey,0);
				switch(keysym){
					case XK_Return:
						if((result = _sub_return(disp,win,psw)) != NULL){
							if(strcmp(result,XJP_NOOP) == 0){
								if(sub_pix) XFreePixmap(disp,sub_pix);
								if((sub_pix = _get_subwindow_pix(disp,&swin,head,&phead,&ptail,max_w,max_h)) == 0)
								       	goto _end;
								_Draw_SubWindow_Text(disp,&swin,sub_pix,ptr_pix,sx,sy,px,py,seg_p);
							}else{
								goto _end;
							}
						}
					break;
					case XK_q:
						result = XJP_CANCEL;
						goto _end;
					break;
					case XK_Up:
						if(psw->prev == NULL) break;
						if(((psw = psw->prev)->y0 - sy) < 0)
							sy = psw->y0 - py;
						else
							py = psw->py - sy;
						px = psw->px;

						if(sy < 0) sy = 0;
						if(_check_hilight(psw->scw)){
							seg_p = NULL;
						}else{
							seg.x1 = psw->x0;
							seg.x2 = psw->x1;
							seg.y1 = psw->y1 - sy; 
							seg.y2 = psw->y1 - sy;
							seg_p = &seg;
						}
						_Draw_SubWindow_Text(disp,&swin,
									sub_pix,ptr_pix,
									sx,sy,px,py,seg_p);
					break;
					case XK_Down:
						if(psw->next == NULL) break;
						if(((psw = psw->next)->y1) - sy > swin.height)
							sy = psw->y0 - py;

						else	
							py = psw->py - sy;
						px = psw->px;

						if(_check_hilight(psw->scw)){
							seg_p = NULL;
						}else{
							seg.x1 = psw->x0;
							seg.x2 = psw->x1;
							seg.y1 = psw->y1 - sy; 
							seg.y2 = psw->y1 - sy;
							seg_p = &seg;
						}
						_Draw_SubWindow_Text(disp,&swin,
									sub_pix,ptr_pix,
									sx,sy,px,py,seg_p);
					break;
					case XK_Right:
						if((sx += 10) >= (max_w - swin.width))
							sx = max_w - swin.width;
						seg_p = NULL;
						_Draw_SubWindow_Text(disp,&swin,
									sub_pix,ptr_pix,
									sx,sy,px,py,seg_p);
					break;
					case XK_Left:
						if((sx -= 10) <= 0){
							sx = 0;
							seg_p = &seg;
						}else{
							seg_p = NULL;
						}
						_Draw_SubWindow_Text(disp,&swin,
									sub_pix,ptr_pix,
									sx,sy,px,py,seg_p);
					break;
						
				}
			break;
		}
	}
_end:
	if(sub_pix) XFreePixmap(disp,sub_pix); 
	if(ptr_pix) XFreePixmap(disp,ptr_pix);
#if HAVE_LIBXFT
	if(win->anti){ if(swin.draw != NULL) XftDrawDestroy(swin.draw); }
#endif
	if(swin.win) XDestroyWindow(disp,swin.win);
	subwindow_data_free(&head,&tail); 
	_sub_window_pos_free(phead);
	return result;
}
int xtextSubWindow_Message(Display *disp,my_window_t *win,char *message)
{
	my_subwindow_t swin;
	XRectangle ink,log;
	int x,y;
	int message_len;

	if(message == NULL) return -1;
	swin.fs = win->fs_s;
	swin.gc = win->gc;
	swin.bgc = win->bgc;
	swin.fgc = win->fgc;
	swin.rfgc = win->rfgc;
	swin.sgc = win->sgc;
	swin.fg_pixel = win->menu_fg_pixel;
	swin.bg_pixel = win->menu_bg_pixel;
	swin.parent_win = win->win;
	message_len = strlen(message);
	XmbTextExtents(swin.fs,message,message_len,&ink,&log);
	swin.width = log.width + 4;
	swin.height = log.height + 4;
	swin.x = (win->width - swin.width) / 2;
	swin.y = (win->height - swin.height) / 2;
	swin.win = XCreateSimpleWindow(disp,swin.parent_win,swin.x,swin.y,swin.width,swin.height,1,swin.fg_pixel,swin.bg_pixel);
	XMapRaised(disp,swin.win);
	XmbDrawString(disp,swin.win,swin.fs,swin.fgc,2,log.height,message,message_len);
	XFlush(disp);
	sleep(1);
	XDestroyWindow(disp,swin.win);
	return 0;
}
