#include "itext.h"
#include "xtext.h"

static chu_data_t *chead = NULL, *ctail = NULL;
static chu_data_t * _chumessage_data_alloc();
static void _chumessage_data_free(chu_data_t **,chu_data_t **);
static void _chumessage_data_add(chu_data_t **,chu_data_t **,chu_data_t *);

static chu_data_t * _chumessage_data_alloc()
{
	chu_data_t *ct;

	if((ct = (chu_data_t *)malloc(sizeof(chu_data_t))) == NULL){
		fprintf(stderr,"False _chumeesage()(malloc()\n");
	       	return NULL;
	}; ct->message[0] = '\0';
	return ct;
}
static void _chumessage_data_free(chu_data_t **head,chu_data_t **tail)
{
	chu_data_t *ct,*ctt;
	for(ct = *head;ct != NULL;ct = ctt){ ctt = ct->next; free(ct); }
	*head = NULL; *tail = NULL;
}
static void _chumessage_data_add(chu_data_t **head,chu_data_t **tail,chu_data_t *im)
{
        if(*tail){im->next = NULL; im->prev = *tail;(*tail)->next = im;*tail = im;}
        else{ im->next = NULL;im->prev = NULL;*tail = im;*head = im;}
}
int xtextClearChuWindow(Display *disp,my_window_t *win)
{
	if(win == NULL) return -1;
	XClearWindow(disp,win->mwin);
	if(chead == NULL) return 0;
	_chumessage_data_free(&chead,&ctail);
	return 0;
}
int xtextDrawChuMessage(Display *disp,my_window_t *win,char_data_t *cd)
{
	chu_data_t *ct;

	Window root;
	char *p,*pp,temp[BUFSIZ];
	int w,h,bw,depth; int wx,wy,max;
	int i,x,y; int flag;

	XClearWindow(disp,win->mwin);
	if(chead == NULL) return -1;
	XGetGeometry(disp,win->mwin,&root,&wx,&wy,&w,&h,&bw,&depth);
	x = 1; y = 0; max = (w / cd->charSize_s) * 2;
	for(ct=chead;ct!=NULL;ct=ct->next){
		pp = ct->message;
		while(1){
			flag = 0; y = y + cd->charSize_s + 2;
			for(p=pp,i=0;*p;p++,i++){
				if(*p & 0x80) flag = flag ? 0 : 1;
				if(i >= max){
					if(flag == 0) temp[i++] = *(p++);
				       	break;
				}
				temp[i] = *p;
			}
			temp[i] = '\0'; XmbDrawString(disp,win->mwin,win->fs_s,win->fgc,x,y,temp,i);
			if(i<max)
				break;
			else
				pp = p;
		}
	}
	return 0;
}
int xtextChuMessage(Display *disp,my_window_t *win,char_data_t *cd,char *message)
{
	chu_data_t *ct;

	if((ct = (chu_data_t *)_chumessage_data_alloc()) == NULL) return -1;
	strcpy(ct->message,message);
	_chumessage_data_add(&chead,&ctail,ct);
	xtextDrawChuMessage(disp,win,cd);
	return 0;
}
