#include "itext.h"
#include "xtext.h"
#if HAVE_LIBXFT
static XftDraw *idraw;
#endif
static Window iwin;
static char *base = "";
static int height;

static void _move_input_position(XIC,XFontSet,char *,int,int);
static void _draw_input_window(Display *,my_window_t *win,int,int,char *,int);
static XIC _create_input_context(XIM,XIMStyle,XFontSet,Window,int,long,long);
static XIMStyle _select_input_style(XIM);

static void 
_move_input_position(XIC xic,XFontSet fs,char *str,int slen,int h)
{
	XPoint spot;
	XVaNestedList list;

	spot.x = 5 + XmbTextEscapement(fs,str,slen);spot.y = h;
	list = XVaCreateNestedList(	0,
					XNSpotLocation,&spot,
					NULL			);
	XSetICValues(	xic,
			XNPreeditAttributes,list,
			NULL				);
	XFree(list);
}
static XIC 
_create_input_context(XIM xim,XIMStyle style,XFontSet fs,Window p,int h,long fg,long bg)
{
	XIC ic;
	XVaNestedList list;
	XPoint spot;

	spot.x = 5; spot.y = h;
	list = XVaCreateNestedList(	0,
					XNFontSet,fs,
					XNSpotLocation,&spot,
					XNForeground,fg,
					XNBackground,bg,
					NULL			);
	ic = XCreateIC(	xim,
			XNInputStyle,style,
			XNClientWindow,p,
			XNPreeditAttributes,list,
			XNStatusAttributes,list,
			NULL				);

	if(ic == NULL) return NULL;
	XFree(list);
	return ic;
}
static XIMStyle 
_select_input_style(XIM xim)
{
	static XIMStyle preedit[] = {	XIMPreeditPosition,
					XIMPreeditArea,
					XIMPreeditNothing,
					0			};
	static XIMStyle status[] = {	XIMStatusArea,	
					XIMStatusNothing,	
					XIMStatusNone,
					0			};
	XIMStyles *im_style;
	int i,j,k;

	XGetIMValues(xim,XNQueryInputStyle,&im_style,NULL);
	i = 0;
	while(preedit[i] != 0){
		j = 0;
		while(status[j] != 0){
			for(k=0;k<im_style->count_styles;k++){
				if((preedit[i] & im_style->supported_styles[k])	&&
				   (status[j] & im_style->supported_styles[k])	){
					return im_style->supported_styles[k];
				}
			}
			j++;
		}
		i++;
	}
	return 0;
}
static void 
_draw_input_window(		Display *disp,
				my_window_t *win,
				int x,
				int y,
				char *str,
				int len			)
{
	if(str != NULL && len >= 0){
		XRectangle ink,log;
		char utf8[1024];
		int cx,cy;
		XClearWindow(disp,iwin);
		if(win->anti){
#if HAVE_LIBXFT
			XGlyphInfo gi;
		
			euc2utf8_c(XJP_CONV,utf8,str,len);
			XftDrawStringUtf8(idraw,&(win->menu_fg_color),win->font,x,y,utf8,strlen(utf8));
			XftTextExtentsUtf8(disp,win->font,utf8,strlen(utf8),&gi);
			cx = x + gi.width;
			cy = y - height + 2;
#else
			goto _no_anti3;
#endif
		}else{
_no_anti3:
			XmbDrawString(disp,iwin,win->fs,win->fgc,x,y,str,len);
			XmbTextExtents(win->fs,str,len,&ink,&log);
			cx = x + log.width;
			cy = y - height + 2;
		}
		XFillRectangle(disp,iwin,win->fgc,cx,cy,3,height);
	}
}
char * 
xtextInputWindow(Display *disp,my_window_t *win,char *title,char *title2,int percent)
{
#if HAVE_LIBXFT
	XftDraw *draw;
#endif
	Window pwin;
	XIM xim;
	XIC xic;
	XIMStyle xstyle;
	XEvent event;
	XRectangle ink,log;

	long mask;
	KeySym sym;
	Status st;

	char *buf,*result = NULL;
	int blen = 1024,len;
	char str[1024],utf8[1024];
	int slen = 0;
	int i,base_width,base_height;

	int x,y,w,h;
	int x1,y1,w1,h1;

	if(XSetLocaleModifiers("") == NULL) return NULL;
	if((xim = XOpenIM(disp,NULL,NULL,NULL)) == NULL){
		fprintf(stderr,"XJP-TEXT:Can't Open Input Method. Why ?\n");
	       	return NULL;
	}

	if(win->anti){
#if HAVE_LIBXFT
		XGlyphInfo gi;
		euc2utf8_c(XJP_CONV,utf8,base,strlen(base));
		XftTextExtentsUtf8(disp,win->font,utf8,strlen(utf8),&gi);
		base_width = gi.width;
		base_height = gi.height;
#else
		goto _no_anti;
#endif
	}else{
_no_anti:
		XmbTextExtents(win->fs,base,strlen(base),&ink,&log);
		base_width = ink.width;
		base_height = ink.height;
	}
	height = base_height;

	if(title == NULL && title2 == NULL){
		h = base_height + 4;
	}else{
		h = base_height * 4;
	}
	w = (win->width * percent) / 100;
	x = (win->width - w) / 2;
	y = (win->height - h) / 2;
	pwin = XCreateSimpleWindow(disp,win->win,x,y,w,h,2,win->menu_fg_pixel,win->menu_bg_pixel);
#if HAVE_LIBXFT
	if(win->anti){
		draw = XftDrawCreate(disp,pwin,win->visual,win->cmap);
		XftDrawRect(draw,&(win->menu_bg_color),0,0,w,h);
	}
#endif

	x1 = 5;
	h1 = base_height + 10;
	if(title == NULL && title2 != NULL){
		y1 = (h - h1) / 2;
		w1 = w / 2;
	}else if(title != NULL && title2 == NULL){
		y1 = base_height + 15;
		w1 = w - 10;
	}else if(title == NULL && title2 == NULL){
		x1 = 0;
		y1 = 0;
		w1 = w;
		h1 = base_height + 4;
	}else{
		y1 = base_height + 15;
		w1 = w/2;
	}
	iwin = XCreateSimpleWindow(disp,pwin,x1,y1,w1,h1,0,win->menu_fg_pixel,win->menu_bg_pixel);
	if(win->anti){
#if HAVE_LIBXFT
		idraw = XftDrawCreate(disp,iwin,win->visual,win->cmap);
		XftDrawRect(idraw,&(win->menu_bg_color),0,0,w1,h1);
#endif
	}
	if((xstyle = _select_input_style(xim)) == 0){
		fprintf(stderr,"XJP-TEXT:Can't Input Style.");
		goto end;
	}
	if((xic = _create_input_context(xim,xstyle,win->fs,pwin,h1-2,win->fg_pixel,win->bg_pixel)) == NULL){
		fprintf(stderr,"XJP-TEXT:Can't Input Context.");
		goto end;
	}
	XGetICValues(xic,XNFilterEvents,&mask,NULL);

	XSelectInput(disp,iwin,ExposureMask|KeyPressMask|/*EnterWindowMask|LeaveWindowMask|*/mask);
	XSelectInput(disp,pwin,ExposureMask);

	XMapRaised(disp,pwin);
	XMapWindow(disp,iwin);

	XSetICValues(xic,XNFocusWindow,iwin,NULL);
	XSetICFocus(xic);
	if(xstyle & XIMPreeditPosition)
		_move_input_position(xic,win->fs,str,slen,h1-5);

	buf = (char *)malloc(blen);
	while(1){
		XNextEvent(disp,&event);
		if(XFilterEvent(&event,iwin)) continue;


		switch(event.type){
			/*
			case EnterNotify:
				XSetICValues(xic,XNFocusWindow,iwin,NULL);
				XSetICFocus(xic);
				if(xstyle & XIMPreeditPosition)
					_move_input_position(xic,win->fs,str,slen,h1-2);
			break;
			case LeaveNotify:
				XUnsetICFocus(xic);
			break;
			*/
			case KeyPress:
				len = XmbLookupString(xic,&event,buf,blen,&sym,&st);
				if(st == XBufferOverflow){
					buf = (char *)realloc(buf,len);
					blen = len;
					len = XmbLookupString(xic,&event,buf,blen,&sym,&st);
				}
				switch(st){
					case XLookupBoth:case XLookupChars:
						if(sym == XK_BackSpace){
							if(str[--slen] & 0x80)
								--slen;
							if(slen < 0) slen = 0;

						}else if(sym == XK_Return){
							if(slen > 0){
								str[slen] = '\0';
								result = (char *)malloc(slen + 2);
								strcpy(result,str);
							}else{
								result = NULL;
							}
							goto end;

						}else{
							for(i=0;i<len;i++) str[slen++] = buf[i];
						}

						if(xstyle & XIMPreeditPosition)
							_move_input_position(xic,win->fs,str,slen,h1-5);

						_draw_input_window(disp,win,5,h1-5,str,slen);
					break;
				}
			break;
			case Expose:
				if(event.xexpose.count == 0)
					if(title != NULL){
						if(win->anti){
#if HAVE_LIBXFT
							euc2utf8_c(XJP_CONV,utf8,title,strlen(title));
							XftDrawStringUtf8(draw,&(win->menu_fg_color),win->font,5,height+5,utf8,strlen(utf8));
#else
							goto _no_anti1;
#endif
						}else{
_no_anti1:
							XmbDrawString(disp,pwin,win->fs,win->fgc,5,height+5,title,strlen(title));
						}
					}
					if(title2 != NULL){
						if(win->anti){
#if HAVE_LIBXFT
							euc2utf8_c(XJP_CONV,utf8,title2,strlen(title2));
							XftDrawStringUtf8(draw,&(win->menu_fg_color),win->font,w/2+20,y1+height+5,utf8,strlen(utf8));
#else
							goto _no_anti2:
#endif
						}else{
_no_anti2:
							XmbDrawString(disp,pwin,win->fs,win->fgc,w/2+20,y1+height+5,title2,strlen(title2));
						}
					}
					_draw_input_window(disp,win,5,h1-5,str,slen);

			break;
		}
	}
end:
	if(buf != NULL) free(buf);
	if(win->anti){
#if HAVE_LIBXFT
		if(draw) XftDrawDestroy(draw);
		if(idraw) XftDrawDestroy(idraw);
#endif
	}
	XDestroyWindow(disp,iwin);
	XDestroyWindow(disp,pwin);

	return result;
}

