#include "itext.h"
#include "xtext.h"
#include "xjp.h"
#include <time.h>

int xtext_get_string_size(Display *disp,my_window_t *win,char *euc_str,char *utf8_str,int *w,int *h,int font_type)
{
        XFontSet fs;

	switch(font_type){
		case 0:fs = win->fs;break;
		case 1:fs = win->fs_s;break;
		case 2:fs = win->rubi_fs;break;
	}
        if(win->anti == 0 || utf8_str == NULL){
                XRectangle ink,log;
                *w = XmbTextExtents(fs,euc_str,strlen(euc_str),&ink,&log) + 2;
                *h = log.height + 2;
        }else{
#if HAVE_LIBXFT
                XftFont *font;
                XGlyphInfo gi;
		switch(font_type){
			case 0:font = win->font;break;
			case 1:font = win->font_s;break;
			case 2:font = win->font_rubi;break;
		}
                XftTextExtentsUtf8(disp,font,utf8_str,strlen(utf8_str),&gi);
                *w = gi.width;
                *h = gi.height;
#else
                XRectangle ink,log;
                *w = XmbTextExtents(fs,euc_str,strlen(euc_str),&ink,&log) + 2;
                *h = log.height + 2;
#endif
        }
        return 0;
}
int xtextDrawPageTitleString(	Display *disp,
				my_window_t *win,
				char *euc_str,
				char *utf8_str,
				int x,
				int y,
				int font_type		)
{
        XFontSet fs;
        GC gc;
	switch(font_type){
		case 0:fs = win->fs;break;
		case 1:fs = win->fs_s;break;
		case 2:fs = win->rubi_fs;break;
	}
        gc = win->rubi_gc;
        if(win->anti == 0){
                XmbDrawString(disp,win->win,fs,gc,x,y,euc_str,strlen(euc_str));

        }else{
#if HAVE_LIBXFT
		XftFont *font;
		switch(font_type){
			case 0:font = win->font;break;
			case 1:font = win->font_s;break;
			case 2:font = win->font_rubi;break;
		}
                XftDrawStringUtf8(win->draw,&(win->rubi_color),font,x,y,utf8_str,strlen(utf8_str));
#else
                XmbDrawString(disp,win->win,fs,gc,x,y,euc_str,strlen(euc_str));
#endif
        }
        return 0;
}
int xtext_Draw_Help(Display *disp,my_window_t *win,xtext_conf_t *xconf)
{
        char *help_str = NULL;
        int x0,y0,width,height;
        int font_type;

	/*
        XClearWindow(disp,win->win);
	*/
	m_mes(disp,win);
	/*
	k_line(disp,win);
	*/

        help_str = (char *)malloc(128);

        font_type = 2;
        sprintf(help_str,"%s   Ver. %s",XTEXT_NAME,XTEXT_VERSION);
        xtext_get_string_size(disp,win,help_str,help_str,&width,&height,font_type);
        x0 = win->width - width - 15;
	y0 = win->height - (height * 3) - 5;
        xtextDrawPageTitleString(disp,win,help_str,help_str,x0,y0,font_type);

        font_type = 2;
        strcpy(help_str,"Creater : aFterbrEaK,xGreEn,UtoSI");
        xtext_get_string_size(disp,win,help_str,help_str,&width,&height,font_type);
        x0 = win->width - width - 5;
        y0 = win->height - height - 5;
        xtextDrawPageTitleString(disp,win,help_str,help_str,x0,y0,font_type);

        font_type = 2;
        strcpy(help_str,"http://xjp-text.sourceforge.jp/");
        xtext_get_string_size(disp,win,help_str,help_str,&width,&height,font_type);
        x0 = win->width - width - 5;
        y0 = win->height - 5;
        xtextDrawPageTitleString(disp,win,help_str,help_str,x0,y0,font_type);

        if(help_str != NULL) free(help_str);
        return 0;
}
