#include "itext.h"
#include "xtext.h"
#include "xjp.h"

extern XImage *bimg;
static image_data_t *_image_data_alloc();
static void *_image_data_add(image_data_t **,image_data_t **,image_data_t *);
static int _xtext_max_wh(Display *,my_window_t *,char_data_t *,
						ITEXT_T *,int *,int *,int *,int *);
static Pixmap _xtext_Draw_imageString_normal(Display *,my_window_t *,char_data_t *,
								ITEXT_T *,int,XImage **);
static Pixmap _xtext_Draw_imageString_anti(Display *,my_window_t *,char_data_t *,
								ITEXT_T *,int,XImage **);
static XImage * get_string_image(Display *,my_window_t *,char_data_t *,ITEXT_T *,int);

static image_data_t * _image_data_alloc()
{
	image_data_t *im;
	if((im = (image_data_t *)malloc(sizeof(image_data_t))) != NULL)
		im->flag = 0;
	return im;
}
static void * _image_data_add(image_data_t **head,image_data_t **tail,image_data_t *im)
{
        if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }
	return NULL;
}
static int _xtext_max_wh(      Display *disp,
                        my_window_t *win,
                        char_data_t *char_d,
                        ITEXT_T *it,
                        int *xmax,
                        int *ymax,
 			int *wmax,
			int *hmax		)
{
        Pixmap pix;
        XImage *im;

        XFontSet fs;
        GC gc;
        unsigned char temp[3];
	char *utf8;

        unsigned long pixel;
        int x,y,charSize,pad=0;
        int x_min=9999,y_min=9999,x_max=0,y_max=0,w,h;

	temp[0] = it->c1;
	temp[1] = it->c2;
	temp[2] = '\0';

        gc = win->gc;
        fs = win->fs;
        charSize = char_d->charSize+pad;
        if(ChFlag(it->flag,_SML)){
		fs = win->fs_s;
                charSize = char_d->charSize_s+pad;
        }
        pix = XCreatePixmap(disp,DefaultRootWindow(disp),charSize,charSize,DefaultDepth(disp,0));
        XFillRectangle(disp,pix,win->bgc,0,0,charSize,charSize);

        x = pad/2; 
        y = charSize-pad/2;
        XmbDrawString(disp,pix,fs,gc,x,y,temp,strlen(temp));

        im = XGetImage(disp,pix,0,0,charSize,charSize,AllPlanes,XYPixmap);

        for(x=0;x<charSize;x++){
                for(y=0;y<charSize;y++){
                        pixel = XGetPixel(im,x,y);
                        if(win->bg_pixel != pixel){
                                if(x < x_min) x_min = x;
                                if(x >= x_max) x_max = x;
                                if(y < y_min) y_min = y;
                                if(y >= y_max) y_max = y;
                        }
                }
        }
	if((w = x_max - x_min) < 0 || (h = y_max - y_min) < 0){
		*xmax = -1;
		*ymax = -1;
		*wmax = -1;
		*hmax = -1;
	}else{
		*xmax = x_min;
		*wmax = w;

		*ymax = y_min;
		*hmax = h;
	}

        if(im) XDestroyImage(im);
        if(pix) XFreePixmap(disp,pix);

        return 0;
}
static Pixmap _xtext_Draw_imageString_normal(	Display *disp,
						my_window_t *win,
						char_data_t *char_d,
						ITEXT_T *it,
						int type,
						XImage **base_im	)
{
        Pixmap pix;
	int charSize;
        int tx,ty;
	int xpad,ypad;

	XFontSet fs;
	GC gc,gc1;
	unsigned char text[3];

	fs = win->fs;
	gc1 = win->sgc;
	gc = win->gc;
	charSize = char_d->charSize;

	if(ChFlag(it->flag,_CHU)){
	       	gc = win->rubi_gc;
	}
	if(ChFlag(it->flag,_SML)){
	       	charSize = char_d->charSize_s;
		fs = win->fs_s;
	}
	if(ChFlag(it->flag,_EJC) == 0){
		/*
		charSize = char_d->charSize_e;
		*/
		fs = win->fs_e;

		text[0] = it->c1;
		text[1] = '\0';
	}else{
		text[0] = it->c1;
		text[1] = it->c2;
		text[2] = '\0';
	}
        pix = XCreatePixmap(disp,DefaultRootWindow(disp),charSize,charSize,DefaultDepth(disp,0));
        XFillRectangle(disp,pix,win->bgc,0,0,charSize,charSize);
        *base_im = XGetImage(disp,pix,0,0,charSize,charSize,AllPlanes,XYPixmap);
	if(ChFlag(it->flag,_EJC) == 1){
		int myw,myh,myx,myy;
		_xtext_max_wh(disp,win,char_d,it,&myx,&myy,&myw,&myh);

		if(type == 4){
			tx = charSize/2 - (myx+myw)/2;
			ty = charSize/2 - myh/2 + myh;

			GetOffset(it->off,&xpad,&ypad);

		}else if(type == 0){
			tx = charSize/2 - (myx+myw)/2;
			/*
			ty = charSize/2 - myh/2 + myh;
			*/
			ty = (charSize - myh)/2 + myh;

			GetOffset(it->off,&ypad,&xpad);
			ypad *= -1;

		}else{
			tx = myx;
			ty = charSize - myh;

			GetOffset(it->off,&xpad,&ypad);
		}
		XmbDrawString(disp,pix,fs,gc,tx+xpad,ty+ypad,text,strlen(text));
	}else{
		tx = 2;
		ty = charSize - 2;
		XmbDrawString(disp,pix,fs,gc,tx,ty,text,strlen(text));
	}

	return pix;
}
static Pixmap _xtext_Draw_imageString_anti(	Display *disp,
						my_window_t *win,
						char_data_t *char_d,
						ITEXT_T *it,
						int type,
						XImage **base_im	)
{
	Pixmap pix;
	int charSize;
#if HAVE_LIBXFT
	XftDraw *draw = NULL;
	XftFont *font = NULL;
	XftColor color;
	unsigned char text[3];
	char utf8[10];
	int tx,ty;
	int ypad;
	int xpad;

	font = win->font;
	color = win->fg_color;
	charSize = char_d->charSize;
	if(ChFlag(it->flag,_CHU)) color = win->rubi_color;
	if(ChFlag(it->flag,_FND)) color = win->find_color;

	if(ChFlag(it->flag,_SML)){
	       	font = win->font_s;
		charSize = char_d->charSize_s;
	}
	if(ChFlag(it->flag,_EJC) == 0){
	       	font = win->font_e;
		/*charSize = char_d->charSize_e;*/
	}

        if((pix = XCreatePixmap(disp,DefaultRootWindow(disp),charSize,charSize,DefaultDepth(disp,0))) <= 0) fprintf(stderr,"False pixmap()\n");

        XFillRectangle(disp,pix,win->bgc,0,0,charSize,charSize);
        *base_im = XGetImage(disp,pix,0,0,charSize,charSize,AllPlanes,XYPixmap);
	draw = XftDrawCreate(disp,pix,win->visual,win->cmap);

	if(ChFlag(it->flag,_EJC)){
		XGlyphInfo gi;
		text[0] = it->c1;
		text[1] = it->c2;
		text[2] = '\0';
		euc2utf8_c(XJP_CONV,utf8,text,2);
		XftTextExtentsUtf8(disp,font,utf8,strlen(utf8),&gi);

		if(type == 4){
			tx = charSize/2 - ((gi.x * -1) + gi.width/2);
			ty = charSize - ( (charSize - gi.height)/2 + (gi.height-gi.y) );
			GetOffset(it->off,&xpad,&ypad);

		}else if(type == 0){
			tx = charSize/2 - ((gi.x * -1) + gi.width/2);
			ty = charSize - ( (charSize - gi.height)/2 + (gi.height-gi.y) );
			GetOffset(it->off,&ypad,&xpad);
			ypad *=  -1;

		}else{
			tx = gi.x * -1;
			ty = charSize - (gi.height - gi.y);
			GetOffset(it->off,&xpad,&ypad);
		}
			
		XftDrawStringUtf8(draw,&color,font,tx+xpad,ty+ypad,utf8,strlen(utf8));
	}else{

		text[0] = it->c1;
		text[1] = '\0';

		tx = 2;
		ty = charSize - 2;

		XftDrawString8(draw,&color,font,tx,ty,text,strlen(text));
	}
	XftDrawDestroy(draw);
	return pix;
#else
	pix = _xtext_Draw_imageString_normal(disp,win,char_d,it,type,base_im);
	return pix;
#endif
}
static XImage * get_string_image(      	Display *disp,
                                	my_window_t *win,
					char_data_t *char_d,
					ITEXT_T *it,
                                	int type        )
{
	int charSize;

	Pixmap pix;
        XImage *base_im,*char_im;
        long pixel;
        int x,y;
        int x0,x1,y0,y1;

	if(win->anti == 0){
		pix = _xtext_Draw_imageString_normal(disp,win,char_d,it,type,&base_im);

	}else{
		pix = _xtext_Draw_imageString_anti(disp,win,char_d,it,type,&base_im);
	}
	charSize = char_d->charSize;
	/*if(it->ej == 0) charSize = char_d->charSize_e;*/
	if(ChFlag(it->flag,_SML)) charSize = char_d->charSize_s;

        char_im = XGetImage(disp,pix,0,0,charSize,charSize,AllPlanes,XYPixmap);

	if(type == 0){ x0=0; x1=charSize; y0=0; y1=charSize;}
	else if(type == 1){ x0=0; x1=charSize/2; y0=charSize/2; y1=charSize;}
	else if(type == 2){ x0=0; x1=charSize; y0=0; y1=charSize/2;}
        else if(type == 3){ x0=charSize/2; x1=charSize; y0=0; y1=charSize/2;}
	else if(type == 4 || type == 5){ x0=0; x1=charSize; y0=0; y1=charSize;}

        for(x=x0;x<x1;x++){
                for(y=y0;y<y1;y++){
                        pixel = XGetPixel(char_im,x,y);

                        if(type == 0){
                                XPutPixel(base_im,charSize-y,x,pixel);

                        }else if(type == 1){
                                XPutPixel(base_im,x+charSize/2,y-charSize/2,pixel);

                        }else if(type == 2){
                                XPutPixel(base_im,x,charSize/2+y,pixel);

                        }else if(type == 3){
                                XPutPixel(base_im,x-charSize/2,charSize/2+y,pixel);

                        }else if(type == 4 || type == 5){
                                XPutPixel(base_im,x,y,pixel);
                        }

                }
        }
        XFreePixmap(disp,pix);
        XDestroyImage(char_im);
        return base_im;
}
void xtext_image_data_free(image_data_t **head,image_data_t **tail)
{
	image_data_t *im,*imm;

	for(im = *head;im!=NULL;im=imm){
		imm = im->next;
		XDestroyImage(im->char_image);
		free(im);
	}
	*head = NULL;
	*tail = NULL;
}
void * xtext_image_data_insert(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int type		)
{
	image_data_t *im;
	int s_type;

	if(char_d->charSize <= 0) return;
	if(char_d->im_head != NULL){
		for(im=char_d->im_head;im!=NULL;im=im->next){
			if(	im->c1 == it->c1 				&& 
				im->c2 == it->c2 				&& 
				ChFlag(im->flag,_CHU) == ChFlag(it->flag,_CHU)	&& 
				ChFlag(im->flag,_SML) == ChFlag(it->flag,_SML) 	&&
				ChFlag(im->flag,_FND) == ChFlag(it->flag,_FND)   ) break;
		}
		if(im != NULL) return NULL;
	}

	im = _image_data_alloc();
	im->c1 = it->c1; im->c2 = it->c2;

	if(ChFlag(it->flag,_CHU))
		OnFlag(im->flag,_CHU);
	else
		OfFlag(im->flag,_CHU);

	if(ChFlag(it->flag,_SML))
		OnFlag(im->flag,_SML);
	else
		OfFlag(im->flag,_SML);

	if(ChFlag(it->flag,_FND))
		OnFlag(im->flag,_FND);
	else
		OfFlag(im->flag,_FND);

	if(type == 1) s_type = 0;
	if(type == 2) s_type = 1;
	if(type == 3) s_type = 2;
	if(type == 4) s_type = 3;
	if(type == 5) s_type = 4;
	if(type == 6) s_type = 5;
	
	im->char_image = (XImage *)get_string_image(disp,win,char_d,it,s_type);
	_image_data_add(&char_d->im_head,&char_d->im_tail,im);
	return NULL;
}
int xtext_check_image_data(ITEXT_T *it)
{
        if(ChFlag(it->flag,_EJC) == 0) return 1;

        if(it->c1 == 0xa1){
                switch(it->c2){
			case 0xa1:
                        case 0xa7:case 0xa8:
                        case 0xbc:case 0xbd:
                        case 0xc1:case 0xc3:case 0xc4:case 0xc5:
                        case 0xca:case 0xcb:
                        case 0xcc:case 0xcd:
                        case 0xce:case 0xcf:
                        case 0xd0:case 0xd1:
                        case 0xd2:case 0xd3:
                        case 0xd4:case 0xd5:
                        case 0xd6:case 0xd7:
                        case 0xd8:case 0xd9:
                        case 0xda:case 0xdb:
                        case 0xdd:
			case 0xe0:case 0xe1:case 0xe2:case 0xe3:
			case 0xe4:case 0xe5:case 0xe6:
				return 1;
                        break;
                        case 0xa2:case 0xa3:
                        case 0xc6:case 0xc7:
                                return 2;
                        break;
                        case 0xc8:case 0xc9:
                                return 3;
                        break;

		}
        }else if(it->c1 == 0xa2){
                switch(it->c2){
                        case 0xaa:case 0xab:case 0xac:case 0xad:
                                return 1;
                        break;
                }
        }else if(it->c1 == 0xa8){
                if(it->c2 >= 0xa0 && it->c2 <= 0xbc){
	                        return 1;
                }

        }else if(it->c1 == 0xa4){
                switch(it->c2){
                        case 0xa1:case 0xa3:case 0xa5:case 0xa7:case 0xa9:
                        case 0xe3:case 0xe5:case 0xe7:case 0xee:case 0xc3:
                                return 5;
                        break;
                }
        }else if(it->c1 == 0xa5){
                switch(it->c2){
                        case 0xa1:case 0xa3:case 0xa5:case 0xa7:case 0xa9:
                        case 0xc3:case 0xe3:case 0xee:case 0xe7:case 0xf5:case 0xf6:
                                return 5;
                        break;
                }
	}

        return 0;
}
XImage * xtext_get_bimage(Display *disp,my_window_t *win,char_data_t *char_d)
{
	Pixmap pix;
	XImage *base_im,*im,*bim;
	unsigned long pixel;
	unsigned char c1 = 0xa1,c2 = 0xa2;

	ITEXT_T *it;

	int charSize;
	int x,y,w,h;
	int xmin=9999,xmax=0,ymin=9999,ymax=0;


	it = (ITEXT_T *)malloc(sizeof(ITEXT_T));
	it->c1 = c1;
	it->c2 = c2;
	it->flag = 0;
	it->off = 0;
	OnFlag(it->flag,_EJC);
	OfFlag(it->flag,_CHU);
	OfFlag(it->flag,_SML);

	if(win->anti == 0){
		pix = _xtext_Draw_imageString_normal(disp,win,char_d,it,1,&base_im);

	}else{
		pix = _xtext_Draw_imageString_anti(disp,win,char_d,it,1,&base_im);
	}

	charSize = char_d->charSize;
        im = XGetImage(disp,pix,0,0,charSize,charSize,AllPlanes,XYPixmap);

        for(x=0;x<charSize;x++){
                for(y=0;y<charSize;y++){
                        pixel = XGetPixel(im,x,y);
                        if(win->bg_pixel != pixel){

                                if(x < xmin) xmin = x;
				if(x >= xmax) xmax = x;

				if(y < ymin) ymin = y;
				if(y >= ymax) ymax = y;

                        }
                }
        }
	if((w = xmax - xmin) < 0) return NULL;
	if((h = ymax - ymin) < 0) return NULL;

	if(( xmin + (w+2) ) <= charSize){
		w += 2;
	}

	h = charSize - ymin;
        bim = XGetImage(disp,pix,xmin,ymin,w,h,AllPlanes,XYPixmap);

	free(it);
        if(im) XDestroyImage(im);
	if(base_im) XDestroyImage(base_im);
        if(pix) XFreePixmap(disp,pix);

	return bim;
}
int xtextDrawArc(	Display *disp,
			my_window_t *win,
			int x0,
			int y0,
			int x1,
			int y1,
			int type		)
{
	XPoint point[4];
	int w,h;

	switch(type){
		case 0:case 1:
			if(bimg != NULL)
				XPutImage(disp,win->win,win->gc,bimg,0,0,x0,y0+(y1-y0)/2,bimg->width,bimg->height);
		break;
		case 2:
			w = (x1 - x0) - 3;
			h = w;
			XFillArc(disp,win->win,win->gc,x0,y0+((y1-y0)-h)/2,w,h,0,360*64);
		break;
		case 3:
			w = (x1 - x0) - 3;
			h = w;
			XDrawArc(disp,win->win,win->gc,x0,y0+((y1-y0)-h)/2,w,h,0,360*64);
		break;
		case 4:
			w = (x1 - x0);
			h = w;

			point[0].x = x0 + w/2;
			point[0].y = y0 + h/4;
			point[1].x = x0;
			point[1].y = y1 - h/4;
			point[2].x = x1;
			point[2].y = y1 - h/4;
			point[3].x = x0 + w/2;
			point[3].y = y0 + h/4;

			XFillPolygon(disp,win->win,win->gc,point,4,Complex,CoordModeOrigin);

		break;
		case 5:
			w = (x1 - x0);
			h = w;

			point[0].x = x0 + w/2;
			point[0].y = y0 + h/4;
			point[1].x = x0;
			point[1].y = y1 - h/4;
			point[2].x = x1;
			point[2].y = y1 - h/4;
			point[3].x = x0 + w/2;
			point[3].y = y0 + h/4;

			XDrawLines(disp,win->win,win->gc,point,4,CoordModeOrigin);
		break;
		case 6:
			w = (x1 - x0) - 1;
			h = w;
			XDrawArc(disp,win->win,win->gc,x0,y0+((y1-y0)-h)/2,w,h,0,360*64);

			w = (x1 - x0) - 5;
			h = w;
			XDrawArc(disp,win->win,win->gc,x0 + 2,y0+((y1-y0)-h)/2,w,h,0,360*64);
		break;
		case 7:
			w = (x1 - x0) - 1;
			h = w;
			XDrawArc(disp,win->win,win->gc,x0,y0+((y1-y0)-h)/2,w,h,0,360*64);

			w = (x1 - x0) - 5;
			h = w;
			XFillArc(disp,win->win,win->gc,x0 + 2,y0+((y1-y0)-h)/2,w,h,0,360*64);
		break;

	}

	return 0;
}
int xtextDrawLine(	Display *disp,
			my_window_t *win,
			int x0,
			int y0,
			int x1,
			int y1,
			int type		)
{
	XSegment seg[2]; 
	XArc arc[10];
	int i,p,w,h;

	if(win == NULL) return -1;

	switch(type){
		case 0:
			p = 2;

			seg[0].x1 = x0;
			seg[0].y1 = y0;
			seg[0].x2 = x1;
			seg[0].y2 = y1;

		       	seg[1].x1 = x0+p;
			seg[1].y1 = y0;
			seg[1].x2 = x1+p;
			seg[1].y2 = y1;

			XDrawSegments(disp,win->win,win->gc,seg,2);
		break;
		case 1:
			p = y0;
			for(i=0;;i++){
				if((p += 2) >= y1) break;
				if((i % 2) == 0){
					XDrawLine(disp,win->win,win->gc,x0,p,x1,p+2);
				}
			}
		break;
		case 2:
			p = y0;
			for(i=0;;i++){
				if((p += 4) >= y1) break;
				if((i % 2) == 0){
					XDrawLine(disp,win->win,win->gc,x0,p,x1,p+4);
				}
			}
		break;
		case 3:
			w = 2;
			h = 4;

			for(i=0;;i++){
				if(y1 <= (y0 + (i * h))) break;
				arc[i].x = x0;
				arc[i].y = y0 + (i * h);
				arc[i].width = w;
				arc[i].height = h;
				if(i % 2 == 0){
					arc[i].angle1 = 90 * 64;
					arc[i].angle2 = 180 * 64;
				}else{
					arc[i].angle1 = 270 * 64;
					arc[i].angle2 = 180 * 64;
				}
			}
			XDrawArcs(disp,win->win,win->gc,arc,i);
		break;
		default:
			XDrawLine(disp,win->win,win->gc,x0,y0,x1,y1);
		break;
	}

	return 0;
}
int xtextDrawFrame(Display *disp,Window win,GC gc0,int width,int height,int type)
{
	GC gc;
	XPoint point[3][3];
	int mode = CoordModeOrigin; 

	gc = gc0;

	point[0][0].x = width - 0;
	point[0][0].y = 0;
	point[0][1].x = 0;
	point[0][1].y = 0;
	point[0][2].x = 0;
	point[0][2].y = height - 0;

	point[1][0].x = 0;
	point[1][0].y = height - 1;
	point[1][1].x = width - 1;
	point[1][1].y = height - 1;
	point[1][2].x = width - 1;
	point[1][2].y = 0;

	point[2][0].x = 1;
	point[2][0].y = height - 2;
	point[2][1].x = width - 2;
	point[2][1].y = height - 2;
	point[2][2].x = width - 2;
	point[2][2].y = 1;

	if(type == 0){
		XSetForeground(disp,gc,WhitePixel(disp,0));
		XDrawLines(disp,win,gc,point[0],3,mode);
		XSetForeground(disp,gc,BlackPixel(disp,0));
		XDrawLines(disp,win,gc,point[1],3,mode);
		XDrawLines(disp,win,gc,point[2],3,mode);
	}else{
		XSetForeground(disp,gc,BlackPixel(disp,0));
		XDrawLines(disp,win,gc,point[0],3,mode);
		XSetForeground(disp,gc,WhitePixel(disp,0));
		XDrawLines(disp,win,gc,point[1],3,mode);
	}

	return 0;
}


