/********************************
 * 2005/06/01
 * *****************************/
#define XJP_MES	1
#define XJP_ICONV 1

#include "itext.h"
#include "xtext.h"
#include "xjp.h"
#include <stdarg.h>
#include <locale.h>

extern int opterr; extern int optind; extern char *optarg;
extern int getopt(int argc,char * const * argv,const char * pattern);
/*
char *XJP_CTRL_STR[] = {"","","","","ɽ","","",""};
*/
Display *disp = NULL;
my_window_t *main_win = NULL;
offset_data_t *off_head = NULL; 
offset_data_t *off_tail = NULL;
page_data_t *char_p = NULL; 
char_data_t *char_d = NULL;
ICONTENT_T *main_book = NULL;
xtext_conf_t xconf;
xtext_net_t xnet;

static Window root;
static IBOOK_T *save_book_head = NULL, *save_book_tail = NULL;
static ISIORI_T *siori_head = NULL, *siori_tail = NULL;
static ctl_window_t *ctl_head = NULL, *ctl_tail = NULL;
static offset_data_t *offset_head = NULL, *offset_tail = NULL;
static page_data_t *find_p = NULL;
static char StepBuf[STEP_MAX];
static int NPC = 0;
static void _usage()
{
	fprintf(stderr,"\n");
	fprintf(stderr,"    %s  Version : %s\n\n",XTEXT_NAME,XTEXT_VERSION);
	fprintf(stderr,"Usage:	xtext [option] filename\n\n");
	fprintf(stderr,"[option]\n");
	fprintf(stderr,	
"   -h       Help Message (This Message)\n \
  -d <dir>   Book Directory\n \
  -f <file>  Book(.txt|.zip) Path\n \
  -a <num>   Window Width\n \
  -b <num>   Window Height\n \
  -c <str>   Main Window-Color (X11 Color_Name)\n \
  -e <str>   Main Font-Color (X11 Color_Name)\n \
  -g <str>   Ruby Font-Color (X11 Color_Name)\n \
  -i <str>   Message Font-Color (X11 Color_Name)\n \
  -j <str>   Message Window-Color (X11 Color_Name)\n \
  -k <str>   Main Font_Name (Xlfd format)\n \
  -l <str>   Sub Font_Name (Xlfd format)\n \
  -m <str>   1Byte Font_Name (xlfd format)\n \
  -n <str>   Ruby Font_Name (xlfd format)\n \
  -o         Use Xft ?\n \
  -p <num>   Line Space (Pixel)\n \
  -q <num>   Row Space (Pixel)\n \
  -r         Display Book_Title ?\n \
  -s	     Display Page_No ? \n \
  -t	     Display Ruby_Char ? \n \
  -u <path>  Rast-Data-Base Path \n \
					 ");
	fprintf(stderr,"\n");
	exit(1);
}	
static void _x_init()
{
	setlocale(LC_ALL,"");
	if((XJP_CONV = iconv_open("UTF-8","EUC-JP")) == NULL){
		xprint("_xinit() (iconv())\n");
		exit(1);
	}
	SEIKEI_LEVEL = (char *)euc2utf8(XJP_CONV,XJP_MESSAGE[6],strlen(XJP_MESSAGE[6]));
	if((disp = XOpenDisplay(NULL)) == NULL){
		xprint("_x_init() (open_display)");
		exit(1);
	}
	if((main_win = (my_window_t *)malloc(sizeof(my_window_t))) == NULL){
		xprint("_x_init() (my_window(malloc))\n");
		exit(1);
	}
	if((char_d = (char_data_t *)char_data_alloc()) == NULL){
		xprint("_x_init() (char_d(malloc))\n");
		exit(1);
	}
	root = DefaultRootWindow(disp);
	main_win->cmap = DefaultColormap(disp,0);
	main_win->visual = DefaultVisual(disp,0);
	main_win->gc = XCreateGC(disp,root,0,0);
	main_win->bgc = XCreateGC(disp,root,0,0);
	main_win->fgc = XCreateGC(disp,root,0,0);
	main_win->rfgc = XCreateGC(disp,root,0,0);
	main_win->find_gc = XCreateGC(disp,root,0,0);
	main_win->rubi_gc = XCreateGC(disp,root,0,0);
	main_win->sgc = XCreateGC(disp,root,0,0);
	main_win->image.img = 0;
	XSetLineAttributes(disp,main_win->sgc,1,LineSolid,CapButt,JoinMiter);
}
static void _set_title()
{
	char temp[64];
	if(!main_win->win || !main_win->mwin) return;
	/*
	XTextProperty ct
	XmbTextListToTextProperty(disp,&str,1,XCompoundTextStyle,&ct);
	XSetWMName(disp,win,&ct);
	*/
	sprintf(temp,"%s[%s]",XTEXT_NAME,XTEXT_VERSION);
	XStoreName(disp,main_win->win,temp);

	sprintf(temp,"%s Message",XTEXT_NAME);
	XStoreName(disp,main_win->mwin,temp);
}
static void _set_win()
{
	XSetWindowBackground(disp,main_win->win,main_win->bg_pixel);
	/*XSetWindowBackground(disp,main_win.cwin,main_win.bg_pixel);*/
	XSetWindowBackground(disp,main_win->mwin,main_win->menu_bg_pixel);
	XClearWindow(disp,main_win->win);
	/*XClearWindow(disp,main_win.cwin);*/
	XClearWindow(disp,main_win->mwin);
}
static void _x_end()
{
	if(char_d != NULL) char_data_free(char_d);
	if(XJP_CONV != NULL) iconv_close(XJP_CONV);
#if HAVE_LIBXFT
	if(main_win->draw != NULL) XftDrawDestroy(main_win->draw);
#endif
	if(main_win->win) XDestroyWindow(disp,main_win->win);
	if(main_win != NULL) free(main_win);
	if(disp != NULL) XCloseDisplay(disp);
}
static void _x_drawable()
{
	XSetWindowAttributes att;
	Atom a1,a2,a3;
	char temp[50];
	int w,h;

	main_win->width = xconf.main_window_width;
	main_win->height = xconf.main_window_height;
	w = main_win->width;
	h = main_win->height;

	main_win->win = XCreateSimpleWindow(disp,root,0,0,w,h,0,0,0);
	a1 = XInternAtom(disp,"WM_DELETE_WINDOW",False);
	XSelectInput(disp,main_win->win,ExposureMask|StructureNotifyMask|ButtonPressMask|KeyPressMask);
	XSetWMProtocols(disp,main_win->win,&a1,1);

	main_win->mwin = XCreateSimpleWindow(disp,root,0,0,w/2,50,0,0,0);
	a2 = XInternAtom(disp,"WM_DELETE_WINDOW",False);
	XSelectInput(disp,main_win->mwin,ExposureMask|StructureNotifyMask);
	XSetWMProtocols(disp,main_win->win,&a2,1);

	/*
	main_win.cwin = XCreateSimpleWindow(disp,main_win.win,0,0,50,200,0,0,0);
	a3 = XInternAtom(disp,"WM_DELETE_WINDOW",False);
	att.backing_store = Always;
	XChangeWindowAttributes(disp,main_win.cwin,CWBackingStore,&att);
	XSelectInput(disp,main_win.cwin,ExposureMask|ButtonPressMask);
	XSetWMProtocols(disp,main_win.win,&a3,1);
	XSetTransientForHint(disp,main_win.cwin,main_win.win); 
	XUnmapWindow(disp,main_win.cwin);
	XMapWindow(disp,main_win.cwin);
	*/
	XMapWindow(disp,main_win->win);
	if(xconf.chuki) XMapRaised(disp,main_win->mwin);
	_set_title();
#if HAVE_LIBXFT
	main_win->draw = XftDrawCreate(disp,main_win->win,main_win->visual,main_win->cmap);
#endif
}
static void _set_col()
{
	XColor c1,c0;

	XAllocNamedColor(disp,main_win->cmap,xconf.main_font_color,&c1,&c0);
	XSetForeground(disp,main_win->gc,c1.pixel);
	XSetBackground(disp,main_win->bgc,c1.pixel);
	main_win->fg_pixel = c1.pixel;

	XAllocNamedColor(disp,main_win->cmap,xconf.main_window_color,&c1,&c0);
	XSetForeground(disp,main_win->bgc,c1.pixel);
	XSetBackground(disp,main_win->gc,c1.pixel);
	main_win->bg_pixel = c1.pixel;

	XAllocNamedColor(disp,main_win->cmap,xconf.menu_font_color,&c1,&c0);
	XSetForeground(disp,main_win->fgc,c1.pixel);
	XSetBackground(disp,main_win->rfgc,c1.pixel);
	main_win->menu_fg_pixel = c1.pixel;

	XAllocNamedColor(disp,main_win->cmap,xconf.menu_window_color,&c1,&c0);
	XSetForeground(disp,main_win->rfgc,c1.pixel);
	XSetBackground(disp,main_win->fgc,c1.pixel);
	main_win->menu_bg_pixel = c1.pixel;

	XAllocNamedColor(disp,main_win->cmap,xconf.rubi_font_color,&c1,&c0);
	XSetForeground(disp,main_win->rubi_gc,c1.pixel);
	main_win->rubi_fg_pixel = c1.pixel;

	XAllocNamedColor(disp,main_win->cmap,xconf.main_shadow_color,&c1,&c0);
	main_win->rubi_bg_pixel = c1.pixel;

	XAllocNamedColor(disp,main_win->cmap,xconf.main_shadow_color,&c1,&c0);
	XSetForeground(disp,main_win->sgc,c1.pixel);

	XAllocNamedColor(disp,main_win->cmap,xconf.find_font_color,&c1,&c0);
	XSetForeground(disp,main_win->find_gc,c1.pixel);

	if(xconf.anti){
#if HAVE_LIBXFT
	XftColorAllocName(disp,main_win->visual,main_win->cmap,xconf.main_window_color,&(main_win->bg_color));
	/*
	main_win->bg_color.color.alpha = 0x0000;
	*/

	XftColorAllocName(disp,main_win->visual,main_win->cmap,xconf.main_font_color,&(main_win->fg_color));
	main_win->fg_color.color.alpha = 0xDFDF;
	/*
	main_win.fg_color.color.red = 0x0000;
	main_win.fg_color.color.green = 0x0000;
	main_win.fg_color.color.blue = 0xFFFF;
	*/
	XftColorAllocName(disp,main_win->visual,main_win->cmap,xconf.rubi_font_color,&(main_win->rubi_color));
	/*
	main_win.rubi_color.color.alpha = 0xFFFF;
	*/
	XftColorAllocName(disp,main_win->visual,main_win->cmap,xconf.menu_font_color,&(main_win->menu_fg_color));
	XftColorAllocName(disp,main_win->visual,main_win->cmap,xconf.menu_window_color,&(main_win->menu_bg_color));
	XftColorAllocName(disp,main_win->visual,main_win->cmap,xconf.find_font_color,&(main_win->find_color));
#endif
	}
	SELECTOR_BACKGROUND_COLOR = (char *)xconf.select_window_color;
	SELECTOR_FOREGROUND_COLOR = (char *)xconf.select_font_color;
	SELECTOR_SELECTFONT_COLOR = (char *)xconf.select_font_background_color;
}
static void _set_fnt()
{
	char font_str[512],font_e[256];
	char **miss,*def;
	int n_miss;

	xtext_font_J2E(xconf.main_font_j,font_e);
	sprintf(font_str,"%s,%s",xconf.main_font_j,font_e);
	if((main_win->fs = XCreateFontSet(disp,font_str,&miss,&n_miss,&def)) == NULL){
		xprint("_set_fnt() (main_fs)");
		exit(1);
	}
	sprintf(font_str,"%s,%s",xconf.main_font_e,xconf.main_font_j);
	if((main_win->fs_e = XCreateFontSet(disp,font_str,&miss,&n_miss,&def)) == NULL){
		xprint("_set_fnt() (main_fs_e)");
		exit(1);
	}
	xtext_font_J2E(xconf.main_font_s,font_e);
	sprintf(font_str,"%s,%s",xconf.main_font_s,font_e);
	if((main_win->fs_s = XCreateFontSet(disp,font_str,&miss,&n_miss,&def)) == NULL){
		xprint("_set_fnt() (main_fs_s)");
		exit(1);
	}
	xtext_font_J2E(xconf.rubi_font,font_e);
	sprintf(font_str,"%s,%s",xconf.rubi_font,font_e);
	if((main_win->rubi_fs = XCreateFontSet(disp,font_str,&miss,&n_miss,&def)) == NULL){
		xprint("_set_fnt() (main_fs_rubi)");
		exit(1);
	}
	if(xconf.anti){
#if HAVE_LIBXFT
	if(main_win->font != NULL) XftFontClose(disp,main_win->font);
	if(main_win->font_e != NULL) XftFontClose(disp,main_win->font_e);
	if(main_win->font_s != NULL) XftFontClose(disp,main_win->font_s);
	if(main_win->font_rubi != NULL) XftFontClose(disp,main_win->font_rubi);
	if((main_win->font = XftFontOpenXlfd(disp,0,xconf.main_font_j)) == NULL){
		xprint("_set_fnt() (main_fs xft)");
		exit(1);
	}
	if((main_win->font_e = XftFontOpenXlfd(disp,0,xconf.main_font_e)) == NULL){
		xprint("_set_fnt() (main_fs_e xft)");
		exit(1);
	}
	if((main_win->font_s = XftFontOpenXlfd(disp,0,xconf.main_font_s)) == NULL){
		xprint("_set_fnt() (main_fs_s xft)");
		exit(1);
	}
	if((main_win->font_rubi = XftFontOpenXlfd(disp,0,xconf.rubi_font)) == NULL){
		xprint("_set_fnt() (main_fs_rubi xft)");
		exit(1);
	}
#endif
	}
	xtext_offt_set(offset_head,offset_tail,&xconf,&off_head,&off_tail);
	xtext_set_offset(main_book->b_head,main_book->b_tail,off_head);
	main_win->change_font = 1;
	SELECTOR_FONT_NAME = (char *)xconf.main_font_j;
}
static void _set_utl()
{
	main_win->title_on = xconf.title_on;
	main_win->anti = xconf.anti;
	main_win->kinsc = xconf.kinsc;
	main_win->page_on = xconf.page_on;
	main_win->cursor = xconf.cursor;
}
static void _set_chr()
{
	char_d->xpad = xconf.line_space != -1 ? xconf.line_space:0;
	char_d->ypad = xconf.row_space != -1 ? xconf.row_space:0;
}
static void _set_pix()
{
	/*
	if(xconf.main_window_img != NULL){
		if(main_win.image.img != 0) XFreePixmap(disp,main_win.image.img);
		xtextGetImage(disp,&main_win,xconf.main_window_img);
	}
	*/
}
static void _set_net()
{
	xnet.book_dir = xconf.book_dir; 
	xnet.ao_url = xconf.ao_url; xnet.ao_list = xconf.ao_list;
}
static void _set_xconf_data()
{
	_set_utl();
	_set_col();
	_set_win();
	_set_fnt();
	_set_chr();
#if HAVE_NETDB_H
	_set_net();
#endif
	/*
	_set_pix();
	*/
	return ;
}
static int _quit_win()
{
	sub_window_t *q_head = NULL, *q_tail = NULL;
	char *result;

	xtextQuitData2Sub(&q_head,&q_tail);

	if((result = (char *)xtextSubWindow(disp,main_win,q_head,q_tail,40,1)) == NULL) return -1;
	if(strcmp(result,XJP_OK) == 0) return 0;
	return 1;
}
static int _quit_cwin(){ return 0; }
static int _hide_cwin(){ return 1; }
static int _button_cwin(XEvent ev)
{
	/*
	ctl_window_t *ct;
	int x,y;
	int loop = 1;

	x = ev.xbutton.x;
	y = ev.xbutton.y;

	for(ct=ctl_head;ct!=NULL;ct=ct->next){
		if(ct->xpos0 < x && x < ct->xpos1 && ct->ypos0 < y && y < ct->ypos1){
			loop = ct->func();
			break;
		}
	}

	return loop;
	*/
	return 1;
}
static int _expose_cwin()
{
	/*
	ctl_window_t *ct;
	XRectangle ink,log;
	int x,y,w,h;
	int ctl_max;
	int xpad = 2,i;

	ctl_max = sizeof(XJP_CTRL_STR) / sizeof(char *);
	XmbTextExtents(main_win.fs_s,XJP_CTRL_STR[0],strlen(XJP_CTRL_STR[0]),&ink,&log);
	w = log.width ;
	h = log.height;
	x = 0; 
	y = 0;
	XMoveResizeWindow(disp,main_win.cwin,x,y,w * (ctl_max+xpad),h+2);
	XClearWindow(disp,main_win.cwin);

	for(ct=ctl_head,i=0;ct!=NULL;ct=ct->next,i++){
		ct->xpos0 = i * (w + xpad);
		ct->xpos1 = ct->xpos0 + w;
		ct->ypos0 = 0;
		ct->ypos1 = h;
		XmbDrawString(disp,main_win.cwin,main_win.fs_s,main_win.rubi_gc,ct->xpos0,ct->ypos1,ct->name,strlen(ct->name));
	}
	*/

	return 1;
}
static int _expose_win()
{
	if((NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p)) < 0)
		xtext_Draw_Help(disp,main_win,&xconf);
	return 1;
}
static int _configure_win(XEvent ev)
{
	if(main_win->width != ev.xconfigure.width || main_win->height != ev.xconfigure.height){
		main_win->width = xconf.main_window_width = ev.xconfigure.width;
		main_win->height = xconf.main_window_height = ev.xconfigure.height;
		char_p = (page_data_t *)xtext_Redraw_Text(disp,main_win,main_book,char_d,NPC);
	}
	return 1;
}
static int _siori_win()
{
	if(siori_head == NULL)
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[2]);
	else
		select_siori_data(siori_head,0);
	return 1;
}
static int _bookmark_win()
{
	if(char_d->book == NULL) return 1;

   	if(xtext_siori_data_mark(&siori_head,&siori_tail,char_d->book->book_path,char_d->book->book_title,NPC) < 0) return -1;

	xtext_siori_data_write(&siori_head,&siori_tail);
	xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[0]);
	return 1;
}
static  page_data_t * _page_find(page_data_t *find)
{
	page_data_t *pt;
	int start,end;

	if(find == NULL) return char_p; 

	for(pt=char_d->head;pt!=NULL;pt=pt->next){
		start = pt->char_no;
		if(pt->next != NULL)
			end = pt->next->char_no;
		else
			end = -1;

		if(end > 0){
			if(find->char_no >= start && find->char_no < end) return pt;
		}else{
			if(find->char_no >= start) return pt;
		}
	}
	return NULL;
}
static  page_data_t * _page_step(page_data_t *page,int step)
{
	page_data_t *p,*pp;
	int i = 0;

	if(step == 0) return page;
	if(page == NULL) return NULL;

	if(step > 0){
		for(p=page,i=0;p!=NULL;p=p->next,i++){
			if(i == step) return p;
			pp = p;
		}
	}else{
		for(p=page,i=0;p!=NULL;p=p->prev,i--){
			if(i == step) return p;
			pp = p;
		}
	}
	return pp;
}
static int _next_win(int step)
{
	if(main_book->b_head == NULL || char_p->next == NULL) return -1;

	if(step == 0) step = 1;
	char_p = _page_step(char_p,step);
	NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p);
	return 1;
}
static int _prev_win(int step)
{
	if(main_book->b_head == NULL || char_p->prev == NULL) return -1;

	if(step == 0) step = -1;
	char_p = _page_step(char_p,step);
	NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p);
	return 1;
}
static int _next_find_win()
{
	int find_page;

	if(find_p == NULL || find_p->next == NULL) return -1;

	find_page = char_p->page_no;
	while(1){
		if(find_p->next == NULL) break;
		find_p = find_p->next;
		if((char_p = _page_find(find_p))->page_no != find_page) break;
	}
	NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p);
	return 1;
}
static int _prev_find_win()
{
	int find_page;
	if(find_p == NULL || find_p->prev == NULL) return -1;

	find_page = char_p->page_no;
	while(1){
		if(find_p->prev == NULL) break;
		find_p = find_p->prev;
		if((char_p = _page_find(find_p))->page_no != find_page) break;
	}
	NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p);
	return 1;
}
static int _title_key_win()
{
	xconf.title_on = xconf.title_on ? 0 : 1;
	_set_utl();
	NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p);
	return 1;
}
static int _page_key_win()
{
	xconf.page_on = xconf.page_on ? 0 : 1;
	_set_utl();
	NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p);
	return 1;
}
static int _kinsc_win()
{
	if(xconf.kinsc++ >= 2) xconf.kinsc = 0;
	_set_utl();
	char_p = (page_data_t *)xtext_Redraw_Text(disp,main_win,main_book,char_d,NPC);
	NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p);
	return 1;
}
static int _curs_win()
{
	if(xconf.cursor++ >= 4) xconf.cursor = 0;
	_set_utl();
	return 1;
}
static int _chuki_win()
{
	if(xconf.chuki){
		xconf.chuki = 0;
		XUnmapWindow(disp,main_win->mwin);
	}else{
		xconf.chuki = 1;
		XMapRaised(disp,main_win->mwin);
	}
	return 1;
}
static int _find_win()
{
	xtextCheckFindData(main_book,char_d,xtextInputWindow(disp,main_win,NULL,NULL,60));
	find_p = char_d->find_head;
	char_p = _page_find(find_p);
	NPC = xtext_Draw_Text(disp,main_win,main_book,char_d,char_p);
	return 1;
}
static int _rast_win()
{
#if HAVE_ATEXIT
	rast_win_reg(save_book_head);
#endif
	return 1;
}
static int _xtext_mwin_event(XEvent ev)
{
	int loop = 1;

	switch(ev.type){
		case Expose:
			xtextDrawChuMessage(disp,main_win,char_d);
		break;
	}
	return loop;
}
static int _xtext_cwin_event(XEvent ev)
{
	/*
	int loop = 1;

	switch(ev.type){
		case Expose:
			_expose_cwin();
		break;
		case ButtonPress:
			loop = _button_cwin(ev);
		break;
	}

	return loop;
	*/
	return 1;
}
static int help_book_data()
{
	sub_window_t *help_head = NULL, *help_tail = NULL;
	char *result; int percent = 95;
	xtextHelpData2Sub(&help_head,&help_tail,&xconf);
	if((result = xtextSubWindow(disp,main_win,help_head,help_tail,percent,0))==NULL) 
		return -1;
	if(strcmp(result,XJP_OK) == 0) return 1; return 0;
}
static int _conf_win()
{
	if(help_book_data()){
		_set_xconf_data(); char_p = (page_data_t *)xtext_Redraw_Text(disp,main_win,main_book,char_d,NPC);
	}
	return 1;
}
int config_win(void *data0,int data1)
{
	if(help_book_data()){
		_set_xconf_data(); char_p = (page_data_t *)xtext_Redraw_Text(disp,main_win,main_book,char_d,NPC);
		return 1;
	}
	return 0;
}
int menu_win(void *data0,int data1)
{
	if(save_book_head != NULL)
		book_link_free(&save_book_head,&save_book_tail);
	if(xconf.book_dir == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[1]); return 1; }
	save_book_head = NULL; save_book_tail = NULL;
	ibookGetBookData(&save_book_head,&save_book_tail,xconf.book_dir);
	save_book_head->siori = siori_head;
	save_book_head->dbpath = xconf.rast_db;
	save_book_head->bookdir = xconf.book_dir;
	if(select_book_data(save_book_head,0) < 0) menu_win(data0,data1);
	return 1;
}
static int _xtext_main_event(XEvent ev)
{
	static int step;
	char *keyname;
	int re = 1;

	switch(ev.type){
		case Expose:
			if(ev.xexpose.count == 0){
				_expose_win();
				/*
				_expose_cwin();
				*/
			}
		break;
		case ConfigureNotify:
			_configure_win(ev);
		break;
		case ButtonPress:
			if(ev.xbutton.button == 1){
				_next_win(1);
			}else if(ev.xbutton.button == 2){
				menu_win(NULL,0);
			}else if(ev.xbutton.button == 3){
				_prev_win(-1);
			}
		break;
		case KeyPress:
			keyname = (char *)XKeysymToString(XLookupKeysym(&ev.xkey,0)); 

			if(strcmp(keyname,xconf.menu)==0){
				menu_win(NULL,0);

			}else if(strcmp(keyname,xconf.conf_page)==0){
				_conf_win();

			}else if(strcmp(keyname,xconf.book_mark)==0){
				_bookmark_win();

			}else if(strcmp(keyname,xconf.siori_menu)==0){
				_siori_win();

			}else if(strcmp(keyname,xconf.quit)==0){
				re = _quit_win();

			}else if(strcmp(keyname,xconf.page_next)==0){
				_next_win(atoi(StepBuf));

			}else if(strcmp(keyname,xconf.page_prev)==0){
				_prev_win(atoi(StepBuf) * -1);

			}else if(strcmp(keyname,xconf.title_key)==0){
				_title_key_win();

			}else if(strcmp(keyname,xconf.page_key)==0){
				_page_key_win();

			}else if(strcmp(keyname,xconf.kinsc_key)==0){
				_kinsc_win();

			}else if(strcmp(keyname,xconf.chuki_key)==0){
				_chuki_win();

			}else if(strcmp(keyname,xconf.cursor_key)==0){
				_curs_win();

			}else if(strcmp(keyname,xconf.other_key)==0){
				other_win(main_book,&xconf);

			}else if(strcmp(keyname,xconf.net_key)==0){
#if HAVE_NETDB_H
				net_win(NULL,0);
#endif
			}else if(strcmp(keyname,xconf.find_key)==0){
				_find_win();
			}else if(strcmp(keyname,xconf.find_next)==0){
				_next_find_win();
			}else if(strcmp(keyname,xconf.find_prev)==0){
				_prev_find_win();

			}else if(strcmp(keyname,xconf.rast_key)==0){
				_rast_win();

			}else{
				re = 1;
			}
			step = checkStepNumber(keyname,StepBuf,step);
		break;
	}
	return re;
}
static ctl_window_t *_ctl_data_alloc()
{
	ctl_window_t *ct;
	ct = (ctl_window_t *)malloc(sizeof(ctl_window_t));
	ct->name = NULL;
	ct->xpos0 = 0;
	ct->xpos1 = 0;
	ct->ypos0 = 0;
	ct->ypos1 = 0;
	ct->func = NULL;
	ct->func_data0 = NULL;
	return ct;
}
static void * _ctl_data_add(ctl_window_t **head,ctl_window_t **tail,ctl_window_t *im)
{
        if(*tail){im->next = NULL;im->prev = *tail; (*tail)->next = im;*tail = im;}
        else{im->next = NULL;im->prev = NULL;*tail = im;*head = im;}
        return NULL;
}
/*
static void _set_ctrl(ctl_window_t **head,ctl_window_t **tail)
{
	ctl_window_t *ct;
	int i;

	for(i=0;i<sizeof(XJP_CTRL_STR)/sizeof(char *);i++){
		ct = (ctl_window_t *)_ctl_data_alloc();
		ct->name = XJP_CTRL_STR[i];
		switch(i){
			case 0:
				ct->func = _hide_cwin;
				ct->func_data0 = NULL;
			break;
			case 1:
				ct->func = _bookmark_win;
				ct->func_data0 = NULL;
			break;
			case 2:
				ct->func = _menu_win;
				ct->func_data0 = NULL;
			break;
			case 3:
				ct->func = _siori_win;
			       	ct->func_data0 = NULL;	
			break;
			case 4:	
				ct->func = _title_key_win;
				ct->func_data0 = NULL;
			break;
			case 5:
				ct->func = _kinsc_win;
				ct->func_data0 = NULL;
			break;
			case 6:
				ct->func = _conf_win;
				ct->func_data0 = NULL;
			break;
			case 7:
				ct->func = _quit_cwin;
				ct->func_data0 = NULL;
			break;
		}
		_ctl_data_add(head,tail,ct);
	}
}
*/
static char * _get_option(int c,char **v)
{
	int option;

	while(1){
		if((option = getopt(c,v,"a:b:c:d:e:f:g:i:j:k:l:m:n:p:q:u:orsth")) == -1) break;
		switch(option){
			case 'h': _usage(); break;
			case 'f':return optarg;break;
			case 'd':_xconf_malloc(&xconf.book_dir,optarg);break;
			case 'a':xconf.main_window_width = atoi(optarg);break;
			case 'b':xconf.main_window_height = atoi(optarg);break;
			case 'c':_xconf_malloc(&xconf.main_window_color,optarg);break;
			case 'e':_xconf_malloc(&xconf.main_font_color,optarg);break;
			case 'g':_xconf_malloc(&xconf.rubi_font_color,optarg);break;
			case 'i':_xconf_malloc(&xconf.menu_font_color,optarg);break;
			case 'j':_xconf_malloc(&xconf.menu_window_color,optarg);break;
			case 'k':_xconf_malloc(&xconf.main_font_j,optarg);break;
			case 'l':_xconf_malloc(&xconf.main_font_s,optarg);break;
			case 'm':_xconf_malloc(&xconf.main_font_e,optarg);break;
			case 'n':_xconf_malloc(&xconf.rubi_font,optarg);break;
			case 'o':xconf.anti = 1;break;
			case 'p':xconf.line_space = atoi(optarg);break;
			case 'q':xconf.row_space = atoi(optarg);break;
			case 'r':xconf.title_on = 1;break;
			case 's':xconf.page_on = 1;break;
			case 't':xconf.ruby_on = 1;break;
			case 'u':_xconf_malloc(&xconf.rast_db,optarg);break;
			default: _usage(); break;
		}
	}
	return NULL;
}
int main(int argc,char *argv[])
{
	XEvent ev;
	char *opt_book_path = NULL, *xjp_help = NULL; int loop = 1;

	if((main_book = (ICONTENT_T *)content_link_alloc()) == NULL) exit(1);
	xjp_help = (char *)xtext_conf_data(&xconf);
	xtext_offt_data(&offset_head,&offset_tail);
	xtext_siori_data_read(&siori_head,&siori_tail);
	opt_book_path = (char *)_get_option(argc,argv);
	/*
	_set_ctrl(&ctl_head,&ctl_tail);
	*/
	_x_init(); _x_drawable(); _set_xconf_data();
	if(opt_book_path != NULL){ 
		char_p = (page_data_t *)xtext_Init_Book(disp,main_win,main_book,
						char_d,off_head,&xconf,opt_book_path,0);}
	while(loop){
		while(XPending(disp)){
			XNextEvent(disp,&ev);
			if(ev.xany.window == main_win->win){
				if((loop = _xtext_main_event(ev)) == 0) break;
				/*
			}else if(ev.xany.window == main_win.cwin){
				if((loop = _xtext_cwin_event(ev)) == 0) break;
				*/
			}else if(ev.xany.window == main_win->mwin){
				_xtext_mwin_event(ev);

			}
		}
		usleep(50000);
		xtextCursorType(disp,main_win,xjp_help);
	}
	xtext_siori_data_write(&siori_head,&siori_tail);
	_x_end();
	return 0;
}

