/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.littleendian.DWord;

public class Property {
    private int id;
    private int type;
    private Object value;

    public int getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Property(int id, byte[] src, int offset, int length) {
        this.id = id;
        if (id == 0) {
            this.value = this.readDictionary(src, offset, length);
            return;
        }
        int o = offset;
        this.type = new DWord(src, o).intValue();
        o += 4;
        switch (this.type) {
            case 3: {
                this.value = new Integer(new DWord(src, o).intValue());
                break;
            }
            case 64: {
                int low = new DWord(src, o).intValue();
                int high = new DWord(src, o += 4).intValue();
                this.value = Util.filetimeToDate(high, low);
                break;
            }
            case 30: {
                int first = o + 4;
                int last = first + new DWord(src, o).intValue() - 1;
                o += 4;
                while (src[last] == 0 && first <= last) {
                    --last;
                }
                this.value = new String(src, first, last - first + 1);
                break;
            }
            default: {
                byte[] v = new byte[length];
                int i = 0;
                while (i < length) {
                    v[i] = src[offset + i];
                    ++i;
                }
                this.value = v;
                break;
            }
        }
    }

    protected Map readDictionary(byte[] src, int offset, int length) {
        int o = offset;
        int nrEntries = new DWord(src, o).intValue();
        o += 4;
        HashMap<Integer, String> m = new HashMap<Integer, String>(nrEntries, 1.0f);
        int i = 0;
        while (i < nrEntries) {
            Integer id = new Integer(new DWord(src, o).intValue());
            int sLength = new DWord(src, o += 4).intValue();
            o += 4;
            int l = sLength;
            while (src[o + l - 1] == 0) {
                --l;
            }
            String s = new String(src, o, l);
            o += sLength;
            m.put(id, s);
            ++i;
        }
        return m;
    }

    protected int readCodePage(byte[] src, int offset) {
        throw new UnsupportedOperationException("FIXME");
    }
}

