/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.generator;

public class RecordUtil {
    public static String getFieldName(int position, String name, int padTo) {
        StringBuffer fieldName = new StringBuffer("field_" + position + "_");
        RecordUtil.toIdentifier(name, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    protected static StringBuffer pad(StringBuffer fieldName, int padTo) {
        int i = fieldName.length();
        while (i < padTo) {
            fieldName.append(' ');
            ++i;
        }
        return fieldName;
    }

    public static String getFieldName(String name, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toIdentifier(name, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    public static String getFieldName1stCap(String name, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toIdentifier(name, fieldName);
        fieldName.setCharAt(0, Character.toUpperCase(fieldName.charAt(0)));
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    private static void toIdentifier(String name, StringBuffer fieldName) {
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == ' ') {
                fieldName.append(Character.toUpperCase(name.charAt(++i)));
            } else {
                fieldName.append(name.charAt(i));
            }
            ++i;
        }
    }

    private static void toConstIdentifier(String name, StringBuffer fieldName) {
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == ' ') {
                fieldName.append('_');
            } else {
                fieldName.append(Character.toUpperCase(name.charAt(i)));
            }
            ++i;
        }
    }

    public static String getType(String size, String type, int padTo) {
        boolean wholeNumber;
        boolean bl = wholeNumber = type.equals("bits") || type.equals("int");
        if (wholeNumber && "1".equals(size)) {
            return RecordUtil.pad(new StringBuffer("byte"), padTo).toString();
        }
        if (wholeNumber && "2".equals(size)) {
            return RecordUtil.pad(new StringBuffer("short"), padTo).toString();
        }
        if (type.equals("int") && "varword".equals(size)) {
            return RecordUtil.pad(new StringBuffer("short[]"), padTo).toString();
        }
        if (wholeNumber && "4".equals(size)) {
            return RecordUtil.pad(new StringBuffer("int"), padTo).toString();
        }
        if (type.equals("float") && "8".equals(size)) {
            return RecordUtil.pad(new StringBuffer("double"), padTo).toString();
        }
        if (type.equals("string")) {
            return RecordUtil.pad(new StringBuffer("ExcelString"), padTo).toString();
        }
        return "";
    }

    public static String getType1stCap(String size, String type, int padTo) {
        StringBuffer result;
        boolean numeric;
        boolean bl = numeric = type.equals("bits") || type.equals("int");
        if (numeric && "1".equals(size)) {
            result = RecordUtil.pad(new StringBuffer("byte"), padTo);
        } else if (type.equals("int") && "varword".equals(size)) {
            result = RecordUtil.pad(new StringBuffer("short[]"), padTo);
        } else if (numeric && "2".equals(size)) {
            result = RecordUtil.pad(new StringBuffer("short"), padTo);
        } else if (type.equals("string")) {
            result = RecordUtil.pad(new StringBuffer("ExcelString"), padTo);
        } else {
            return "";
        }
        result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
        return result.toString();
    }

    public static String getMask(int bit) {
        int mask = (int)Math.pow(2.0, bit);
        return "0x" + Integer.toHexString(mask);
    }

    public static String getConstName(String parentName, String constName, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toConstIdentifier(parentName, fieldName);
        fieldName.append('_');
        RecordUtil.toConstIdentifier(constName, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }
}

