/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class Pack
extends Task {
    protected File zipFile;
    protected File source;

    public void setZipfile(File zipFile) {
        this.zipFile = zipFile;
    }

    public void setSrc(File src) {
        this.source = src;
    }

    private void validate() throws BuildException {
        if (this.zipFile == null) {
            throw new BuildException("zipfile attribute is required", this.getLocation());
        }
        if (this.zipFile.isDirectory()) {
            throw new BuildException("zipfile attribute must not represent a directory!", this.getLocation());
        }
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.getLocation());
        }
        if (this.source.isDirectory()) {
            throw new BuildException("Src attribute must not represent a directory!", this.getLocation());
        }
    }

    public void execute() throws BuildException {
        this.validate();
        if (!this.source.exists()) {
            this.log("Nothing to do: " + this.source.getAbsolutePath() + " doesn't exist.");
        } else if (this.zipFile.lastModified() < this.source.lastModified()) {
            this.log("Building: " + this.zipFile.getAbsolutePath());
            this.pack();
        } else {
            this.log("Nothing to do: " + this.zipFile.getAbsolutePath() + " is up to date.");
        }
    }

    private void zipFile(InputStream in, OutputStream zOut) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(File file, OutputStream zOut) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fIn.close();
            throw throwable;
        }
        fIn.close();
    }

    protected abstract void pack();
}

