/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class FormatRecord
extends Record {
    public static final short sid = 1054;
    private short field_1_index_code;
    private byte field_2_formatstring_len;
    private short field_3_zero;
    private String field_4_formatstring;

    public FormatRecord() {
    }

    public FormatRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public FormatRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 1054) {
            throw new RecordFormatException("NOT A FORMAT RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_index_code = LittleEndian.getShort(data, 0 + offset);
        this.field_2_formatstring_len = data[2 + offset];
        this.field_3_zero = LittleEndian.getShort(data, 3 + offset);
        this.field_4_formatstring = new String(data, 5 + offset, LittleEndian.ubyteToInt(this.field_2_formatstring_len));
    }

    public void setIndexCode(short index) {
        this.field_1_index_code = index;
    }

    public void setFormatStringLength(byte len) {
        this.field_2_formatstring_len = len;
    }

    public void setFormatString(String fs) {
        this.field_4_formatstring = fs;
    }

    public short getIndexCode() {
        return this.field_1_index_code;
    }

    public byte getFormatStringLength() {
        return this.field_2_formatstring_len;
    }

    public String getFormatString() {
        return this.field_4_formatstring;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FORMAT]\n");
        buffer.append("    .indexcode       = ").append(Integer.toHexString(this.getIndexCode())).append("\n");
        buffer.append("    .formatstringlen = ").append(Integer.toHexString(this.getFormatStringLength())).append("\n");
        buffer.append("    .zero            = ").append(Integer.toHexString(this.field_3_zero)).append("\n");
        buffer.append("    .formatstring    = ").append(this.getFormatString()).append("\n");
        buffer.append("[/FORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)1054);
        LittleEndian.putShort(data, 2 + offset, (short)(5 + this.getFormatStringLength()));
        LittleEndian.putShort(data, 4 + offset, this.getIndexCode());
        data[6 + offset] = this.getFormatStringLength();
        LittleEndian.putShort(data, 7 + offset, (short)0);
        StringUtil.putCompressedUnicode(this.getFormatString(), data, 9 + offset);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 9 + this.getFormatStringLength();
    }

    public short getSid() {
        return 1054;
    }
}

