/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.poi.util.LittleEndianConsts;

public class LittleEndian
implements LittleEndianConsts {
    private static final byte[] _short_buffer = new byte[2];
    private static final byte[] _int_buffer = new byte[4];
    private static final byte[] _long_buffer = new byte[8];

    private LittleEndian() {
    }

    public static short getShort(byte[] data, int offset) {
        return (short)LittleEndian.getNumber(data, offset, 2);
    }

    public static short[] getSimpleShortArray(byte[] data, int offset, int size) {
        short[] results = new short[size];
        int i = 0;
        while (i < size) {
            results[i] = LittleEndian.getShort(data, offset + 2 + i * 2);
            ++i;
        }
        return results;
    }

    public static short[] getShortArray(byte[] data, int offset) {
        short size = (short)LittleEndian.getNumber(data, offset, 2);
        short[] results = LittleEndian.getSimpleShortArray(data, offset, size);
        return results;
    }

    public static short getShort(byte[] data) {
        return LittleEndian.getShort(data, 0);
    }

    public static int getInt(byte[] data, int offset) {
        return (int)LittleEndian.getNumber(data, offset, 4);
    }

    public static int getInt(byte[] data) {
        return LittleEndian.getInt(data, 0);
    }

    public static long getLong(byte[] data, int offset) {
        return LittleEndian.getNumber(data, offset, 8);
    }

    public static long getLong(byte[] data) {
        return LittleEndian.getLong(data, 0);
    }

    public static double getDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(LittleEndian.getNumber(data, offset, 8));
    }

    public static double getDouble(byte[] data) {
        return LittleEndian.getDouble(data, 0);
    }

    public static void putShort(byte[] data, int offset, short value) {
        LittleEndian.putNumber(data, offset, value, 2);
    }

    public static void putUShort(byte[] data, int offset, int value) {
        LittleEndian.putNumber(data, offset, value, 2);
    }

    public static void putShortArray(byte[] data, int offset, short[] value) {
        LittleEndian.putNumber(data, offset, value.length, 2);
        int i = 0;
        while (i < value.length) {
            LittleEndian.putNumber(data, offset + 2 + i * 2, value[i], 2);
            ++i;
        }
    }

    public static void putShort(byte[] data, short value) {
        LittleEndian.putShort(data, 0, value);
    }

    public static void putInt(byte[] data, int offset, int value) {
        LittleEndian.putNumber(data, offset, value, 4);
    }

    public static void putInt(byte[] data, int value) {
        LittleEndian.putInt(data, 0, value);
    }

    public static void putLong(byte[] data, int offset, long value) {
        LittleEndian.putNumber(data, offset, value, 8);
    }

    public static void putLong(byte[] data, long value) {
        LittleEndian.putLong(data, 0, value);
    }

    public static void putDouble(byte[] data, int offset, double value) {
        LittleEndian.putNumber(data, offset, Double.doubleToLongBits(value), 8);
    }

    public static void putDouble(byte[] data, double value) {
        LittleEndian.putDouble(data, 0, value);
    }

    public static short readShort(InputStream stream) throws IOException, BufferUnderrunException {
        return LittleEndian.getShort(LittleEndian.readFromStream(stream, 2));
    }

    public static int readInt(InputStream stream) throws IOException, BufferUnderrunException {
        return LittleEndian.getInt(LittleEndian.readFromStream(stream, 4));
    }

    public static long readLong(InputStream stream) throws IOException, BufferUnderrunException {
        return LittleEndian.getLong(LittleEndian.readFromStream(stream, 8));
    }

    public static byte[] readFromStream(InputStream stream, int size) throws IOException, BufferUnderrunException {
        byte[] buffer = null;
        switch (size) {
            case 2: {
                buffer = _short_buffer;
                break;
            }
            case 4: {
                buffer = _int_buffer;
                break;
            }
            case 8: {
                buffer = _long_buffer;
                break;
            }
            default: {
                buffer = new byte[size];
            }
        }
        int count = stream.read(buffer);
        if (count == -1) {
            Arrays.fill(buffer, (byte)0);
        } else if (count != size) {
            throw new BufferUnderrunException();
        }
        return buffer;
    }

    private static long getNumber(byte[] data, int offset, int size) {
        long result = 0L;
        int j = offset + size - 1;
        while (j >= offset) {
            result <<= 8;
            result |= (long)(0xFF & data[j]);
            --j;
        }
        return result;
    }

    private static void putNumber(byte[] data, int offset, long value, int size) {
        int limit = size + offset;
        long v = value;
        int j = offset;
        while (j < limit) {
            data[j] = (byte)(v & 0xFFL);
            v >>= 8;
            ++j;
        }
    }

    public static int ubyteToInt(byte b) {
        return (b & 0x80) == 0 ? b : (b & 0x7F) + 128;
    }

    public static int getUnsignedByte(byte[] data, int offset) {
        return (int)LittleEndian.getNumber(data, offset, 1);
    }

    public static int getUnsignedByte(byte[] data) {
        return LittleEndian.getUnsignedByte(data, 0);
    }

    public static byte[] getByteArray(byte[] data, int offset, int size) {
        byte[] copy = new byte[size];
        System.arraycopy(data, offset, copy, 0, size);
        return copy;
    }

    public static int getUShort(byte[] data, int offset) {
        return (int)LittleEndian.getNumber(data, offset, 2);
    }

    public static class BufferUnderrunException
    extends IOException {
        BufferUnderrunException() {
            super("buffer underrun");
        }
    }
}

