/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;

public class ZipScanner
extends DirectoryScanner {
    protected File srcFile;
    private Resource lastScannedResource;
    private Hashtable myentries;

    public void setSrc(File srcFile) {
        this.srcFile = srcFile;
    }

    public String[] getIncludedFiles() {
        if (this.srcFile != null) {
            Vector<String> myvector = new Vector<String>();
            this.scanme();
            Enumeration e = this.myentries.elements();
            while (e.hasMoreElements()) {
                Resource myresource = (Resource)e.nextElement();
                if (myresource.isDirectory() || !this.match(myresource.getName())) continue;
                myvector.addElement(myresource.getName());
            }
            Object[] files = new String[myvector.size()];
            myvector.copyInto(files);
            return files;
        }
        return super.getIncludedFiles();
    }

    public String[] getIncludedDirectories() {
        if (this.srcFile != null) {
            Vector<String> myvector = new Vector<String>();
            this.scanme();
            Enumeration e = this.myentries.elements();
            while (e.hasMoreElements()) {
                Resource myresource = (Resource)e.nextElement();
                if (!myresource.isDirectory() || !this.match(myresource.getName())) continue;
                myvector.addElement(myresource.getName());
            }
            Object[] files = new String[myvector.size()];
            myvector.copyInto(files);
            return files;
        }
        return super.getIncludedDirectories();
    }

    public void init() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    public boolean match(String path) {
        String vpath = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return this.isIncluded(vpath) && !this.isExcluded(vpath);
    }

    public Resource getResource(String name) {
        if (this.srcFile == null) {
            return super.getResource(name);
        }
        if (name.equals("")) {
            return new Resource("", true, Long.MAX_VALUE, true);
        }
        this.scanme();
        if (this.myentries.containsKey(name)) {
            return (Resource)this.myentries.get(name);
        }
        if (this.myentries.containsKey(name + "/")) {
            return (Resource)this.myentries.get(name + "/");
        }
        return new Resource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanme() {
        Resource thisresource = new Resource(this.srcFile.getAbsolutePath(), this.srcFile.exists(), this.srcFile.lastModified());
        if (this.lastScannedResource != null && this.lastScannedResource.getName().equals(thisresource.getName()) && this.lastScannedResource.getLastModified() == thisresource.getLastModified()) {
            return;
        }
        ZipEntry entry = null;
        ZipInputStream in = null;
        this.myentries = new Hashtable();
        try {
            try {
                in = new ZipInputStream(new FileInputStream(this.srcFile));
            }
            catch (IOException ex) {
                throw new BuildException("problem opening " + this.srcFile, ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            while ((entry = in.getNextEntry()) != null) {
                this.myentries.put(new String(entry.getName()), new Resource(entry.getName(), true, entry.getTime(), entry.isDirectory()));
            }
        }
        catch (ZipException ex) {
            throw new BuildException("problem reading " + this.srcFile, ex);
        }
        catch (IOException e) {
            throw new BuildException("problem reading zip entry from " + this.srcFile, e);
        }
        Object var7_7 = null;
        if (in != null) {
            try {}
            catch (IOException ex) {}
            in.close();
        }
        this.lastScannedResource = thisresource;
    }
}

