/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.dti.venus.okazaki.xls2src;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import jp.ne.dti.venus.okazaki.xls2src.GeneratorInfo;
import jp.ne.dti.venus.okazaki.xls2src.Model;
import jp.ne.dti.venus.okazaki.xls2src.Table;
import jp.ne.dti.venus.okazaki.xls2src.Util;
import jp.ne.dti.venus.okazaki.xls2src.XmlLoader;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tools.ant.Task;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class Xls2src
extends Task {
    private GeneratorInfo _ginfo;
    private String _templateDir = "template";
    private String _destDir = "destDir";
    private String _xlsFile = "data/workbook.xls";

    public void execute() {
        XmlLoader xmlloader = new XmlLoader();
        this._ginfo = (GeneratorInfo)xmlloader.execute(this._templateDir + "/digester.xml", this._templateDir + "/generateInfo.xml");
        try {
            ArrayList modelCollection = this.getModelCollection();
            this.excute2(modelCollection);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end");
    }

    private ArrayList getModelCollection() throws IOException {
        ArrayList<Model> modelCollection = new ArrayList<Model>();
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(this._xlsFile));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet indexSheet = wb.getSheet("index");
        Table indexTable = new Table(indexSheet);
        HSSFSheet cmrInfoSheet = wb.getSheet("CMR");
        Table cmrInfoTable = new Table(cmrInfoSheet);
        int i = 0;
        while (i < indexTable.getRows().size()) {
            HashMap info = (HashMap)indexTable.getRows().get(i);
            info.get("sheet");
            HSSFSheet sheet = wb.getSheet((String)info.get("sheet"));
            Table table = new Table(sheet);
            Model model = new Model();
            model.setInfo(info);
            model.setRows(table.getRows());
            model.setCmrInfo(cmrInfoTable.getRows());
            System.out.println("class" + info.get("\u30af\u30e9\u30b9\u540d") + i);
            modelCollection.add(model);
            ++i;
        }
        return modelCollection;
    }

    public void excute2(ArrayList modelCollection) throws Exception, IOException {
        ArrayList templates = this._ginfo.getTemplates();
        Util util = new Util();
        Velocity.init((String)(this._templateDir + "/velocity.properties"));
        VelocityContext context = new VelocityContext();
        int i = 0;
        while (i < modelCollection.size()) {
            Model model = (Model)modelCollection.get(i);
            context.put("info", (Object)model.getInfo());
            context.put("rows", (Object)model.getRows());
            context.put("cmrInfo", (Object)model.getCmrInfo());
            context.put("util", (Object)util);
            context.put("u", (Object)util);
            int j = 0;
            while (j < modelCollection.size()) {
                this.write((HashMap)templates.get(j), context, model);
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(HashMap templateInfo, VelocityContext context, Model model) throws ResourceNotFoundException, ParseErrorException, Exception {
        OutputStreamWriter fileWriter = null;
        StringWriter writer = new StringWriter();
        Template template = Velocity.getTemplate((String)(this._templateDir + "/" + (String)templateInfo.get("templateFileName")), (String)"Shift_JIS");
        template.merge((Context)context, (Writer)writer);
        String packageDirName = this._destDir + "/" + (String)templateInfo.get("distDir");
        String packageName = (String)model.getInfo().get("\u30d1\u30c3\u30b1\u30fc\u30b8\u540d");
        if (((String)templateInfo.get("packageDir")).equals("all")) {
            packageDirName = packageDirName + "/" + packageName.replace('.', '/');
        } else if (((String)templateInfo.get("packageDir")).equals("last")) {
            packageDirName = packageDirName + "/" + packageName.substring(packageName.lastIndexOf(".") + 1, packageName.length());
        }
        System.out.println("packageDirName[" + packageDirName + "]");
        File file = new File(packageDirName);
        file.mkdirs();
        Util u = new Util();
        try {
            fileWriter = new FileWriter(packageDirName + "/" + ((String)templateInfo.get("fileName")).replaceAll("\\$1", u.uCaseFC((String)model.getInfo().get("\u30af\u30e9\u30b9\u540d"))));
            fileWriter.write(writer.toString());
            Object var12_11 = null;
            if (fileWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (fileWriter == null) throw throwable;
            fileWriter.close();
            throw throwable;
        }
        fileWriter.close();
    }

    public String getTemplateDir() {
        return this._templateDir;
    }

    public void setDestDir(String string) {
        this._destDir = string;
    }

    public void setTemplateDir(String string) {
        this._templateDir = string;
    }

    public void setXlsFile(String string) {
        this._xlsFile = string;
    }
}

