/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.BinaryTree;
import org.apache.poi.util.LittleEndian;

class SSTDeserializer {
    private BinaryTree strings;
    private int continuationExpectedChars;
    private String unfinishedString;
    private boolean wideChar;
    private boolean richText;
    private boolean extendedText;
    private short runCount;
    private int charCount;
    private int extensionLength;

    public SSTDeserializer(BinaryTree strings) {
        this.strings = strings;
        this.initVars();
    }

    private void initVars() {
        this.runCount = 0;
        this.continuationExpectedChars = 0;
        this.unfinishedString = "";
        this.wideChar = false;
        this.richText = false;
        this.extendedText = false;
    }

    public void manufactureStrings(byte[] data, int initialOffset, short dataSize) {
        this.initVars();
        int offset = initialOffset;
        while (offset - initialOffset < dataSize) {
            boolean stringContinuesOverContinuation;
            int remaining = dataSize - offset + initialOffset;
            if (remaining > 0 && remaining < 2) {
                throw new RecordFormatException("Cannot get length of the last string in SSTRecord");
            }
            if (remaining == 2) {
                this.setContinuationExpectedChars(LittleEndian.getUShort(data, offset));
                this.unfinishedString = "";
                break;
            }
            this.charCount = LittleEndian.getUShort(data, offset);
            this.readStringHeader(data, offset);
            boolean bl = stringContinuesOverContinuation = remaining < this.totalStringSize();
            if (stringContinuesOverContinuation) {
                int remainingBytes = initialOffset + dataSize - offset - this.stringHeaderOverhead();
                this.setContinuationExpectedChars(this.charCount - this.calculateCharCount(remainingBytes));
                this.charCount -= this.getContinuationExpectedChars();
            } else {
                this.setContinuationExpectedChars(0);
            }
            this.processString(data, offset, this.charCount);
            offset += this.totalStringSize();
            if (this.getContinuationExpectedChars() != 0) break;
        }
    }

    private void readStringHeader(byte[] data, int index) {
        byte optionFlag = data[index + 2];
        this.wideChar = (optionFlag & 1) == 1;
        this.extendedText = (optionFlag & 4) == 4;
        this.richText = (optionFlag & 8) == 8;
        this.runCount = 0;
        if (this.richText) {
            this.runCount = LittleEndian.getShort(data, index + 3);
        }
        this.extensionLength = 0;
        if (this.extendedText) {
            this.extensionLength = LittleEndian.getInt(data, index + 3 + (this.richText ? 2 : 0));
        }
    }

    private int processString(byte[] data, int dataIndex, int characters) {
        int length = 3 + this.calculateByteCount(characters);
        byte[] unicodeStringBuffer = new byte[length];
        int offset = 0;
        LittleEndian.putUShort(unicodeStringBuffer, offset, characters);
        unicodeStringBuffer[offset += 2] = data[dataIndex + offset];
        int bytesRead = unicodeStringBuffer.length - 3;
        this.arraycopy(data, dataIndex + this.stringHeaderOverhead(), unicodeStringBuffer, 3, bytesRead);
        UnicodeString string = new UnicodeString(4095, (short)unicodeStringBuffer.length, unicodeStringBuffer);
        if (this.isStringFinished()) {
            Integer integer = new Integer(this.strings.size());
            SSTDeserializer.addToStringTable(this.strings, integer, string);
        } else {
            this.unfinishedString = string.getString();
        }
        return bytesRead;
    }

    private boolean isStringFinished() {
        return this.getContinuationExpectedChars() == 0;
    }

    public static void addToStringTable(BinaryTree strings, Integer integer, UnicodeString string) {
        if (string.isRichText()) {
            string.setOptionFlags((byte)(string.getOptionFlags() & 0xFFFFFFF7));
        }
        if (string.isExtendedText()) {
            string.setOptionFlags((byte)(string.getOptionFlags() & 0xFFFFFFFB));
        }
        boolean added = false;
        while (!added) {
            try {
                strings.put(integer, string);
                added = true;
            }
            catch (Exception ignore) {
                string.setString(string.getString() + " ");
            }
        }
    }

    private int calculateCharCount(int byte_count) {
        return byte_count / (this.wideChar ? 2 : 1);
    }

    public void processContinueRecord(byte[] record) {
        if (this.isStringFinished()) {
            this.initVars();
            this.manufactureStrings(record, 0, (short)record.length);
        } else {
            boolean bl = this.wideChar = (record[0] & 1) == 1;
            if (this.stringSpansContinuation(record.length - 1)) {
                this.processEntireContinuation(record);
            } else {
                this.readStringRemainder(record);
            }
        }
    }

    private void readStringRemainder(byte[] record) {
        int stringRemainderSizeInBytes = this.calculateByteCount(this.getContinuationExpectedChars());
        byte[] unicodeStringData = new byte[3 + this.calculateByteCount(this.getContinuationExpectedChars())];
        LittleEndian.putShort(unicodeStringData, 0, (short)this.getContinuationExpectedChars());
        unicodeStringData[2] = this.createOptionByte(this.wideChar, this.richText, this.extendedText);
        this.arraycopy(record, 1, unicodeStringData, 3, unicodeStringData.length - 3);
        UnicodeString string = new UnicodeString(4095, (short)unicodeStringData.length, unicodeStringData, this.unfinishedString);
        Integer integer = new Integer(this.strings.size());
        SSTDeserializer.addToStringTable(this.strings, integer, string);
        int newOffset = this.offsetForContinuedRecord(stringRemainderSizeInBytes);
        this.manufactureStrings(record, newOffset, (short)(record.length - newOffset));
    }

    private int stringSizeInBytes() {
        return this.calculateByteCount(this.charCount);
    }

    private int totalStringSize() {
        return this.stringSizeInBytes() + this.stringHeaderOverhead() + 4 * this.runCount + this.extensionLength;
    }

    private int stringHeaderOverhead() {
        return 3 + (this.richText ? 2 : 0) + (this.extendedText ? 4 : 0);
    }

    private int offsetForContinuedRecord(int stringRemainderSizeInBytes) {
        return stringRemainderSizeInBytes + 1 + this.runCount * 4 + this.extensionLength;
    }

    private byte createOptionByte(boolean wideChar, boolean richText, boolean farEast) {
        return (byte)((wideChar ? 1 : 0) + (farEast ? 4 : 0) + (richText ? 8 : 0));
    }

    private void processEntireContinuation(byte[] record) {
        int dataLengthInBytes = record.length - 1;
        byte[] unicodeStringData = new byte[record.length + 2];
        LittleEndian.putShort(unicodeStringData, 0, (short)this.calculateCharCount(dataLengthInBytes));
        this.arraycopy(record, 0, unicodeStringData, 2, record.length);
        UnicodeString ucs = new UnicodeString(4095, (short)unicodeStringData.length, unicodeStringData);
        this.unfinishedString = this.unfinishedString + ucs.getString();
        this.setContinuationExpectedChars(this.getContinuationExpectedChars() - this.calculateCharCount(dataLengthInBytes));
    }

    private boolean stringSpansContinuation(int continuationSizeInBytes) {
        return this.calculateByteCount(this.getContinuationExpectedChars()) > continuationSizeInBytes;
    }

    int getContinuationExpectedChars() {
        return this.continuationExpectedChars;
    }

    private void setContinuationExpectedChars(int count) {
        this.continuationExpectedChars = count;
    }

    private int calculateByteCount(int character_count) {
        return character_count * (this.wideChar ? 2 : 1);
    }

    private void arraycopy(byte[] src, int src_position, byte[] dst, int dst_position, int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }

    String getUnfinishedString() {
        return this.unfinishedString;
    }

    boolean isWideChar() {
        return this.wideChar;
    }
}

