// Copyright (C) 2005-2006 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// In addition, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef XML_HXX
#define XML_HXX

#include <xsd/cxx/version.hxx>

#if (XSD_INT_VERSION != 2030051L)
#error XSD runtime version mismatch
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>
#include <xsd/cxx/xml/error-handler.hxx>

namespace xml_schema
{
  namespace parser
  {
    // anyType and anySimpleType.
    //
    typedef ::xsd::cxx::tree::type type;
    typedef ::xsd::cxx::tree::simple_type<type> simple_type;

    // 8-bit
    //
    typedef signed char byte;
    typedef unsigned char unsigned_byte;

    // 16-bit
    //
    typedef short short_;
    typedef unsigned short unsigned_short;

    // 32-bit
    //
    typedef int int_;
    typedef unsigned int unsigned_int;

    // 64-bit
    //
    typedef long long long_;
    typedef unsigned long long unsigned_long;

    // Supposed to be arbitrary-length integral types.
    //
    typedef long long integer;
    typedef integer non_positive_integer;
    typedef integer non_negative_integer;
    typedef integer positive_integer;
    typedef integer negative_integer;

    // Boolean.
    //
    typedef bool boolean;

    // Floating-point types.
    //
    typedef float float_;
    typedef double double_;
    typedef long double decimal;

    // String types.
    //
    typedef ::xsd::cxx::tree::string< char, simple_type > string;
    typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
    typedef ::xsd::cxx::tree::token< char, normalized_string > token;
    typedef ::xsd::cxx::tree::name< char, token > name;
    typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
    typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken> nmtokens;
    typedef ::xsd::cxx::tree::ncname< char, name > ncname;
    typedef ::xsd::cxx::tree::language< char, token > language;

    // ID/IDREF.
    //
    typedef ::xsd::cxx::tree::id< char, ncname > id;
    typedef ::xsd::cxx::tree::idref< type, char, ncname > idref;
    typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

    // URI.
    //
    typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

    // Qualified name.
    //
    typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

    // Binary.
    //
    typedef ::xsd::cxx::tree::buffer< char > buffer;
    typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
    typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

    // Date/time.
    //
    typedef ::xsd::cxx::tree::date< char, simple_type > date;
    typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
    typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
    typedef ::xsd::cxx::tree::day< char, simple_type > day;
    typedef ::xsd::cxx::tree::month< char, simple_type > month;
    typedef ::xsd::cxx::tree::month_day< char, simple_type > month_day;
    typedef ::xsd::cxx::tree::year< char, simple_type > year;
    typedef ::xsd::cxx::tree::year_month< char, simple_type > year_month;
    typedef ::xsd::cxx::tree::time< char, simple_type > time;

    // Entity.
    //
    typedef ::xsd::cxx::tree::entity< char, ncname > entity;
    typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

    // Exceptions.
    //
    typedef ::xsd::cxx::tree::exception< char > exception;
    typedef ::xsd::cxx::tree::parsing< char > parsing;
    typedef ::xsd::cxx::tree::expected_element< char > expected_element;
    typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
    typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
    typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
    typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
    typedef ::xsd::cxx::tree::not_derived< char > not_derived;
    typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
    typedef ::xsd::cxx::tree::serialization< char > serialization;
    typedef ::xsd::cxx::tree::no_namespace_mapping< char > no_namespace_mapping;
    typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
    typedef ::xsd::cxx::tree::xsi_already_in_use< char > xsi_already_in_use;
    typedef ::xsd::cxx::tree::bounds< char > bounds;

    // Parsing/serialization error.
    //
    typedef ::xsd::cxx::tree::error< char > error;
    typedef ::xsd::cxx::tree::errors< char > errors;

    // Error handler interface.
    //
    typedef ::xsd::cxx::xml::error_handler< char > error_handler;

    // Flags and properties.
    //
    typedef ::xsd::cxx::tree::flags flags;
    typedef ::xsd::cxx::tree::properties< char > properties;

    // DOM user data key for back pointers to tree nodes.
    //
#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA__PARSER
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA__PARSER

    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;

#endif
  }
}

// Forward declarations.
//
namespace namespace_
{
  class lang;
  class space;
}


#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

namespace namespace_
{
  class lang: public ::xml_schema::parser::string
  {
    public:

    lang (const ::std::basic_string< char >&);

    lang (const ::xercesc::DOMElement&,
          ::xml_schema::parser::flags = 0,
          ::xml_schema::parser::type* = 0);

    lang (const ::xercesc::DOMAttr&,
          ::xml_schema::parser::flags = 0,
          ::xml_schema::parser::type* = 0);

    lang (const ::std::basic_string< char >&,
          const ::xercesc::DOMElement*,
          ::xml_schema::parser::flags = 0,
          ::xml_schema::parser::type* = 0);

    lang (const lang&,
          ::xml_schema::parser::flags = 0,
          ::xml_schema::parser::type* = 0);

    virtual lang*
    _clone (::xml_schema::parser::flags = 0,
            ::xml_schema::parser::type* = 0) const;
  };

  class space: public ::xml_schema::parser::ncname
  {
    public:
    enum _xsd_space
    {
      default_,
      preserve
    };

    space (_xsd_space);

    space (const ::xml_schema::parser::ncname&);

    space (const ::xercesc::DOMElement&,
           ::xml_schema::parser::flags = 0,
           ::xml_schema::parser::type* = 0);

    space (const ::xercesc::DOMAttr&,
           ::xml_schema::parser::flags = 0,
           ::xml_schema::parser::type* = 0);

    space (const ::std::basic_string< char >&,
           const ::xercesc::DOMElement*,
           ::xml_schema::parser::flags = 0,
           ::xml_schema::parser::type* = 0);

    space (const space&,
           ::xml_schema::parser::flags = 0,
           ::xml_schema::parser::type* = 0);

    virtual space*
    _clone (::xml_schema::parser::flags = 0,
            ::xml_schema::parser::type* = 0) const;

    space&
    operator= (_xsd_space);

    virtual
    operator _xsd_space () const
    {
      return _xsd_space_convert ();
    }

    protected:
    _xsd_space
    _xsd_space_convert () const;

    public:
    static const char* const _xsd_space_literals_[2];
    static const _xsd_space _xsd_space_indexes_[2];
  };
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMInputSource.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

#include <xsd/cxx/tree/parsing.hxx>

namespace namespace_
{
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // XML_HXX
