<?php
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/item.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/attachment.php";

class XooNIpsBook extends XooNIpsItem{
    
    /**
     * array of supported version of import file
     */
    var $import_file_version = array( "1.00", "1.01" );

    function XooNIpsBook(){
        parent::XooNIpsItem();
        
        $this->columnLengths = $lengths = $this->getColumnMaxLen( 'xnpbook_item_detail' );
        $this->initVar('detail_version'   , XOBJ_DTYPE_TXTBOX, '1.00', false,10 );
        $this->initVar('detail_author'    , XOBJ_DTYPE_TXTBOX, null, false, $lengths['author'   ]);
        $this->initVar('detail_editor'    , XOBJ_DTYPE_TXTBOX, null, false, $lengths['editor'   ]);
        $this->initVar('detail_publisher' , XOBJ_DTYPE_TXTBOX, null, false, $lengths['publisher']);
        $this->initVar('detail_isbn'      , XOBJ_DTYPE_TXTBOX, null, false, $lengths['isbn'     ]);
        $this->initVar('detail_url'       , XOBJ_DTYPE_TXTBOX, null, false, $lengths['url'      ]);
        $this->initVar('detail_attachment_dl_limit', XOBJ_DTYPE_INT, null, false);
        $this->initVar('book_pdf'  , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->attachment_info = array(
            'book_pdf' => array( 'multiple' => false ),
        );
        // $this->initVar('year', XOBJ_DTYPE_INT, null, false); // use publication_year
    }

    function cleanVars()
    {
        $retval = true;
        if ( !parent::cleanVars() )
            $retval = false;
        
        // validate attachment_dl_limit
        if( $this->getVar('detail_attachment_dl_limit' ) != 0
            && $this->getVar('detail_attachment_dl_limit' ) != 1 ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "invalid value (".$this->getVar('detail_attachment_dl_limit' ).") of attachment_dl_limit " . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            $this->cleanVars['detail_attachment_dl_limit'] = intval( $this->getVar('detail_attachment_dl_limit' ) );
            $retval = false;
        }
        
        $vals = array(
            'author'   => $this->getVar('detail_author'    ,'n'),
            'editor'   => $this->getVar('detail_editor'    ,'n'),
            'publisher'=> $this->getVar('detail_publisher' ,'n'),
            'isbn'     => $this->getVar('detail_isbn'      ,'n'),
            'url'      => $this->getVar('detail_url'       ,'n'),
            'attachment_dl_limit' => $this->getVar('detail_attachment_dl_limit' ,'n'),
        );

        $ar = $this -> stripSurplusString( $this->columnLengths, $vals );
        foreach ( $vals as $key => $val ){
            if ( isset( $ar[$key] ) ){
                $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $key is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $this->cleanVars['detail_'.$key] = $ar[$key];
                $retval = false;
            }
            else
                $this->cleanVars['detail_'.$key] = $val;
        }
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            if ( !$info['multiple'] && count($attachments) > 1 ){
                $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $retval = false;
            }
            for ( $i = 0; $i < count($attachments); $i++ )
                if ( !$attachments[$i]->cleanVars() )
                    $retval = false;
            $this->setVar($name, serialize($attachments));
        }
        
        return $retval;
    }

    /**
     * 
     * for attachment file
     * 
     */
    var $file = null;
    var $attachment_info;
    
    // for column length check
    var $columnLengths;
    
    function startElement($parser, $name, $attribs){
        global $xoopsDB;
        
        parent::startElement($parser, $name, $attribs);

//            echo "\nS ".implode( '/', $this -> tagstack )."\tattributes=";print_r($attribs);
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            foreach ( $this->attachment_info as $name => $info )
                $this->setVar( $name, serialize(array()), true );
            // 
            // validate version and set it to 'detail_version' variable
            // 
            if( !empty( $attribs['VERSION'] ) ){
                if( in_array( $attribs['VERSION'], $this -> import_file_version ) ){
                    $this -> setVar( 'detail_version', $attribs['VERSION'] );
                }else{
                    $this -> setErrors( E_XOONIPS_INVALID_VALUE, "unsupported version(" . $attribs['VERSION'] . ") " . $this -> getParserErrorAt( $parser ) );
                }
            }else{
                $this -> setVar( 'detail_version', '1.00' );
            }
            break;
        case "ITEM/DETAIL/FILE":
            $result = $xoopsDB -> query( "select value from " . $xoopsDB -> prefix( "xoonips_config" ) . " where name='upload_dir'" );
            if( $result ){
                list( $upload_dir ) = $xoopsDB -> fetchRow( $result );
                $this -> file = new XooNIpsAttachment( $this -> attachment_dir, $upload_dir );
            }else{
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
            }
            break;
        }

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> startElement( $parser, $name, $attribs );
        }
    }

    function endElement($parser, $name) { 
        global $xoopsDB;

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> endElement( $parser, $name );
        }

        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            $keys = array(
                'author'   ,
                'editor'   ,
                'publisher',
                'isbn'     ,
                'url'      ,
            );
            foreach ( $keys as $key )
                if ( is_null($this->getVar('detail_'.$key,'n')) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no $key tag " . $this -> getParserErrorAt( $parser ) );

            if( $this -> getVar( 'detail_version' ) == '1.01'
                && is_null( $this -> getVar( 'detail_attachment_dl_limit' ) ) ){
                $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no attachment_dl_limit tag " . $this -> getParserErrorAt( $parser ) );
            }else if( $this -> getVar( 'detail_version' ) == '1.00'
                      && is_null( $this -> getVar( 'detail_attachment_dl_limit' ) ) ){
                // 
                // set zero to attachment_dl_limit if it is not declared in xml
                // 
                $this -> setVar( 'detail_attachment_dl_limit', 0 );
            }
            break;
        case "ITEM/DETAIL/AUTHOR":
        case "ITEM/DETAIL/EDITOR":
        case "ITEM/DETAIL/PUBLISHER":
        case "ITEM/DETAIL/ISBN":
        case "ITEM/DETAIL/URL":
            $this -> setVar( 'detail_'.strtolower( end( $this -> tagstack ) ) , encodeMeta2Server( end( $this -> cdata ) ), true );
            break;
        case "ITEM/DETAIL/ATTACHMENT_DL_LIMIT":
            if( !is_null( $this -> getVar( 'detail_attachment_dl_limit' ) ) ){
                $this -> setErrors( E_XOONIPS_TAG_REDUNDANT, "attachment_dl_limit is redundant" . $this -> getParserErrorAt( $parser ) );
            }else if( ctype_digit( end( $this -> cdata ) ) ){
                $this -> setVar( 'detail_attachment_dl_limit', intval( end( $this -> cdata ) ) );
            }else{
                $this -> setErrors( E_XOONIPS_INVALID_VALUE, "invalid value(" . end( $this -> cdata ) . ") of attachment_dl_limit" . $this -> getParserErrorAt( $parser ) );
            }
            break;
        case "ITEM/DETAIL/FILE":
            if( isset( $this -> file ) ){
                $file_type_id = $this->file->getVar('file_type_id');
                if ( $file_type_id ){
                    $sql = "select name from " . $xoopsDB->prefix('xoonips_file_type') . " where file_type_id=$file_type_id";
                    $result = $xoopsDB->query( $sql );
                    if ( $result ){
                        if ( $xoopsDB->getRowsNum($result) ){
                            list( $name ) = $xoopsDB->fetchRow( $result );
                            if ( isset( $this->attachment_info[$name]) ){
                                $info = $this->attachment_info[$name];
                                $attachments = $this->getVar($name);
                                if ( count( $attachments ) && !$info['multiple'] )
                                    $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getParserErrorAt( $parser ) );
                                $attachments[] = $this->file;
                                $this -> setVar( $name, serialize( $attachments ), true );
                                break;
                            }
                            else 
                                $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_name($name) " . $this -> getParserErrorAt( $parser ) );
                        }
                        else
                            $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_id($file_type_id) " . $this -> getParserErrorAt( $parser ) );
                    }
                    else
                        $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
                }
                else
                    $this -> setErrors( E_XOONIPS_ATTR_NOT_FOUND, " no file_type_id " . $this -> getParserErrorAt( $parser ) );
                
                // include $this->file->_error, error_codes
                $errors = $this->file->getErrors();
                $codes = $this->file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
            }
            break;
        }

        parent::endElement($parser, $name);
    }
    
    function characterData($parser, $data) {
        
        parent::characterData($parser, $data);

//        echo "\nC ".implode( '/', $this -> tagstack )."\t${data}";
        switch( implode( '/', $this -> tagstack ) ){
/*
        case "ITEM/DETAIL/TAGNAME":
            ....... 
            break;
*/
        }
        
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> characterData( $parser, $data );
        }
    }
    
    /**
     * insert/update object
     *   
     * @return false if failed, true if insert successfully or already exists and unchanged.
     *   
     */
    function insert()
    {
        global $xoopsDB;
        
        if ($this->isNew()) {
            if( !parent::insert() ) return false;

            $keys = implode( ",", array(
                'book_id'           ,
                'author'            ,
                'editor'            ,
                'publisher'         ,
                'isbn'              ,
                'url'               ,
                'attachment_dl_limit' ,
            ) );
            $vals = implode( ",", array(
                $this -> getVar( 'item_id' ),
                is_null( $this -> cleanVars['detail_author'          ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars['detail_author'          ] ),
                is_null( $this -> cleanVars['detail_editor'          ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars['detail_editor'          ] ),
                is_null( $this -> cleanVars['detail_publisher'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars['detail_publisher'       ] ),
                is_null( $this -> cleanVars['detail_isbn'            ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars['detail_isbn'            ] ),
                is_null( $this -> cleanVars['detail_url'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars['detail_url'             ] ),
                is_null( $this -> cleanVars['detail_attachment_dl_limit'] ) ? 'null' : $this -> cleanVars['detail_attachment_dl_limit'] ,
                ) );
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnpbook_item_detail") . " ( $keys ) VALUES ( $vals ) ";
        } else {
            if( !parent::insert() ) return false;

            $item_id = $this->getVar('item_id');
            $keyval = implode( ', ', array(
                'author'             . '=' . ( is_null( $this -> cleanVars['detail_author'          ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars['detail_author'          ] ) ),
                'editor'             . '=' . ( is_null( $this -> cleanVars['detail_editor'          ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars['detail_editor'          ] ) ),
                'publisher'          . '=' . ( is_null( $this -> cleanVars['detail_publisher'       ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars['detail_publisher'       ] ) ),
                'isbn'               . '=' . ( is_null( $this -> cleanVars['detail_isbn'            ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars['detail_isbn'            ] ) ),
                'url'                . '=' . ( is_null( $this -> cleanVars['detail_url'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars['detail_url'             ] ) ),
                'attachment_dl_limit'. '=' . ( is_null( $this -> cleanVars['detail_attachment_dl_limit'] ) ? 'null' : $this -> cleanVars['detail_attachment_dl_limit'] ) ,
            ));
            $sql = "UPDATE " . $xoopsDB->prefix("xnpbook_item_detail") . " set $keyval where book_id=$item_id";
        }
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // remove old attachment information 
        $item_id = $this->getVar('item_id');
        $sql = "select file_id from " . $xoopsDB->prefix('xoonips_file') . " where item_id=$item_id";
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        while ( list($file_id) = $xoopsDB->fetchRow($result) ){
            $file = new XooNIpsAttachment(null,null);
            $file->setVar('item_id', $item_id);
            $file->setVar('file_id',$file_id);
            if ( !$file->delete() ){
                // include $file->_error, error_codes
                $errors = $file->getErrors();
                $codes = $file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
                return false;
            }
        }
        
        // register attachment files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i] -> setVar( 'item_id', $this -> getVar( 'item_id' ) );
                if ( !$attachments[$i] -> insert() ){
                    @$this -> delete();
                    // 
                    // before return false, set attachments array to keep error message of attachment object
                    // 
                    $this->setVar( $name, serialize($attachments) );
                    return false;
                }
            }
            $this->setVar( $name, serialize($attachments) );
        }
        
        if( $this -> isNew() ){
            $this -> unsetNew();//item is not new because it was inserted
        }
        
        return true;
    }
    
    /**
     * delete an item from the database
     * 
     * @return false if failed, true if delete successfully
     *   
     */
    function delete(){
        global $xoopsDB;
        
        if( !parent::delete() ) return false;
        
        $sql = sprintf( "DELETE FROM %s WHERE book_id = %u", $xoopsDB->prefix( "xnpbook_item_detail" ), $this -> getVar( 'book_id' ) );
        $result = $xoopsDB->query( $sql );
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // delete files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i]->delete();
            }
        }
        
        return true;
    }
    
    function getErrors(){
        $ar = parent::getErrors();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrors() );
            }
        }
        return $ar;
    }
    
    function getErrorCodes(){
        $ar = parent::getErrorCodes();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrorCodes() );
            }
        }
        return $ar;
    }
    
    function toString( $htmlspecialchars = false ){
        $ar = array( parent::toString( $htmlspecialchars ) );
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar[] = $attachments[$i] -> toString($htmlspecialchars);
            }
        }
        
        $keys = array( 
            'author'   ,
            'editor'   ,
            'publisher',
            'isbn'     ,
            'url'      ,
            'attachment_dl_limit',
        );
        foreach ( $keys as $key ){ // don't use $this->columnLengths because it has obsoleted column 'classification'
            $val = $this->getVar('detail_'.$key,'n');
            if( extension_loaded( 'mbstring' ) ){
                $val = mb_ereg_replace( '\n', '\n', mb_ereg_replace( '\\\\', '\\\\', $val ) );
            }else{
                $val = str_replace( array( "\\", "\n" ), array( "\\\\", "\\n" ), $val );
            }
            $ar[] = "detail.$key " . ( $htmlspecialchars ? htmlspecialchars($val) : $val );
        }
        
        return implode( "\n", $ar );
    }
    
}
?>
