<?php
//  $Revision: 1.45.2.3 $                                                           //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
global $xoopsConfig;
if( file_exists( XOOPS_ROOT_PATH.'/modules/xnpbook/language/'.$xoopsConfig['language'].'/main.php' ) ) {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpbook/language/'.$xoopsConfig['language'].'/main.php' );
} else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpbook/language/english/main.php' );
}
include_once XOOPS_ROOT_PATH . "/modules/xnpbook/class/xnpbook.php";

/**
 * 
 * generate URL for lookking up for item specified  by given ISBN.
 * @param aa_id amazon associate id(not used)
 * @param isbn ISBN code
 * 
 */
function
get_isbn_url( $aa_id, $isbn )
{
	$char = substr( $isbn, 0, 1 );
	if ( $char == "0" || $char == "1" ) // 
		return "http://webservices.amazon.com/onca/xml?Service=AWSECommerceService&AWSAccessKeyId=0H8BRF5MB0Z590ZPWA82&Operation=ItemLookup&IdType=ASIN&MerchantId=All&ResponseGroup=Medium&Version=2006-11-14&ItemId=" . $isbn;
	else if ( $char == "2" ) // 2:france
		return "http://webservices.amazon.fr/onca/xml?Service=AWSECommerceService&AWSAccessKeyId=0H8BRF5MB0Z590ZPWA82&Operation=ItemLookup&IdType=ASIN&MerchantId=All&ResponseGroup=Medium&Version=2006-11-14&ItemId=" . $isbn;
	else if ( $char == "3" ) // 3:german
		return "http://webservices.amazon.co.jp/onca/xml?Service=AWSECommerceService&AWSAccessKeyId=0H8BRF5MB0Z590ZPWA82&Operation=ItemLookup&IdType=ASIN&MerchantId=All&ResponseGroup=Medium&Version=2006-11-14&ItemId=" . $isbn;
	else if ( $char == "4" ) // 4:japan
		return "http://webservices.amazon.co.jp/onca/xml?Service=AWSECommerceService&AWSAccessKeyId=0H8BRF5MB0Z590ZPWA82&Operation=ItemLookup&IdType=ASIN&MerchantId=All&ResponseGroup=Medium&Version=2006-11-14&ItemId=" . $isbn;
	else
		return "http://webservices.amazon.com/onca/xml?Service=AWSECommerceService&AWSAccessKeyId=0H8BRF5MB0Z590ZPWA82&Operation=ItemLookup&IdType=ASIN&MerchantId=All&ResponseGroup=Medium&Version=2006-11-14&ItemId=" . $isbn;
}

/**
 * @return array of specifiable Classification. array( internal_name => display_name ... ) <br/>
 * display names are explode( "\t", _MD_XNPBOOK_CLASSIFICATION_SELECT ) <br/>
 * element order: regular, review, historical<br/>
 * <br/>
 * return false if count(display names) != count(internal names)<br/>
 * <br/>
 * 
 */
function
xnpbook_get_classification_array( )
{
	$key = array( 'regular', 'review', 'historical' );
	$value = explode( "\t", _MD_XNPBOOK_CLASSIFICATION_SELECT );
	$ret = array( );
	if( count( $key ) != count( $value ) )
		return FALSE;
	for( $i = 0; $i < count( $key ); $i++ ) {
		$ret[$key[$i]] = $value[$i];
	}
	return $ret;
}

/** get Detail Information by item_id.
  * @return detail information of xnpbook item
  */
function
xnpbookGetDetailInformation( $item_id )
{
	global $xoopsDB;
	
	
	$xnpsid = $_SESSION['XNPSID'];
	$item = array( );

	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpbook_item_detail" )." where book_id=$item_id" );
	$item = $xoopsDB->fetchArray( $result );
	
	/*	
	$classification_array = xnpbook_get_classification_array( );
	return array( 'classification' => array( 'value' => $item['classification'],
					 'display_value' => $classification_array[$item['classification']],
					 'select' => $classification_array ),
				  'author' => array( 'value' => $item['author'] ),
				  'editor' => array( 'value' => $item['editor'] ),
				  'publisher' => array( 'value' => $item['publisher'] ),
				  'isbn' => array( 'value' => $item['isbn'] ), 'url' => array( 'value' => $item['url'] ),
				  'attachment_dl_limit' => array( 'value' => $item['attachment_dl_limit'] ) );
	*/
	return array( 'author' => array( 'value' => $item['author'] ),
		      'editor' => array( 'value' => $item['editor'] ),
		      'publisher' => array( 'value' => $item['publisher'] ),
		      'isbn' => array( 'value' => $item['isbn'] ), 'url' => array( 'value' => $item['url'] ),
		      'attachment_dl_limit' => array( 'value' => $item['attachment_dl_limit'] ) );
	return false;
}

function
xnpbookGetListBlock( $item_basic )
{
	$item_id = $item_basic['item_id'];

	// get DetailInformation
	$detail = xnpbookGetDetailInformation( $item_id );

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );

	// return as HTML
	return $tpl->fetch( "db:xnpbook_list_block.html" );
}

function
xnpbookGetPrinterFriendlyListBlock( $item_basic ){
	return xnpbookGetListBlock( $item_basic );
}


function
xnpbookGetDetailBlock( $item_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// get DetailInformation
	$detail = xnpbookGetDetailInformation( $item_id );

	//retrive variables from GET/POST array and overwrite $detail
	$myts =& MyTextsanitizer::getInstance( );
	//	foreach( array( 'item_id', 'classification', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
	foreach( array( 'item_id', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}
	//	$detail['classification']['display_value'] = $detail['classification']['select'][$detail['classification']['value']];

	// get BasicInformation / RegisteredItem  block
	$basic = xnpGetBasicInformationDetailBlock( $item_id );

	$index = xnpGetIndexDetailBlock( $item_id );
	$attachment = xnpGetAttachmentDetailBlock( $item_id, 'book_pdf' );

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail', $detail );

	// return as HTML
	return $tpl->fetch( "db:xnpbook_detail_block.html" );
}

// todo
function
xnpbookGetPrinterFriendlyDetailBlock( $item_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// get DetailInformation
	$detail = xnpbookGetDetailInformation( $item_id );

	//retrive variables from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	//	foreach( array( 'item_id', 'classification', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
	foreach( array( 'item_id', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}
	//	$detail['classification']['display_value'] = $detail['classification']['select'][$detail['classification']['value']];

	// get BasicInformation / RegisteredItem block
	$basic = xnpGetBasicInformationDetailBlock( $item_id );

	$index = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$attachment = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'book_pdf' );

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail', $detail );

	// return as HTML
	return $tpl->fetch( "db:xnpbook_detail_block.html" );
}

function
xnpbookGetRegisterBlock( )
{
	global $xoopsDB;
	$system_message = '';

	//retrive variables from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	//	foreach( array( 'item_id', 'classification', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
	foreach( array( 'item_id', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$$k = $_GET[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$$k = $_POST[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_POST[$k] );
			}
		} else {
			$$k = false;
		}
	}
	
	/*
	$classification_array = xnpbook_get_classification_array( );
	if ( $classification == false ){
		list( $classification ) = each( $classification_array );
	}
	$detail = array( 'classification' => array( 'value' => $classification,
								'display_value' => $classification_array[$classification],
								'select' => xnpbook_get_classification_array( ) ),
					 'author' => array( 'value' => $author ),
					 'editor' => array( 'value' => $editor ),
					 'publisher' => array( 'value' => $publisher ),
					 'isbn' => array( 'value' => $isbn ), 'url' => array( 'value' => $url ) );
	*/
	$detail = array( 'author' => array( 'value' => $author ),
				 'editor' => array( 'value' => $editor ),
				 'publisher' => array( 'value' => $publisher ),
				 'isbn' => array( 'value' => $isbn ), 'url' => array( 'value' => $url ) );
	$index = xnpGetIndexRegisterBlock( );
	$attachment = xnpGetAttachmentRegisterBlock( 'book_pdf' );

	if( isset( $_POST['isbnComplete'] ) && $_POST['isbnComplete'] == '1' ) {
		// complete by ISBN
		$aa_id = ""; // amazon associate id (it is not used in ECS4.0 but only for compatibility)

		$detail['isbn']['value'] = ereg_replace( "[^0-9X]", "", $detail['isbn']['value'] );	// prune off not a digit
		$isbn_url = get_isbn_url( $aa_id, $detail['isbn']['value'] );
		$book = array( );
		$result = xnp_amazon_complete( $isbn_url, $book );
		if( $result == RES_OK ) {
			foreach ($book as $key => $value) {
				$book[$key] = encodeClient2Server($value);
			}
			$detail['title']['value'] = $book['title'];
			$detail['author']['value'] = $book['author'];
			$detail['publisher']['value'] = $book['publisher'];
			$detail['isbn']['value'] = $book['isbn'];
			$detail['url']['value'] = $book['url'];
			// set title to BasicInformation
			// must be before xnpGetBasicInformationRegisterBlock
			if( get_magic_quotes_gpc( ) )	// because of myts->stripSlashesGPC
				$_POST['title'] = addslashes( $detail['title']['value'] );
			else
				$_POST['title'] = $detail['title']['value'];
			$_POST['publicationDateYear'] = $book['year_of_publication'];	//set publication year to basic
			$_POST['publicationDateMonth'] = 1;
			$_POST['publicationDateDay'] = 1;
		} else {
			$system_message .= "</br><font color='#ff0000'>"._MI_AMAZON_COMPLETE_FAILURE . " " . xnp_get_last_error_string() . "(result=$result)</font>";
		}
	}
	// get BasicInformation / Preview / Readme / License / Rights / index block
	$basic = xnpGetBasicInformationRegisterBlock( );

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionRegisterBlock( 'xnpbook' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'system_message', $tpl->get_template_vars( 'system_message' ).$system_message );

	// return as HTML
	return $tpl->fetch( "db:xnpbook_register_block.html" );
}

function
xnpbookGetEditBlock( $item_id )
{
	global $xoopsDB;
	$system_message = '';
	
	// get DetailInformation
	$detail = xnpbookGetDetailInformation( $item_id );

	//retrive variables from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	//	foreach( array( 'item_id', 'classification', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
	foreach( array( 'item_id', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}
	//	$detail['classification']['display_value'] = $detail['classification']['select'][$detail['classification']['value']];

	if( isset( $_POST['isbnComplete'] ) && $_POST['isbnComplete'] == '1' ) {
		// complete by ISBN
		$aa_id = ""; // amazon associate id (it is not used in ECS4.0 but only for compatibility)
		$detail['isbn']['value'] = ereg_replace( "[^0-9X]", "", $detail['isbn']['value'] );	// prune off not a digit
		$isbn_url = get_isbn_url( $aa_id, $detail['isbn']['value'] );
		$book = array( );
		$result = xnp_amazon_complete( $isbn_url, $book );
		if( $result == RES_OK ) {
			foreach ($book as $key => $value) {
				$book[$key] = encodeClient2Server($value);
			}
			$detail['title']['value'] = $book['title'];
			$detail['author']['value'] = $book['author'];
			$detail['publisher']['value'] = $book['publisher'];
			$detail['isbn']['value'] = $book['isbn'];
			$detail['url']['value'] = $book['url'];
			// set title to BasicInformation
			// must be before xnpGetBasicInformationRegisterBlock
			if( get_magic_quotes_gpc( ) )	// because of myts->stripSlashesGPC
				$_POST['title'] = addslashes( $detail['title']['value'] );
			else
				$_POST['title'] = $detail['title']['value'];
			$_POST['publicationDateYear'] = $book['year_of_publication'];	//set publication year to basic
			$_POST['publicationDateMonth'] = 1;
			$_POST['publicationDateDay'] = 1;
		} else {
			$system_message .= "</br><font color='#ff0000'>"._MI_AMAZON_COMPLETE_FAILURE . " " . xnp_get_last_error_string() . "(result=$result)</font>";
		}
	}
	// get BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationEditBlock( $item_id );

	$index = xnpGetIndexEditBlock( $item_id );
	$attachment = xnpGetAttachmentEditBlock( $item_id, 'book_pdf' );

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionEditBlock( 'xnpbook', xnpbookGetAttachmentDownloadLimitOption( $item_id ) ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'system_message', $tpl->get_template_vars( 'system_message' ).$system_message );

	// return as HTML
	return $tpl->fetch( "db:xnpbook_register_block.html" );
}


function
xnpbookGetConfirmBlock( $item_id )
{

	// retrieve detail information
	if ( empty($item_id) ){ // if ( confirm_register.php ) 
	  //		$detail = array('classification' => array('select' => xnpbook_get_classification_array()));
	}else{
		$detail = xnpbookGetDetailInformation( $item_id );
	}

	//retrive variables from GET/POST array, and overwrite to $detail
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'item_id', 'classification', 'author', 'editor', 'publisher', 'isbn', 'url' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}
	xnpConfirmHtml( $detail, 'xnpbook_item_detail', array_keys( $detail ), _CHARSET );
	
	//	$detail['classification']['display_value'] = $detail['classification']['select'][$detail['classification']['value']];

	// get BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationConfirmBlock( $item_id );

	$attachment = xnpGetAttachmentConfirmBlock( $item_id, 'book_pdf' );
	$index = xnpGetIndexConfirmBlock( $item_id );

	if ( xnpHasWithout( $basic ) || xnpHasWithout( $attachment ) || xnpHasWithout( $detail ) ){
		global $system_message;
		$system_message = $system_message."\n<br /><font color='#ff0000'>" . _MD_XOONIPS_ITEM_WARNING_FIELD_TRIM . "</font><br />";
	}
	
	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionConfirmBlock( 'xnpbook' ) );
	$tpl->assign( 'detail', $detail );

	// return as HTML
	return $tpl->fetch( "db:xnpbook_confirm_block.html" );
}

function
xnpbookInsertItem( )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// set fixed value for month and day
	$_POST['publicationDateMonth'] = 1;
	$_POST['publicationDateDay'] = 1;

	// register BasicInformation, Index, Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if( $result ) {
		$result = xnpUpdateIndex( $item_id );
		if( $result ) {
			$result = xnpUpdateAttachment( $item_id, 'book_pdf' );
			if( $result ) {
			}
		}
		if( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if( !$result )
		return false;

	$myts =& MyTextSanitizer::getInstance( );
	
	// ʸ
	$ar = array(
		'author'   =>$myts->stripSlashesGPC($_POST['author'   ]),
		'editor'   =>$myts->stripSlashesGPC($_POST['editor'   ]),
		'publisher'=>$myts->stripSlashesGPC($_POST['publisher']),
		'isbn'     =>$myts->stripSlashesGPC($_POST['isbn'     ]),
		'url'      =>$myts->stripSlashesGPC($_POST['url'      ]),
	);
	xnpTrimColumn( $ar, 'xnpbook_item_detail', array_keys( $ar ), _CHARSET );
	
	$keys = implode( ",", array( 'author', 'editor', 'publisher', 'isbn', 'url', 'attachment_dl_limit' ) );
	$vals = implode( "','", array( addslashes( $ar['author'   ] ),
								   addslashes( $ar['editor'   ] ),
								   addslashes( $ar['publisher'] ),
								   addslashes( $ar['isbn'     ] ),
								   addslashes( $ar['url'      ] ),
								   (int)$_POST['attachment_dl_limit'] ) );

	// register DetailInformation
	$myts =& MyTextSanitizer::getInstance( );
	$sql = "insert into ".$xoopsDB->prefix( "xnpbook_item_detail" )." ( book_id, $keys ) values ( $item_id, '$vals' ) ";
	$result = $xoopsDB->queryF( $sql );
	if( $result == false ) {
		echo "cannot insert item_detail";
		return false;
	}

	return true;
}

function
xnpbookUpdateItem( $book_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance( );

	// set fixed value for month and day
	$_POST['publicationDateMonth'] = 1;
	$_POST['publicationDateDay'] = 1;

	// edit BasicInformation, Index, Preview, Attachment 
	$result = xnpUpdateBasicInformation( $book_id );
	if( $result ) {
		$result = xnpUpdateIndex( $book_id );
		if( $result ) {
			$result = xnpUpdateAttachment( $book_id, 'book_pdf' );
			if( $result ) {
				$result = xnp_insert_change_log( $xnpsid, $book_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
				$result = !$result;
				if( !$result )
					echo " xnp_insert_change_log failed.";
			} else
				echo " xnpUpdateAttachment failed.";
		} else
			echo " xnpUpdateIndex failed.";
	} else
		echo " xnpUpdateBasicInformation failed.";
	if( !$result )
		return false;

	$myts =& MyTextSanitizer::getInstance( );
	// trim strings
	$ar = array(
		'author'    =>$myts->stripSlashesGPC($_POST['author'    ]),
		'editor'    =>$myts->stripSlashesGPC($_POST['editor'    ]),
		'publisher' =>$myts->stripSlashesGPC($_POST['publisher' ]),
		'isbn'      =>$myts->stripSlashesGPC($_POST['isbn'      ]),
		'url'       =>$myts->stripSlashesGPC($_POST['url'       ]),
	);
	xnpTrimColumn( $ar, 'xnpbook_item_detail', array_keys( $ar ), _CHARSET );
	
	// register DetailInformation
	$keyval = array(
		'author'             ."='".addslashes( $ar['author'             ] )."'",
		'editor'             ."='".addslashes( $ar['editor'             ] )."'",
		'publisher'          ."='".addslashes( $ar['publisher'          ] )."'",
		'isbn'               ."='".addslashes( $ar['isbn'               ] )."'",
		'url'                ."='".addslashes( $ar['url'                ] )."'",
		'attachment_dl_limit'."='".(int)$_POST['attachment_dl_limit']."'"
	);

	// edit DetailInformation
	$myts =& MyTextSanitizer::getInstance( );
	$sql = "update ".$xoopsDB->prefix( "xnpbook_item_detail" )
		." set ".implode( ", ", $keyval )
		." where book_id=$book_id";
	$result = $xoopsDB->queryF( $sql );
	if( $result == false ) {
		echo "cannot update item_detail";
		echo "\n$sql";
		return false;
	}

	return true;
}

function
xnpbookDeleteItem( $book_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// delete BasicInformation, Index, Preview, Attachment 
	if( !xnpDeleteBasicInformation( $book_id ) ) {
		echo "cannot delete book item";
		return false;
	}
	// delete DetailInformation
	$sql = "delete from ".$xoopsDB->prefix( "xnpbook_item_detail" )
		." where book_id=$book_id";
	$xoopsDB->queryF( $sql );
	return true;
}


function
xnpbookGetSearchBlock( $item_id ){}


function
xnpbookCheckRegisterParameters( &$msg )
{
	$xnpsid = $_SESSION['XNPSID'];
	$result = true;
	/*
	if( $_POST['editor'] == '' ) {
		//editor is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPBOOK_EDITOR_REQUIRED."</font>";
		$result = false;
	}
	*/
	if( $_POST['publisher'] == '' ) {
		//publisher is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPBOOK_PUBLISHER_REQUIRED."</font>";
		$result = false;
	}
	if( $_POST['publicationDateYear'] == '' ) {
		//year is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPBOOK_YEAR_REQUIRED."</font>";
		$result = false;
	}
	return $result;
}

function
xnpbookCheckEditParameters( &$msg )
{
	return xnpbookCheckRegisterParameters( $msg );
}

function
xnpbookGetMetaInformation( $item_id )
{
	$ret = array( );
	$basic = xnpGetBasicInformationArray( $item_id );
	$detail = xnpbookGetDetailInformation( $item_id );

	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = implode( "\n", $basic['titles'] );
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = implode( "\n", $basic['keywords'] );
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
	}
	if ( !empty( $detail ) ){
	  //		$ret[_MD_XNPBOOK_BOOK_CLASSIFICATION_LABEL] = $detail['classification']['display_value'];
		$ret[_MD_XNPBOOK_AUTHOR_LABEL] = $detail['author']['value'];
		$ret[_MD_XNPBOOK_EDITOR_LABEL] = $detail['editor']['value'];
		$ret[_MD_XNPBOOK_PUBLISHER_LABEL] = $detail['publisher']['value'];
		$ret[_MD_XNPBOOK_YEAR_LABEL] = $basic['publication_year'];
		$ret[_MD_XNPBOOK_URL_LABEL] = $detail['url']['value'];
		$ret[_MD_XNPBOOK_ISBN_LABEL] = $detail['isbn']['value'];
	}
	
	return $ret;
}


function
xnpbookGetAdvancedSearchBlock( &$search_var )
{

	$basic = xnpGetBasicInformationAdvancedSearchBlock( 'xnpbook', $search_var );

	//	$search_var[] = 'xnpbook_classification';
	$search_var[] = 'xnpbook_author';
	$search_var[] = 'xnpbook_editor';
	$search_var[] = 'xnpbook_publisher';
	$search_var[] = 'xnpbook_isbn';
	$search_var[] = 'xnpbook_book_pdf';

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpbook' );
	//	$classification_option = xnpbook_get_classification_array( );
	//	$tpl->assign( 'classification_option', $classification_option );
	$types = array( );
	if( xnp_get_item_types( $types ) == RES_OK ) {
		foreach( $types as $i ) {
			if( $i['name'] == 'xnpbook' ) {
				$tpl->assign( 'module_display_name', $i['display_name'] );
			}
		}
	} else {
		$tpl->assign( 'module_display_name', 'xnpbook' );
	}

	// return as HTML
	return $tpl->fetch( "db:xnpbook_search_block.html" );
}

function
xnpbookGetAdvancedSearchQuery( &$where, &$join )
{
	global $xoopsDB;

	$book_table = $xoopsDB->prefix( 'xnpbook_item_detail' );
	$file_table = $xoopsDB->prefix('xoonips_file');

	$wheres = array( );
	$w = xnpGetBasicInformationAdvancedSearchQuery( 'xnpbook' );
	//	if( $w ) $wheres[] = $w;
	//	$w = xnpGetKeywordQuery( $book_table.'.classification', 'xnpbook_classification' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $book_table.'.author', 'xnpbook_author' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $book_table.'.editor', 'xnpbook_editor' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $book_table.'.publisher', 'xnpbook_publisher' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $book_table.'.isbn', 'xnpbook_isbn' );
	if( $w ) $wheres[] = $w;
	if ( !empty($_POST['xnpbook_book_pdf']) ){
		$xnpsid = $_SESSION['XNPSID'];
		if ( $xnpsid == XNPSID_GUEST )
			$wheres[] = "attachment_dl_limit = 1";
		list( $pattern, $errorMessage ) = xnpKeywordsToFulltextSql($_POST['xnpbook_book_pdf']);
		if ( !$errorMessage )
			$wheres[] = "match ( $file_table.search_text ) against ( '$pattern' in boolean mode )";
	}
	
	$where = implode( ' and ', $wheres );
	$join = "";
}

function
xnpbookGetDetailInformationQuickSearchQuery( &$wheres, &$join, $keywords )
{
	global $xoopsDB;

	$book_table = $xoopsDB->prefix( 'xnpbook_item_detail' );

	$colnames = array( $book_table.'.author', $book_table.'.editor', $book_table.'.publisher' );
	$wheres = xnpGetKeywordsQueries( $colnames, $keywords );
	return true;
}

function
xnpbookGetDetailInformationTotalSize( $iids ){
	return xnpGetTotalFileSize( $iids );
}

/**
 * 
 * create XML for exporting detail information
 * see xnpExportItem for detail
 * @see xnpExportItem
 * 
 * @param export_path folder that export file is written to.
 * @param fhdl file handle that items are exported to.
 * @param item_id item id that is exported
 * @param attachment true if attachment files are exported, else false.
 * @return true: success
 * @return false:error
 */
function xnpbookExportItem( $export_path, $fhdl, $item_id, $attachment )
{
	global $xoopsDB;

    if( !$fhdl ) return false;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpbook_item_detail" )." where book_id=$item_id" );
	if( !$result ) return false;
    $detail = $xoopsDB->fetchArray( $result );
    if( !fwrite( $fhdl, "<detail id=\"${item_id}\" version=\"1.01\">\n"
                 ."<author>".xnpHtmlspecialchars( $detail['author'], ENT_QUOTES )."</author>\n"
                 ."<editor>".xnpHtmlspecialchars( $detail['editor'], ENT_QUOTES )."</editor>\n"
                 ."<publisher>".xnpHtmlspecialchars( $detail['publisher'], ENT_QUOTES )."</publisher>\n"
                 ."<isbn>".xnpHtmlspecialchars( $detail['isbn'], ENT_QUOTES )."</isbn>\n"
                 ."<url>".xnpHtmlspecialchars( $detail['url'], ENT_QUOTES )."</url>\n"
                 ."<attachment_dl_limit>".$detail['attachment_dl_limit']."</attachment_dl_limit>\n" ) ) return false;
    if( !( $attachment ? xnpExportFile( $export_path, $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;
    
    return true;
}
function xnpbookGetLicenseRequired( $item_id ){ return false; }
function xnpbookGetLicenseStatement( $item_id ){ return NULL; }


function xnpbookStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/AUTHOR":
    case "/ITEM/DETAIL/EDITOR": 
    case "/ITEM/DETAIL/PUBLISHER": 
    case "/ITEM/DETAIL/ISBN": 
    case "/ITEM/DETAIL/URL": 
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
//    echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnpbookEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    switch( $tags ){
    case '/ITEM/DETAIL':
//        print_r( $parser_hash['detail'] );
        $ar = array(
            'author'    => encodeClient2Server( $parser_hash['detail']['AUTHOR'   ] ),
            'editor'    => encodeClient2Server( $parser_hash['detail']['EDITOR'   ] ),
            'publisher' => encodeClient2Server( $parser_hash['detail']['PUBLISHER'] ),
            'isbn'      => encodeClient2Server( $parser_hash['detail']['ISBN'     ] ),
            'url'       => encodeClient2Server( $parser_hash['detail']['URL'      ] ),
        );
        xnpTrimColumn( $ar, 'xnpbook_item_detail', array_keys( $ar ), 'UTF-8');
        
        $keys = implode( ",", array( 'author', 'editor', 'publisher', 'year', 'isbn', 'url' ) );
        $vals = implode( "','", array( addslashes( $ar['author'   ] ),
                                       addslashes( $ar['editor'   ] ),
                                       addslashes( $ar['publisher'] ),
                                       addslashes( encodeClient2Server( $parser_hash['basic']['PUBLICATION_YEAR'] ) ),
                                       addslashes( $ar['isbn'     ] ),
                                       addslashes( $ar['url'      ] )
            ) );
        
        // register DetailInformation
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpbook_item_detail" )." ( book_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n";
            return false;
        }
        break;
    }
//    echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnpbookCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/AUTHOR":
    case "/ITEM/DETAIL/EDITOR": 
    case "/ITEM/DETAIL/PUBLISHER": 
    case "/ITEM/DETAIL/ISBN": 
    case "/ITEM/DETAIL/URL": 
        $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        break; 
    } 
//    echo($data); 
}

function xnpbookGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpbookStartElement", "xnpbookEndElement", "xnpbookCharacterData" ) );
}

function xnpbookCheckItemLengthEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $lengths = xnpGetColumnLengths( 'xnpbook_item_detail' );
        
        $values = array(
            'author'    => encodeClient2Server( $parser_hash['detail']['AUTHOR'   ] ),
            'editor'    => encodeClient2Server( $parser_hash['detail']['EDITOR'   ] ),
            'publisher' => encodeClient2Server( $parser_hash['detail']['PUBLISHER'] ),
            'isbn'      => encodeClient2Server( $parser_hash['detail']['ISBN'     ] ),
            'url'       => encodeClient2Server( $parser_hash['detail']['URL'      ] ),
        );
        $names = array(
            'author'    => _MD_XNPBOOK_AUTHOR_LABEL   ,
            'editor'    => _MD_XNPBOOK_EDITOR_LABEL   ,
            'publisher' => _MD_XNPBOOK_PUBLISHER_LABEL,
            'isbn'      => _MD_XNPBOOK_ISBN_LABEL     ,
            'url'       => _MD_XNPBOOK_URL_LABEL      ,
        );
        foreach ( $values as $key => $value ){
            if ( strlen($value) > $lengths[$key] ){
                list( $within, $without ) = xnpTrimString( $value, $lengths[$key], 'UTF-8' );
                $parser_hash['exceeds'][$key] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
            }
        }
        break;
    }
}

function xnpbookGetCheckItemLengthHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpbookStartElement", "xnpbookCheckItemLengthEndElement", "xnpbookCharacterData" ) );
}

function xnpbookGetModifiedFields( $item_id )
{
    $ret = array();
    $detail = xnpbookGetDetailInformation( $item_id );
    if( $detail ){
      /*
        foreach( array( 'classification' => _MD_XNPBOOK_BOOK_CLASSIFICATION_LABEL,
                        'author' => _MD_XNPBOOK_AUTHOR_LABEL,
                        'editor' => _MD_XNPBOOK_EDITOR_LABEL,
                        'publisher' => _MD_XNPBOOK_PUBLISHER_LABEL,
                        'isbn' => _MD_XNPBOOK_ISBN_LABEL,
                        'url' => _MD_XNPBOOK_URL_LABEL ) as $k => $v ){
      */
        foreach( array( 'author' => _MD_XNPBOOK_AUTHOR_LABEL,
                        'editor' => _MD_XNPBOOK_EDITOR_LABEL,
                        'publisher' => _MD_XNPBOOK_PUBLISHER_LABEL,
                        'isbn' => _MD_XNPBOOK_ISBN_LABEL,
                        'url' => _MD_XNPBOOK_URL_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ][ 'value' ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        
        // was pdf file modified?
        if( xnpIsAttachmentModified( 'book_pdf', $item_id ) ){
            array_push( $ret, _MD_XNPBOOK_PDF_LABEL );
        }
    }
    return $ret;
}

function xnpbookGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_book.gif', _MD_XNPBOOK_EXPLANATION, false, false );
}



//return 1 if downloadable for login user only
//return 0 if downloadable for everyone
function xnpbookGetAttachmentDownloadLimitOption( $item_id )
{
	global $xoopsDB;
    $sql = "select attachment_dl_limit from ".$xoopsDB->prefix( "xnpbook_item_detail" )." where book_id=${item_id}";
    $result = $xoopsDB->query( $sql );
    if( $result ){
        list( $option ) = $xoopsDB->fetchRow( $result );
        return $option;
    }
    return 0;
}

function xnpbookSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' || $metadataPrefix == 'junii2' ) return true;
    return false;
}

function xnpbookGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
        $detail = xnpbookGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;

            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(2)."</type>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['author']['value'])."</creator>";
            $lines[] = "<creator>editor:".xnpHtmlspecialchars($detail['editor']['value'])."</creator>";
            $lines[] = "<publisher>".xnpHtmlspecialchars($detail['publisher']['value'])."</publisher>";
            $lines[] = "<date xsi:type=\"ISO8601\">".xnpISO8601($basic['publication_year'], $basic['publication_month'], $basic['publication_mday'])."</date>";
            $lines[] = "<identifier xsi:type=\"ISBN\">".xnpHtmlspecialchars($detail['isbn']['value'])."</identifier>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if( $metadataPrefix == 'junii2' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii2.xsd">';
            $lines[] = $meta_basic;

            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii2(04)."</type>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['author']['value'])."</creator>";
            $lines[] = "<creator>editor:".xnpHtmlspecialchars($detail['editor']['value'])."</creator>";
            $lines[] = "<publisher>".xnpHtmlspecialchars($detail['publisher']['value'])."</publisher>";
            $lines[] = "<date xsi:type=\"ISO8601\">".xnpISO8601($basic['publication_year'], $basic['publication_month'], $basic['publication_mday'])."</date>";
            $lines[] = "<identifier xsi:type=\"ISBN\">".xnpHtmlspecialchars($detail['isbn']['value'])."</identifier>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
			$lines[] = "<dc:creator>".xnpHtmlspecialchars($detail['author']['value'])."</dc:creator>";
			$lines[] = "<dc:creator>editor:".xnpHtmlspecialchars($detail['editor']['value'])."</dc:creator>";
			$lines[] = "<dc:publisher>".xnpHtmlspecialchars($detail['publisher']['value'])."</dc:publisher>";
			$lines[] = "<dc:date>".xnpISO8601($basic['publication_year'], $basic['publication_month'], $basic['publication_mday'])."</dc:date>";
			$lines[] = "<dc:identifier>ISBN:".xnpHtmlspecialchars($detail['isbn']['value'])."</dc:identifier>";

			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}

function xnpbookCreateXooNIpsItem(){
    return new XooNIpsBook();
}
?>
