<?php
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/item.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/attachment.php";
include_once XOOPS_ROOT_PATH.'/modules/xnpconference/include/view.php';

class XooNIpsConference extends XooNIpsItem{

    /**
     * array of supported version of import file
     */
    var $import_file_version = array( "1.00", "1.01" );

    function XooNIpsConference(){
        parent::XooNIpsItem();
        
        $this->columnLengths = $lengths = $this->getColumnMaxLen( 'xnpconference_item_detail' );
        $this->initVar('version'              , XOBJ_DTYPE_TXTBOX, null, false, 10);
        $this->initVar('presentation_type'    , XOBJ_DTYPE_TXTBOX, null, false, $lengths['presentation_type']);
        $this->initVar('author'               , XOBJ_DTYPE_TXTBOX, null, false, $lengths['author'           ]);//for ver.1.00
        $this->initVar('authors'              , XOBJ_DTYPE_ARRAY, serialize(null), true);//for ver.1.01
        $this->initVar('conference_title'     , XOBJ_DTYPE_TXTBOX, null, false, $lengths['conference_title' ]);
        $this->initVar('place'                , XOBJ_DTYPE_TXTBOX, null, false, $lengths['place'            ]);
        $this->initVar('abstract'             , XOBJ_DTYPE_TXTBOX, null, false, $lengths['abstract'         ]);
        $this->initVar('conference_from_year' , XOBJ_DTYPE_INT, null, false);
        $this->initVar('conference_from_month', XOBJ_DTYPE_INT, null, false);
        $this->initVar('conference_from_mday' , XOBJ_DTYPE_INT, null, false);
        $this->initVar('conference_to_year'   , XOBJ_DTYPE_INT, null, false);
        $this->initVar('conference_to_month'  , XOBJ_DTYPE_INT, null, false);
        $this->initVar('conference_to_mday'   , XOBJ_DTYPE_INT, null, false);
        $this->initVar('conference_paper'     , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->initVar('conference_file'      , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->initVar('attachment_dl_limit'  , XOBJ_DTYPE_INT, null, false);
        $this->attachment_info = array(
            'conference_paper'  => array( 'multiple' => false ),
            'conference_file' => array( 'multiple' => false ),
        );
        
        $this->presentation_types = xnpconferenceGetTypes();
    }

    function cleanVars()
    {
        if ( !parent::cleanVars() )
            return false;
        
        // validate attachment_dl_limit
        if( $this->getVar('attachment_dl_limit' ) != 0
            && $this->getVar('attachment_dl_limit' ) != 1 ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "invalid value (".$this->getVar('attachment_dl_limit' ).") of attachment_dl_limit " . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            $this->cleanVars['attachment_dl_limit'] = intval( $this->getVar('attachment_dl_limit' ) );
            $retval = false;
        }
        
        if( $this -> getVar( 'version' ) == '1.00' ){
            $vals = array(
                'presentation_type'=> $this->getVar('presentation_type','n'),
                'author'           => $this->getVar('author'           ,'n'),
                'conference_title' => $this->getVar('conference_title' ,'n'),
                'place'            => $this->getVar('place'            ,'n'),
                'abstract'         => $this->getVar('abstract'         ,'n'),
                'attachment_dl_limit' => $this->getVar('attachment_dl_limit' ,'n'),
                );
        }else if( $this -> getVar( 'version' ) == '1.01' ){
            $vals = array(
                'presentation_type'=> $this->getVar('presentation_type','n'),
                'author'           => implode( "\n", $this->getVar('authors'  ,'n') ),
                'conference_title' => $this->getVar('conference_title' ,'n'),
                'place'            => $this->getVar('place'            ,'n'),
                'abstract'         => $this->getVar('abstract'         ,'n'),
                'attachment_dl_limit' => $this->getVar('attachment_dl_limit' ,'n'),
                );
        }

        $ar = $this -> stripSurplusString( $this->columnLengths, $vals );
        foreach ( $vals as $key => $val ){
            if ( isset( $ar[$key] ) ){
                $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $key is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $this->cleanVars[$key] = $ar[$key];
                $retval = false;
            }
            else
                $this->cleanVars[$key] = $val;
        }
        if( $this -> getVar( 'version' ) == '1.01' ){
            $this->cleanVars['authors'] = explode( "\n", $this->cleanVars['author']);
        }
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            if ( !$info['multiple'] && count($attachments) > 1 ){
                $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $retval = false;
            }
            for ( $i = 0; $i < count($attachments); $i++ )
                if ( !$attachments[$i]->cleanVars() )
                    $retval = false;
            $this->setVar($name, serialize($attachments));
        }
        
        $y = $this->getVar('conference_from_year' );
        $m = $this->getVar('conference_from_month');
        $d = $this->getVar('conference_from_mday' );
        if ( !checkdate( $m, $d, $y ) ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "bad conference_from($y/$m/$d)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        $this->cleanVars['conference_from_year' ] = $y;
        $this->cleanVars['conference_from_month'] = $m;
        $this->cleanVars['conference_from_mday' ] = $d;
        
        $y = $this->getVar('conference_to_year' );
        $m = $this->getVar('conference_to_month');
        $d = $this->getVar('conference_to_mday' );
        if ( !checkdate( $m, $d, $y ) ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "bad conference_to($y/$m/$d)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        $this->cleanVars['conference_to_year' ] = $y;
        $this->cleanVars['conference_to_month'] = $m;
        $this->cleanVars['conference_to_mday' ] = $d;
        
        $type = $this->getVar('presentation_type');
        if ( !isset( $this->presentation_types[ $type ] ) ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "unknown presentation_type($type)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        return true;
    }

    /**
     * 
     * for attachment file
     * 
     */
    var $file = null;
    var $attachment_info;
    
    // for column length check
    var $columnLengths;
    
    function startElement($parser, $name, $attribs){
        global $xoopsDB;
        
        parent::startElement($parser, $name, $attribs);

//            echo "\nS ".implode( '/', $this -> tagstack )."\tattributes=";print_r($attribs);
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            foreach ( $this->attachment_info as $name => $info )
                $this->setVar( $name, serialize(array()), true );
            // 
            // validate version and set it to 'version' variable
            // 
            if( !empty( $attribs['VERSION'] ) ){
                if( in_array( $attribs['VERSION'], $this -> import_file_version ) ){
                    $this -> setVar( 'version', $attribs['VERSION'] );
                }else{
                    $this -> setErrors( E_XOONIPS_INVALID_VALUE, "unsupported version(" . $attribs['VERSION'] . ") " . $this -> getParserErrorAt( $parser ) );
                }
            }else{
                $this -> setVar( 'version', '1.00' );
            }
            break;
        case "ITEM/DETAIL/AUTHORS":
            if( $this -> getVar( 'version' ) != '1.01' ) break; //nop if version is not 1.01
            $this->setVar( 'authors', serialize(array()), true );
            break;
        case "ITEM/DETAIL/FILE":
            $result = $xoopsDB -> query( "select value from " . $xoopsDB -> prefix( "xoonips_config" ) . " where name='upload_dir'" );
            if( $result ){
                list( $upload_dir ) = $xoopsDB -> fetchRow( $result );
                $this -> file = new XooNIpsAttachment( $this -> attachment_dir, $upload_dir );
            }else{
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
            }
            break;
        }

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> startElement( $parser, $name, $attribs );
        }
    }

    function endElement($parser, $name) { 
        global $xoopsDB;
        

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> endElement( $parser, $name );
        }

        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            $keys = array();
            if( $this -> getVar( 'version' ) == '1.00' ){
                $keys = array(
                    'presentation_type'    ,
                    'author'              ,
                    'conference_title'     ,
                    'place'                ,
                    'abstract'             ,
                    'conference_from_year' ,
                    'conference_from_month',
                    'conference_from_mday' ,
                    'conference_to_year'   ,
                    'conference_to_month'  ,
                    'conference_to_mday'   ,
                    );
            }else if( $this -> getVar( 'version' ) == '1.01' ){
                $keys = array(
                    'presentation_type'    ,
                    'authors'              ,
                    'conference_title'     ,
                    'place'                ,
                    'abstract'             ,
                    'conference_from_year' ,
                    'conference_from_month',
                    'conference_from_mday' ,
                    'conference_to_year'   ,
                    'conference_to_month'  ,
                    'conference_to_mday'   ,
                    'attachment_dl_limit'
                    );
            }
            foreach ( $keys as $key )
                if ( is_null($this->getVar($key,'n')) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no $key tag " . $this -> getParserErrorAt( $parser ) );

            if( $this -> getVar( 'version' ) == '1.00'
                      && is_null( $this -> getVar( 'attachment_dl_limit' ) ) ){
                // 
                // set zero to attachment_dl_limit if it is not declared in xml
                // 
                $this -> setVar( 'attachment_dl_limit', 0 );
            }
            break;
        case "ITEM/DETAIL/AUTHORS/AUTHOR":
            if( $this -> getVar( 'version' ) != '1.01' ) break; //nop if version is not 1.01
//            echo "\nE ".implode( '/', $this -> tagstack );
            $authors = $this -> getVar( 'authors' );
            $authors[] = encodeMeta2Server( end( $this -> cdata ) );
            $this -> setVar( 'authors', serialize( $authors ), true );
            break;
        case "ITEM/DETAIL/AUTHOR": 
            // /item/detail/author is only available in ver 1.00
            if( $this -> getVar( 'version' ) != '1.00' ) break; 
        case "ITEM/DETAIL/PRESENTATION_TYPE":
        case "ITEM/DETAIL/CONFERENCE_TITLE": 
        case "ITEM/DETAIL/PLACE": 
        case "ITEM/DETAIL/ABSTRACT": 
        case "ITEM/DETAIL/CONFERENCE_FROM_YEAR": 
        case "ITEM/DETAIL/CONFERENCE_FROM_MONTH": 
        case "ITEM/DETAIL/CONFERENCE_FROM_MDAY": 
        case "ITEM/DETAIL/CONFERENCE_TO_YEAR": 
        case "ITEM/DETAIL/CONFERENCE_TO_MONTH": 
        case "ITEM/DETAIL/CONFERENCE_TO_MDAY": 
            $this -> setVar( strtolower( end( $this -> tagstack ) ) , encodeMeta2Server( end( $this -> cdata ) ), true );
            break;
        case "ITEM/DETAIL/ATTACHMENT_DL_LIMIT":
            if( !is_null( $this -> getVar( 'attachment_dl_limit' ) ) ){
                $this -> setErrors( E_XOONIPS_TAG_REDUNDANT, "attachment_dl_limit is redundant" . $this -> getParserErrorAt( $parser ) );
            }else if( ctype_digit( end( $this -> cdata ) ) ){
                $this -> setVar( 'attachment_dl_limit', intval( end( $this -> cdata ) ) );
            }else{
                $this -> setErrors( E_XOONIPS_INVALID_VALUE, "invalid value(" . end( $this -> cdata ) . ") of attachment_dl_limit" . $this -> getParserErrorAt( $parser ) );
            }
            break;
        case "ITEM/DETAIL/FILE":
            if( isset( $this -> file ) ){
                $file_type_id = $this->file->getVar('file_type_id');
                if ( $file_type_id ){
                    $sql = "select name from " . $xoopsDB->prefix('xoonips_file_type') . " where file_type_id=$file_type_id";
                    $result = $xoopsDB->query( $sql );
                    if ( $result ){
                        if ( $xoopsDB->getRowsNum($result) ){
                            list( $name ) = $xoopsDB->fetchRow( $result );
                            if ( isset( $this->attachment_info[$name]) ){
                                $info = $this->attachment_info[$name];
                                $attachments = $this->getVar($name);
                                if ( count( $attachments ) && !$info['multiple'] )
                                    $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getParserErrorAt( $parser ) );
                                $attachments[] = $this->file;
                                $this -> setVar( $name, serialize( $attachments ), true );
                                break;
                            }
                            else 
                                $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_name($name) " . $this -> getParserErrorAt( $parser ) );
                        }
                        else
                            $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_id($file_type_id) " . $this -> getParserErrorAt( $parser ) );
                    }
                    else
                        $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
                }
                else
                    $this -> setErrors( E_XOONIPS_ATTR_NOT_FOUND, " no file_type_id " . $this -> getParserErrorAt( $parser ) );
                
                // include $this->file->_error, error_codes
                $errors = $this->file->getErrors();
                $codes = $this->file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
            }
            break;
        }

        parent::endElement($parser, $name);
    }
    
    function characterData($parser, $data) {
        
        parent::characterData($parser, $data);

        //
//        echo "\nC ".implode( '/', $this -> tagstack )."\t${data}";
        switch( implode( '/', $this -> tagstack ) ){
/*
        case "ITEM/DETAIL/TAGNAME":
            ....... 
            break;
*/
        }
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> characterData( $parser, $data );
        }
    }
    
    /**
     * insert/update object
     *   
     * @return false if failed, true if insert successfully or already exists and unchanged.
     *   
     */
    function insert()
    {
        global $xoopsDB;
        
        if ($this->isNew()) {
            if( !parent::insert() ) return false;

                $keys = implode( ",", array(
                    'conference_id'        ,
                    'presentation_type'    ,
                    'author'               ,
                    'conference_title'     ,
                    'place'                ,
                    'abstract'             ,
                    'conference_from_year' ,
                    'conference_from_month',
                    'conference_from_mday' ,
                    'conference_to_year'   ,
                    'conference_to_month'  ,
                    'conference_to_mday'   ,
                    'attachment_dl_limit'  ,
                    ) );
            if( $this -> getVar( 'version' ) == '1.00' ){
                $vals = implode( ",", array(
                    $this -> getVar( 'item_id' ),
                    is_null( $this -> cleanVars[ 'presentation_type'    ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'presentation_type'    ] ),
                    is_null( $this -> cleanVars[ 'author'               ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'author'               ] ),//for ver.1.00
                    is_null( $this -> cleanVars[ 'conference_title'     ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'conference_title'     ] ),
                    is_null( $this -> cleanVars[ 'place'                ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'place'                ] ),
                    is_null( $this -> cleanVars[ 'abstract'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'abstract'             ] ),
                    is_null( $this -> cleanVars[ 'conference_from_year' ] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_year' ]  ,
                    is_null( $this -> cleanVars[ 'conference_from_month'] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_month']  ,
                    is_null( $this -> cleanVars[ 'conference_from_mday' ] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_mday' ]  ,
                    is_null( $this -> cleanVars[ 'conference_to_year'   ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_year'   ]  ,
                    is_null( $this -> cleanVars[ 'conference_to_month'  ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_month'  ]  ,
                    is_null( $this -> cleanVars[ 'conference_to_mday'   ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_mday'   ]  ,
                    is_null( $this -> cleanVars[ 'attachment_dl_limit'  ] ) ? 'null' :                          $this -> cleanVars[ 'attachment_dl_limit'  ]  ,
                    ) );
            }else if( $this -> getVar( 'version' ) == '1.01' ){
                $vals = implode( ",", array(
                    $this -> getVar( 'item_id' ),
                    is_null( $this -> cleanVars[ 'presentation_type'    ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'presentation_type'    ] ),
                    is_null( $this -> cleanVars[ 'authors'               ] ) ? "''"   : $xoopsDB -> quoteString( implode( "\n", $this -> cleanVars[ 'authors'] ) ),//for ver.1.01
                    is_null( $this -> cleanVars[ 'conference_title'     ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'conference_title'     ] ),
                    is_null( $this -> cleanVars[ 'place'                ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'place'                ] ),
                    is_null( $this -> cleanVars[ 'abstract'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'abstract'             ] ),
                    is_null( $this -> cleanVars[ 'conference_from_year' ] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_year' ]  ,
                    is_null( $this -> cleanVars[ 'conference_from_month'] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_month']  ,
                    is_null( $this -> cleanVars[ 'conference_from_mday' ] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_mday' ]  ,
                    is_null( $this -> cleanVars[ 'conference_to_year'   ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_year'   ]  ,
                    is_null( $this -> cleanVars[ 'conference_to_month'  ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_month'  ]  ,
                    is_null( $this -> cleanVars[ 'conference_to_mday'   ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_mday'   ]  ,
                    is_null( $this -> cleanVars[ 'attachment_dl_limit'  ] ) ? 'null' :                          $this -> cleanVars[ 'attachment_dl_limit'  ]  ,
                    ) );
            }
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnpconference_item_detail") . " ( $keys ) VALUES ( $vals ) ";
        } else {
            if( !parent::insert() ) return false;
            $item_id = $this->getVar('item_id');
            if( $this -> getVar( 'version' ) == '1.00' ){
                $keyval = implode( ', ', array(
                    'presentation_type'     . '=' . ( is_null( $this -> cleanVars[ 'presentation_type'    ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'presentation_type'    ] ) ),
                    'author'                . '=' . ( is_null( $this -> cleanVars[ 'author'               ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'author'               ] ) ),
                    'conference_title'      . '=' . ( is_null( $this -> cleanVars[ 'conference_title'     ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'conference_title'     ] ) ),
                    'place'                 . '=' . ( is_null( $this -> cleanVars[ 'place'                ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'place'                ] ) ),
                    'abstract'              . '=' . ( is_null( $this -> cleanVars[ 'abstract'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'abstract'             ] ) ),
                    'conference_from_year'  . '=' . ( is_null( $this -> cleanVars[ 'conference_from_year' ] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_year' ]   ),
                    'conference_from_month' . '=' . ( is_null( $this -> cleanVars[ 'conference_from_month'] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_month']   ),
                    'conference_from_mday'  . '=' . ( is_null( $this -> cleanVars[ 'conference_from_mday' ] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_mday' ]   ),
                    'conference_to_year'    . '=' . ( is_null( $this -> cleanVars[ 'conference_to_year'   ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_year'   ]   ),
                    'conference_to_month'   . '=' . ( is_null( $this -> cleanVars[ 'conference_to_month'  ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_month'  ]   ),
                    'conference_to_mday'    . '=' . ( is_null( $this -> cleanVars[ 'conference_to_mday'   ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_mday'   ]   ),
                    'attachment_dl_limit'   . '=' . ( is_null( $this -> cleanVars[ 'attachment_dl_limit'  ] ) ? 'null' :                          $this -> cleanVars[ 'attachment_dl_limit'  ]   ),
                    ));
            }else if( $this -> getVar( 'version' ) == '1.01' ){
                $keyval = implode( ', ', array(
                    'presentation_type'     . '=' . ( is_null( $this -> cleanVars[ 'presentation_type'    ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'presentation_type'    ] ) ),
                    'author'                . '=' . ( is_null( $this -> cleanVars[ 'authors'               ] ) ? "''"   : $xoopsDB -> quoteString( implode( "\n", $this -> cleanVars[ 'authors'] ) ) ),
                    'conference_title'      . '=' . ( is_null( $this -> cleanVars[ 'conference_title'     ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'conference_title'     ] ) ),
                    'place'                 . '=' . ( is_null( $this -> cleanVars[ 'place'                ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'place'                ] ) ),
                    'abstract'              . '=' . ( is_null( $this -> cleanVars[ 'abstract'             ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'abstract'             ] ) ),
                    'conference_from_year'  . '=' . ( is_null( $this -> cleanVars[ 'conference_from_year' ] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_year' ]   ),
                    'conference_from_month' . '=' . ( is_null( $this -> cleanVars[ 'conference_from_month'] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_month']   ),
                    'conference_from_mday'  . '=' . ( is_null( $this -> cleanVars[ 'conference_from_mday' ] ) ? 'null' :                          $this -> cleanVars[ 'conference_from_mday' ]   ),
                    'conference_to_year'    . '=' . ( is_null( $this -> cleanVars[ 'conference_to_year'   ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_year'   ]   ),
                    'conference_to_month'   . '=' . ( is_null( $this -> cleanVars[ 'conference_to_month'  ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_month'  ]   ),
                    'conference_to_mday'    . '=' . ( is_null( $this -> cleanVars[ 'conference_to_mday'   ] ) ? 'null' :                          $this -> cleanVars[ 'conference_to_mday'   ]   ),
                    'attachment_dl_limit'   . '=' . ( is_null( $this -> cleanVars[ 'attachment_dl_limit'  ] ) ? 'null' :                          $this -> cleanVars[ 'attachment_dl_limit'  ]   ),
                    ));
            }
            $sql = "UPDATE " . $xoopsDB->prefix("xnpconference_item_detail") . " set $keyval where conference_id=$item_id";
        }
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // remove old attachment information 
        $item_id = $this->getVar('item_id');
        $sql = "select file_id from " . $xoopsDB->prefix('xoonips_file') . " where item_id=$item_id";
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        while ( list($file_id) = $xoopsDB->fetchRow($result) ){
            $file = new XooNIpsAttachment(null,null);
            $file->setVar('item_id', $item_id);
            $file->setVar('file_id',$file_id);
            if ( !$file->delete() ){
                // include $file->_error, error_codes
                $errors = $file->getErrors();
                $codes = $file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
                return false;
            }
        }
        
        // register attachment files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i] -> setVar( 'item_id', $this -> getVar( 'item_id' ) );
                if ( !$attachments[$i] -> insert() ){
                    @$this -> delete();
                    // 
                    // before return false, set attachments array to keep error message of attachment object
                    // 
                    $this->setVar( $name, serialize($attachments) );
                    return false;
                }
            }
            $this->setVar( $name, serialize($attachments) );
        }
        
        if( $this -> isNew() ){
            $this -> unsetNew();//item is not new because it was inserted
        }
        return true;
    }
    
    /**
     * delete an item from the database
     * 
     * @return false if failed, true if delete successfully
     *   
     */
    function delete(){
        global $xoopsDB;
        
        if( !parent::delete() ) return false;
        
        
        $sql = sprintf( "DELETE FROM %s WHERE conference_id = %u", $xoopsDB->prefix( "xnpconference_item_detail" ), $this -> getVar( 'conference_id' ) );
        $result = $xoopsDB->query( $sql );
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // delete files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i]->delete();
            }
        }
        
        return true;
    }
    
    function getErrors(){
        $ar = parent::getErrors();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrors() );
            }
        }
        return $ar;
    }
    
    function getErrorCodes(){
        $ar = parent::getErrorCodes();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrorCodes() );
            }
        }
        return $ar;
    }
    
    function toString( $htmlspecialchars = false ){
        $ar = array( parent::toString( $htmlspecialchars ) );
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar[] = $attachments[$i] -> toString($htmlspecialchars);
            }
        }
        
        foreach ( $this->columnLengths as $key => $dummy ){
            if ( $key == 'conference_id' ) continue;
            if( $this -> getVar( 'version' ) == '1.01' && $key == 'author' ){
                $authors = $this -> getVar( 'authors','n' );
                if ( is_null( $authors ) )
                    $authors = array();
                $val = implode( "\n", $authors );
            }
            else
                $val = $this->getVar($key,'n');
            if( extension_loaded( 'mbstring' ) ){
                $val = mb_ereg_replace( '\n', '\n', mb_ereg_replace( '\\\\', '\\\\', $val ) );
            }else{
                $val = str_replace( array( "\\", "\n" ), array( "\\\\", "\\n" ), $val );
            }
            $ar[] = "detail.$key " . ( $htmlspecialchars ? htmlspecialchars($val) : $val );
        }
        
        return implode( "\n", $ar );
    }
    
}
?>
