<?php
//  Install script for dummy module                                             //
//  $Revision: 1.7 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

function xoops_module_install_xnpdummy( $xoopsMod ) {
	global $xoopsDB;
	
	// register itemtype
	$table = $xoopsDB->prefix('xnpaccount_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "INSERT INTO $table ( name, display_name, mid ) VALUES ( 'xnpdummy', 'Dummy', $mid )";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot register itemtype
		return false;
	}
	
	// register filetype
	$table = $xoopsDB->prefix('xnpaccount_file_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "INSERT INTO $table ( name, display_name, mid ) VALUES ( 'dummyfile', 'Dummy File', $mid )";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot register itemtype
		return false;
	}
	
	//$item_type_id = $xoopsDB->getInsertId();
	return true;
} 

function xoops_module_uninstall_xnpdummy( $xoopsMod ) {
	global $xoopsDB;
	
	// unregister itemtype
	$table = $xoopsDB->prefix('xnpaccount_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "DELETE FROM $table where mid = $mid";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot unregister itemtype
		return false;
	}
	return true;
}

function xoops_module_update_xnpdummy ( $xoopsMod, $oldversion) {

	switch ($oldversion) { //remember that version is multiplied with 100 to get an integer
	case 100: //perform actions to upgrade from version 1.00
		break;
	case 110: //perform actions to upgrade from version 1.10
		break;
	}
	return true;
}
?>
