<?php
//  $Revision: 1.52.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if( file_exists( XOOPS_ROOT_PATH.'/modules/xnpmodel/language/'.$xoopsConfig['language'].'/main.php' ) ) {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpmodel/language/'.$xoopsConfig['language'].'/main.php' );
} else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpmodel/language/english/main.php' );
}
include_once XOOPS_ROOT_PATH . "/modules/xnpmodel/class/xnpmodel.php";


/**
 * 
 * @return array of specifiable Model Types. array( internal_name => display_name ... ) <br/>
 * display names are explode( "\t", _MD_XNPMODEL_MODEL_TYPE_SELECT ) <br/>
 * element order: matlab, neuron, original_program, satellite, genesis, a_cell, other<br/>
 * <br/>
 * return false if count(display names) != count(internal names)<br/>
 * <br/>
 * 
 */
function
xnpmodel_get_type_array( )
{
	$key = array( 'matlab', 'neuron', 'original_program', 'satellite', 'genesis', 'a_cell', 'other' );
	$value = explode( "\t", _MD_XNPMODEL_MODEL_TYPE_SELECT );
	$ret = array( );
	if( count( $key ) != count( $value ) )
		return FALSE;
	for( $i = 0; $i < count( $key ); $i++ ) {
		$ret[$key[$i]] = $value[$i];
	}
	return $ret;
}

/** get DetailInformation by item_id
  * 
  * @return
  *     array( 'model_type' => arary( 'value' => internal name of model type,
  *                                   'display_value' => display name of model type,
  *                                   'select' => array( internal_name => display_name ,...  ),
  *            'creator'    => arary( 'value' => creator name ) )
  * @return empty array with keys if bad $item_id
  * @return false: failure
  */
function
xnpmodelGetDetailInformation( $item_id )
{
	global $xoopsDB;

	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpmodel_item_detail" )." where model_id=$item_id" );
	$model = $xoopsDB->fetchArray( $result );
	if ( !is_array($model) )
		return false;
	
	foreach( $model as $k => $v ) {
		$$k = $v;
	}
	
	$model_types = xnpmodel_get_type_array( );
	$myts =& MyTextsanitizer::getInstance( );
	$detail = array( 'model_type' => array( 'value' => $model_type,
											'select' => xnpmodel_get_type_array( ),
											'display_value' => $model_types[$model_type] ),
					 'creator' => array( 'value' => $creator ),
                     'readme' => array( 'value' => $readme ),
                     'rights' => array( 'value' => $rights ),
                     'use_cc'  => array( 'value' => $use_cc ),
                     'cc_commercial_use' => array( 'value' => $cc_commercial_use ),
                     'cc_modification'  => array( 'value' => $cc_modification ),
                     'attachment_dl_limit' => array( 'value' => $attachment_dl_limit ) );
	return $detail;
}

function
xnpmodelGetListBlock( $item_basic )
{
	$item_id = $item_basic['item_id'];

	// get DetailInformation
	$item_detail = xnpmodelGetDetailInformation( $item_id );

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );

	// return as HTML
	return $tpl->fetch( "db:xnpmodel_list_block.html" );
}

function xnpmodelGetPrinterFriendlyListBlock( $item_basic ){
	return xnpmodelGetListBlock( $item_basic );
}


function
xnpmodelGetDetailBlock( $item_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	//retrive creator, model_type from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'model_type', 'creator', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			$$k = $myts->stripSlashesGPC( $_GET[$k] );
		} else if( array_key_exists( $k, $_POST ) ) {
			$$k = $myts->stripSlashesGPC( $_POST[$k] );
		}
	}

	// get BasicInformation / RegisteredItem block
	$basic = xnpGetBasicInformationDetailBlock( $item_id );

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpmodel_item_detail" )." where model_id=$item_id" );
	foreach( $model = $xoopsDB->fetchArray( $result ) as $k => $v ) {
		$$k = $v;
	}
	$detail = xnpmodelGetDetailInformation( $item_id );
	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index = xnpGetIndexDetailBlock( $item_id );
	$attachment = xnpGetAttachmentDetailBlock( $item_id, 'model_data' );
	$readme = xnpGetTextFileDetailBlock( $item_id, 'readme', $myts->htmlspecialchars( $readme ) );
	$rights = xnpGetRightsDetailBlock( $item_id, $detail['use_cc']['value'], $detail['rights']['value'], $detail['cc_commercial_use']['value'], $detail['cc_modification']['value'] );
	
	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );

	// return as HTML
	return $tpl->fetch( "db:xnpmodel_detail_block.html" );
}

// todo
function
xnpmodelGetPrinterFriendlyDetailBlock( $item_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	//retrive creator, model_type from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'model_type', 'creator', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			$$k = $myts->stripSlashesGPC( $_GET[$k] );
		} else if( array_key_exists( $k, $_POST ) ) {
			$$k = $myts->stripSlashesGPC( $_POST[$k] );
		}
	}

	// get BasicInformation / RegisteredItem block
	$basic = xnpGetBasicInformationDetailBlock( $item_id );

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpmodel_item_detail" )." where model_id=$item_id" );
	foreach( $model = $xoopsDB->fetchArray( $result ) as $k => $v ) {
		$$k = $v;
	}
	$detail = xnpmodelGetDetailInformation( $item_id );
	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$attachment = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'model_data' );
	$readme = array( 'value' => $myts->htmlspecialchars( $readme ) );
	$rights = xnpGetRightsPrinterFriendlyBlock( $item_id, $use_cc, $rights );

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );

	// return as HTML
	return $tpl->fetch( "db:xnpmodel_detail_block.html" );
}

function
xnpmodelGetRegisterBlock( )
{
	global $xoopsDB;

	//retrive creator, model_type from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'model_type', 'creator', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			$$k = $myts->stripSlashesGPC( $_GET[$k] );
		} else if( array_key_exists( $k, $_POST ) ) {
			$$k = $myts->stripSlashesGPC( $_POST[$k] );
		} else {
			$$k = false;
		}
	}
	// get BasicInformation / Preview / Readme / License / index block
	$basic = xnpGetBasicInformationRegisterBlock( );
	$model_types = xnpmodel_get_type_array( );
	if ( $model_type == false ){
		list( $model_type ) = each( $model_types );
	}
	$detail = array( 'model_type' => array( 'value' => $model_type,
											'display_value' => $model_types[$model_type],
											'select' => xnpmodel_get_type_array( ) ),
					 'creator' => array( 'value' => $creator ) );
	$preview = xnpGetPreviewRegisterBlock( );
	$index = xnpGetIndexRegisterBlock( );
	$attachment = xnpGetAttachmentRegisterBlock( 'model_data' );
	$readme = xnpGetTextFileRegisterBlock( 'readme' );
	$rights = xnpGetRightsRegisterBlock();
	
	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionRegisterBlock( 'xnpmodel' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'jumpto_url', 'register.php' );

	// return as HTML
	return $tpl->fetch( "db:xnpmodel_register_block.html" );
}

function
xnpmodelGetEditBlock( $item_id )
{
	global $xoopsDB;

	$myts =& MyTextsanitizer::getInstance( );

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpmodel_item_detail" )." where model_id=$item_id" );
	foreach( $model = $xoopsDB->fetchArray( $result ) as $k => $v ) {
		$$k = $v;
	}
	// overwrite DetailInformation with POST/GET variables
	foreach( array( 'model_type', 'creator', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			$$k = $myts->stripSlashesGPC( $_GET[$k] );
		} else if( array_key_exists( $k, $_POST ) ) {
			$$k = $myts->stripSlashesGPC( $_POST[$k] );
		}
	}

	// get BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationEditBlock( $item_id );

	$model_types = xnpmodel_get_type_array( );
	$detail = xnpmodelGetDetailInformation( $item_id );
	$detail['model_type']['value'] = $model_type;
	$detail['model_type']['display_value'] = $model_types[$model_type];
	$detail['model_type']['select'] = $model_types;
	$detail['creator']['value'] = $creator;
	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$attachment = xnpGetAttachmentEditBlock( $item_id, 'model_data' );

	$readme = xnpGetTextFileEditBlock( $item_id, 'readme', $myts->htmlspecialchars( $readme ) );
 	$rights = xnpGetRightsEditBlock( $item_id, $detail['use_cc']['value'], $detail['rights']['value'], $detail['cc_commercial_use']['value'], $detail['cc_modification']['value'] );

	//$attachment['name'] = _MD_XNPMODEL_MODEL_FILE_LABEL;

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionEditBlock( 'xnpmodel', xnpmodelGetAttachmentDownloadLimitOption( $item_id ) ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'jumpto_url', 'edit.php' );

	// return as HTML
	return $tpl->fetch( "db:xnpmodel_register_block.html" );
}


function
xnpmodelGetConfirmBlock( $item_id )
{

	//retrive creator, model_type from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'model_type', 'creator', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			$$k = $myts->stripSlashesGPC( $_GET[$k] );
		} else if( array_key_exists( $k, $_POST ) ) {
			$$k = $myts->stripSlashesGPC( $_POST[$k] );
		}
	}

	// get BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationConfirmBlock( $item_id );
	$detail = array( 'creator' => array( 'value' => $creator ) );
	// it makes strings with constant length
	xnpConfirmHtml( $detail, 'xnpmodel_item_detail', array_keys( $detail ), _CHARSET );
	$model_types = xnpmodel_get_type_array( );
	if ( isset($model_types[$model_type]) ) // reject if illegal model_type
		$detail['model_type'] = array( 'value' => $model_type,
								   'display_value' => $model_types[$model_type] );
	
	$preview = xnpGetPreviewConfirmBlock( $item_id );
	$attachment = xnpGetAttachmentConfirmBlock( $item_id, 'model_data' );
	$index = xnpGetIndexConfirmBlock( $item_id );
	$lengths = xnpGetColumnLengths('xnpmodel_item_detail');
	$readme = xnpGetTextFileConfirmBlock( $item_id, 'readme', $lengths['readme'] );
	$rights = xnpGetRightsConfirmBlock( $item_id, $lengths['rights'] );

	if ( xnpHasWithout( $basic ) || xnpHasWithout( $readme ) || xnpHasWithout( $rights ) || xnpHasWithout( $detail ) ){
		global $system_message;
		$system_message = $system_message."\n<br /><font color='#ff0000'>" . _MD_XOONIPS_ITEM_WARNING_FIELD_TRIM . "</font><br />";
	}
	
	//$attachment['name'] = _MD_XNPMODEL_MODEL_FILE_LABEL;

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionConfirmBlock( 'xnpmodel' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'jumpto_url', 'register.php' );
	$tpl->assign( 'model_type', $model_type );

	// return as HTML
	return $tpl->fetch( "db:xnpmodel_confirm_block.html" );
}

function
xnpmodelInsertItem( )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// register BasicInformation, Index, Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if( $result ) {
		$result = xnpUpdateIndex( $item_id );
		if( $result ) {
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
                $result = xnpUpdateAttachment( $item_id, 'model_data' );
                if( $result ) {
                }
            }
        }
		if( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if( !$result )
		return false;

	// register DetailInformation
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();

	// it makes strings with constant length
	$myts =& MyTextSanitizer::getInstance();
	$ar = array(
		'model_type'         =>$myts->stripSlashesGPC($_POST['model_type'  ]),
		'creator'            =>$myts->stripSlashesGPC($_POST['creator'     ]),
		'readme'             =>$myts->stripSlashesGPC(xnpGetTextFile( 'readme' )),
		'rights'             =>$rights,
	);
	xnpTrimColumn( $ar, 'xnpmodel_item_detail', array_keys( $ar ), _CHARSET );
	
	$keys = implode( ",", array(
		'attachment_dl_limit',
		'model_type'    ,
		'creator'       ,
		'readme',
		'rights',
		'use_cc', 'cc_commercial_use', 'cc_modification'
	) );
	$vals = implode( "','", array(
		(int)$_POST['attachment_dl_limit'  ],
		addslashes($ar['model_type'  ]),
		addslashes($ar['creator'     ]),
		addslashes($ar['readme'      ]),
		addslashes($ar['rights'      ]),
		$use_cc, $cc_commercial_use, $cc_modification
	) );

	$myts =& MyTextSanitizer::getInstance( );
	$sql = "insert into ".$xoopsDB->prefix( "xnpmodel_item_detail" )." ( model_id, $keys ) values ( $item_id, '$vals' ) ";
	$result = $xoopsDB->queryF( $sql );
	if( $result == false ) {
		echo "cannot insert item_detail: ".$xoopsDB -> error();
		return false;
	}

	return true;
}

function
xnpmodelUpdateItem( $model_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance( );

	// edit BasicInformation, Index, Preview, Attachment 
	$result = xnpUpdateBasicInformation( $model_id );
	if( $result ) {
		$result = xnpUpdateIndex( $model_id );
		if( $result ) {
			$result = xnpUpdatePreview( $model_id );
			if ( $result ){
                $result = xnpUpdateAttachment( $model_id, 'model_data' );
                if( $result ) {
                    $result = xnp_insert_change_log( $xnpsid, $model_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
                    $result = !$result;
                    if( !$result )
                        echo " xnp_insert_change_log failed.";
                } else
                    echo " xnpUpdateAttachment failed.";
            } else
                echo " xnpUpdatePreview failed.";
		} else
			echo " xnpUpdateIndex failed.";
	} else
		echo " xnpUpdateBasicInformation failed.";
	if( !$result )
		return false;

	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	$myts =& MyTextSanitizer::getInstance( );

	// it makes strings with constant length
	$ar = array(
		'model_type'         =>$myts->stripSlashesGPC($_POST['model_type'  ]),
		'creator'            =>$myts->stripSlashesGPC($_POST['creator'     ]),
		'readme'             =>$myts->stripSlashesGPC(xnpGetTextFile( 'readme' )),
		'rights'             =>$rights,
	);
	xnpTrimColumn( $ar, 'xnpmodel_item_detail', array_keys( $ar ), _CHARSET );
	
	// insert Detail Information
	$keyval = array(
		'attachment_dl_limit'."='".$myts->addSlashes($_POST['attachment_dl_limit'  ])."'",
		'model_type'         ."='".addslashes( $ar['model_type'  ] )."'",
		'creator'            ."='".addslashes( $ar['creator'     ] )."'",
		'readme'             ."='".addslashes( $ar['readme'      ] )."'",
		'rights'             ."='".addslashes( $ar['rights'      ] )."'",
		'use_cc'             ."='".$use_cc           ."'",
		'cc_commercial_use'  ."='".$cc_commercial_use."'",
		'cc_modification'    ."='".$cc_modification ."'"
	);

	// edit DetailInformation
	$myts =& MyTextSanitizer::getInstance( );
	$sql = "update ".$xoopsDB->prefix( "xnpmodel_item_detail" )
		." set ".implode( ", ", $keyval )
		." where model_id=$model_id";
	$result = $xoopsDB->queryF( $sql );
	if( $result == false ) {
		echo "cannot update item_detail";
		echo "\n$sql";
		return false;
	}

	return true;
}

function
xnpmodelDeleteItem( $model_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// delete BasicInformation, Index, Preview, Attachment 
	if( !xnpDeleteBasicInformation( $model_id ) ) {
		echo "cannot delete model item";
		return false;
	}
	// delete DetailInformation
	$sql = "delete from ".$xoopsDB->prefix( "xnpmodel_item_detail" )
		." where model_id=$model_id";
	$xoopsDB->queryF( $sql );
	return true;
}

function
xnpmodelCheckRegisterParameters( &$msg )
{
	$xnpsid = $_SESSION['XNPSID'];
	$result = true;
	if( $_POST['creator'] == '' ) {
		//creator is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPMODEL_CREATOR_REQUIRED."</font>";
		$result = false;
	}
	if( ( !isset($_FILES['model_data']) || $_FILES['model_data']['name'] == '' ) && $_POST['model_dataFileID'] == '' ) {
		//model_data is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPMODEL_MODEL_DATA_REQUIRED."</font>";
		$result = false;
	}
	// require Readme and License if register to public indexes
	$xids = explode( ',', $_POST['xoonipsCheckedXID'] );
	$indexes = array( );
	if( $xids[0] != $_POST['xoonipsCheckedXID'] ) {
		foreach( $xids as $i ) {
			$index = array( );
			if( xnp_get_index( $xnpsid, $i, $index ) == RES_OK ) {
				$indexes[] = $index;
			} else {
				$msg = $msg."<br/><font color='#ff0000'>".xnp_get_last_error_string( )."</font>";
				$result = false;
				break;
			}
		}
	}
	if( count( $indexes ) > 0 ) {
		foreach( $indexes as $i ) {
			if( $i['open_level'] <= OL_GROUP_ONLY ) {
				if( $_POST['readmeEncText'] == '' ) {
					//readme is not filled
					$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPMODEL_README_REQUIRED."</font>";
					$result = false;
				}
				if( $_POST['rightsEncText'] == '' && $_POST['rightsUseCC'] == '0') {
					//license is not filled
					$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPMODEL_RIGHTS_REQUIRED."</font>";
					$result = false;
				}
				break;
			}
		}
	}
	return $result;
}

function
xnpmodelCheckEditParameters( &$msg )
{
	return xnpmodelCheckRegisterParameters( $msg );
}

function
xnpmodelGetMetaInformation( $item_id )
{
	$ret = array( );
	$basic = xnpGetBasicInformationArray( $item_id );
	$detail = xnpmodelGetDetailInformation( $item_id );
	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = implode( "\n", $basic['titles'] );
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = implode( "\n", $basic['keywords'] );
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPMODEL_MODEL_TYPE_LABEL] = $detail['model_type']['display_value'];
		$ret[_MD_XNPMODEL_CREATOR_LABEL] = $detail['creator']['value'];
	}
	return $ret;
}

function
xnpmodelGetAdvancedSearchBlock( &$search_var )
{

	$basic = xnpGetBasicInformationAdvancedSearchBlock( 'xnpmodel', $search_var );

	$search_var[] = 'xnpmodel_model_type';
	$search_var[] = 'xnpmodel_creator';
	$search_var[] = 'xnpmodel_caption';
	$search_var[] = 'xnpmodel_model_file';

	// set to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// copy variables in $xoopsTpl to $tpl
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpmodel' );
	$model_type = xnpmodel_get_type_array( );
	$tpl->assign( 'model_type_option', $model_type );
	$types = array( );
	if( xnp_get_item_types( $types ) == RES_OK ) {
		foreach( $types as $i ) {
			if( $i['name'] == 'xnpmodel' ) {
				$tpl->assign( 'module_display_name', $i['display_name'] );
			}
		}
	} else {
		$tpl->assign( 'module_display_name', 'xnpmodel' );
	}

	// return as HTML
	return $tpl->fetch( "db:xnpmodel_search_block.html" );
}

function
xnpmodelGetAdvancedSearchQuery( &$where, &$join )
{
	global $xoopsDB;
	$basic_table =$xoopsDB->prefix('xoonips_item_basic');
	$model_table = $xoopsDB->prefix( 'xnpmodel_item_detail' );
	$file_table = $xoopsDB->prefix( 'xoonips_file' );

	$wheres = array( );
	$joins = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery( 'xnpmodel' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $model_table.'.model_type', 'xnpmodel_model_type' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $model_table.'.creator', 'xnpmodel_creator' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($file_table.'.caption' ,'xnpmodel_caption');
	if( $w ){
		$wheres[] = $w;
		$wheres[] = " $file_table.file_type_id = 1";
	}
	if ( !empty($_POST['xnpmodel_model_file']) ){
		list( $pattern, $errorMessage ) = xnpKeywordsToFulltextSql($_POST['xnpmodel_model_file']);
		if ( !$errorMessage )
			$wheres[] = "match ( $file_table.search_text ) against ( '$pattern' in boolean mode )";
	}
	$where = implode( ' and ', $wheres );
	$join = '';
}


function
xnpmodelGetDetailInformationQuickSearchQuery( &$wheres, &$join, $keywords )
{
	global $xoopsDB;
	$model_table = $xoopsDB->prefix( 'xnpmodel_item_detail' );
	$file_table  = $xoopsDB->prefix( 'xoonips_file' );

	$colnames = array( $model_table.".creator", $file_table.".caption" );
	$wheres = xnpGetKeywordsQueries( $colnames, $keywords );
	return true;
}

function
xnpmodelGetDetailInformationTotalSize( $iids ){
	return xnpGetTotalFileSize( $iids );
}

/**
 * 
 * create XML for exporting detail information
 * see xnpExportItem for detail
 * @see xnpExportItem
 * 
 * @param export_path folder that export file is written to.
 * @param fhdl file handle that items are exported to.
 * @param item_id item id that is exported
 * @param attachment true if attachment files are exported, else false.
 * @return true: success
 * @return false:error
 */
function xnpmodelExportItem( $export_path, $fhdl, $item_id, $attachment )
{
	global $xoopsDB;

    if( !$fhdl ) return false;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpmodel_item_detail" )." where model_id=$item_id" );
	if( !$result ) return false;
    $detail = $xoopsDB->fetchArray( $result );
	if( !fwrite( $fhdl, "<detail id=\"${item_id}\"> version=\"1.01\">\n"
        ."<model_type>".xnpHtmlspecialchars( $detail['model_type'], ENT_QUOTES )."</model_type>\n"
        ."<creator>".xnpHtmlspecialchars( $detail['creator'], ENT_QUOTES )."</creator>\n"
        ."<readme>".xnpHtmlspecialchars( $detail['readme'], ENT_QUOTES )."</readme>\n"
        ."<rights>".xnpHtmlspecialchars( $detail['rights'], ENT_QUOTES )."</rights>\n"
        ."<use_cc>"           .$detail['use_cc']           ."</use_cc>\n"
        ."<cc_commercial_use>".$detail['cc_commercial_use']."</cc_commercial_use>\n"
        ."<cc_modification>"  .$detail['cc_modification']  ."</cc_modification>\n"
        ."<attachment_dl_limit>".$detail['attachment_dl_limit']."</attachment_dl_limit>\n"
         ) ) return false;
    if( !( $attachment ? xnpExportFile( $export_path, $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;

    return true;
}

function xnpmodelStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/MODEL_TYPE":
    case "/ITEM/DETAIL/CREATOR": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
//    echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnpmodelEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
//        print_r( $parser_hash['detail'] );
        $ar = array(
            'model_type' => encodeClient2Server( $parser_hash['detail']['MODEL_TYPE'] ),
            'creator'    => encodeClient2Server( $parser_hash['detail']['CREATOR'   ] ),
            'readme'     => encodeClient2Server( $parser_hash['detail']['README'    ] ),
            'rights'     => encodeClient2Server( $parser_hash['detail']['RIGHTS'    ] ),
        );
        xnpTrimColumn( $ar, 'xnpmodel_item_detail', array_keys( $ar ), 'UTF-8' );
        
        $keys = implode( ",", array( 'model_type', 'creator', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification' ) );
        $vals = implode( "','", array( addSlashes( $ar['model_type'] ),
                                       addSlashes( $ar['creator'   ] ),
                                       addslashes( $ar['readme'    ] ),
                                       addslashes( $ar['rights'    ] ),
                                       (int)$parser_hash['detail']['USE_CC'],
                                       (int)$parser_hash['detail']['CC_COMMERCIAL_USE'],
                                       (int)$parser_hash['detail']['CC_MODIFICATION'],
            ) );
        
        // register DetailInformation
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpmodel_item_detail" )." ( model_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n $sql";
            return false;
        }
        break;
    }
//    echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnpmodelCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/MODEL_TYPE":
    case "/ITEM/DETAIL/CREATOR": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
//    echo($data); 
}

function xnpmodelGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpmodelStartElement", "xnpmodelEndElement", "xnpmodelCharacterData" ) );
}

/**
 * bool xnpmodelGetLicenseRequired( int item_id )
 * 
 * 
 */
function xnpmodelGetLicenseRequired( $item_id )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpmodel_item_detail" )." where model_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['rights'] ) && $detail['rights'] != '';
}

/**
 * string xnpmodelGetLicenseStatement( int item_id )
 * 
 * 
 */
function xnpmodelGetLicenseStatement( $item_id )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpmodel_item_detail" )." where model_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return array( isset( $detail['rights'] ) ? $detail['rights'] : '', $detail['use_cc'] );;
}

function xnpmodelCheckItemLengthEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $lengths = xnpGetColumnLengths( 'xnpmodel_item_detail' );
        
        $values = array(
            'model_type' => encodeClient2Server( $parser_hash['detail']['MODEL_TYPE'] ),
            'creator'    => encodeClient2Server( $parser_hash['detail']['CREATOR'   ] ),
            'readme'     => encodeClient2Server( $parser_hash['detail']['README'    ] ),
            'rights'     => encodeClient2Server( $parser_hash['detail']['RIGHTS'    ] ),
        );
        $names = array(
            'model_type' => _MD_XNPMODEL_MODEL_TYPE_LABEL,
            'creator'    => _MD_XNPMODEL_CREATOR_LABEL   ,
            'readme'     => _MD_XOONIPS_ITEM_README_LABEL,
            'rights'     => _MD_XOONIPS_ITEM_RIGHTS_LABEL,
        );
        foreach ( $values as $key => $value ){
            if ( strlen($value) > $lengths[$key] ){
                list( $within, $without ) = xnpTrimString( $value, $lengths[$key], 'UTF-8' );
                $parser_hash['exceeds'][$key] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
            }
        }
        break;
    }
}

function xnpmodelGetCheckItemLengthHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpmodelStartElement", "xnpmodelCheckItemLengthEndElement", "xnpmodelCharacterData" ) );
}

function xnpmodelGetModifiedFields( $item_id )
{
    $ret = array();
    $detail = xnpmodelGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'model_type' => _MD_XNPMODEL_MODEL_TYPE_LABEL,
                        'creator' => _MD_XNPMODEL_CREATOR_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ]['value'] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        //is readme modified ?
        foreach( array( 'readme' => _MD_XOONIPS_ITEM_README_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( "${k}EncText", $_POST ) ) continue;
            if( urldecode($_POST[ "${k}EncText" ]) != $detail[ $k ][ 'value' ] ) array_push( $ret, $v );
        }
        
        //is rights modified ?
        if( array_key_exists( 'rightsUseCC', $_POST ) ){
            if( $_POST['rightsUseCC'] == 0 ){
                if( !array_key_exists( 'rights', $detail )
                    || !array_key_exists( "rightsEncText", $_POST ) ) continue;
                if( urldecode($_POST[ "rightsEncText" ]) != $detail[ 'rights' ][ 'value' ] ) array_push( $ret, _MD_XOONIPS_ITEM_RIGHTS_LABEL );
            }else if( $_POST['rightsUseCC'] == 1 ){
                foreach( array( 'rightsCCCommercialUse' => 'cc_commercial_use',
                                'rightsCCModification'  => 'cc_modification' ) as $k => $v ){
                    if( !array_key_exists( $v, $detail ) || !array_key_exists( $k, $_POST ) ) continue;
                    if( $_POST[ $k ] != $detail[ $v ][ 'value' ] ){
                        array_push( $ret, _MD_XOONIPS_ITEM_RIGHTS_LABEL );
                        break;
                    }
                }
            }
        }
        
        // was model file modified?
        if( xnpIsAttachmentModified( 'model_data', $item_id ) ){
            array_push( $ret, _MD_XNPMODEL_MODEL_FILE_LABEL );
        }
    }
    return $ret;
}

function xnpmodelGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_model.gif', _MD_XNPMODEL_EXPLANATION, 'xnpmodel_model_type', xnpmodel_get_type_array() );
}

//return 1 if downloadable for login user only
//return 0 if downloadable for everyone
function xnpmodelGetAttachmentDownloadLimitOption( $item_id )
{
	global $xoopsDB;
    $sql = "select attachment_dl_limit from ".$xoopsDB->prefix( "xnpmodel_item_detail" )." where model_id=${item_id}";
    $result = $xoopsDB->query( $sql );
    if( $result ){
        list( $option ) = $xoopsDB->fetchRow( $result );
        return $option;
    }
    return 0;
}

function xnpmodelSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' || $metadataPrefix == 'junii2' ) return true;
    return false;
}

function xnpmodelGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
        $detail = xnpmodelGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(20)."</type>";
            $lines[] = "<type>modelType:".xnpHtmlspecialchars($detail['model_type']['value'])."</type>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['creator']['value'])."</creator>";
            $lines[] = "<description>readme:".xnpHtmlspecialchars($detail['readme']['value'])."</description>";
            $lines[] = "<description>rights:".xnpHtmlspecialchars($detail['rights']['value'])."</description>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if( $metadataPrefix == 'junii2' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii2.xsd">';
            $lines[] = $meta_basic;
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii2(30)."</type>";
            $lines[] = "<type>modelType:".xnpHtmlspecialchars($detail['model_type']['value'])."</type>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['creator']['value'])."</creator>";
            $lines[] = "<description>readme:".xnpHtmlspecialchars($detail['readme']['value'])."</description>";
            $lines[] = "<description>rights:".xnpHtmlspecialchars($detail['rights']['value'])."</description>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
			$lines[] = "<dc:type>modelType:".xnpHtmlspecialchars($detail['model_type']['value'])."</dc:type>";
			$lines[] = "<dc:creator>".xnpHtmlspecialchars($detail['creator']['value'])."</dc:creator>";
			$lines[] = "<dc:rights>".xnpHtmlspecialchars($detail['rights']['value'])."</dc:rights>";
			$lines[] = "<dc:description>readme:".xnpHtmlspecialchars($detail['readme']['value'])."</dc:description>";

			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}

function xnpmodelCreateXooNIpsItem(){
    return new XooNIpsModel();
}
?>
