<?php
// $Id: xmlparser.class.php,v 1.1.2.1 2007/01/10 12:27:11 makotonton Exp $
//  ------------------------------------------------------------------------ //
//  XOOPS module base classes                                                //
//  Copyright (C) 2006 RIKEN BSI Neuroinformaitcs Japan Center               //
//  All rights reserved.                                                     //
//  http://nijc.brain.riken.jp/                                              //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if ( ! class_exists( 'XooNIps_XML_Parser' ) ) {

class XooNIps_XML_Parser
{
  /**
   * the xml data, fetch() function will set results to this variable
   * @var string
   * @access private
   */
  var $_xml_data = '';

  /**
   * the error messages
   * @var string
   * @access private
   */
  var $_error_message = '';

  /**
   * the snoopy class file path
   * @var string
   * @access private
   */
  var $_snoopy_path = '';

  /**
   * the fetcher target url
   * @var string
   * @access protected
   */
  var $_fetch_url = '';

  /**
   * the fetcher arguments
   * @var array
   * @access protected
   */
  var $_fetch_arguments = array();

  /**
   * the xml document type
   * @var string
   * @access protected
   */
  var $_parser_doctype = '';

  /**
   * the public id of xml document
   * @var string
   * @access protected
   */
  var $_parser_public_id = '';

  /**
   * the system id of xml document
   * @var string
   * @access protected
   */
  var $_parser_system_id = '';

  /**
   * the perser condition
   * @var string
   * @access protected
   */
  var $_parser_condition = '';

  /**
   * constructor
   * normally, the is called from child classes only
   * @access public
   */
  function XooNIps_XML_Parser()
  {
    $this->_snoopy_path = dirname( __FILE__ ).'/Snoopy.class.php';
  }

  /**
   * get error message
   *
   * @access public
   * @return string error message reference
   */
  function get_error_message()
  {
    return $this->_error_message;
  }

  /**
   * fetch the xml data from target url
   *
   * @access public
   * @return bool FALSE if failure
   */
  function fetch()
  {
    if ( empty( $this->_fetch_url ) ) {
      $this->_error_message = 'target url is empty';
      return FALSE;
    }
    // create fetch url
    $url = $this->_fetch_url.'?';
    foreach( $this->_fetch_arguments as $k => $v ) {
      $url .= '&'.trim( $k ).'='.urlencode( $v );
    }
    $url = str_replace( '?&', '?', $url );
    // fetch data using snoopy class
    require_once( $this->_snoopy_path );
    $snoopy = new Snoopy();
    if ( ! $snoopy->fetch( $url ) ) {
      $this->_error_message = 'Failed to fetch results : "'.$url.'"';
      return FALSE;
    }
    $this->_xml_data =& $snoopy->results;
    // echo $url."\n";
    // echo $this->_xml_data."\n";
    return TRUE;
  }

  /**
   * parse the xml data
   *
   * @access public
   * @return bool FALSE if failure
   */
  function parse()
  {
    if ( ! $this->_parser_check_doctype() ) {
      return FALSE;
    }
    $this->_parser_condition = '';
    $parser = xml_parser_create();
    xml_set_object( $parser, $this );
    xml_parser_set_option( $parser, XML_OPTION_CASE_FOLDING, 0 );
    xml_set_element_handler( $parser, '_parser_start_element_handler', '_parser_end_element_handler' );
    xml_set_character_data_handler( $parser, '_parser_character_data_handler' );
    xml_parse( $parser, $this->_xml_data );
    xml_parser_free( $parser );
    return TRUE;
  }

  /**
   * virtual function of the start elemnt handler
   *
   * @access protected
   * @param string $attribs xml attribute
   */
  function parser_start_element( $attribs )
  {
  }

  /**
   * virtual function of the end elemnt handler
   *
   * @access protected
   */
  function parser_end_element()
  {
  }

  /**
   * virtual function of the character data handler
   *
   * @access protected
   * @param string $cdata character data
   */
  function parser_character_data( $cdata )
  {
  }

  /**
   * check doctype of xml
   * this function is a part of parse() function
   *
   * @access private
   * @return bool FALSE if failure
   */
  function _parser_check_doctype()
  {
    if ( empty( $this->_xml_data ) ) {
      $this->_error_message = 'the parsing xml file is empty';
      return FALSE;
    }
    $public_search = '/<!DOCTYPE\s+(\w+)\s+PUBLIC\s"([^"]+)"\s+"([^"]+)"\s*>/is';
    $system_search = '/<!DOCTYPE\s+(\w+)\s+SYSTEM\s"([^"]+)"\s*>/is';
    if ( preg_match( $public_search, $this->_xml_data, $matches ) ) {
      $name = $matches[1];
      $public_id = $matches[2];
      $system_id = $matches[3];
    } else if ( preg_match( $system_search, $this->_xml_data, $matches ) ) {
      $name = $matches[1];
      $public_id = '';
      $system_id = $matches[2];
    } else {
      $this->_error_message = 'DOCTYPE not found in xml data';
      return FALSE;
    }

    // compare doctype
    if ( ! empty( $this->_parser_doctype ) ) {
      if ( $name != $this->_parser_doctype ) {
        $this->_error_message = 'unknown doctype : '.$name;
        return FALSE;
      }
    }
    // compare public id
    if ( ! empty( $this->_parser_public_id ) ) {
      if ( $public_id != $this->_parser_public_id ) {
        $this->_error_message = 'unknown public id : '.$public_id;
        return FALSE;
      }
    }
    // compare system id
    if ( ! empty( $this->_parser_system_id ) ) {
      if ( $system_id != $this->_parser_system_id ) {
        $this->_error_message = 'unknown system id : '.$system_id;
        return FALSE;
      }
    }
    return TRUE;
  }

  /**
   * callback handler of start element of xml data
   * this function is a part of parse() function
   *
   * @access private
   * @param resource $parser parser resource
   * @param string $name xml element tag
   * @param string $attribs xml attributes
   */
  function _parser_start_element_handler( $parser, $name, $attribs )
  {
    // update condition
    $this->_parser_condition .= '/'.$name;
    // call start element handler
    $this->parser_start_element( $attribs );
  }


  /**
   * callback handler of end element of xml data
   * this function is a part of parse() function
   *
   * @access private
   * @param resource $parser parser resource
   * @param string $name xml element tag
   */
  function _parser_end_element_handler( $parser, $name )
  {
    // call end element handler
    $this->parser_end_element();
    // update condition
    $all_len = strlen( $this->_parser_condition );
    $tag_len = strlen( $name );
    $this->_parser_condition = substr( $this->_parser_condition, 0, $all_len - $tag_len - 1 );
  }

  /**
   * callback handler of character data handler of xml data
   * this function is a part of parse() function
   *
   * @access private
   * @param resource $parser parser resource
   * @param string $cdata character data
   */
  function _parser_character_data_handler( $parser, $cdata )
  {
    $this->parser_character_data( trim( $cdata ) );
  }
}

}

?>
