<?php
//  Install script for paper module                                             //
//  $Revision: 1.10 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

function xoops_module_install_xnppaper( $xoopsMod ) {
	global $xoopsDB;
	
	// register itemtype
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "INSERT INTO $table ( name, display_name, mid, viewphp ) VALUES ( 'xnppaper', 'Paper', $mid, 'xnppaper/include/view.php' )";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot register itemtype
		return false;
	}
	
	// register filetype
	$table = $xoopsDB->prefix('xoonips_file_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "INSERT INTO $table ( name, display_name, mid ) VALUES ( 'paper_pdf_reprint', 'PDF Reprint', $mid )";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot register itemtype
		return false;
	}

	// Delete 'Module Access Rights' from all groups
	// This allows to remove redundant module name in Main Menu
	$member_handler =& xoops_gethandler('member');
	$gperm_handler =& xoops_gethandler('groupperm');
	$groups =& $member_handler->getGroupList();
	foreach ($groups as $groupid2 => $groupname) {
		if ($gperm_handler->checkRight('module_read', $mid, $groupid2)) {
			$criteria = new CriteriaCompo();
			$criteria->add( new Criteria( 'gperm_groupid', $groupid2 ) );
			$criteria->add( new Criteria( 'gperm_itemid', $mid ) );
			$criteria->add( new Criteria( 'gperm_name', 'module_read' ) );
			
			$objects = $gperm_handler->getObjects($criteria);
			if ( count( $objects ) == 1 ){
				$gperm_handler->delete( $objects[0] );
			}
		}
	}
	
	//$item_type_id = $xoopsDB->getInsertId();
	return true;
} 

function xoops_module_uninstall_xnppaper( $xoopsMod ) {
	global $xoopsDB;
	
	$item_type_id = -1;
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "SELECT item_type_id FROM $table where mid = $mid";
	$result = $xoopsDB->query($sql);
	if ( $result ){
		list($item_type_id) = $xoopsDB->fetchRow($result);
	}else{
		echo mysql_error();
		echo $sql;
		return false;
	}
	
	//item_status.is_deleted to be 1(Deleted)
	$table = $xoopsDB->prefix('xoonips_item_basic');
	$sql = "SELECT item_id from ${table} WHERE item_type_id = $item_type_id";
	$result = $xoopsDB->query($sql);
	if ( !$result ){
		echo mysql_error();
		echo $sql;
		return false;
	}
	$ids = array( );
	while( list( $item_id ) = $xoopsDB->fetchRow($result) ){
		$ids[] = $item_id;
	}
	if( count( $ids ) > 0 ){
		$table = $xoopsDB->prefix('xoonips_item_status');
		$sql = "UPDATE ${table} SET deleted_timestamp=UNIX_TIMESTAMP(NOW()), is_deleted=1 WHERE item_id in ( ".implode( ",", $ids ).")";
		if ( $xoopsDB->query($sql) == FALSE ){
			echo mysql_error();
			echo $sql;
			return false;
		}
	}
	
	// remove basic information
	$table = $xoopsDB->prefix('xoonips_item_basic');
	$sql = "DELETE FROM $table where item_type_id = $item_type_id";
	if ( $xoopsDB->query($sql) == FALSE ){
		echo mysql_error();
		echo $sql;
		return false;
	}

	// unregister itemtype
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "DELETE FROM $table where mid = $mid";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot unregister itemtype
		return false;
	}
	$table = $xoopsDB->prefix('xoonips_file_type');
	$sql = "DELETE FROM $table where mid = $mid";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot unregister filetype
		return false;
	}
	return true;
}

function xoops_module_update_xnppaper ( $xoopsMod, $oldversion) {

	global $xoopsDB;
	switch ($oldversion) { //remember that version is multiplied with 100 to get an integer
	case 100: //perform actions to upgrade from version 1.00
		if (_CHARSET != 'UTF-8') {
			include_once XOOPS_ROOT_PATH.'/modules/xoonips/include/encode.php';
			$table1 = $xoopsDB->prefix("xnppaper_item_detail");
			$table2 = $xoopsDB->prefix('xoonips_item_basic');
			$items = array( );
			$sql1 = "SELECT paper_id, author, journal, page, abstract FROM $table1";
			$result1 = $xoopsDB->query($sql1);
			if( !$result1 ){
				echo "ERROR: " . $xoopsDB->error();
				return false;
			}
			$i = 0;
			while ( list($paper_id, $author, $journal, $page, $abstract) = $xoopsDB->fetchRow($result1) ) {
				if (_CHARSET == 'EUC-JP') {
					$author = encodeServer2Client($author);
					$journal = encodeServer2Client($journal);
					$page = encodeServer2Client($page);
					$abstract = encodeServer2Client($abstract);
				}
				$author = encodeClient2Server($author);
				$author = addslashes($author);
				$journal = encodeClient2Server($journal);
				$journal = addslashes($journal);
				$page = encodeClient2Server($page);
				$abstract = encodeClient2Server($abstract);
				$abstract = addslashes($abstract);
				$sql2 = "SELECT title FROM $table2 where item_id=$paper_id";
				$result2 = $xoopsDB->query($sql2);
				if( !$result2 ){
					echo "ERROR: " . $xoopsDB->error();
					return false;
				}
				list($title) = $xoopsDB->fetchRow($result2);
				if (_CHARSET == 'EUC-JP') {
					$title = encodeServer2Client($title);
				}
				$title = encodeClient2Server($title);
				$title = addslashes($title);
				$sql3 = "UPDATE $table2 SET title='$title' where item_id=$paper_id";
				$result3 = $xoopsDB->query($sql3);
				if( !$result3 ){
					echo "ERROR: " . $xoopsDB->error();
					return false;
				}
				$sql4 = "UPDATE $table1 SET author='$author', journal='$journal', page='$page', abstract='$abstract' where paper_id=$paper_id";
				$result4 = $xoopsDB->query($sql4);
				if( !$result4 ){
					echo "ERROR: " . $xoopsDB->error();
					return false;
				}
			}
		}
	case 110: // 110->111: author varchar -> text
		$result = $xoopsDB->query( "ALTER TABLE ".$xoopsDB->prefix('xnppaper_item_detail')." CHANGE COLUMN author author TEXT NOT NULL" );
		if( !$result ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}
		
	case 310:
		
	default:
		return true;
	}
	return true;
}
?>
