<?php
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/item.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/attachment.php";
include_once XOOPS_ROOT_PATH.'/modules/xnppresentation/include/view.php';

class XooNIpsPresentation extends XooNIpsItem{

    /**
     * array of supported version of import file
     */
    var $import_file_version = array( "1.00", "1.01" );

    function XooNIpsPresentation(){
        parent::XooNIpsItem();
        
        $this->columnLengths = $lengths = $this->getColumnMaxLen( 'xnppresentation_item_detail' );
        $this->initVar('version'          , XOBJ_DTYPE_TXTBOX, null, false, 10);
        $this->initVar('presentation_type', XOBJ_DTYPE_TXTBOX, null, false, $lengths['presentation_type']);
        $this->initVar('creator'          , XOBJ_DTYPE_TXTBOX, null, false, $lengths['creator'          ]);
        $this->initVar('rights'           , XOBJ_DTYPE_TXTBOX, null, false, $lengths['rights'           ]);
        $this->initVar('readme'           , XOBJ_DTYPE_TXTBOX, null, false, $lengths['readme'           ]);
        $this->initVar('use_cc'           , XOBJ_DTYPE_INT, null, false);
        $this->initVar('cc_commercial_use', XOBJ_DTYPE_INT, null, false);
        $this->initVar('cc_modification'  , XOBJ_DTYPE_INT, null, false);
        $this->initVar('presentation_file', XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->initVar('preview'          , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->initVar('attachment_dl_limit', XOBJ_DTYPE_INT, null, false);
        $this->attachment_info = array(
            'presentation_file' => array( 'multiple' => false ),
            'preview'           => array( 'multiple' => true  ),
        );
        
        $this->presentation_types = xnppresentationGetTypes();
    }

    function cleanVars()
    {
        if ( !parent::cleanVars() )
            return false;
        
        // validate attachment_dl_limit
        if( $this->getVar('attachment_dl_limit' ) != 0
            && $this->getVar('attachment_dl_limit' ) != 1 ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "invalid value (".$this->getVar('attachment_dl_limit' ).") of attachment_dl_limit " . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            $this->cleanVars['attachment_dl_limit'] = intval( $this->getVar('attachment_dl_limit' ) );
            $retval = false;
        }
        
        $vals = array(
            'presentation_type'=> $this->getVar('presentation_type','n'),
            'creator'          => $this->getVar('creator'          ,'n'),
            'rights'           => $this->getVar('rights'           ,'n'),
            'readme'           => $this->getVar('readme'           ,'n'),
            'attachment_dl_limit' => $this->getVar('attachment_dl_limit' ,'n'),
        );
        $ar = $this -> stripSurplusString( $this->columnLengths, $vals );
        foreach ( $vals as $key => $val ){
            if ( isset( $ar[$key] ) ){
                $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $key is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $this->cleanVars[$key] = $ar[$key];
                $retval = false;
            }
            else
                $this->cleanVars[$key] = $val;
        }
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            if ( !$info['multiple'] && count($attachments) > 1 ){
                $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $retval = false;
            }
            for ( $i = 0; $i < count($attachments); $i++ )
                if ( !$attachments[$i]->cleanVars() )
                    $retval = false;
            $this->setVar($name, serialize($attachments));
        }
        
        $use_cc = $this->getVar('use_cc');
        if ( !in_array( $use_cc, array('0', '1') ) ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "bad use_cc($use_cc)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        $this->cleanVars['use_cc'] = $use_cc;
        
        $cc_commercial_use = $this->getVar('cc_commercial_use');
        if ( !in_array( $cc_commercial_use, array('0', '1') ) ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "bad cc_commercial_use($cc_commercial_use)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        $this->cleanVars['cc_commercial_use'] = $cc_commercial_use;
        
        $cc_modification = $this->getVar('cc_modification');
        if ( !in_array( $cc_modification, array('0', '1', '2') ) ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "bad cc_modification($cc_modification)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        $this->cleanVars['cc_modification'] = $cc_modification;
        
        $type = $this->getVar('presentation_type');
        if ( !isset( $this->presentation_types[ $type ] ) ){
            $this -> setErrors( E_XOONIPS_INVALID_VALUE, "unknown presentation_type($type)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        return true;
    }

    /**
     * 
     * for attachment file
     * 
     */
    var $file = null;
    var $attachment_info;
    
    // for column length check
    var $columnLengths;
    
    function startElement($parser, $name, $attribs){
        global $xoopsDB;
        
        parent::startElement($parser, $name, $attribs);

//            echo "\nS ".implode( '/', $this -> tagstack )."\tattributes=";print_r($attribs);
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            foreach ( $this->attachment_info as $name => $info )
                $this->setVar( $name, serialize(array()), true );
            // 
            // validate version and set it to 'version' variable
            // 
            if( !empty( $attribs['VERSION'] ) ){
                if( in_array( $attribs['VERSION'], $this -> import_file_version ) ){
                    $this -> setVar( 'version', $attribs['VERSION'] );
                }else{
                    $this -> setErrors( E_XOONIPS_INVALID_VALUE, "unsupported version(" . $attribs['VERSION'] . ") " . $this -> getParserErrorAt( $parser ) );
                }
            }else{
                $this -> setVar( 'version', '1.00' );
            }
            break;
        case "ITEM/DETAIL/FILE":
            $result = $xoopsDB -> query( "select value from " . $xoopsDB -> prefix( "xoonips_config" ) . " where name='upload_dir'" );
            if( $result ){
                list( $upload_dir ) = $xoopsDB -> fetchRow( $result );
                $this -> file = new XooNIpsAttachment( $this -> attachment_dir, $upload_dir );
            }else{
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
            }
            break;
        }

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> startElement( $parser, $name, $attribs );
        }
    }

    function endElement($parser, $name) { 
        global $xoopsDB;
        

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> endElement( $parser, $name );
        }

        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            $keys = array(
                'presentation_type',
                'creator'          ,
                'rights'           ,
                'readme'           ,
                'use_cc'           ,
                'cc_commercial_use',
                'cc_modification'  ,
            );
            foreach ( $keys as $key )
                if ( is_null($this->getVar($key,'n')) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no $key tag " . $this -> getParserErrorAt( $parser ) );

            if( $this -> getVar( 'version' ) == '1.01'
                && is_null( $this -> getVar( 'attachment_dl_limit' ) ) ){
                $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no attachment_dl_limit tag " . $this -> getParserErrorAt( $parser ) );
            }else if( $this -> getVar( 'version' ) == '1.00'
                      && is_null( $this -> getVar( 'attachment_dl_limit' ) ) ){
                // 
                // set zero to attachment_dl_limit if it is not declared in xml
                // 
                $this -> setVar( 'attachment_dl_limit', 0 );
            }
            break;
        case "ITEM/DETAIL/PRESENTATION_TYPE":
        case "ITEM/DETAIL/CREATOR": 
        case "ITEM/DETAIL/RIGHTS": 
        case "ITEM/DETAIL/README": 
        case "ITEM/DETAIL/USE_CC": 
        case "ITEM/DETAIL/CC_COMMERCIAL_USE": 
        case "ITEM/DETAIL/CC_MODIFICATION": 
            $this -> setVar( strtolower( end( $this -> tagstack ) ) , encodeMeta2Server( end( $this -> cdata ) ), true );
            break;
        case "ITEM/DETAIL/ATTACHMENT_DL_LIMIT":
            if( !is_null( $this -> getVar( 'attachment_dl_limit' ) ) ){
                $this -> setErrors( E_XOONIPS_TAG_REDUNDANT, "attachment_dl_limit is redundant" . $this -> getParserErrorAt( $parser ) );
            }else if( ctype_digit( end( $this -> cdata ) ) ){
                $this -> setVar( 'attachment_dl_limit', intval( end( $this -> cdata ) ) );
            }else{
                $this -> setErrors( E_XOONIPS_INVALID_VALUE, "invalid value(" . end( $this -> cdata ) . ") of attachment_dl_limit" . $this -> getParserErrorAt( $parser ) );
            }
            break;
        case "ITEM/DETAIL/FILE":
            if( isset( $this -> file ) ){
                $file_type_id = $this->file->getVar('file_type_id');
                if ( $file_type_id ){
                    $sql = "select name from " . $xoopsDB->prefix('xoonips_file_type') . " where file_type_id=$file_type_id";
                    $result = $xoopsDB->query( $sql );
                    if ( $result ){
                        if ( $xoopsDB->getRowsNum($result) ){
                            list( $name ) = $xoopsDB->fetchRow( $result );
                            if ( isset( $this->attachment_info[$name]) ){
                                $info = $this->attachment_info[$name];
                                $attachments = $this->getVar($name);
                                if ( count( $attachments ) && !$info['multiple'] )
                                    $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getParserErrorAt( $parser ) );
                                $attachments[] = $this->file;
                                $this -> setVar( $name, serialize( $attachments ), true );
                                break;
                            }
                            else 
                                $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_name($name) " . $this -> getParserErrorAt( $parser ) );
                        }
                        else
                            $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_id($file_type_id) " . $this -> getParserErrorAt( $parser ) );
                    }
                    else
                        $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
                }
                else
                    $this -> setErrors( E_XOONIPS_ATTR_NOT_FOUND, " no file_type_id " . $this -> getParserErrorAt( $parser ) );
                
                // include $this->file->_error, error_codes
                $errors = $this->file->getErrors();
                $codes = $this->file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
            }
            break;
        }

        parent::endElement($parser, $name);
    }
    
    function characterData($parser, $data) {
        
        parent::characterData($parser, $data);

//        echo "\nC ".implode( '/', $this -> tagstack )."\t${data}";
        switch( implode( '/', $this -> tagstack ) ){
/*
        case "ITEM/DETAIL/TAGNAME":
            ....... 
            break;
*/
        }
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> characterData( $parser, $data );
        }
    }
    
    /**
     * insert/update object
     *   
     * @return false if failed, true if insert successfully or already exists and unchanged.
     *   
     */
    function insert()
    {
        global $xoopsDB;
        
        if ($this->isNew()) {
            if( !parent::insert() ) return false;

            $keys = implode( ",", array(
                'presentation_id'   ,
                'presentation_type' ,
                'creator'           ,
                'rights'            ,
                'readme'            ,
                'use_cc'            ,
                'cc_commercial_use' ,
                'cc_modification'   ,
                'attachment_dl_limit' ,
            ) );
            $vals = implode( ",", array(
                $this -> getVar( 'item_id' ),
                is_null( $this -> cleanVars[ 'presentation_type' ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'presentation_type' ] ),
                is_null( $this -> cleanVars[ 'creator'           ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'creator'           ] ),
                is_null( $this -> cleanVars[ 'rights'            ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'rights'            ] ),
                is_null( $this -> cleanVars[ 'readme'            ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'readme'            ] ),
                is_null( $this -> cleanVars[ 'use_cc'            ] ) ? 0      :                          $this -> cleanVars[ 'use_cc'            ]  ,
                is_null( $this -> cleanVars[ 'cc_commercial_use' ] ) ? 'null' :                          $this -> cleanVars[ 'cc_commercial_use' ]  ,
                is_null( $this -> cleanVars[ 'cc_modification'   ] ) ? 'null' :                          $this -> cleanVars[ 'cc_modification'   ]  ,
                is_null( $this -> cleanVars[ 'attachment_dl_limit' ] ) ? 'null' :                          $this -> cleanVars[ 'attachment_dl_limit' ]  ,
                ) );
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnppresentation_item_detail") . " ( $keys ) VALUES ( $vals ) ";
        } else {
            if( !parent::insert() ) return false;
            $item_id = $this->getVar('item_id');
            $keyval = implode( ', ', array(
                 'presentation_type' . '=' . ( is_null( $this -> cleanVars[ 'presentation_type' ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'presentation_type' ] ) ),
                 'creator'           . '=' . ( is_null( $this -> cleanVars[ 'creator'           ] ) ? "''"   : $xoopsDB -> quoteString( $this -> cleanVars[ 'creator'           ] ) ),
                 'rights'            . '=' . ( is_null( $this -> cleanVars[ 'rights'            ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'rights'            ] ) ),
                 'readme'            . '=' . ( is_null( $this -> cleanVars[ 'readme'            ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'readme'            ] ) ),
                 'use_cc'            . '=' . ( is_null( $this -> cleanVars[ 'use_cc'            ] ) ? 0      : $xoopsDB -> quoteString( $this -> cleanVars[ 'use_cc'            ] ) ),
                 'cc_commercial_use' . '=' . ( is_null( $this -> cleanVars[ 'cc_commercial_use' ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'cc_commercial_use' ] ) ),
                 'cc_modification'   . '=' . ( is_null( $this -> cleanVars[ 'cc_modification'   ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'cc_modification'   ] ) ),
                 'attachment_dl_limit'. '=' . ( is_null( $this -> cleanVars[ 'attachment_dl_limit'  ] ) ? 'null' :                          $this -> cleanVars[ 'attachment_dl_limit'  ] ),
            ));
            $sql = "UPDATE " . $xoopsDB->prefix("xnppresentation_item_detail") . " set $keyval where presentation_id=$item_id";
        }
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        // remove old attachment information 
        $item_id = $this->getVar('item_id');
        $sql = "select file_id from " . $xoopsDB->prefix('xoonips_file') . " where item_id=$item_id";
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        while ( list($file_id) = $xoopsDB->fetchRow($result) ){
            $file = new XooNIpsAttachment(null,null);
            $file->setVar('item_id', $item_id);
            $file->setVar('file_id',$file_id);
            if ( !$file->delete() ){
                // include $file->_error, error_codes
                $errors = $file->getErrors();
                $codes = $file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
                return false;
            }
        }
        
        // register attachment files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i] -> setVar( 'item_id', $this -> getVar( 'item_id' ) );
                if ( !$attachments[$i] -> insert() ){
                    @$this -> delete();
                    // 
                    // before return false, set attachments array to keep error message of attachment object
                    // 
                    $this->setVar( $name, serialize($attachments) );
                    return false;
                }
            }
            $this->setVar( $name, serialize($attachments) );
        }
        
        if( $this -> isNew() ){
            $this -> unsetNew();//item is not new because it was inserted
        }
        return true;
    }
    
    /**
     * delete an item from the database
     * 
     * @return false if failed, true if delete successfully
     *   
     */
    function delete(){
        global $xoopsDB;
        
        if( !parent::delete() ) return false;
        
        
        $sql = sprintf( "DELETE FROM %s WHERE presentation_id = %u", $xoopsDB->prefix( "xnppresentation_item_detail" ), $this -> getVar( 'presentation_id' ) );
        $result = $xoopsDB->query( $sql );
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // delete files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i]->delete();
            }
        }
        
        return true;
    }
    
    function getErrors(){
        $ar = parent::getErrors();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrors() );
            }
        }
        return $ar;
    }
    
    function getErrorCodes(){
        $ar = parent::getErrorCodes();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrorCodes() );
            }
        }
        return $ar;
    }
    
    function toString( $htmlspecialchars = false ){
        $ar = array( parent::toString( $htmlspecialchars ) );
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar[] = $attachments[$i] -> toString($htmlspecialchars);
            }
        }
        
        foreach ( $this->columnLengths as $key => $dummy ){
            if ( $key == 'presentation_id' ) continue;
            $val = $this->getVar($key,'n');
            if( extension_loaded( 'mbstring' ) ){
                $val = mb_ereg_replace( '\n', '\n', mb_ereg_replace( '\\\\', '\\\\', $val ) );
            }else{
                $val = str_replace( array( "\\", "\n" ), array( "\\\\", "\\n" ), $val );
            }
            $ar[] = "detail.$key " . ( $htmlspecialchars ? htmlspecialchars($val) : $val );
        }
        
        return implode( "\n", $ar );
    }
    
}
?>
