<?php
//  $Revision: 1.12.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if( file_exists( XOOPS_ROOT_PATH.'/modules/xnpsimulator/language/'.$xoopsConfig['language'].'/main.php' ) ) {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpsimulator/language/'.$xoopsConfig['language'].'/main.php' );
} else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpsimulator/language/english/main.php' );
}
include_once XOOPS_ROOT_PATH . "/modules/xnpsimulator/class/xnpsimulator.php";


/**
 * 
 * return an array ov available simulator types.<br/>
 * that structue is shown below.<br/>
 * array( value of simulator type for processing => value of simulator type for displaying, ... )<br/>
 * values of displaying are defined by _MD_XNPSIMULATOR_SIMULATOR_TYPE_SELECT.<br/>
 * _MD_XNPSIMULATOR_SIMULATOR_TYPE_SELECT is tab(\t) separated value.<br/>
 * _MD_XNPSIMULATOR_SIMULATOR_TYPE_SELECT has four values which correspond to values for displaying as below.<br/>
 * matlab, mathematica, program, other
 * <br/>
 * number of values for displaying != number of values for processing then return false.<br/>
 * <br/>
 * 
 */
function
xnpsimulator_get_type_array( )
{
	$key = array( 'matlab', 'mathematica', 'program', 'other' );
	$value = explode( "\t", _MD_XNPSIMULATOR_SIMULATOR_TYPE_SELECT );
	$ret = array( );
	if( count( $key ) != count( $value ) )
		return FALSE;
	for( $i = 0; $i < count( $key ); $i++ ) {
		$ret[$key[$i]] = $value[$i];
	}
	return $ret;
}

/** retrieve Detail Information that specified by item_id
  * return array of items which registered into binder specified by item_id.
  * return array(only keys, no values) if item_id is wrong.
  * @return array as result
  * @return false if failed
  */
function xnpsimulatorGetDetailInformation( $item_id ){
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];
	$item = array( );

	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpsimulator_item_detail" )." where simulator_id=$item_id" );
	$item = $xoopsDB->fetchArray( $result );

//  if( $item ){
	$simulator_types = xnpsimulator_get_type_array( );
	$myts =& MyTextsanitizer::getInstance( );
	return array( 'simulator_type' => array( 'value' => $item['simulator_type'],
										'select' => xnpsimulator_get_type_array( ),
										'display_value' => $myts->htmlspecialchars( $simulator_types[$item['simulator_type']] ) ),
				  'developer' => array( 'value' => $item['developer'] ),
				  'readme' => array( 'value' => $item['readme'] ),
				  'rights' => array( 'value' => $item['rights'] ),
				  'use_cc'  => array( 'value' => $item['use_cc'] ),
				  'cc_commercial_use' => array( 'value' => $item['cc_commercial_use'] ),
				  'cc_modification'  => array( 'value' => $item['cc_modification'] ),
				  'attachment_dl_limit' => array( 'value' => $item['attachment_dl_limit']) );
//  }   
	return false;
}

function
xnpsimulatorGetListBlock( $item_basic )
{
	$item_id = $item_basic['item_id'];

	// retrieve detail information
	$detail = xnpsimulatorGetDetailInformation( $item_id );

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );

	// return HTML content
	return $tpl->fetch( "db:xnpsimulator_list_block.html" );
}

function
xnpsimulatorGetPrinterFriendlyListBlock( $item_basic ){
	return xnpsimulatorGetListBlock( $item_basic );
}

function xnpsimulatorGetDetailBlock( $item_id ){
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// retrieve detail information
	$detail = xnpsimulatorGetDetailInformation( $item_id );

	//retrive developer, simulator_type, readme, license from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'simulator_type', 'developer', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}

	// retrieve blocks ofBasicInformation / RegisteredItem
	$basic = xnpGetBasicInformationDetailBlock( $item_id );

	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index = xnpGetIndexDetailBlock( $item_id );
	$attachment = xnpGetAttachmentDetailBlock( $item_id, 'simulator_data' );
	$readme = xnpGetTextFileDetailBlock( $item_id, 'readme', $detail['readme']['value'] );
	$rights = xnpGetRightsDetailBlock( $item_id, $detail['use_cc']['value'], $detail['rights']['value'], $detail['cc_commercial_use']['value'], $detail['cc_modification']['value'] );
	
	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );

	// return HTML content
	return $tpl->fetch( "db:xnpsimulator_detail_block.html" );
}

function
xnpsimulatorGetPrinterFriendlyDetailBlock( $item_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// retrieve detail information
	$detail = xnpsimulatorGetDetailInformation( $item_id );

	//retrive developer, simulator_type, readme, license from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'simulator_type', 'developer', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}

	// retrieve blocks ofBasicInformation / RegisteredItem
	$basic = xnpGetBasicInformationDetailBlock( $item_id );

	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$attachment = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'simulator_data' );
	$readme = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'readme', $detail['readme']['value'] );
	$rights = xnpGetRightsPrinterFriendlyBlock( $item_id, $detail['use_cc']['value'], $detail['rights']['value'] );

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );

	// return HTML content
	return $tpl->fetch( "db:xnpsimulator_detail_block.html" );
}

function
xnpsimulatorGetRegisterBlock( )
{
	global $xoopsDB;

	//retrive developer, simulator_type from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'simulator_type', 'developer', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$$k = $_GET[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$$k = $_POST[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_POST[$k] );
			}
		} else {
			$$k = false;
		}
	}

	// retrieve blocks of BasicInformation / Preview / Readme / License / index
	$basic = xnpGetBasicInformationRegisterBlock( );
	$simulator_types = xnpsimulator_get_type_array( );
	if ( $simulator_type == false ){
		list( $simulator_type ) = each( $simulator_types );
	}
	$detail = array( 'simulator_type' => array( 'value' => $simulator_type,
										   'display_value' => $simulator_types[$simulator_type],
										   'select' => $simulator_types ), 'developer' => array( 'value' => $developer ) );
	$preview = xnpGetPreviewRegisterBlock( );
	$index = xnpGetIndexRegisterBlock( );
	$attachment = xnpGetAttachmentRegisterBlock( 'simulator_data' );
	$readme = xnpGetTextFileRegisterBlock( 'readme' );
	$rights = xnpGetRightsRegisterBlock();

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionRegisterBlock( 'xnpsimulator' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'jumpto_url', 'register.php' );
	if( isset( $simulator_date ) ) {
		$tpl->assign( 'gmtime', mktime( 0, 0, 0, $simulator_date['Date_Month'], $simulator_date['Date_Day'], $simulator_date['Date_Year'] ) );
	} else {
		$tpl->assign( 'gmtime', time( ) );
	}
	// return HTML content
	return $tpl->fetch( "db:xnpsimulator_register_block.html" );
}

function
xnpsimulatorGetEditBlock( $item_id )
{
	global $xoopsDB;

	// retrieve detail information
	$detail = xnpsimulatorGetDetailInformation( $item_id );

	//retrive developer, simulator_type, readme, license from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'simulator_type', 'developer', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}
	$simulator_types = xnpsimulator_get_type_array( );
	$detail['simulator_type']['display_value'] = $simulator_types[$detail['simulator_type']['value']];
	$detail['simulator_type']['select'] = $simulator_types;

	// retrieve blocks of BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationEditBlock( $item_id );

	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$attachment = xnpGetAttachmentEditBlock( $item_id, 'simulator_data' );

	$readme = xnpGetTextFileEditBlock( $item_id, 'readme', $detail['readme']['value'] );
	$rights = xnpGetRightsEditBlock( $item_id, $detail['use_cc']['value'], $detail['rights']['value'], $detail['cc_commercial_use']['value'], $detail['cc_modification']['value'] );

	$attachment['name'] = _MD_XNPSIMULATOR_SIMULATOR_FILE;

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionEditBlock( 'xnpsimulator', xnpsimulatorGetAttachmentDownloadLimitOption( $item_id ) ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'jumpto_url', 'edit.php' );

	// return HTML content
	return $tpl->fetch( "db:xnpsimulator_register_block.html" );
}


function
xnpsimulatorGetConfirmBlock( $item_id )
{


	//retrive developer, simulator_type from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'simulator_type', 'developer', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$$k = $_GET[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$$k = $_POST[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}

	// retrieve blocks of BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationConfirmBlock( $item_id );
	$simulator_type = strtolower($simulator_type);
	$simulator_types = xnpsimulator_get_type_array( );
/*
	$detail = array( 'simulator_type' => array( 'value' => $simulator_type,
										   'display_value' => $myts->htmlspecialchars( $simulator_types[$simulator_type] ) ),
					 'developer' => array( 'value' => xnpHtmlspecialchars( $developer ) ));
*/
	$detail = array( 'simulator_type' => array( 'value' => $simulator_type,
										   'display_value' => $simulator_types[$simulator_type] ),
					 'developer' => array( 'value' => $developer ));
/*	if( isset( $simulator_date ) ) {
		$detail['simulator_date'] = array( 'value' => mktime( 0, 0, 0,
														 $simulator_date['Date_Month'],
														 $simulator_date['Date_Day'], $simulator_date['Date_Year'] ) );
	} else {
		$detail['simulator_date'] = array( 'value' => time( ) );
	}
*/

	xnpConfirmHtml( $detail, 'xnpsimulator_item_detail', array_keys( $detail ), _CHARSET );
	$preview = xnpGetPreviewConfirmBlock( $item_id );
	$attachment = xnpGetAttachmentConfirmBlock( $item_id, 'simulator_data' );
	$index = xnpGetIndexConfirmBlock( $item_id );
	$lengths = xnpGetColumnLengths('xnpsimulator_item_detail');
	$readme = xnpGetTextFileConfirmBlock( $item_id, 'readme', $lengths['readme'] );
	$rights = xnpGetRightsConfirmBlock( $item_id, $lengths['rights'] );

	if ( xnpHasWithout( $basic ) || xnpHasWithout( $detail ) || xnpHasWithout( $preview ) 
	  || xnpHasWithout( $attachment ) || xnpHasWithout( $readme ) || xnpHasWithout( $rights ) ){
		global $system_message;
		$system_message = $system_message."\n<br /><font color='#ff0000'>" . _MD_XOONIPS_ITEM_WARNING_FIELD_TRIM . "</font><br />";
	}
	
	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionConfirmBlock( 'xnpsimulator' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	if( isset( $simulator_date ) ){
		$tpl->assign( 'simulator_date', $simulator_date );
		if( $simulator_date['Date_Year'] )
			$tpl->assign( 'system_message', $tpl->get_template_vars( 'system_message' )
						  ."<br/><font color='#ff0000'>"._MD_XOONIPS_ITEM_TITLE_REQUIRED."</font>" );
	}
	
	// return HTML content
	return $tpl->fetch( "db:xnpsimulator_confirm_block.html" );
}

function
xnpsimulatorInsertItem( )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// retister BasicInformation, Index and Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if( $result ) {
		$result = xnpUpdateIndex( $item_id );
		if( $result ) {
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
                $result = xnpUpdateAttachment( $item_id, 'simulator_data' );
                if( $result ) {
                }
            }
		}
		if( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if( !$result )
		return false;

	// register detail information
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	
	// it makes string with constant length
	$myts =& MyTextSanitizer::getInstance();
	$ar = array(
		'simulator_type' =>$myts->stripSlashesGPC($_POST['simulator_type'  ]),
		'developer'      =>$myts->stripSlashesGPC($_POST['developer'  ]),
		'readme'         =>$myts->stripSlashesGPC(xnpGetTextFile( 'readme' )),
		'rights'         =>$rights,
	);
	xnpTrimColumn( $ar, 'xnpsimulator_item_detail', array_keys( $ar ), _CHARSET );
	
	$simulator_date = $_POST['simulator_date'];

	$myts =& MyTextSanitizer::getInstance( );
	$keys = implode( ",", array( 'simulator_type', 'developer', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification', 'attachment_dl_limit' ) );
	$vals = implode( "','", array( addslashes( $ar['simulator_type'] ),
								   addslashes( $ar['developer'     ] ),
								   addslashes( $ar['readme'        ] ),
								   addslashes( $ar['rights'        ] ),
								   $use_cc, $cc_commercial_use, $cc_modification, 
								   $myts->addSlashes( $_POST['attachment_dl_limit'] )
					  ) );

	$sql = "insert into ".$xoopsDB->prefix( "xnpsimulator_item_detail" )." ( simulator_id, $keys ) values ( $item_id, '$vals' ) ";
	$result = $xoopsDB->queryF( $sql );
	if( $result == false ) {
		echo "cannot insert item_detail: ".$xoopsDB->error();
		return false;
	}

	return true;
}

function
xnpsimulatorUpdateItem( $simulator_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance( );

	// modify BasicInformation, Index, Preview and Attachment.
	$result = xnpUpdateBasicInformation( $simulator_id );
	if( $result ) {
		$result = xnpUpdateIndex( $simulator_id );
		if( $result ) {
			$result = xnpUpdatePreview( $simulator_id );
			if ( $result ){
                $result = xnpUpdateAttachment( $simulator_id, 'simulator_data' );
                if( $result ) {
                    $result = xnp_insert_change_log( $xnpsid, $simulator_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
                    $result = !$result;
                    if( !$result )
                        echo " xnp_insert_change_log failed.";
                } else
                    echo " xnpUpdateAttachment failed.";
			}
			else echo " xnpUpdatePreview failed.";
		} else
			echo " xnpUpdateIndex failed.";
	} else
		echo " xnpUpdateBasicInformation failed.";
	if( !$result )
		return false;

	$simulator_date = $_POST['simulator_date'];
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	
	// it makes string with constant length
	$myts =& MyTextSanitizer::getInstance();
	$ar = array(
		'simulator_type' =>$myts->stripSlashesGPC($_POST['simulator_type'  ]),
		'developer'      =>$myts->stripSlashesGPC($_POST['developer'       ]),
		'readme'         =>$myts->stripSlashesGPC(xnpGetTextFile( 'readme' )),
		'rights'         =>$rights,
	);
	xnpTrimColumn( $ar, 'xnpdata_item_detail', array_keys( $ar ), _CHARSET );
	$keyval = array( "simulator_type='".addslashes( $ar['simulator_type'] )."'",
					 "developer='"     .addslashes( $ar['developer'     ] )."'",
					 "readme='"        .addslashes( $ar['readme'        ] )."'",
					 "rights='"        .addslashes( $ar['rights'        ] )."'",
					 "use_cc='"           .$use_cc           ."'",
					 "cc_commercial_use='".$cc_commercial_use."'",
					 "cc_modification='" .$cc_modification ."'",
					 "attachment_dl_limit='".$myts->addSlashes( $_POST['attachment_dl_limit'] )."'" );

	// modify detail information
	$myts =& MyTextSanitizer::getInstance( );
	$sql = "update ".$xoopsDB->prefix( "xnpsimulator_item_detail" )
		." set ".implode( ", ", $keyval )
		." where simulator_id=$simulator_id";
	$result = $xoopsDB->queryF( $sql );
	if( $result == false ) {
		echo "cannot update item_detail";
		echo "\n$sql";
		return false;
	}

	return true;
}

function
xnpsimulatorDeleteItem( $simulator_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// remove BasicInformation, Index, Preview and Attachment.
	if( !xnpDeleteBasicInformation( $simulator_id ) ) {
		echo "cannot delete simulator item";
		return false;
	}
	// remove detail information
	$sql = "delete from ".$xoopsDB->prefix( "xnpsimulator_item_detail" )
		." where simulator_id=$simulator_id";
	$xoopsDB->queryF( $sql );
	return true;
}




function
xnpsimulatorGetSearchBlock( $item_id )
{
	// todo: details to be defnied
}

function
xnpsimulatorCheckRegisterParameters( &$msg )
{
	$xnpsid = $_SESSION['XNPSID'];
	$result = true;
	if( $_POST['developer'] == '' ) {
		//developer is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPSIMULATOR_DEVELOPER_REQUIRED."</font>";
		$result = false;
	}
	if( (empty($_FILES['simulator_data']) || $_FILES['simulator_data']['name'] == '') && $_POST['simulator_dataFileID'] == '' ) {
		//simulator_data is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPSIMULATOR_SIMULATOR_DATA_REQUIRED."</font>";
		$result = false;
	}
	// notify that license statement is required when register into public indexes.
	$xids = explode( ',', $_POST['xoonipsCheckedXID'] );
	$indexes = array( );
	if( $xids[0] != $_POST['xoonipsCheckedXID'] ) {
		foreach( $xids as $i ) {
			$index = array( );
			if( xnp_get_index( $xnpsid, $i, $index ) == RES_OK ) {
				$indexes[] = $index;
			} else {
				$msg = $msg."<br/><font color='#ff0000'>".xnp_get_last_error_string( )."</font>";
				$result = false;
				break;
			}
		}
	}
	if( count( $indexes ) > 0 ) {
		foreach( $indexes as $i ) {
			if( $i['open_level'] <= OL_GROUP_ONLY ) {
				if( $_POST['readmeEncText'] == '' ) {
					//readme is not filled
					$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPSIMULATOR_README_REQUIRED."</font>";
					$result = false;
				}
				if( $_POST['rightsEncText'] == '' && $_POST['rightsUseCC'] == '0' ) {
					//license is not filled
					$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPSIMULATOR_RIGHTS_REQUIRED."</font>";
					$result = false;
				}
				break;
			}
		}
	}
	return $result;
}

function
xnpsimulatorCheckEditParameters( &$msg )
{
	return xnpsimulatorCheckRegisterParameters( $msg );
}

function
xnpsimulatorGetMetaInformation( $item_id )
{
	$ret = array( );
	$basic = xnpGetBasicInformationArray( $item_id );
	$detail = xnpsimulatorGetDetailInformation( $item_id );

	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = implode( "\n", $basic['titles'] );
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = implode( "\n", $basic['keywords'] );
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
/*
		$ret[_MD_XNPSIMULATOR_DATE_LABEL] =
			date( DATE_FORMAT,
				  mktime( 0, 0, 0, $basic['publication_month'], $basic['publication_mday'], $basic['publication_year'] ) );
*/
		$ret[_MD_XNPSIMULATOR_DATE_LABEL] = xnpDate($basic['publication_year'], $basic['publication_month'], $basic['publication_mday']);
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPSIMULATOR_SIMULATOR_TYPE_LABEL] = $detail['simulator_type']['display_value'];
		$ret[_MD_XNPSIMULATOR_DEVELOPER_LABEL] = $detail['developer']['value'];
		$ret[_MD_XOONIPS_ITEM_README_LABEL] = $detail['readme']['value'];
		$ret[_MD_XOONIPS_ITEM_RIGHTS_LABEL] = $detail['rights']['value'];
	}
	return $ret;
}

function
xnpsimulatorGetAdvancedSearchBlock( &$search_var )
{

	$basic = xnpGetBasicInformationAdvancedSearchBlock( 'xnpsimulator', $search_var );

	$search_var[] = 'xnpsimulator_simulator_type';
	$search_var[] = 'xnpsimulator_developer';
	$search_var[] = 'xnpsimulator_caption';

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpsimulator' );
	$simulator_type = xnpsimulator_get_type_array( );
	$tpl->assign( 'simulator_type_option', $simulator_type );
	$types = array( );
	if( xnp_get_item_types( $types ) == RES_OK ) {
		foreach( $types as $i ) {
			if( $i['name'] == 'xnpsimulator' ) {
				$tpl->assign( 'module_display_name', $i['display_name'] );
			}
		}
	} else {
		$tpl->assign( 'module_display_name', 'xnpsimulator' );
	}

	// return HTML content
	return $tpl->fetch( "db:xnpsimulator_search_block.html" );
}

function
xnpsimulatorGetAdvancedSearchQuery( &$where, &$join )
{
	global $xoopsDB;
	$simulator_table = $xoopsDB->prefix( 'xnpsimulator_item_detail' );
	$file_table = $xoopsDB->prefix( 'xoonips_file' );

	$wheres = array( );
	$joins = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery( 'xnpsimulator' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $simulator_table.'.simulator_type', 'xnpsimulator_simulator_type' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $simulator_table.'.developer', 'xnpsimulator_developer' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $file_table.'.caption', 'xnpsimulator_caption' );
	if( $w ){
		$wheres[] = $w;
		$wheres[] = " $file_table.file_type_id = 1";
	}
	$where = implode( ' and ', $wheres );
	$join = "";
}

function
xnpsimulatorGetDetailInformationQuickSearchQuery( &$wheres, &$join, $keywords )
{
	global $xoopsDB;
	$simulator_table = $xoopsDB->prefix( 'xnpsimulator_item_detail' );
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$colnames = array( "$simulator_table.developer", "$file_table.caption" );
	$wheres = xnpGetKeywordsQueries( $colnames, $keywords );
	return true;
}

function
xnpsimulatorGetDetailInformationTotalSize( $iids ){
	return xnpGetTotalFileSize( $iids );
}

function xnpsimulatorGetLicenseRequired( $item_id )
{
	global $xoopsDB;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpsimulator_item_detail" )." where simulator_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['rights'] ) && $detail['rights'] != '';
}

function xnpsimulatorGetLicenseStatement( $item_id )
{
	global $xoopsDB;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpsimulator_item_detail" )." where simulator_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return array( isset( $detail['rights'] ) ? $detail['rights'] : '', $detail['use_cc'] );;
}

/**
 * 
 * ƥDetailInformatinoExportXML
 * 
 * export_pathξܺ٤xnpExportItem򻲾
 * @see xnpExportItem
 * 
 * @param export_path Exportե¸ե
 * @param fhdl ̤񤭽Фեϥɥ
 * @param item_id ExportƥID
 * @param attachment źեե롦եExportȤtrue̤false
 * @return true:false:
 */
function xnpsimulatorExportItem( $export_path, $fhdl, $item_id, $attachment )
{
	global $xoopsDB;

    if( !$fhdl ) return false;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpsimulator_item_detail" )." where simulator_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    if( !fwrite( $fhdl, "<detail id=\"${item_id}\" version=\"1.01\">\n"
        ."<simulator_type>".xnpHtmlspecialchars( $detail['simulator_type'], ENT_QUOTES )."</simulator_type>\n"
        ."<developer>".xnpHtmlspecialchars( $detail['developer'], ENT_QUOTES )."</developer>\n"
        ."<readme>".xnpHtmlspecialchars( $detail['readme'], ENT_QUOTES )."</readme>\n"
        ."<rights>".xnpHtmlspecialchars( $detail['rights'], ENT_QUOTES )."</rights>\n"
        ."<use_cc>"           .$detail['use_cc']           ."</use_cc>\n"
        ."<cc_commercial_use>".$detail['cc_commercial_use']."</cc_commercial_use>\n"
        ."<cc_modification>"  .$detail['cc_modification']  ."</cc_modification>\n"
        ."<attachment_dl_limit>".$detail['attachment_dl_limit']."</attachment_dl_limit>\n" ) ) return false;
    if( !( $attachment ? xnpExportFile( $export_path, $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;
    
    return true;
}

function xnpsimulatorStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/SIMULATOR_TYPE":
    case "/ITEM/DETAIL/DEVELOPER": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
//    echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnpsimulatorEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
//        print_r( $parser_hash['detail'] );
        $keys = implode( ",", array( 'simulator_type', 'developer', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification' ) );
/*
        $vals = implode( "','", array( $myts->addSlashes( $parser_hash['detail']['SIMULATOR_TYPE'] ),
                                       $myts->addSlashes( $parser_hash['detail']['DEVELOPER'] ),
                                       addslashes( $parser_hash['detail']['README'] ),
                                       addslashes( $parser_hash['detail']['RIGHTS'] ),
                                       (int)$parser_hash['detail']['USE_CC'],
                                       (int)$parser_hash['detail']['CC_COMMERCIAL_USE'],
                                       (int)$parser_hash['detail']['CC_MODIFICATION'],
            ) );
*/
        $vals = implode( "','", array( $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['SIMULATOR_TYPE'] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['DEVELOPER'] ) ),
                                       addslashes( encodeClient2Server( $parser_hash['detail']['README'] ) ),
                                       addslashes( encodeClient2Server( $parser_hash['detail']['RIGHTS'] ) ),
                                       (int)$parser_hash['detail']['USE_CC'],
                                       (int)$parser_hash['detail']['CC_COMMERCIAL_USE'],
                                       (int)$parser_hash['detail']['CC_MODIFICATION'],
            ) );
        
        // register detail information
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpsimulator_item_detail" )." ( simulator_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n $sql";
            return false;
        }
        break;
    }
//    echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnpsimulatorCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/SIMULATOR_TYPE":
    case "/ITEM/DETAIL/DEVELOPER": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
//    echo($data); 
}

function xnpsimulatorGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpsimulatorStartElement", "xnpsimulatorEndElement", "xnpsimulatorCharacterData" ) );
}

function xnpsimulatorCheckItemLengthEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $lengths = xnpGetColumnLengths( 'xnpsimulator_item_detail' );
        
        $values = array(
          'simulator_type' => encodeClient2Server( $parser_hash['detail']['SIMULATOR_TYPE'] ),
          'developer'      => encodeClient2Server( $parser_hash['detail']['DEVELOPER'     ] ),
          'readme'         => encodeClient2Server( $parser_hash['detail']['README'        ] ),
          'rights'         => encodeClient2Server( $parser_hash['detail']['RIGHTS'        ] ),
        );
        $names = array(
          'simulator_type' => _MD_XNPSIMULATOR_SIMULATOR_TYPE_LABEL   ,
          'developer'      => _MD_XNPSIMULATOR_DEVELOPER_LABEL,
          'readme'         => _MD_XOONIPS_ITEM_README_LABEL ,
          'rights'         => _MD_XOONIPS_ITEM_RIGHTS_LABEL ,
        );
        foreach ( $values as $key => $value ){
            if ( strlen($value) > $lengths[$key] ){
                list( $within, $without ) = xnpTrimString( $value, $lengths[$key], 'UTF-8' );
                $parser_hash['exceeds'][$key] = array( 'within' => $within, 'without' => $without, 'name' => $names[$key], 'value' => nl2br(xnpWithinWithoutHtml( $within, $without )) );
            }
        }
        break;
    }
}

function xnpsimulatorGetCheckItemLengthHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpsimulatorStartElement", "xnpsimulatorCheckItemLengthEndElement", "xnpsimulatorCharacterData" ) );
}

function xnpsimulatorGetModifiedFields( $item_id )
{
    $ret = array();
    $basic = xnpGetBasicInformationArray($item_id);
    if( $basic ){
        if( mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year'] )
            != mktime(0,0,0,$_POST['publicationDateMonth'],$_POST['publicationDateDay'],$_POST['publicationDateYear']) )
            array_push( $ret, _MD_SIMULATOR_DATE_LABEL );
    }
    $detail = xnpsimulatorGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'simulator_type' => _MD_XNPSIMULATOR_SIMULATOR_TYPE,
                        'developer' => _MD_XNPSIMULATOR_DEVELOPER ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ][ 'value' ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        //is readme modified ?
        foreach( array( 'readme' => _MD_XOONIPS_ITEM_README_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( "${k}EncText", $_POST ) ) continue;
            if( urldecode($_POST[ "${k}EncText" ]) != $detail[ $k ][ 'value' ] ) array_push( $ret, $v );
        }
        
        //is rights modified ?
        if( array_key_exists( 'rightsUseCC', $_POST ) ){
            if( $_POST['rightsUseCC'] == 0 ){
                if( !array_key_exists( 'rights', $detail )
                    || !array_key_exists( "rightsEncText", $_POST ) ) continue;
                if( urldecode($_POST[ "rightsEncText" ]) != $detail[ 'rights' ][ 'value' ] ) array_push( $ret, _MD_XOONIPS_ITEM_RIGHTS_LABEL );
            }else if( $_POST['rightsUseCC'] == 1 ){
                foreach( array( 'rightsCCCommercialUse' => 'cc_commercial_use',
                                'rightsCCModification'  => 'cc_modification' ) as $k => $v ){
                    if( !array_key_exists( $v, $detail ) || !array_key_exists( $k, $_POST ) ) continue;
                    if( $_POST[ $k ] != $detail[ $v ][ 'value' ] ){
                        array_push( $ret, _MD_XOONIPS_ITEM_RIGHTS_LABEL );
                        break;
                    }
                }
            }
        }
        
        // is modified data files ?
        if( xnpIsAttachmentModified( 'simulator_data', $item_id ) ){
            array_push( $ret, _MD_XNPSIMULATOR_SIMULATOR_FILE );
        }
    }
    return $ret;
}

function xnpsimulatorGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_simulator.gif', _MD_XNPSIMULATOR_EXPLANATION, 'xnpsimulator_simulator_type', xnpsimulator_get_type_array() );
}


//return 1 if downloadable for login user only
//return 0 if downloadable for everyone
function xnpsimulatorGetAttachmentDownloadLimitOption( $item_id )
{
	global $xoopsDB;
    $sql = "select attachment_dl_limit from ".$xoopsDB->prefix( "xnpsimulator_item_detail" )." where simulator_id=${item_id}";
    $result = $xoopsDB->query( $sql );
    if( $result ){
        list( $option ) = $xoopsDB->fetchRow( $result );
        return $option;
    }
    return 0;
}

function xnpsimulatorSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii'  || $metadataPrefix == 'junii2' ) return true;
    return false;
}

function xnpsimulatorGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
        $detail = xnpsimulatorGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(22)."</type>";
            $lines[] = "<type>simulatorType:".xnpHtmlspecialchars($detail['simulator_type']['value'])."</type>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['developer']['value'])."</creator>";
            $lines[] = "<date xsi:type=\"ISO8601\">".xnpISO8601($basic['publication_year'], $basic['publication_month'], $basic['publication_mday'])."</date>";
            $lines[] = "<description>readme:".xnpHtmlspecialchars($detail['readme']['value'])."</description>";
            $lines[] = "<description>rights:".xnpHtmlspecialchars($detail['rights']['value'])."</description>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if( $metadataPrefix == 'junii2' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii2.xsd">';
            $lines[] = $meta_basic;
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii2(30)."</type>";
            $lines[] = "<type>simulatorType:".xnpHtmlspecialchars($detail['simulator_type']['value'])."</type>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['developer']['value'])."</creator>";
            $lines[] = "<date xsi:type=\"ISO8601\">".xnpISO8601($basic['publication_year'], $basic['publication_month'], $basic['publication_mday'])."</date>";
            $lines[] = "<description>readme:".xnpHtmlspecialchars($detail['readme']['value'])."</description>";
            $lines[] = "<description>rights:".xnpHtmlspecialchars($detail['rights']['value'])."</description>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
			$lines[] = "<dc:type>simulatorType:".xnpHtmlspecialchars($detail['simulator_type']['value'])."</dc:type>";
			$lines[] = "<dc:creator>".xnpHtmlspecialchars($detail['developer']['value'])."</dc:creator>";
			$lines[] = "<dc:date>".xnpISO8601($basic['publication_year'], $basic['publication_month'], $basic['publication_mday'])."</dc:date>";
			$lines[] = "<dc:rights>".xnpHtmlspecialchars($detail['rights']['value'])."</dc:rights>";
			$lines[] = "<dc:description>readme:".xnpHtmlspecialchars($detail['readme']['value'])."</dc:description>";
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}

function xnpsimulatorCreateXooNIpsItem(){
    return new XooNIpsSimulator();
}
?>
