<?php
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/item.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/attachment.php";

class XooNIpsUrl extends XooNIpsItem{

    function XooNIpsUrl(){
        parent::XooNIpsItem();
        
        $this->columnLengths = $lengths = $this->getColumnMaxLen( 'xnpurl_item_detail' );
        $this->initVar('detail_url', XOBJ_DTYPE_TXTBOX, null, false, $lengths['url']);
        $this->initVar('url_banner_file' , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->attachment_info = array(
            'url_banner_file' => array( 'multiple' => false ),
        );
    }
    
    function cleanVars()
    {
        if ( !parent::cleanVars() )
            return false;
        
        $vals = array(
            'url'=> $this->getVar('detail_url','n'),
        );
        $ar = $this -> stripSurplusString( $this->columnLengths, $vals );
        foreach ( $vals as $key => $val ){
            if ( isset( $ar[$key] ) ){
                $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $key is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $this->cleanVars['detail_'.$key] = $ar[$key];
                $retval = false;
            }
            else
                $this->cleanVars['detail_'.$key] = $val;
        }
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            if ( !$info['multiple'] && count($attachments) > 1 ){
                $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $retval = false;
            }
            for ( $i = 0; $i < count($attachments); $i++ )
                if ( !$attachments[$i]->cleanVars() )
                    $retval = false;
            $this->setVar($name, serialize($attachments));
        }
        
        return true;
    }

    /**
     * 
     * for attachment file
     * 
     */
    var $file = null;
    var $attachment_info;
    
    // for column length check
    var $columnLengths;
    
    function startElement($parser, $name, $attribs){
        global $xoopsDB;
        
        parent::startElement($parser, $name, $attribs);

//            echo "\nS ".implode( '/', $this -> tagstack )."\tattributes=";print_r($attribs);
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            foreach ( $this->attachment_info as $name => $info )
                $this->setVar( $name, serialize(array()), true );
            break;
        case "ITEM/DETAIL/FILE":
            $result = $xoopsDB -> query( "select value from " . $xoopsDB -> prefix( "xoonips_config" ) . " where name='upload_dir'" );
            if( $result ){
                list( $upload_dir ) = $xoopsDB -> fetchRow( $result );
                $this -> file = new XooNIpsAttachment( $this -> attachment_dir, $upload_dir );
            }else{
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
            }
            break;
        }

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> startElement( $parser, $name, $attribs );
        }
    }

    function endElement($parser, $name) { 
        global $xoopsDB;
        

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> endElement( $parser, $name );
        }

        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            $keys = array(
                'url',
            );
            foreach ( $keys as $key )
                if ( is_null($this->getVar('detail_'.$key,'n')) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no $key tag " . $this -> getParserErrorAt( $parser ) );
            break;
        case "ITEM/DETAIL/URL": 
            $this -> setVar( 'detail_url' , encodeMeta2Server( end( $this -> cdata ) ), true );
            break;
        case "ITEM/DETAIL/FILE":
            if( isset( $this -> file ) ){
                $file_type_id = $this->file->getVar('file_type_id');
                if ( $file_type_id ){
                    $sql = "select name from " . $xoopsDB->prefix('xoonips_file_type') . " where file_type_id=$file_type_id";
                    $result = $xoopsDB->query( $sql );
                    if ( $result ){
                        if ( $xoopsDB->getRowsNum($result) ){
                            list( $name ) = $xoopsDB->fetchRow( $result );
                            if ( isset( $this->attachment_info[$name]) ){
                                $info = $this->attachment_info[$name];
                                $attachments = $this->getVar($name);
                                if ( count( $attachments ) && !$info['multiple'] )
                                    $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getParserErrorAt( $parser ) );
                                $attachments[] = $this->file;
                                $this -> setVar( $name, serialize( $attachments ), true );
                                break;
                            }
                            else 
                                $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_name($name) " . $this -> getParserErrorAt( $parser ) );
                        }
                        else
                            $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_id($file_type_id) " . $this -> getParserErrorAt( $parser ) );
                    }
                    else
                        $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
                }
                else
                    $this -> setErrors( E_XOONIPS_ATTR_NOT_FOUND, " no file_type_id " . $this -> getParserErrorAt( $parser ) );
                
                // include $this->file->_error, error_codes
                $errors = $this->file->getErrors();
                $codes = $this->file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
            }
            break;
        }

        parent::endElement($parser, $name);
    }
    
    function characterData($parser, $data) {
        
        parent::characterData($parser, $data);

//        echo "\nC ".implode( '/', $this -> tagstack )."\t${data}";
        switch( implode( '/', $this -> tagstack ) ){
/*
        case "ITEM/DETAIL/TAGNAME":
            ....... 
            break;
*/
        }
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> characterData( $parser, $data );
        }
    }
    
    /**
     * insert/update object
     *
     */
    function insert()
    {
        global $xoopsDB;
        
        if ($this->isNew()) {
            if( !parent::insert() ) return false;
            $keys = implode( ",", array(
                'url_id'           ,
                'url'              ,
            ) );
            $vals = implode( ",", array(
                $this -> getVar( 'item_id' ),
                $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_url'        ] ),
                ) );
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnpurl_item_detail") . " ( $keys ) VALUES ( $vals ) ";
        } else {
            if( !parent::insert() ) return false;
            $item_id = $this->getVar('item_id');
            $keyval = implode( ', ', array(
                 'url'               . '=' . ( is_null( $this -> cleanVars[ 'detail_url'        ] ) ? "''" : $xoopsDB -> quoteString( $this -> cleanVars[ 'detail_url'        ] ) ),
            ));
            $sql = "UPDATE " . $xoopsDB->prefix("xnpurl_item_detail") . " set $keyval where url_id=$item_id";
        }
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // remove old attachment information 
        $item_id = $this->getVar('item_id');
        $sql = "select file_id from " . $xoopsDB->prefix('xoonips_file') . " where item_id=$item_id";
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        while ( list($file_id) = $xoopsDB->fetchRow($result) ){
            $file = new XooNIpsAttachment(null,null);
            $file->setVar('item_id', $item_id);
            $file->setVar('file_id',$file_id);
            if ( !$file->delete() ){
                // include $file->_error, error_codes
                $errors = $file->getErrors();
                $codes = $file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
                return false;
            }
        }
        
        // register attachment files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i] -> setVar( 'item_id', $this -> getVar( 'item_id' ) );
                if ( !$attachments[$i] -> insert() ){
                    @$this -> delete();
                    // 
                    // before return false, set attachments array to keep error message of attachment object
                    // 
                    $this->setVar( $name, serialize($attachments) );
                    return false;
                }
            }
            $this->setVar( $name, serialize($attachments) );
        }
        
        if( $this -> isNew() ){
            $this -> unsetNew();//item is not new because it was inserted
        }
        return true;
    }
    
    /**
     * delete an item from the database
     * 
     * @return false if failed.
     */
    function delete(){
        global $xoopsDB;
        
        if( !parent::delete() ) return false;
        
        
        $sql = sprintf( "DELETE FROM %s WHERE url_id = %u", $xoopsDB->prefix( "xnpurl_item_detail" ), $this -> getVar( 'url_id' ) );
        $result = $xoopsDB->query( $sql );
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // delete files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i]->delete();
            }
        }
        
        return true;
    }
    
    function getErrors(){
        $ar = parent::getErrors();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrors() );
            }
        }
        return $ar;
    }
    
    function getErrorCodes(){
        $ar = parent::getErrorCodes();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrorCodes() );
            }
        }
        return $ar;
    }
    
    function toString( $htmlspecialchars = false ){
        $ar = array( parent::toString( $htmlspecialchars ) );
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar[] = $attachments[$i] -> toString($htmlspecialchars);
            }
        }
        
        foreach ( $this->columnLengths as $key => $dummy ){
            if ( $key == 'url_id' ) continue;
            $val = $this->getVar($key,'n');
            if( extension_loaded( 'mbstring' ) ){
                $val = mb_ereg_replace( '\n', '\n', mb_ereg_replace( '\\\\', '\\\\', $val ) );
            }else{
                $val = str_replace( array( "\\", "\n" ), array( "\\\\", "\\n" ), $val );
            }
            $ar[] = "detail.$key " . ( $htmlspecialchars ? htmlspecialchars($val) : $val );
        }
        
        return implode( "\n", $ar );
    }
    
}
?>
