<?php
// $Id: pickup.php,v 1.12 2006/09/29 06:03:00 makotonton Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
//  Project: The XOOPS Project                                               //
//  URL: http://sourceforge.jp/projects/xoonips/                             //
// ------------------------------------------------------------------------- //

$xoopsOption['pagetype'] = "user";

include "../../../mainfile.php";
include XOOPS_ROOT_PATH."/include/cp_functions.php";
if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/".$xoopsConfig['language']."/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/".$xoopsConfig['language']."/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}
include_once XOOPS_ROOT_PATH."/class/xoopsmodule.php";

if (file_exists(XOOPS_ROOT_PATH."/modules/system/language/".$xoopsConfig['language']."/admin/users.php")) {
	include XOOPS_ROOT_PATH."/modules/system/language/".$xoopsConfig['language']."/admin/users.php";
} elseif (file_exists(XOOPS_ROOT_PATH."/modules/system/language/english/admin/users.php")) {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin/users.php";
}

if (is_object($xoopsUser)) {
	$xoopsModule =& XoopsModule::getByDirname("system");
	if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
		redirect_header(XOOPS_URL."/",3,_NOPERM);
		exit();
	}
	$admintest=1;
} else {
	redirect_header(XOOPS_URL."/",3,_NOPERM);
	exit();
}

include_once XOOPS_ROOT_PATH."/modules/system/constants.php";

if ( !is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
	exit("Access Denied");
}

foreach( array( 'op' => 'mod_users',
                'uids' => null ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

// configuration for XooNIps
require_once '../condefs.php';
require_once '../include/lib.php';
require_once '../include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

// add XOOPS user to XooNIps ( uncertified ).
function add_user_to_xoonips( $uids )
{
	global $xoopsDB;
	$xnp_users = $xoopsDB->prefix('xoonips_users');
	
	foreach( array( 'private_item_number_limit', 'private_index_number_limit', 'private_item_storage_limit' ) as $k ){
		$val = '';
		if( xnp_get_config_value( $k, $val ) == RES_OK ){
			$$k = $val;
		}
	}
	
	// position value = Registered Users
	$posi = '';
	$potab = $xoopsDB -> prefix("xoonips_positions");
	$posql = "SELECT posi_id FROM ".$potab." WHERE posi_title='Registered Users'";
	$pores = $xoopsDB -> query( $posql );
	// there is no title 'Registered Users' in xoonips_positions => posi = 0
	if ( $pores == FALSE ){
		echo "ERROR: SQL=$posql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
	}
	$po = $xoopsDB -> fetchArray( $pores );
	$posi = intval( $po['posi_id'] );

    foreach( $uids as $uid ){
    	$result = $xoopsDB->queryF( "insert into $xnp_users ( uid, activate, private_item_number_limit, private_index_number_limit, private_item_storage_limit, posi ) values ( $uid, 0, ${private_item_number_limit}, ${private_index_number_limit}, ${private_item_storage_limit}, $posi )" );
	    if ( $result == FALSE ){
		    echo "ERROR: SQL=$sql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
    		redirect_header("pickup.php",2,_MD_XOONIPS_ACCOUNT_QUERY_ERROR);
	    }
		// Record events (request insert account)
		xnp_insert_event( XNPSID_GUEST, ETID_REQUEST_INSERT_ACCOUNT, time(), UID_GUEST, xnpGetRemoteHost(), array( 'uid' => $uid ) );
    }
}	

switch ($op) {
case "addUserToXooNIps":
    if( count( $uids ) == 0 ) break;
    
    add_user_to_xoonips( $uids );
	
	global $xoopsDB;
	$x_users = $xoopsDB->prefix('users');
	$x_groups = $xoopsDB->prefix('groups');
	$xnp_users = $xoopsDB->prefix('xoonips_users');
	$xnp_item_basic = $xoopsDB->prefix('xoonips_item_basic');
	$xnp_index = $xoopsDB->prefix('xoonips_index');
	$xnp_groups = $xoopsDB->prefix('xoonips_groups');
	$xnp_item_title = $xoopsDB->prefix('xoonips_item_title');
	
	// Add private index. (in case the user has no private index)
	$max_int = 2147483647;
	$result = $xoopsDB->queryF(  
		"select tu.uid, uname ".
		" from $x_users as tu ".
		" left join $xnp_users as tnu on tnu.uid=tu.uid ".
		" left join $xnp_item_basic as ti on ti.item_id = tnu.private_index_id ".
		" left join $xnp_index as tx on tx.index_id = tnu.private_index_id ".
		" where ( private_index_id is NULL or private_index_id = 0 or tx.index_id is NULL )".
        " and tu.uid in ( ". implode( ',', $uids ) ." )" );
	if ( $result == FALSE ){
		echo "ERROR: SQL=$sql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
		redirect_header("pickup.php",2,_MD_XOONIPS_ACCOUNT_QUERY_ERROR);
        return;
	}
	while ( list( $uid, $uname ) = $xoopsDB->fetchRow( $result ) ){
		$result2 = $xoopsDB->queryF( "select min(sort_number-1) from $xnp_index where parent_index_id=1 and open_level = 3 " );
        if ( $result2 == FALSE ){
            echo "ERROR: SQL=$sql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
            redirect_header("pickup.php",2,_MD_XOONIPS_ACCOUNT_QUERY_ERROR);
            return;
        }
		list( $sort_number ) = $xoopsDB->fetchRow( $result2 );
		if ( $sort_number < 1 )
			$sort_number = $max_int-1;
		$xoopsDB->queryF( "insert into $xnp_item_basic (item_type_id, uid, title, creation_date) values (1,$uid,'$uname',unix_timestamp(now()))" );
		$xid = mysql_insert_id();
		$xoopsDB->queryF( "insert into $xnp_index (index_id, parent_index_id, uid, gid, open_level, sort_number) values ($xid,1,$uid,NULL,3,$sort_number)" );
		$xoopsDB->queryF( "update $xnp_users set private_index_id = $xid where uid = $uid " );
		//echo " private index ($uid,$uname) created<br />\n";
		//add data to item_title
		$xoopsDB->query( "insert into $xnp_item_title (item_id, title) values ($xid, '$uname')" );
	}
	// Add group index. (in case the user has no group index)
	$result = $xoopsDB->queryF(
        "select tg.gid, tg.gname ".
		" from $xnp_groups as tg ".
		" left join $xnp_index as tx on tg.group_index_id = tx.index_id ".
		" where group_index_id is NULL or group_index_id = 0 or tx.index_id is NULL" );
	if ( $result == FALSE ){
		echo "ERROR: SQL=$sql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
		redirect_header("pickup.php",2,_MD_XOONIPS_ACCOUNT_QUERY_ERROR);
        return;
	}
	while ( list( $gid, $gname ) = $xoopsDB->fetchRow( $result ) ){
		$result2 = $xoopsDB->queryF( "select max(sort_number)+1 from $xnp_index where parent_index_id=1 and open_level in ( 1, 2 )" );
		list( $sort_number ) = $xoopsDB->fetchRow( $result2 );
		$xoopsDB->queryF( "insert into $xnp_item_basic (item_type_id, uid, title, creation_date) values (1,1,'$gname',unix_timestamp(now()))" );
		$xid = mysql_insert_id();
		$xoopsDB->queryF( "insert into $xnp_index (index_id, parent_index_id, uid, gid, open_level, sort_number) values ($xid,1,NULL,$gid,2,$sort_number)" );
		$xoopsDB->queryF( "update $xnp_groups set group_index_id = $xid where gid = $gid " );
		//echo " group index ($gid,$gname) created<br />\n";
		//add data to item_title
		$xoopsDB->query( "insert into $xnp_item_title (item_id, title) values ($xid, '$gname')" );
	}

	// insert uid into xoonips_item_show
	$isql = "SELECT item_id FROM ".$xoopsDB->prefix('xoonips_item_status')."";
	$ires = $xoopsDB->query($isql);
		if(!$ires){
			$err = "Can't select data from database.";
		}
		if($ires == FALSE){
			echo "ERROR: SQL=$isql<br />\n error=" . $xoopsDB->error() . "<br />\n";
		}
		$ins_iids = array();
		while( $irow = $xoopsDB->fetchArray($ires) ){
			$ins_iids[] = intval( $irow['item_id'] );
		}
		if( !empty( $ins_iids ) ){
			foreach( $ins_iids as $itemnum => $itid ){
				foreach( $uids as $uidnum => $uid ){
					$ins_sql = "INSERT INTO ".$xoopsDB->prefix('xoonips_item_show')." (item_id, uid) VALUES (".$itid.", ".$uid.")";
					$ins_res = $xoopsDB->query($ins_sql);
					if(!$ins_res) {
					$err = "Can't select data from database.";
					}
					if($ins_res == FALSE) {
						echo "ERROR: SQL=$ins_sql<br />\n error=" . $xoopsDB->error() . "<br />\n";
					}
				}
			}
		}
    redirect_header("pickup.php",1,_AM_DBUPDATED);
}



xoops_cp_header();

// xoonips user
$xoonips_uids = array();
$xoonips_users = array();
xnp_dump_uids( $xnpsid, array(), $xoonips_uids );
xnp_get_accounts( $xnpsid, $xoonips_uids, array(), $xoonips_users );

// Non-xoonips user
$member_handler =& xoops_gethandler('member');
$xoops_users = $member_handler->getUserList();

echo '<p><h3>'._MD_XOONIPS_ADMIN_PICK_UP_USERS.'</h3></p>';

echo '<table class="outer">
<tr><th align="center">'._MD_XOONIPS_ADMIN_PICK_UP_USERS_NON_XOONIPS_USER.'<br />';

echo '</th><th></th><th align="center">'._MD_XOONIPS_ADMIN_PICK_UP_USERS_XOONIPS_USER.'<br />';
echo '</th></tr>
<tr><td class="even">
<form action="pickup.php" method="post">
<select name="uids[]" size="10" multiple="multiple">'."\n";
foreach ($xoops_users as $uid => $uname ) {
    if( in_array( $uid,  $xoonips_uids ) ) continue;
    echo '<option value="'.$uid.'">'.$uname.'</option>'."\n";
}
echo '</select>';
echo "</td><td align='center' class='odd'>
<input type='hidden' name='op' value='addUserToXooNIps' />
<input type='submit' name='submit' value='"._MD_XOONIPS_ADMIN_PICK_UP_USERS_ADD_TO_XOONIPS."' />
</form></td>
<td class='even'>";
echo "<select name='' size='10'>";
foreach ($xoonips_users as $u) {
echo '<option value="">'.$u['uname'].'</option>'."\n";
}
echo "</select>";
echo '</td></tr>
</table>';

xoops_cp_footer();
?>
