<?php
//  $Revision: 1.3.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include '../../../include/cp_header.php';
$language = $xoopsConfig['language'];
if ( file_exists(XOOPS_ROOT_PATH."/language/$language/user.php") ) {
	include XOOPS_ROOT_PATH."/language/$language/user.php";
}

if ( file_exists("../language/$language/main.php") ) {
	include "../language/$language/main.php";
} else {
	include "../language/english/main.php";
}

if ( file_exists("../language/$language/blocks.php") ) {
	include "../language/$language/blocks.php";
} else {
	include "../language/english/blocks.php";
}

if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}


include_once '../condefs.php';
include_once '../include/lib.php';
require_once '../include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

/* input
	op                   up=up_reorder, down=down_reorder, update=update
	
	visible[ranking_id]  0:invisible, 1:visible
	order[ranking_id]    order
	steps[ranking_id]    reorder step
	rid                  ranking to reorder
	
	new_visible[ranking_id]  0:invisible, 1:visible
	new_order[ranking_id]    order
	new_steps[ranking_id]    reorder step
	new_rid                  ranking to reorder
	
	days                 
	days_enabled         
	
*/

/*
xoonips_config :
	'ranking_num_rows'          => '5',
	'ranking_days'              => '14',
	'ranking_days_enabled'      => '0',
	'ranking_order'             => '0,1,2,3,4',
	'ranking_visible'           => '1,1,1,1,1',
	'ranking_steps'             => '1,1,1,1,1',

	'ranking_new_num_rows'      => '5',
	'ranking_new_order'         => '0,1',
	'ranking_new_visible'       => '1,1',
	'ranking_new_steps'         => '1,1',

	'ranking_last_update'
	'ranking_sum_last_update'

*/

include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

$myts =& MyTextSanitizer::getInstance();

xoops_cp_header();

$ranking_configs = array(
	'op'           => '',
	'block'        => '',

	'rid'          => '',
	'order'        => '0,1,2,3,4',
	'visible'      => '1,1,1,1,1',
	'steps'        => '1,1,1,1,1',
	'num_rows'     => '5',
	'days'         => '14',
	'days_enabled' => '0',

	'new_rid'      => '',
	'new_order'    => '0,1',
	'new_visible'  => '1,1',
	'new_steps'    => '1,1',
	'new_num_rows' => '5',
);

$ranking_config_keys = array(
	'days'        ,
	'days_enabled',
	'num_rows'    ,
	'order'       ,
	'visible'     ,
	'new_num_rows'    ,
	'new_order'   ,
	'new_visible' ,
);

// priority: default < config < $_POST
foreach ( $ranking_config_keys as $key ){
	if ( RES_OK == xnp_get_config_value( 'ranking_'.$key , $val ) ){
		$ranking_configs[ $key ] = $val;
	}
}

foreach( $ranking_configs as $k => $v ){
	if ( isset( $_POST['op'] ) ){
		if ( array_key_exists( $k, $_POST ) ){
			$$k = $_POST[$k];
		} else {
			$$k = false;
		}
	}
	else {
		$$k = $v;
	}
}

if ( is_string( $order       ) )  $order       = explode( ',', $order       );
if ( is_string( $visible     ) )  $visible     = explode( ',', $visible     );
if ( is_string( $steps       ) )  $steps       = explode( ',', $steps       );
if ( is_string( $new_order   ) )  $new_order   = explode( ',', $new_order   );
if ( is_string( $new_visible ) )  $new_visible = explode( ',', $new_visible );
if ( is_string( $new_steps   ) )  $new_steps   = explode( ',', $new_steps   );




$ranking_names = array(
	_MB_XOONIPS_RANKING_VIEWED_ITEM,
	_MB_XOONIPS_RANKING_DOWNLOADED_ITEM,
	_MB_XOONIPS_RANKING_CONTRIBUTING_USER,
	_MB_XOONIPS_RANKING_SEARCHED_KEYWORD,
	_MB_XOONIPS_RANKING_CONTRIBUTED_GROUP,
);

$new_ranking_names = array(
	_MB_XOONIPS_RANKING_NEW_ITEM,
	_MB_XOONIPS_RANKING_NEW_GROUP,
);

for ( $i = 0; $i < count($ranking_names); $i++ )
	if ( !isset( $visible[$i] ) )
		$visible[$i] = 0;

for ( $i = 0; $i < count($new_ranking_names); $i++ )
	if ( !isset( $new_visible[$i] ) )
		$new_visible[$i] = 0;

if ( $op == 'up' || $op == 'down' ){
	function updown( $op, &$order, $steps, $rid ){
		$step = $steps[$rid];
		$order_rid = $order[$rid];
		$num = count( $order );
		
		// up/down ranking. todo: simplify
		for ( $i = 0; $i < $num; $i++ ){
			if ( $op == 'up' ){
				if ( $order_rid - $step <= $order[$i] && $order[$i] < $order_rid )
					$order[$i]++;
				else if ( $i == $rid )
					$order[$rid] = max( 0, $order_rid - $step );
			}
			else {
				if ( $order_rid + $step >= $order[$i] && $order[$i] > $order_rid )
					$order[$i]--;
				else if ( $i == $rid )
					$order[$rid] = min( $num-1, $order_rid + $step );
			}
		}
	}
	
	if      ( $block == 'ranking'     )  updown( $op, $order    , $steps    , $rid    );
	else if ( $block == 'new_ranking' )  updown( $op, $new_order, $new_steps, $new_rid);
}

if ( $op == 'update' ) {
	global $xoopsDB;
	
	//  assert(sort(array_keys($order)) == array(0,1,2,3,4)); assert(sort(array_values($order)) == array(0,1,2,3,4));
	$keys = array_keys  ($order); sort( $keys ); $keys = implode( ',', $keys );
	$vals = array_values($order); sort( $vals ); $vals = implode( ',', $vals );
	
	if ( $keys <> "0,1,2,3,4" || $vals <> "0,1,2,3,4" )
		redirect_header('ranking.php', 3, 'error' );
	
	//  assert(sort(array_keys($new_order)) == array(0,1)); assert(sort(array_values($new_order)) == array(0,1));
	$keys = array_keys  ($new_order); sort( $keys ); $keys = implode( ',', $keys );
	$vals = array_values($new_order); sort( $vals ); $vals = implode( ',', $vals );
	
	if ( $keys <> "0,1" || $vals <> "0,1" )
		redirect_header('ranking.php', 3, 'error' );
	
	$days         = (int)$days        ; if ( $days         < 1 ) $days         = 1;
	$num_rows     = (int)$num_rows    ; if ( $num_rows     < 1 ) $num_rows     = 1;
	$new_num_rows = (int)$new_num_rows; if ( $new_num_rows < 1 ) $new_num_rows = 1;

	foreach ( $ranking_config_keys as $key ){
		if ( is_array( $$key ) ){
			ksort( $$key );
			$$key = implode( ',', $$key );
		}
		xnp_set_config_value( 'ranking_'.$key, $$key );
	}
	
	xnpRecalcRanking( false );
	
	redirect_header('ranking.php', 3, _MD_AM_DBUPDATED );
	exit;
}


$updown = '
	<option label="1" value="1" selected="selected">1</option>
	<option label="2" value="2">2</option>
	<option label="3" value="3">3</option>
	<option label="4" value="4">4</option>';

?>
<script type="text/javascript">
<!--
function xoonipsUpDown( op, rid ) {
	document.getElementById('xoonips_op').value = op;
	document.getElementById('xoonips_rid').value = rid;
	document.getElementById('xoonips_block').value = 'ranking';
	document.getElementById('xoonips_modify_form').submit();
	return false;
}
function xoonipsNewUpDown( op, new_rid ) {
	document.getElementById('xoonips_op').value = op;
	document.getElementById('xoonips_new_rid').value = new_rid;
	document.getElementById('xoonips_block').value = 'new_ranking';
	document.getElementById('xoonips_modify_form').submit();
	return false;
}
//-->
</script>
<form name='modify_form' id='xoonips_modify_form' action='ranking.php' method='post'>
<input type='hidden' name='rid' id='xoonips_rid' value='' />
<input type='hidden' name='new_rid' id='xoonips_new_rid' value='' />
<input type='hidden' name='block' id='xoonips_block' value='' />
<input type='hidden' name='op' id='xoonips_op' value='update' />
<h4><?php echo _MI_XOONIPS_RANKING_CONFIG; ?></h4>

<?php echo _MD_XOONIPS_RANKING_CHECK_RANKING_LABEL; ?><br />
<br />
<br />
<b><?php echo _MD_XOONIPS_RANKING_LABEL; ?></b>
<table width='100%' class='outer' cellspacing='1'>
 <tr><th><?php echo _MD_XOONIPS_RANKING_VISIBLE; ?></th><th><?php echo _MD_XOONIPS_RANKING_NAME; ?></th><th><?php echo _MD_XOONIPS_INDEX_LABEL_UP.'/'._MD_XOONIPS_INDEX_LABEL_DOWN; ?></th></tr>
<?php
	
	
	for ( $i = 0; $i < count( $ranking_names ); $i++ ) {
		$rid = array_search( $i, $order );
		$checked = $visible[$rid] ? "checked='checked'" : "";
		$even_odd = ( $i % 2 ) ? 'odd' : 'even';
		echo "
			 <tr valign='top' align='left'>
			  <td class='head' width='70'><input type='checkbox' name='visible[$rid]' value='1' $checked /></td><td class='head'>". $ranking_names[$rid]."</td>
			  <td class='$even_odd' width='120'>
			    <input type='hidden' name='order[$rid]' value='$i' />
			    <select name='steps[$rid]'>
			      $updown
			    </select>
			    <a href='#' onclick=\"return xoonipsUpDown('up'  , $rid)\">"._MD_XOONIPS_INDEX_LABEL_UP."</a>/
			    <a href='#' onclick=\"return xoonipsUpDown('down', $rid)\">"._MD_XOONIPS_INDEX_LABEL_DOWN."</a>
			  </td>
			 </tr>
		";
	}
?>
</table>
<br />
<?php echo _MD_XOONIPS_RANKING_NUM_ROWS_1 . "<input type='text' name='num_rows' value='$num_rows' size='4' />" . _MD_XOONIPS_RANKING_NUM_ROWS_2; ?><br />
<br />
<br />
<br />
<b><?php echo _MD_XOONIPS_RANKING_NEW_LABEL; ?></b>
<table width='100%' class='outer' cellspacing='1'>
 <tr><th><?php echo _MD_XOONIPS_RANKING_VISIBLE; ?></th><th><?php echo _MD_XOONIPS_RANKING_NAME; ?></th><th><?php echo _MD_XOONIPS_INDEX_LABEL_UP.'/'._MD_XOONIPS_INDEX_LABEL_DOWN; ?></th></tr>
<?php
	// todo: assert(sort(array_keys($order)) == array(0,1,2,3,4)); assert(sort(array_values($order)) == array(0,1,2,3,4));
	
	for ( $i = 0; $i < count( $new_ranking_names ); $i++ ) {
		$new_rid = array_search( $i, $new_order );
		$checked = $new_visible[$new_rid] ? "checked='checked'" : "";
		$even_odd = ( $i % 2 ) ? 'odd' : 'even';
		echo "
			 <tr valign='top' align='left'>
			  <td class='head' width='70'><input type='checkbox' name='new_visible[$new_rid]' value='1' $checked /></td><td class='head'>" . $new_ranking_names[$new_rid]."</td>
			  <td class='$even_odd' width='120'>
			    <input type='hidden' name='new_order[$new_rid]' value='$i' />
			    <input type='hidden' name='new_steps[$new_rid]' value='1' />
			    <a href='#' onclick=\"return xoonipsNewUpDown('up'  , $new_rid)\">"._MD_XOONIPS_INDEX_LABEL_UP."</a>/
			    <a href='#' onclick=\"return xoonipsNewUpDown('down', $new_rid)\">"._MD_XOONIPS_INDEX_LABEL_DOWN."</a>
			  </td>
			 </tr>
		";
	}
?>
</table>
<br />
<?php echo _MD_XOONIPS_RANKING_NUM_ROWS_1 . "<input type='text' name='new_num_rows' value='$new_num_rows' size='4' />" . _MD_XOONIPS_RANKING_NUM_ROWS_2; ?><br />
<br />
<br />
<br />
<br />
<?php
	$checked = $days_enabled ? "checked='checked'" : "";
	echo "<input type='checkbox' name='days_enabled' $checked />&nbsp;" . 
		_MD_XOONIPS_RANKING_DAYS_1 .
		"<input type='text' name='days' value='$days' size='4' />" .
		_MD_XOONIPS_RANKING_DAYS_2;
?>
<br />
<br />
<br />
<input type='submit' value='<?php echo _US_SUBMIT; ?>' />
</form>
<?php
xoops_cp_footer();
?>
