<?php
//  $Revision: 1.2.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include '../../../include/cp_header.php';
$language = $xoopsConfig['language'];
if ( file_exists(XOOPS_ROOT_PATH."/language/$language/user.php") ) {
	include XOOPS_ROOT_PATH."/language/$language/user.php";
}

if ( file_exists("../language/$language/main.php") ) {
	include "../language/$language/main.php";
} else {
	include "../language/english/main.php";
}

if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}

include_once '../condefs.php';
include_once '../include/lib.php';
include_once '../include/create_session.php';
include_once '../include/unzip.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

/* input
	ranking_download
	ranking_download_file
	ranking_upload
	ranking_upload_file
	ranking_clear
	
	each operation(download/upload/clear) must keep
		ranking_last_update
		ranking_sum_last_update
		sum
		cache
	consistent.
	
*/

	/** sql -> csv file */
	function xnp_dump_ranking( $filename, $sql ){
		global $xoopsDB;
		$h = fopen( $filename, 'w'  );
		
		$result = $xoopsDB->query( $sql );
		while ( $Row = $xoopsDB->fetchRow( $result ) ){
			$ar = array();
			foreach ( $Row as $val ){
				if ( is_numeric( $val ) ) $ar[] = $val;
				else                      $ar[] = urlencode( $val );
			}
			fputs( $h, implode( ',', $ar ) . "\n" );
		}
		fclose( $h );
	}
	
	/** assoc -> csv file */
	function xnp_dump_assoc( $filename, $assoc ){
		global $xoopsDB;
		$h = fopen( $filename, 'w'  );
		
		foreach ( $assoc as $key => $val ){
			fputs( $h, "$key,$val\n" );
		}
		fclose( $h );
	}
	
	/** write csv lines to table */
	function load_ranking_file( $lines, $name, $columns ){
		global $xoopsDB;
		$table = $xoopsDB->prefix( 'xoonips_ranking_sum_'.$name );
		$xoopsDB->query( "delete from $table" );
		foreach ( $lines as $line ){
			if ( $line === "" )
				continue;
			$ar = explode( ',', $line );
			$Row = array();
			foreach ( $ar as $val ){
				if ( is_numeric( $val ) ) $Row[] = floor($val);
				else                      $Row[] = "'" . addslashes(urldecode( $val )) . "'";
			}
			$sql = "insert into $table ( $columns ) values ( ".implode( ',', $Row )." )";
			if ( false == $xoopsDB->query( $sql ) ){
				echo "error while loading. sql= $sql <br />\n";
			}
		}
	}
	
	
	$names = array( 'viewed_item', 'downloaded_item', 'contributing_user', 'searched_keyword', 'active_group', 'new_item', 'new_group' );
	$columns = array( 'item_id, count', 'item_id, count', 'item_id, uid, timestamp', 'keyword, count', 'gid, count', 'item_id, timestamp', 'gid, timestamp', );
	$configs = array( 'ranking_sum_last_update', 'ranking_sum_start' );
	
	if ( RES_OK != xnp_get_config_value( 'ranking_days_enabled'     , $days_enabled ) )     $days_enabled     = false;
	
	if ( isset( $_POST['ranking_download']) ){
		function onShutdown(){
			global $removeFiles;
			global $removeDir;
			foreach ($removeFiles as $file)
				unlink($file);
			if ($removeDir) rmdir($removeDir);
		}
		
		// zip xoonips_ranking_sum_* and let download it
		function download_log( $now, $sum_start, $sum_last_update ){
			global $xoopsDB, $names, $columns;
			
			$now = time();
			$removeDirs  = array(); // Directories to remove at the end of the procedures.
			$removeFiles = array(); // Files       to remove at the end of the procedures.
			register_shutdown_function('onShutdown');
			
			$dir = tempnam( '/tmp', 'xnp_ranking' );
			$zipFile = tempnam( '/tmp', 'xnp_ranking_zip' );
			unlink( $dir );
			mkdir ( $dir );
			$removeDir[] = $dir;
			
			$zippedFiles = array();
			chdir($dir);
			for ( $i = 0; $i < count($names); $i++ ){
				$filename = $names[$i];
				$zippedFiles[] = $filename;
				$removeFiles[] = "$dir/$filename";
				$sql = "select ". $columns[$i]. " from " . $xoopsDB->prefix("xoonips_ranking_sum_".$names[$i]);
				$result = xnp_dump_ranking( "$dir/$filename", $sql );
			}
			$zippedFiles[] = "config";
			$removeFiles[] = "$dir/config";
			$result = xnp_dump_assoc( "$dir/config", array( 'ranking_sum_last_update' => $sum_last_update, 'ranking_sum_start' => $sum_start ) );
			
			$removeFiles[] = $zipFile;
			$result = xnp_zip_create( $zipFile, $zippedFiles );
			
			session_cache_limiter('none'); // avoid IE bug1 -> http://jp2.php.net/header  Harry 10-Dec-2004 03:26
			
			$size = filesize($zipFile);

			// If character auto translation ON -> OFF
			if (function_exists('mb_http_output')){
				mb_http_output('pass');
			}
			
			$filename = $_POST['ranking_download_file'];
			header("Cache-Control: none");  // avoid IE bug 2
			header("Content-Type: application/zip");
			header("Content-Disposition: attachment; filename=\"$filename\"");
			header("Content-Length: $size");
			readfile($zipFile);
		}
		
		$now = time();
		
		// set ranking_sum_start, ranking_sum_last_update
		if ( RES_OK != xnp_get_config_value( 'ranking_sum_start', $sum_start ) || $sum_start == 0 ){
			$sql = "select min(timestamp) from ".$xoopsDB->prefix('xoonips_event_log');
			$result = $xoopsDB->query( $sql );
			if ( $xoopsDB->getRowsNum( $result ) ){
				list( $sum_start ) = $xoopsDB->fetchRow( $result );
				xnp_set_config_value( 'ranking_sum_start', $sum_start );
			}
		}
		if ( RES_OK != xnp_get_config_value( 'ranking_sum_last_update', $sum_last_update ) || $sum_last_update == 0 ){
			$sum_last_update = $sum_start;
			xnp_set_config_value( 'ranking_sum_last_update', $sum_last_update );
		}
		
		/*  
				                               v last_update
				           v sum_last_update       v now
				--------------log------------------+
				---sum-----+
				           +-----------------------+  // add this to sum
			ranking_sum_last_update = now;
			
			
			if ( days_enabled == true ){
				                  +---cache----+      // before
				update cache.
				                     +----cache----+  // after 
			}
			else {
				----------------------cache----+      // before
				copy sum to cache.                    
				----------------------cache--------+  // after 
			}
			
			let download ranking_sum_* 
		*/
		$h = xnpLockRanking();
		if ( $h ){
			xnpRecalcRankingSql( "( $sum_last_update <= timestamp and timestamp < $now )" , " 0 ", true );
			xnp_set_config_value( 'ranking_sum_last_update', "$now" );
			$sum_last_update = $now;
			xnpUnlockRanking( $h );
		}
		else {
			redirect_header('ranking_log.php', 3, _MD_XOONIPS_RANKING_LOCKED );
			exit;
		}
		
		if ( $days_enabled ){
			xnpRecalcRanking( true );
		}
		else {
			// copy tables
			for ( $i = 0; $i < count($names); $i++ ){
				$xoopsDB->query( "delete from  " . $xoopsDB->prefix('xoonips_ranking_'.$names[$i]) );
				$sql =  "replace into " . $xoopsDB->prefix('xoonips_ranking_'.$names[$i]) . 
				  " ( " . $columns[$i]. " ) select ".$columns[$i]." from " . $xoopsDB->prefix('xoonips_ranking_sum_'.$names[$i]);
				$xoopsDB->query( $sql );
			}
		}
		
		download_log( $now, $sum_start, $sum_last_update );
		exit;
	}
	else if ( isset( $_POST['ranking_upload']) &&
			$_FILES['ranking_upload_file']['name'] != '' && 
			$_FILES['ranking_upload_file']['size'] > 0 &&
			is_uploaded_file($_FILES['ranking_upload_file']['tmp_name']) ){
		
		// extract sum 
		$uploadfile = $_FILES['ranking_upload_file']['tmp_name'];
		$hdl = fopen( $uploadfile, 'rb' );
		if( !$hdl ) exit( "can't open file ".$uploadfile );
		fseek( $hdl, 0, SEEK_SET );
		$entries = unzip_all_entries( $hdl );
		
		foreach( $entries as $entry ){
			$data = unzip_read_data( $entry );
			$lines = explode( "\n", $data );
			unset( $data );
			switch ( $entry['filename'] ){
			case $names[0]: load_ranking_file( $lines, $names[0], $columns[0] ); break;
			case $names[1]: load_ranking_file( $lines, $names[1], $columns[1] ); break;
			case $names[2]: load_ranking_file( $lines, $names[2], $columns[2] ); break;
			case $names[3]: load_ranking_file( $lines, $names[3], $columns[3] ); break;
			case $names[4]: load_ranking_file( $lines, $names[4], $columns[4] ); break;
			case $names[5]: load_ranking_file( $lines, $names[5], $columns[5] ); break;
			case $names[6]: load_ranking_file( $lines, $names[6], $columns[6] ); break;
			case 'config': 
				foreach ( $lines as $line ){
					if ( $line === "" )
						continue;
					list( $key, $val ) = explode( ',', $line );
					if ( in_array( $key, $configs ) )
						xnp_set_config_value( $key, $val );
				}
				break;
			}
		}
		fclose( $hdl );
		
		// recalc cache
		xnpRecalcRanking( false );
		
		redirect_header('ranking_log.php', 3, _MD_AM_DBUPDATED );
		exit;
	}
	else if ( isset( $_POST['ranking_clear']) ){
		// clear sum
		foreach ( $names as $name )
			$xoopsDB->query( "delete from " . $xoopsDB->prefix('xoonips_ranking_sum_'.$name) );
		xnp_set_config_value( 'ranking_sum_last_update', "0" );
		xnp_set_config_value( 'ranking_sum_start', "0" );
		
		// recalc cache
		xnpRecalcRanking( false );
		
		redirect_header('ranking_log.php', 3, _MD_AM_DBUPDATED );
		exit;
	}
	
	include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
	$myts =& MyTextSanitizer::getInstance();
	xoops_cp_header();

	$sum_start = 0;
	$sum_last_update = 0;
	xnp_get_config_value( 'ranking_sum_start', $sum_start );
	xnp_get_config_value( 'ranking_sum_last_update', $sum_last_update );
	
	if ( $sum_start != 0 && $sum_last_update != 0 ){
		$clear_label = sprintf( _MD_XOONIPS_RANKING_CLEAR_SOME_LABEL, date('Y/m/d', $sum_start), date('Y/m/d', $sum_last_update));
	}
	else {
		$clear_label = _MD_XOONIPS_RANKING_CLEAR_EMPTY_LABEL;
	}



?>
<h4><?php echo _MI_XOONIPS_RANKING_FILE_CONFIG; ?></h4>
<?php echo _MD_XOONIPS_RANKING_FILE_CONFIG_EXPLAIN; ?><br />
<br />
<form name='modify_form' id='modify_form' action='ranking_log.php' method='post' enctype="multipart/form-data" >
<table width='100%' class='outer' cellspacing='1'>
 <tr><th colspan='3'><?php echo _MI_XOONIPS_RANKING_FILE_CONFIG; ?></th></tr>
 <tr>
  <td class='head'><?php echo _MD_XOONIPS_RANKING_DOWNLOAD_LABEL; ?></td>
  <td class='even'><input type='text' name='ranking_download_file' value='<?php echo 'ranking'.date('YmdHis').'.zip'; ?>' size='30'></td>
  <td class='even'><input type='submit' name='ranking_download' value='<?php echo _MD_XOONIPS_RANKING_DOWNLOAD_FILE; ?>'></td>
 </tr>
 <tr>
  <td class='head'><?php echo _MD_XOONIPS_RANKING_UPLOAD_LABEL; ?></td>
  <td class='odd'><input type='file' name='ranking_upload_file' size='30'></td>
  <td class='odd'><input type='submit' name='ranking_upload' value='<?php echo _MD_XOONIPS_RANKING_UPLOAD_FILE; ?>'></td>
 </tr>
 <tr>
  <td class='head'><?php echo _MD_XOONIPS_RANKING_CLEAR_LABEL; ?></td>
  <td class='even'><?php echo $clear_label; ?></td>
  <td class='even'><input type='submit' name='ranking_clear' value='<?php echo _MD_XOONIPS_RANKING_CLEAR; ?>'></td>
 </tr>
</table>
 <br />
<?php echo _MD_XOONIPS_RANKING_WHAT_DELETING_LOG_IS; ?><br />

</form>
<?php
	xoops_cp_footer();
?>
