<?php
// $Id: useradmin.php,v 1.24 2006/11/30 06:35:30 makotonton Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
//  Project: The XOOPS Project                                               //
//  URL: http://sourceforge.jp/projects/xoonips/                             //
// ------------------------------------------------------------------------- //

$xoopsOption['pagetype'] = "user";

include "../../../mainfile.php";
include XOOPS_ROOT_PATH."/include/cp_functions.php";
if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/".$xoopsConfig['language']."/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/".$xoopsConfig['language']."/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}
include_once XOOPS_ROOT_PATH."/class/xoopsmodule.php";

if (file_exists(XOOPS_ROOT_PATH."/modules/system/language/".$xoopsConfig['language']."/admin/users.php")) {
	include XOOPS_ROOT_PATH."/modules/system/language/".$xoopsConfig['language']."/admin/users.php";
} elseif (file_exists(XOOPS_ROOT_PATH."/modules/system/language/english/admin/users.php")) {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin/users.php";
}

if (is_object($xoopsUser)) {
	$xoopsModule =& XoopsModule::getByDirname("system");
	if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
		redirect_header(XOOPS_URL."/",3,_NOPERM);
		exit();
	}
	$admintest=1;
} else {
	redirect_header(XOOPS_URL."/",3,_NOPERM);
	exit();
}

include_once XOOPS_ROOT_PATH."/modules/system/constants.php";

if ( !is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
	exit("Access Denied");
}

foreach( array( 'op' => 'mod_users',
                'username' => null,
                'name' => null,
                'email' => null,
                'url' => null,
                'timezone_offset' => null,
                'address' => null,
                'division' => null,
                'tel' => null,
                'fax' => null,
                'company_name' => null,
                'country' => null,
                'zipcode' => null,
                'notice_mail' => null,
                'private_item_number_limit' => null,
                'private_index_number_limit' => null,
                'private_item_storage_limit' => null,
                // 'user_icq' => null,
                // 'user_aim' => null,
                // 'user_yim' => null,
                // 'user_msnm' => null,
                // 'user_from' => null,
                'user_viewemail' => null,
                // 'user_occ' => null,
                'user_intrest' => null,
                'user_sig' => null,
                'attachsig' => null,
                'umode' => null,
                'uorder' => null,
                'notify_method' => null,
                'notify_mode' => null,
                // 'bio' => null,
                'rank' => null,
                'password' => null,
                'pass2' => null,
                'user_mailok' => null,
                'groups' => null,
                'posi' => null,
                'appeal' => null,
                'fct' => null,
                'op' => null,
                'del_uid' => null,
                'uid' => null ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}
// configuration for XooNIps
require_once '../condefs.php';
require_once '../include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

/*********************************************************/
/* Users Functions                                       */
/*********************************************************/
include_once XOOPS_ROOT_PATH."/class/xoopslists.php";
include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

function displayUsers()
{
	global $xoopsDB, $xoopsConfig, $xoopsModule, $xnpsid;
	$userstart = isset($_GET['userstart']) ? intval($_GET['userstart']) : 0;
	xoops_cp_header();
	$member_handler =& xoops_gethandler('member');
// acquire a number of XooNIps users
	//$usercount = $member_handler->getUserCount();
	$usercount = xnp_get_account_count( $xnpsid );
//
	$nav = new XoopsPageNav($usercount, 200, $userstart, "userstart", "fct=users");
	$editform = new XoopsThemeForm(_AM_EDEUSER, "edituser", "useradmin.php");
	$user_select = new XoopsFormSelect('', "uid");
	$criteria = new CriteriaCompo();
	$criteria->setSort('uname');
	$criteria->setOrder('ASC');
	$criteria->setLimit(200);
	$criteria->setStart($userstart);
// pass XooNIps users to addOptionArray argument 
	$criteria = array( 'start' => $userstart, 'rows' => 200, 'orders' => array( array( 'name' => 'uid', 'order' => 0 /* 0:ASC */) ) );
	$uids = array( );
	if( xnp_dump_uids( $xnpsid, $criteria, $uids ) != RES_OK ){
		redirect_header("index.php",2,_MD_XOONIPS_ACCOUNT_QUERY_ERROR);
		exit();
	}
	$accounts = array( );
	if( xnp_get_accounts( $xnpsid, $uids, array(), $accounts ) != RES_OK ){
		redirect_header("index.php",2,_MD_XOONIPS_ACCOUNT_QUERY_ERROR);
		exit();
	}
	$options = array();
	foreach( $accounts as $a ){
		$options[$a['uid']] = $a['uname'];
	}
	asort($options);   // The order of a display of a pull down is made into the alphabetic order of an account name.
	$user_select->addOptionArray($options);
// 
	$user_select_tray = new XoopsFormElementTray(_AM_NICKNAME, "<br />");
	$user_select_tray->addElement($user_select);
	$user_select_nav = new XoopsFormLabel('', $nav->renderNav(4));
	$user_select_tray->addElement($user_select_nav);
	$op_select = new XoopsFormSelect(_MD_XOONIPS_ADMIN_EDIT_DELETE_USER, "op");
	$op_select->addOptionArray(array("modifyUser"=>_AM_MODIFYUSER, "delUser"=>_AM_DELUSER));
	$submit_button = new XoopsFormButton("", "submit", _AM_GO, "submit");
	$fct_hidden = new XoopsFormHidden("fct", "users");
	$editform->addElement($user_select_tray);
	$editform->addElement($op_select);
	$editform->addElement($submit_button);
	$editform->addElement($fct_hidden);
	echo _MD_XOONIPS_ADMIN_EDIT_DELETE_USER_EXPLANATION."<br />\n";
	$editform->display();

	echo "<br />\n";
	echo _MD_XOONIPS_ADMIN_ADD_USER_EXPLANATION."<br />\n";
	$uid_value = "";
	$uname_value = "";
	$name_value = "";
	$email_value = "";
	$email_cbox_value = 0;
	$url_value = "";
	$posi_value = 0;
//	$avatar_value = "blank.gif";
//	$theme_value = $xoopsConfig['default_theme'];
// start of XooNIps user info
	$division_value = "";
	$company_name_value = "";
	$tel_value = "";
	$fax_value = "";
	$address_value = "";
	$country_value = "";
	$zipcode_value = "";
	$timezone_value = $xoopsConfig['default_TZ'];
// end of XooNIps user info
	// $icq_value = "";
	// $aim_value = "";
	// $yim_value = "";
	// $msnm_value = "";
	// $location_value = "";
	// $occ_value = "";
	$interest_value = "";
	$appeal_value = "";
	$sig_value = "";
	$sig_cbox_value = 0;
	$notice_mail_value = "";
	foreach( array( 'private_item_number_limit', 'private_index_number_limit', 'private_item_storage_limit' ) as $k ){
		$val = '';
		if( xnp_get_config_value( $k, $val ) == RES_OK ){
			$k .= "_value";
			$$k = $val;
		}
	}
	$private_item_storage_limit_value /= 1000000;
	$umode_value = $xoopsConfig['com_mode'];
	$uorder_value = $xoopsConfig['com_order'];
	// RMV-NOTIFY
	include_once XOOPS_ROOT_PATH . '/include/notification_constants.php';
	$notify_method_value = XOOPS_NOTIFICATION_METHOD_PM;
	$notify_mode_value = XOOPS_NOTIFICATION_MODE_SENDALWAYS;
	// $bio_value = "";
	$rank_value = 0;
	$mailok_value = 0;
	$op_value = "addUser";
	$form_title = _AM_ADDUSER;
	$form_isedit = false;
	$groups = array(XOOPS_GROUP_USERS);
	include XOOPS_ROOT_PATH."/modules/xoonips/include/useradminform.php";
	xoops_cp_footer();
}

function modifyUser($user)
{
	global $xnpsid, $xoopsConfig, $myts, $xoopsDB;
	xoops_cp_header();
	$member_handler =& xoops_gethandler('member');
	$user =& $member_handler->getUser($user);
	$xoonips_user = array();
	if( xnp_get_account( $xnpsid, $user->getVar('uid'), $xoonips_user ) != RES_OK ){
		redirect_header("useradmin.php",1,_MD_XOONIPS_ACCOUNT_CANNOT_ACQUIRE_USER_INFO);
		exit();
	}
	if (is_object($user)) {
		if (!$user->isActive()) {
			xoops_confirm(array('fct' => 'users', 'op' => 'reactivate', 'uid' => $user->getVar('uid')), 'useradmin.php', _AM_NOTACTIVE);
			xoops_cp_footer();
			exit();
		}
		$uid_value = $user->getVar("uid");
		$uname_value = $user->getVar("uname", "E");
		$name_value = $user->getVar("name", "E");
		$email_value = $user->getVar("email", "E");
		$email_cbox_value = $user->getVar("user_viewemail") ? 1 : 0;
		$url_value = $user->getVar("url", "E");
//		$avatar_value = $user->getVar("user_avatar");
		$temp = $user->getVar("theme");
//		$theme_value = empty($temp) ? $xoopsConfig['default_theme'] : $temp;
		$timezone_value = $user->getVar("timezone_offset");
// start of XooNIps user info
		$division_value = $xoonips_user['division'];
		$company_name_value = $xoonips_user['company_name'];
		$tel_value = $xoonips_user['tel'];
		$fax_value = $xoonips_user['fax'];
		$address_value = $xoonips_user['address'];
		$country_value = $xoonips_user['country'];
		$zipcode_value = $xoonips_user['zipcode'];
		$notice_mail_value = $xoonips_user['notice_mail'];
		$private_item_number_limit_value = $xoonips_user['item_number_limit'];
		$private_index_number_limit_value = $xoonips_user['index_number_limit'];
		$private_item_storage_limit_value = $xoonips_user['item_storage_limit'] / 1000000;

		$division_value = htmlspecialchars($division_value, ENT_QUOTES);
		$company_name_value = htmlspecialchars($company_name_value, ENT_QUOTES);
		$tel_value = htmlspecialchars($tel_value, ENT_QUOTES);
		$fax_value = htmlspecialchars($fax_value, ENT_QUOTES);
		$address_value = htmlspecialchars($address_value, ENT_QUOTES);
		$country_value = htmlspecialchars($country_value, ENT_QUOTES);
		$zipcode_value = htmlspecialchars($zipcode_value, ENT_QUOTES);
		$notice_mail_value = htmlspecialchars($notice_mail_value, ENT_QUOTES);
		$private_item_number_limit_value = htmlspecialchars($private_item_number_limit_value, ENT_QUOTES);
		$private_index_number_limit_value = htmlspecialchars($private_index_number_limit_value, ENT_QUOTES);
		$private_item_storage_limit_value = htmlspecialchars($private_item_storage_limit_value, ENT_QUOTES);
// end of XooNIps user info
		// $icq_value = $user->getVar("user_icq", "E");
		// $aim_value = $user->getVar("user_aim", "E");
		// $yim_value = $user->getVar("user_yim", "E");
		// $msnm_value = $user->getVar("user_msnm", "E");
		// $location_value = $user->getVar("user_from", "E");
		// $occ_value = $user->getVar("user_occ", "E");
		$interest_value = $user->getVar("user_intrest", "E");
		$sig_value = $user->getVar("user_sig", "E");
		$sig_cbox_value = ($user->getVar("attachsig") == 1) ? 1 : 0;
		$umode_value = $user->getVar("umode");
		$uorder_value = $user->getVar("uorder");
		// RMV-NOTIFY
		$notify_method_value = $user->getVar("notify_method");
		$notify_mode_value = $user->getVar("notify_mode");
		// $bio_value = $user->getVar("bio", "E");
		$rank_value = $user->rank(false);
		$mailok_value = $user->getVar('user_mailok', 'E');
		$op_value = "updateUser";
		$form_title = _AM_UPDATEUSER.": ".$user->getVar("uname");
		$form_isedit = true;
		$groups = array_values($user->getGroups());
		$atab = $xoopsDB -> prefix('xoonips_users');
		$userid = $xoonips_user['uid'];
		$asql = "SELECT posi, appeal FROM $atab WHERE uid=$userid";
		$ares = $xoopsDB->query( $asql );
		$arow = $xoopsDB ->fetchArray($ares);
		if( !isset( $posi->_posi ) && intval($arow['posi']) !== 0 ) {
			$ptab = $xoopsDB -> prefix('xoonips_positions');
			$posiid = intval($arow['posi']);
			$twsql = "SELECT posi_title, posi_id FROM ".$ptab." WHERE posi_id = ".$posiid." ORDER BY posi_order DESC";
			$twres = $xoopsDB -> query( $twsql );
			$posi = $xoopsDB->fetchArray( $twres );
			$posi['title'] = $myts->makeTboxData4Show($posi['posi_title']);
			$posi['id'] = intval($posi['posi_id']);
			$_SESSION['posi_id'] = $posi['id'];
		}
		$appeal_value = $arow['appeal'];
		$appeal_value = htmlspecialchars($appeal_value, ENT_QUOTES);
		include XOOPS_ROOT_PATH."/modules/xoonips/include/useradminform.php";
		echo "<br /><string>"._AM_USERPOST."</string><br /><br />\n";
		echo "<table>\n";
		echo "<tr><td>"._AM_COMMENTS."</td><td>".$user->getVar("posts")."</td></tr>\n";
		echo "</table>\n";
		echo "<br />"._AM_PTBBTSDIYT."<br />\n";
		echo "<form action=\"useradmin.php\" method=\"post\">\n";
		echo "<input type=\"hidden\" name=\"id\" value=\"".$user->getVar("uid")."\" />";
		echo "<input type=\"hidden\" name=\"type\" value=\"user\" />\n";
		echo "<input type=\"hidden\" name=\"fct\" value=\"users\" />\n";
		echo "<input type=\"hidden\" name=\"op\" value=\"synchronize\" />\n";
		echo "<input type=\"submit\" value=\""._AM_SYNCHRONIZE."\" />\n";
		echo "</form>\n";
	} else {
		echo "<h4 style='text-align:left;'>";
		echo _AM_USERDONEXIT;
		echo "</h4>";
	}
	xoops_cp_footer();
}

// RMV-NOTIFY
function updateUser($uid, $uname, $name, $url, $email, $user_intrest, $user_viewemail, $user_avatar, $user_sig, $attachsig, $theme, $pass, $pass2, $rank, $uorder, $umode, $notify_method, $notify_mode, $timezone_offset, $user_mailok, $groups, $posi, $appeal = array())
{
	$member_handler =& xoops_gethandler('member');
	$edituser =& $member_handler->getUser($uid);
	if ($edituser->getVar('uname') != $uname && $member_handler->getUserCount(new Criteria('uname', $uname)) > 0) {
		xoops_cp_header();
		echo 'User name '.$uname.' already exists';
		xoops_cp_footer();
	} else {
		$edituser->setVar("name", $name);
		$edituser->setVar("uname", $uname);
		$edituser->setVar("email", $email);
		if (isset($url) && $url != "") {
			$edituser->setVar("url", formatURL($url));
		}
	//	$edituser->setVar("user_avatar", $user_avatar);
	//	$edituser->setVar("user_icq", $user_icq);
	//	$edituser->setVar("user_from", $user_from);
		$edituser->setVar("user_sig", $user_sig);
		$user_viewemail = (isset($user_viewemail) && $user_viewemail == 1) ? 1 : 0;
		$edituser->setVar("user_viewemail", $user_viewemail);
	//	$edituser->setVar("user_aim", $user_aim);
	//	$edituser->setVar("user_yim", $user_yim);
	//	$edituser->setVar("user_msnm", $user_msnm);
		$attachsig = (isset($attachsig) && $attachsig == 1) ? 1 : 0;
		$edituser->setVar("attachsig", $attachsig);
		$edituser->setVar("timezone_offset", $timezone_offset);
	//	$edituser->setVar("theme", $theme);
		$edituser->setVar("uorder", $uorder);
		$edituser->setVar("umode", $umode);
		// RMV-NOTIFY
		$edituser->setVar("notify_method", $notify_method);
		$edituser->setVar("notify_mode", $notify_mode);
	//	$edituser->setVar("bio", $bio);
		$edituser->setVar("rank", $rank);
	//	$edituser->setVar("user_occ", $user_occ);
		$edituser->setVar("user_intrest", $user_intrest);
		$edituser->setVar('user_mailok', $user_mailok);
		if ($pass2 != "") {
			if ( $pass != $pass2 ) {
				xoops_cp_header();
				echo "
				<string>"._AM_STNPDNM."</string>";
				xoops_cp_footer();
				exit();
			}
			$edituser->setVar("pass", md5($pass));
		}
		if (!$member_handler->insertUser($edituser)) {
			xoops_cp_header();
			echo $edituser->getHtmlErrors();
			xoops_cp_footer();
		} else {
		    if ($groups != array()) {
		        global $xoopsUser;
		        $oldgroups = $edituser->getGroups();
		        //If the edited user is the current user and the current user WAS in the webmaster's group and is NOT in the new groups array
		        if ($edituser->getVar('uid') == $xoopsUser->getVar('uid') && (in_array(XOOPS_GROUP_ADMIN, $oldgroups)) && !(in_array(XOOPS_GROUP_ADMIN, $groups))) {
		            //Add the webmaster's group to the groups array to prevent accidentally removing oneself from the webmaster's group
		            array_push($groups, XOOPS_GROUP_ADMIN);
		        }		        
		        $member_handler =& xoops_gethandler('member');
		        foreach ($oldgroups as $groupid) {
		            $member_handler->removeUsersFromGroup($groupid, array($edituser->getVar('uid')));
		        }
		        foreach ($groups as $groupid) {
		            $member_handler->addUserToGroup($groupid, $edituser->getVar('uid'));
		        }
		    }
			if( strlen( trim( $_POST['posi'] ) ) !== 0 ) {
				global $xoopsDB;
				$insposi = $_POST['posi'];
				$insuid = $_POST['uid'];
				$iptab = $xoopsDB -> prefix("xoonips_users");
				$ipsql = "UPDATE $iptab SET posi = $insposi WHERE uid = $insuid";
				$ipres = $xoopsDB -> query( $ipsql );
				$_SESSION['posi_id'] = array();
			}
			if( strlen( trim( $_POST['appeal'] ) ) !== 0 ) {
				global $xoopsDB;
				$insapp = $_POST['appeal'];
				$insuid = $_POST['uid'];
				$iatab = $xoopsDB -> prefix("xoonips_users");
				$iasql = "UPDATE $iatab SET appeal = '$insapp' WHERE uid = $insuid";
                   		$iares = $xoopsDB -> query( $iasql );
			}
			redirect_header("useradmin.php",1,_AM_DBUPDATED);
		}
	}
	exit();
}

function synchronize($id, $type)
{
	global $xoopsDB;
   	switch($type) {
   	case 'user':
		// Array of tables from which to count 'posts'
		$tables = array();
		// Count comments (approved only: com_status == XOOPS_COMMENT_ACTIVE)
		include_once XOOPS_ROOT_PATH . '/include/comment_constants.php';
		$tables[] = array ('table_name' => 'xoopscomments', 'uid_column' => 'com_uid', 'criteria' => new Criteria('com_status', XOOPS_COMMENT_ACTIVE));
		// Count forum posts
		$tables[] = array ('table_name' => 'bb_posts', 'uid_column' => 'uid');

		$total_posts = 0;
		foreach ($tables as $table) {
			$criteria = new CriteriaCompo();
			$criteria->add (new Criteria($table['uid_column'], $id));
			if (!empty($table['criteria'])) {
				$criteria->add ($table['criteria']);
			}
   			$sql = "SELECT COUNT(*) AS total FROM ".$xoopsDB->prefix($table['table_name']) . ' ' . $criteria->renderWhere();
   			if ( $result = $xoopsDB->query($sql) ) {
				if ($row = $xoopsDB->fetchArray($result)) {
					$total_posts = $total_posts + $row['total'];
   				}
   			}
		}
		$sql = "UPDATE ".$xoopsDB->prefix("users")." SET posts = $total_posts WHERE uid = $id";
   		if ( !$result = $xoopsDB->query($sql) ) {
   			exit(sprintf(_AM_CNUUSER %s ,$id));
   		}
   		break;
   	case 'all users':
   		$sql = "SELECT uid FROM ".$xoopsDB->prefix("users")."";
   		if ( !$result = $xoopsDB->query($sql) ) {
   			exit(_AM_CNGUSERID);
   		}
   		while ($row = $xoopsDB->fetchArray($result)) {
   			$id = $row['uid'];
   			synchronize($id, "user");
   		}
   		break;
   	default:
		break;
   	}
   	redirect_header("useradmin.php?op=modifyUser&amp;uid=".$id,1,_AM_DBUPDATED);
	exit();
}

$myts =& MyTextSanitizer::getInstance();

switch ($op) {

case "modifyUser":
	modifyUser($uid);
	break;
case "updateUser":
	// RMV-NOTIFY
// start of updating XooNIps user information
	$new_user = array();
	if( xnp_get_account( $xnpsid, $uid, $new_user ) != RES_OK ){
		redirect_header("useradmin.php",2,_MD_XOONIPS_ACCOUNT_CANNOT_UPDATE_USER_INFO);
		exit();
	}
	$new_user['posi'] = $myts->stripSlashesGPC($posi);
	$new_user['division'] = $myts->stripSlashesGPC($division);
	$new_user['company_name'] = $myts->stripSlashesGPC($company_name);
	$new_user['tel'] = $myts->stripSlashesGPC($tel);
	$new_user['fax'] = $myts->stripSlashesGPC($fax);
	$new_user['address'] = $myts->stripSlashesGPC($address);
	$new_user['country'] = $myts->stripSlashesGPC($country);
	$new_user['zipcode'] = $myts->stripSlashesGPC($zipcode);
//	$new_user['fax'] = $myts->stripSlashesGPC($fax);
	$new_user['appeal'] = $myts->stripSlashesGPC($appeal);
	$new_user['notice_mail'] = $myts->stripSlashesGPC($notice_mail);
	$new_user['item_storage_limit'] = max( 0, $private_item_storage_limit ) * 1000000;// storage_limit is changed MegaByte into Byte.
	$new_user['item_number_limit'] = max( 0, $private_item_number_limit );
	$new_user['index_number_limit'] = max( 0, $private_index_number_limit );
	if( xnp_update_account( $xnpsid, $new_user ) != 0 ){
		redirect_header('useradmin.php', 2, _MD_XOONIPS_ACCOUNT_CANNOT_UPDATE_USER_INFO);
		exit();
	}
// end of updating XooNIps user information
        $user_avatar = ''; // for PHP Notice message
        $theme = '';       // for PHP Notice message
	// updateUser($uid, $username, $name, $url, $email, $user_icq, $user_aim, $user_yim, $user_msnm, $user_from, $user_occ, $user_intrest, $user_viewemail, $user_avatar, $user_sig, $attachsig, $theme, $password, $pass2, $rank, $bio, $uorder, $umode, $notify_method, $notify_mode, $timezone_offset, $user_mailok, $groups, $posi, $appeal);
	updateUser($uid, $username, $name, $url, $email, $user_intrest, $user_viewemail, $user_avatar, $user_sig, $attachsig, $theme, $password, $pass2, $rank, $uorder, $umode, $notify_method, $notify_mode, $timezone_offset, $user_mailok, $groups, $posi, $appeal);
	break;
case "delUser":
	xoops_cp_header();
	$member_handler =& xoops_gethandler('member');
	$userdata =& $member_handler->getUser($uid);
	xoops_confirm(array('fct' => 'users', 'op' => 'delUserConf', 'del_uid' => $userdata->getVar('uid')), 'useradmin.php', sprintf(_AM_AYSYWTDU,$userdata->getVar('uname')));
	// delete uid from xoonips_item_show
	$dsql = "DELETE FROM ".$xoopsDB->prefix('xoonips_item_show')." WHERE uid = ".$uid."";
	$dres = $xoopsDB->query($dsql);
		if(!$dres){
			$err = "Can't select data from database.";
		}
		if($dres == FALSE){
			echo "ERROR: SQL=$dsql<br />\n error=" . $xoopsDB->error() . "<br />\n";
		}
	xoops_cp_footer();
	break;
case "delete_many":
	xoops_cp_header();
	$count = count($memberslist_id);
	if ( $count > 0 ) {
		$list = "<a href='".XOOPS_URL."/userinfo.php?uid=".$memberslist_id[0]."' target='_blank'>".$memberslist_uname[$memberslist_id[0]]."</a>";
		$hidden = "<input type='hidden' name='memberslist_id[]' value='".$memberslist_id[0]."' />\n";
		for ( $i = 1; $i < $count; $i++ ) {
			$list .= ", <a href='".XOOPS_URL."/userinfo.php?uid=".$memberslist_id[$i]."' target='_blank'>".$memberslist_uname[$memberslist_id[$i]]."</a>";
			$hidden .= "<input type='hidden' name='memberslist_id[]' value='".$memberslist_id[$i]."' />\n";
		}
		echo "<div><h4>".sprintf(_AM_AYSYWTDU," ".$list." ")."</h4>";
		echo _AM_BYTHIS."<br /><br />
		<form action='useradmin.php' method='post'>
		<input type='hidden' name='op' value='delete_many_ok' />
		<input type='submit' value='"._YES."' />
		<input type='button' value='"._NO."' onclick='javascript:location.href=\"index.html\"' />";
		echo $hidden;
		echo "</form></div>";
	} else {
		echo _AM_NOUSERS;
	}
	xoops_cp_footer();
	break;
case "delete_many_ok":
	$count = count($memberslist_id);
	$output = "";
	$member_handler =& xoops_gethandler('member');
	for ( $i = 0; $i < $count; $i++ ) {
		$deluser =& $member_handler->getUser($memberslist_id[$i]);
		$groups = $deluser->getGroups();
		if (in_array(XOOPS_GROUP_ADMIN, $groups)) {
			$output .= sprintf('Admin user cannot be deleted. (User: %s)', $deluser->getVar("uname"))."<br />";
		} else {
			if (!$member_handler->deleteUser($deluser)) {
				$output .= "Could not delete ".$deluser->getVar("uname")."<br />";
			} else {
				$output .= $deluser->getVar("uname")." deleted<br />";
			}
			// RMV-NOTIFY
			xoops_notification_deletebyuser($deluser->getVar('uid'));
		}
	}
	xoops_cp_header();
	echo $output;
	xoops_cp_footer();
	break;
case "delUserConf":
	$member_handler =& xoops_gethandler('member');
	$user =& $member_handler->getUser($del_uid);
	$groups = $user->getGroups();
	if (in_array(XOOPS_GROUP_ADMIN, $groups)) {
		xoops_cp_header();
		echo sprintf('Admin user cannot be deleted. (User: %s)', $user->getVar("uname"));
		xoops_cp_footer();
	} elseif (xnp_delete_account( $xnpsid, $del_uid )!=RES_OK){
		xoops_cp_header();
		echo "Could not delete ".$deluser->getVar("uname");
		xoops_cp_footer();
	} else {
		$online_handler =& xoops_gethandler('online');
		$online_handler->destroy($del_uid);
		// RMV-NOTIFY
		xoops_notification_deletebyuser($del_uid);
		redirect_header("useradmin.php",1,_AM_DBUPDATED);
	}
	break;
case "addUser":
	if (!$username || !$email || !$password) {
		$adduser_errormsg = _AM_YMCACF;
	} else {
		$member_handler =& xoops_gethandler('member');
		// make sure the username doesnt exist yet
		if ($member_handler->getUserCount(new Criteria('uname', $username)) > 0) {
			$adduser_errormsg = 'User name '.$username.' already exists';
		} else {
/*
			$newuser =& $member_handler->createUser();
			if ( isset($user_viewemail) ) {
				$newuser->setVar("user_viewemail",$user_viewemail);
			}
			if ( isset($attachsig) ) {
				$newuser->setVar("attachsig",$attachsig);
			}
			$newuser->setVar("name", $name);
			$newuser->setVar("uname", $username);
			$newuser->setVar("email", $email);
			$newuser->setVar("url", formatURL($url));
			$newuser->setVar("user_avatar",'blank.gif');
			$newuser->setVar("user_icq", $user_icq);
			$newuser->setVar("user_from", $user_from);
			$newuser->setVar("user_sig", $user_sig);
			$newuser->setVar("user_aim", $user_aim);
			$newuser->setVar("user_yim", $user_yim);
			$newuser->setVar("user_msnm", $user_msnm);
			if ($pass2 != "") {
				if ( $password != $pass2 ) {
					xoops_cp_header();
					echo "
					<string>"._AM_STNPDNM."</string>";
					xoops_cp_footer();
					exit();
				}
				$newuser->setVar("pass", md5($password));
			}
			$newuser->setVar("timezone_offset", $timezone_offset);
			$newuser->setVar("uorder", $uorder);
			$newuser->setVar("umode", $umode);
			// RMV-NOTIFY
			$newuser->setVar("notify_method", $notify_method);
			$newuser->setVar("notify_mode", $notify_mode);
			$newuser->setVar("bio", $bio);
			$newuser->setVar("rank", $rank);
			$newuser->setVar("level", 1);
			$newuser->setVar("user_occ", $user_occ);
			$newuser->setVar("user_intrest", $user_intrest);
			$newuser->setVar('user_mailok', $user_mailok);
			if (!$member_handler->insertUser($newuser)) {
*/
			$newuser = array( );
			if ( isset($user_viewemail) ) {
				$newuser['user_viewemail'] = $user_viewemail;
			}
			if ( isset($attachsig) ) {
				$newuser['attachsig'] = $attachsig;
			}
			$newuser['name'] = $myts->stripSlashesGPC($name);
			$newuser['uname'] = $myts->stripSlashesGPC($username);
			$newuser['email'] = $myts->stripSlashesGPC($email);
			$newuser['url'] = formatURL($url);
			$newuser['user_avatar'] = 'blank.gif';
// start of XooNIps user information
			$newuser['division'] = $myts->stripSlashesGPC($division);
			$newuser['company_name'] = $myts->stripSlashesGPC($company_name);
			$newuser['tel'] = $myts->stripSlashesGPC($tel);
			$newuser['fax'] = $myts->stripSlashesGPC($fax);
			$newuser['address'] = $myts->stripSlashesGPC($address);
			$newuser['country'] = $myts->stripSlashesGPC($country);
			$newuser['zipcode'] = $myts->stripSlashesGPC($zipcode);
			$newuser['fax'] = $myts->stripSlashesGPC($fax);
			$newuser['notice_mail'] = $notice_mail;
			$newuser['item_storage_limit'] = max( 0, $private_item_storage_limit ) * 1000000;// MegaByte -> Byte (convert the unit of storage_limit)
			$newuser['item_number_limit'] = max( 0, $private_item_number_limit );
			$newuser['index_number_limit'] = max( 0, $private_index_number_limit );
// end of XooNIps user information
			// $newuser['user_icq'] = $myts->stripSlashesGPC($user_icq);
			// $newuser['user_from'] = $myts->stripSlashesGPC($user_from);
			// $newuser['user_sig'] = $myts->stripSlashesGPC($user_sig);
			// $newuser['user_aim'] = $myts->stripSlashesGPC($user_aim);
			// $newuser['user_yim'] = $myts->stripSlashesGPC($user_yim);
			// $newuser['user_msnm'] = $myts->stripSlashesGPC($user_msnm);
			if ($pass2 != "") {
				if ( $password != $pass2 ) {
					xoops_cp_header();
					echo "
					<string>"._AM_STNPDNM."</string>";
					xoops_cp_footer();
					exit();
				}
				$newuser['pass'] = md5($password);
			}
			$newuser['timezone_offset'] = $timezone_offset;
			$newuser['uorder'] = $myts->stripSlashesGPC($uorder);
			$newuser['umode'] = $myts->stripSlashesGPC($umode);
			// RMV-NOTIFY
			$newuser['notify_method'] = $myts->stripSlashesGPC($notify_method);
			$newuser['notify_mode'] = $myts->stripSlashesGPC($notify_mode);
			// $newuser['bio'] = $myts->stripSlashesGPC($bio);
			$newuser['rank'] = $myts->stripSlashesGPC($rank);
			$newuser['level'] = 1;
			// $newuser['user_occ'] = $myts->stripSlashesGPC($user_occ);
			$newuser['user_intrest'] = $myts->stripSlashesGPC($user_intrest);
			$newuser['user_mailok'] = $myts->stripSlashesGPC($user_mailok);
			$newuser['posi'] = $myts->stripSlashesGPC($posi);
			$newuser['appeal'] = $myts->stripSlashesGPC($appeal);
			$uid = 0;
			if (xnp_insert_account($xnpsid, $newuser, $uid)!=RES_OK) {
				$adduser_errormsg = _AM_CNRNU;
			} else {
//				if (!$member_handler->addUserToGroup(XOOPS_GROUP_USERS, $newuser->getVar('uid'))) {
				if (!$member_handler->addUserToGroup(XOOPS_GROUP_USERS, $uid)) {
					$adduser_errormsg = _AM_CNRNU2;
				} else {
					global $xoopsUser;
				    $member_handler =& xoops_gethandler('member');
                    if (!empty($_POST['groups'])) {
                        foreach ($_POST['groups'] as $groupid) {
                            $member_handler->addUserToGroup(intval($groupid), intval($uid));
                        }
					}
					// set position in xoonips_users
					if( strlen( trim ($posi) ) !== 0 && intval($posi) !== 0 ) {
						$aptab = $xoopsDB -> prefix("xoonips_users");
						$apsql = "UPDATE ".$aptab." SET posi = ".$posi." WHERE uid = ".$uid."";
						$apres = $xoopsDB -> query( $apsql );
					} else {
						// $posi = 0 -> $posi = number of moderator
						$grtab = $xoopsDB -> prefix("groups");
						$grsql = "SELECT groupid FROM ".$grtab." WHERE name IN ('moderator')";
						$grres = $xoopsDB -> query( $grsql );
						if ( $grres == FALSE ){
							echo "ERROR: SQL=$grsql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
						}
						$gr = $xoopsDB -> fetchArray( $grres );
						$gr4sql = intval( $gr['groupid'] ) ;
							$litab = $xoopsDB -> prefix("groups_users_link");
							$lisql = "SELECT linkid FROM ".$litab." WHERE groupid = ".$gr4sql." AND uid = ".$uid."";
							$lires = $xoopsDB -> query( $lisql );
							if ( $lires == FALSE ){
								echo "ERROR: SQL=$lisql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
							}
							$nummo = $xoopsDB -> getRowsNum($lires);
							if( strlen( trim ($nummo) ) !== 0 && $nummo !== 0  ){
								// user is moderator: position->Moderator
								$potab = $xoopsDB -> prefix("xoonips_positions");
								$posql = "SELECT posi_id FROM ".$potab." WHERE posi_title IN ('Moderator')";
								$pores = $xoopsDB -> query( $posql );
								// there is no title 'Moderator' in xoonips_positions => posi = 0
								if ( $pores == FALSE ){
									echo "ERROR: SQL=$posql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
								}
								$po = $xoopsDB -> fetchArray( $pores );
								$po4sql = intval( $po['posi_id'] );
									$aptab = $xoopsDB -> prefix("xoonips_users");
									$apsql = "UPDATE ".$aptab." SET posi = ".$po4sql." WHERE uid = ".$uid."";
									$apres = $xoopsDB -> query( $apsql );
									if ( $apres == FALSE ){
										echo "ERROR: SQL=$apsql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
									}
							} else {
								// user is Registered Users: position->Registered Users
								$potab = $xoopsDB -> prefix("xoonips_positions");
								$posql = "SELECT posi_id FROM ".$potab." WHERE posi_title IN ('Registered Users')";
								$pores = $xoopsDB -> query( $posql );
								// there is no title 'Registered Users' in xoonips_positions => posi = 0
								if ( $pores == FALSE ){
									echo "ERROR: SQL=$posql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
								}
								$po = $xoopsDB -> fetchArray( $pores );
								$po4sql = intval( $po['posi_id'] );
									$aptab = $xoopsDB -> prefix("xoonips_users");
									$apsql = "UPDATE ".$aptab." SET posi = ".$po4sql." WHERE uid = ".$uid."";
									$apres = $xoopsDB -> query( $apsql );
									if ( $apres == FALSE ){
										echo "ERROR: SQL=$apsql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
									}
							}
					}
					if( strlen( trim ($appeal) ) !== 0 ){
						$aatab = $xoopsDB -> prefix("xoonips_users");
						$aasql = "UPDATE ".$aatab." SET appeal = '".$appeal."' WHERE uid = ".$uid."";
						$aares = $xoopsDB -> query( $aasql );
					}
					redirect_header("useradmin.php",1,_AM_DBUPDATED);
					exit();
				}
			}
		}
	}
	xoops_cp_header();
	xoops_error($adduser_errormsg);
	xoops_cp_footer();
	break;
case "synchronize":
	synchronize($id, $type);
	break;
case "reactivate":
	$result=$xoopsDB->query("UPDATE ".$xoopsDB->prefix("users")." SET level=1 WHERE uid=".$uid);
	if(!$result){
		exit();
	}
	redirect_header("useradmin.php?&amp;op=modifyUser&amp;uid=".$uid,1,_AM_DBUPDATED);
	break;
case "mod_users":
default:
	include_once XOOPS_ROOT_PATH.'/class/pagenav.php';
	displayUsers();
	break;
}

?>
