<?php
//  $Revision: 1.12.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005-2007 RIKEN, Japan. All rights reserved.                  //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include_once "item.php";
include_once "xnpindex.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/include/unzip.php";

class XooNIpsImportManager extends XooNIpsObject
{
    /**
     * 
     * folder that zip file is extracted to 
     * 
     */
    var $extract_dir = null;
    
    /**
     * 
     * file name of uploaded file on the server
     * 
     */
    var $filename = null;

    /**
     * 
     * original file name of imoprt file
     * 
     */
    var $original_filename = null;

    /**
     * 
     * array of XooNIps Item(s)
     * 
     */
    var $items = array();
    
    /**
     * 
     * array of conflict items
     *     array( pseudo_id => array( 'import_items' => array( pseudo_id, pseudo_id, ... ),
     *                                'exists_items' => array( item_id, item_id, ... ) ),
     *                                ... )
     * 
     */
    var $conflict_info = array();
    
    /**
     * 
     * uid of importer( null if not specified )
     * 
     */
    var $importer_uid = null;
    
    function XooNIpsImportManager(){
    }
    
    /**
     * 
     * parse xml text and return item or null
     * 
     * @param xml 
     * @param importer_uid uid of contributor for imported items. if null <contributor> is used.
     * @param attachment_dir
     * @return XooNIpsItem or null
     * 
     * @private
     */
    function parse_xml( $xml, $importer_uid, $base_index_id, $attachment_dir, $filename ){
        global $xoopsDB;
        
        // 
        // parse basic part to retrieve a CDATA of <itemtype>
        // 
        $basic = new XooNIpsItem();
        if( !$basic -> parse( $xml, $importer_uid, $attachment_dir, $base_index_id, $filename ) ){
            return null;
        }
        
        // 
        // convert itemtype to item_type_id
        // 
        $result = $xoopsDB -> query( 'select * from ' . $xoopsDB -> prefix( 'xoonips_item_type' ) . ' where item_type_id=' . $basic -> getVar( 'item_type_id' ) );
        if( !$result ){
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) );
            return null;
        }
        $itemtype = $xoopsDB -> fetchArray( $result );
        
        // 
        // create a XooNIpsItem object of the itemtype.
        // 
        include_once( XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'] );
        $fname = $itemtype['name'] . "CreateXooNIpsItem";
        if( !function_exists( $fname ) ){
            $this -> setErrors( E_XOONIPS_ERROR, "function is not found(${fname})" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) );
            return null;
        }
        $item = $fname();
        if( !$item -> parse( $xml, $importer_uid, $attachment_dir, $base_index_id, $filename ) ){
            return null;
        }
        return $item;
    }
    
    /**
     * 
     * parse given xml file and return item or null
     * 
     * @param filepath xml filepath
     * @param importer_uid uid of contributor for imported items. if null <contributor> is used.
     * @param attachment_dir
     * @return XooNIpsItem or null
     * 
     * @private
     */
    function parse_file( $filepath, $importer_uid, $base_index_id, $attachment_dir ){
        global $xoopsDB;
        
        // 
        // parse basic part to retrieve a CDATA of <itemtype>
        // 
        $basic = new XooNIpsItem();
        if( !$basic -> parseFile( $filepath, $importer_uid, $attachment_dir, $base_index_id ) || count( $basic -> getErrors() ) ){
            return $basic;
        }
        
        // 
        // convert itemtype to item_type_id
        // 
        $result = $xoopsDB -> query( 'select * from ' . $xoopsDB -> prefix( 'xoonips_item_type' ) . ' where item_type_id=' . $basic -> getVar( 'item_type_id' ) );
        if( !$result ){
            $basic -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) );
            return $basic;
        }
        $itemtype = $xoopsDB -> fetchArray( $result );
        
        // 
        // create a XooNIpsItem object of the itemtype.
        // 
        include_once( XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'] );
        $fname = $itemtype['name'] . "CreateXooNIpsItem";
        if( !function_exists( $fname ) ){
            $basic -> setErrors( E_XOONIPS_ERROR, "function is not found(${fname})" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) );
            return $basic;
        }
        $item = $fname();
        $item -> parseFile( $filepath, $importer_uid, $attachment_dir, $base_index_id );
        return $item;
    }
    
    /**
     * 
     * extract given zip filep, parse each xml files in the zip, and create instances of XooNIpsItem.
     * Call getItems to get created XooNIpsItems instances.
     * 
     * @param zipfile file path of import file
     * @param importer_uid uid of contributor for imported items. if null <contributor> is used.
     * @param base_index_id array of index ids where items should be imported to( or empty array )
     * @return bool
     * 
     * @public
     */
    function parseFile( $zipfile, $importer_uid, $base_index_id ){
        $this -> filename = $zipfile;
        $this -> importer_uid = $importer_uid;
        
        if( !$this -> extract_zip() ) return false;

        $hdl = fopen( $this -> filename, "rb" );
        if( !$hdl ){
            $this -> setErrors( E_XOONIPS_OPEN_FILE, "can't open file(" . $this -> filename . ")" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }

        $entries = unzip_all_entries( $hdl );
        fclose( $hdl );
        foreach( $entries as $e ){
            if( dirname( $e['filename'] ) == "." // read from extract_dir(not sub directories)
                && ctype_digit( basename( $e['filename'], '.xml' ) ) ){
                $item = $this -> parse_file( $this -> extract_dir . "/" . $e['filename'], $importer_uid, $base_index_id, $this -> extract_dir );
                
                // 
                // setDirty force after cleanVars
                // 
                $item -> cleanVars();
                $item -> setDirty();
                
                $this -> items[] = $item;
            }
        }
        
        // every item has unique pseudo_id ?
        $pseudo_id2i = array();
        foreach ( $this -> items as $i => $item ){
            $item = $this -> items[ $i ];
            $pseudo_id = $item -> getVar( 'pseudo_id' );
            if( isset($pseudo_id2i[ $pseudo_id ]) ){
                foreach ( $pseudo_id2i[$pseudo_id] as $j ){
                    $this -> items[ $i ] -> setErrors( E_XOONIPS_PSEUDO_ID_CONFLICT, 
                      " pseudo_id($pseudo_id) conflicts with " . $this -> items[ $j ] -> getFilename()
                       . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                    $this -> items[ $j ] -> setErrors( E_XOONIPS_PSEUDO_ID_CONFLICT, 
                      " pseudo_id($pseudo_id) conflicts with " . $this -> items[ $i ] -> getFilename()
                       . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                }
                $pseudo_id2i[ $pseudo_id ][] = $i;
            }
            else
                $pseudo_id2i[ $pseudo_id ] = array( $i );
        }
        
        // every related_to has valid pseudo_id ?
        $valid_pseudo_ids = array();
        foreach ( $this -> items as $item )
            $valid_pseudo_ids[ $item->getVar('pseudo_id') ] = true;
        foreach ( $this -> items as $key => $item ){
            foreach ( $item -> getVar( 'related_to' ) as $item_id ){
                if ( !isset( $valid_pseudo_ids[$item_id] ) ){
                    $this -> items[$key] -> setErrors( E_XOONIPS_RELATED_ITEM_IS_NOT_FOUND, 
                      "unresolvable related_to(id=$item_id)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                }
            }
        }
        
        return true;
    }
    
    /**
     * 
     * extract zip file to temp dir
     * 
     * @return bool
     * @private
     */
    function extract_zip(){
        $hdl = @fopen( $this -> filename, "rb" );
        
        if( $hdl ){
            $this -> extract_dir = tempnam( '/tmp', 'XNP' );
            @unlink( $this -> extract_dir );
            if( !$this -> mkdir_p( $this -> extract_dir, 0755 ) ){
                $this -> setErrors( E_XOONIPS_FILE_SYSTEM, "can't mkdir(" . $this -> extract_dir . ")" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                fclose( $hdl );
                return false;
            }
            
            $entries = unzip_all_entries( $hdl );
            foreach( $entries as $entry ){
                $filename = basename( $entry['filename'] );
                // 
                // if $entry['filename'] includes sub directory, to make its directory
                // 
                if( dirname( $entry['filename'] ) != "." ){
                    $dirname = $this -> extract_dir . "/" . dirname( $entry['filename'] );
                    if( !file_exists( $dirname ) && !$this -> mkdir_p( $dirname, 0755 ) ){
                        $this -> setErrors( E_XOONIPS_FILE_SYSTEM, "can't mkdir(${dirname})" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                        fclose( $hdl );
                        return false;
                    }
                }else{
                    $dirname = $this -> extract_dir;
                }
                if( !unzip_read_data_to_file( $entry, $dirname . "/" . $filename ) ){
                    $this -> setErrors( E_XOONIPS_FILE_SYSTEM, "can't extract file to " . $dirname . "/" . $filename  . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                    fclose( $hdl );
                    return false;
                }
            }
            fclose( $hdl );
        }else{
            $this -> setErrors( E_XOONIPS_OPEN_FILE, "can't open file(" . $this -> filename . ")" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        return true;
    }
    
    /**
     * 
     * import specified item
     * - update item if an item has item_id attribute
     * - insert item if an item has pseudo_id attribute and don't have item_id attribute.
     * 
     * 
     * @param import_id array of pseudo item id
     * @param certify_auto if true certify registering items to public indexes automatically
     * @return bool
     * 
     * @public
     */
    function import( $import_id, $certify_auto ){
        foreach( $this -> items as $i ){
            if( in_array( $i -> getVar( 'pseudo_id' ), $import_id ) ){
                // 
                // import item
                // 
                if( $i -> import( $certify_auto ) ){
                    
                }else{
                    $this -> setErrors( E_XOONIPS_IMPORT, "can't import item(id=" . $i -> getVar( 'pseudo_id' ) . ")" . $this -> getErrorAt( __LINE__, __FLIE__, __FUNCTION__ ) );
                }
            }
        }
    }
    
    /**
     * 
     * conflict check
     * 
     * - to find equal items in importing items
     * - to find equal items in database
     * - assign item id of exist item to item_id of import item if only one equal item is exist
     * - key 'import_items'           of return value means conflict item id in import file.
     * - key 'exists_items'           of return value means conflict item id in database(already exist items)
     * - key 'exists_updatable_items' of return value means conflict item id in database(already exist items) which have same index_id
     * 
     * @return true|false
     */
    function checkConflict(){
        global $xoopsDB;
        
        $ret = array( );
        
        // check good items only. 
        $items = array();
        $pseudo_id2idx = array();
        foreach( $this -> items as $key => $i ){
            $uid = $i -> getVar( 'uid' );
            $item_type_id = $i -> getVar( 'item_type_id' );
            $pseudo_id = $i -> getVar( 'pseudo_id' );
            $titles = $i -> getVar( 'titles' );
            
            if ( !empty( $item_type_id ) && !empty( $uid ) && !empty( $titles ) && !empty( $pseudo_id ) ){
                $items[] = $i;
                $pseudo_id2idx[ $pseudo_id ] = $key;
            }
        }
        
        // 
        // in import file
        // 
        $sql = "CREATE TEMPORARY TABLE " . $xoopsDB -> prefix( "xoonips_check_conflict" ) . " (
                  id int(10) NOT NULL auto_increment,
                  pseudo_id int(10) unsigned NOT NULL default '0',
                  uid int(10) unsigned NOT NULL default '0',
                  item_type_id int(10) unsigned NOT NULL default '0',
                  title varchar(255) NOT NULL default '',
                  title_count int(10) unsigned NOT NULL default '0',
                  PRIMARY KEY  (id)
                ) TYPE=MyISAM";
        $result = $xoopsDB -> query( $sql );/*echo "<pre>$sql</pre>";*/
        if( !$result ){
            $this -> setErrors( array ( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) ) );
            return false;
        }

        $values = array();
        $c = 1;
        foreach( $items as $i ){
            foreach( $i -> getVar( 'titles' ) as $title ){
                $sql = "INSERT INTO " . $xoopsDB -> prefix( "xoonips_check_conflict" )
                    . " (pseudo_id, uid, item_type_id, title, title_count) VALUES "
                    . sprintf( "( %d, %d, %d, %s, %d )",
                               $i -> getVar( 'pseudo_id' ),
                               $i -> getVar( 'uid' ),
                               $i -> getVar( 'item_type_id' ),
                               $xoopsDB -> quoteString( $title ),
                               count( $i -> getVar( 'titles' ) ) );
                $result = $xoopsDB -> query( $sql );/*echo "<pre>$sql</pre>";*/
                if( !$result ){
                    $this -> setErrors( array ( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) ) );
                    return false;
                }
            }
        }

    
        $sql = "CREATE TEMPORARY TABLE " . $xoopsDB -> prefix( "xoonips_check_conflict2" ) . " (
                  pseudo_id int(10) unsigned NOT NULL default '0',
                  uid int(10) unsigned NOT NULL default '0',
                  item_type_id int(10) unsigned NOT NULL default '0',
                  title varchar(255) NOT NULL default '',
                  count int(10) unsigned NOT NULL default '0',
                  title_count int(10) unsigned NOT NULL default '0',
                  PRIMARY KEY  (pseudo_id, title)
                ) TYPE=MyISAM;";
        $result = $xoopsDB -> query( $sql );/*echo "<pre>$sql</pre>";*/
        if( !$result ){
            $this -> setErrors( array ( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) ) );
            return false;
        }
        
        $sql = "insert into " . $xoopsDB -> prefix( "xoonips_check_conflict2" ) . " (pseudo_id, uid, item_type_id, title, count, title_count) SELECT pseudo_id, uid, item_type_id, title, count(*), title_count from " . $xoopsDB -> prefix( "xoonips_check_conflict" ) . " group by pseudo_id,title";
        $result = $xoopsDB -> query( $sql );/*echo "<pre>$sql</pre>";*/
        if( !$result ){
            $this -> setErrors( array ( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) ) );
            return false;
        }
    
    
        $sql = "select distinct pseudo_id from " . $xoopsDB -> prefix( "xoonips_check_conflict" );
        $result1 = $xoopsDB -> query( $sql );/*echo "<pre>$sql</pre>";*/
        if( !$result1 ){
            $this -> setErrors( array ( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) ) );
            return false;
        }
        while( list( $pseudo_id ) = $xoopsDB -> fetchRow( $result1 ) ){
            $sum = 0;// number of titles of the item
            $where = array();
            $sql = "select pseudo_id, uid, item_type_id, title, count, title_count from " . $xoopsDB -> prefix( "xoonips_check_conflict2" ) . " where pseudo_id=" . $pseudo_id;
            $result = $xoopsDB -> query( $sql );/*echo "<pre>$sql</pre>";*/
            if( !$result ){
                $this -> setErrors( array ( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) ) );
                return false;
            }
            
            $sql = '';
            while( $ar = $xoopsDB -> fetchRow( $result ) ){
                list( $pseudo_id_1, $uid, $item_type_id, $title, $count, $title_count ) = $ar;
                if( empty( $sql ) ){
                    $sql = "select distinct pseudo_id from " . $xoopsDB -> prefix( "xoonips_check_conflict2" ) . "
                        where pseudo_id != $pseudo_id_1 and uid=$uid and item_type_id=$item_type_id and title_count=$title_count and ";
                }
                $where[] = "title=" . $xoopsDB -> quoteString( $title ) . " and count=$count";
                $sum += $count;
            }
            if( count( $where ) > 0 ){
                $sql .= "(" . implode( ' or ', $where ) . ")";
                $result = $xoopsDB -> query( $sql );/*echo "<pre>$sql</pre>";*/
                if( !$result ){
                    $this -> setErrors( array ( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) ) );
                    return false;
                }
                if( $xoopsDB -> getRowsNum( $result ) > 0 ){
                    $ret[ $pseudo_id ] = array( 'import_items' => array( ), 'exists_items' => array( ), 'exists_updatable_items' => array( ) );
                    while( list( $id ) = $xoopsDB -> fetchRow( $result ) ) 
                        $ret[ $pseudo_id ]['import_items'][] = $id;
                }
            }
        }
    
        // 
        // in database
        // 
        foreach( $items as $i ){
            // find items that have same uid, titles, itemtype
            $titles = array();
            foreach( $i -> getVar( 'titles' ) as $t ){
                $titles[] = $xoopsDB -> quoteString( $t );
            }
            $uid = $i -> getVar( 'uid' );
            $item_type_id = $i -> getVar( 'item_type_id' );
            $sql = "SELECT distinct tb.item_id FROM "
                . $xoopsDB -> prefix( "xoonips_item_title" ) . " AS tt,"
                . $xoopsDB -> prefix( "xoonips_item_basic" ) . " AS tb,"
                . $xoopsDB -> prefix( "xoonips_index" ) . " AS ti,"
                . $xoopsDB -> prefix( "xoonips_index_item_link" ) . " AS til,"
                . $xoopsDB -> prefix( "xoonips_groups_users_link" ) . " AS tgl,"
                . $xoopsDB -> prefix( "xoonips_item_type" ) . " AS ty"
                . " WHERE tt.item_id = tb.item_id AND "
                . "tb.item_id = til.item_id AND "
                . "til.index_id = ti.index_id AND "
                . "( ti.open_level = 1 AND til.certify_state = 2 OR "
                . "  ti.open_level = 2 AND til.certify_state = 2 AND ti.gid = tgl.gid AND tgl.uid = ${uid} OR "
                . "  ti.open_level = 3 AND tb.uid = ${uid} ) "
                . "AND ty.item_type_id = tb.item_type_id "
                . "AND ty.item_type_id = ${item_type_id} "
                . "AND tt.title in ( " . implode( ", ", $titles ) . " ) ";
            
            $result = $xoopsDB -> query( $sql );
            if( !$result ){
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) );
                return false;
            }
            
            $pseudo_id = $i -> getVar( 'pseudo_id' );
            $indexes = $i -> getVar( 'indexes' );
            while( list( $item_id ) = $xoopsDB -> fetchRow( $result ) ){
                $exist_item = new XooNIpsItem();
                $exist_item -> get( $item_id );
                if( !$exist_item -> equals( $i ) ) continue;
                if( !array_key_exists( $pseudo_id, $ret ) )
                    $ret[ $pseudo_id ] = array( 'import_items' => array( ), 'exists_items' => array( $item_id ), 'exists_updatable_items' => array() );
                else                    
                    $ret[ $pseudo_id ]['exists_items'][] = $item_id;
                
                if ( 0 != count( array_intersect( $exist_item -> getVar('indexes'), $indexes ) ) )
                    $ret[ $pseudo_id ]['exists_updatable_items'][] = $item_id;
            }
        }
        //
        // error if related items conflict
        //
        foreach( $items as $i => $item ){
            $related_tos = $item -> getVar( 'related_to' );
            $pseudo_id = $item -> getVar( 'pseudo_id' );
            if( !empty( $related_tos ) && isset( $ret[ $pseudo_id ] ) && !empty( $ret[ $pseudo_id ][ 'exists_updatable_items' ] ) ){
                foreach( $related_tos as $related_to ){
                    $item_ids = implode( ',', $ret[ $pseudo_id ][ 'exists_updatable_items' ] );
                    $this -> items[ $pseudo_id2idx[ $pseudo_id ] ] -> setErrors( E_XOONIPS_RELATED_TO_CONFLICTING_ITEM, 
                     "can't import this item(id=$pseudo_id) because this item has a related_to item(id=$related_to) and conflicts with existing item(id=$item_ids)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) );
                }
            }
            
            foreach( $related_tos as $related_to ){
                if( isset( $ret[ $related_to ] ) && !empty( $ret[ $related_to ][ 'exists_updatable_items' ] ) ){
                    $item_ids = implode( ',', $ret[ $related_to ][ 'exists_updatable_items' ] );
                    $this -> items[ $pseudo_id2idx[ $related_to ] ] -> setErrors( E_XOONIPS_RELATED_TO_CONFLICTING_ITEM, 
                      "can't import this item(id=$related_to) because an item(id=$pseudo_id) is related to this item and conflicts with existing item(id=$item_ids)" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__  ) );
                }
            }
        }
        $this -> conflict_info = $ret;
        return true;
    }
    
    function getItems(){ return $this -> items; }
    
    function setItems( $items ){ $this -> items = $items; }
    
    function getConflict(){ return $this -> conflict_info; }
    
    /**
     * 
     * return a original file name.
     * @see setOriginalFilename
     */
    function getOriginalFilename(){
       return $this -> original_filename;
    }
    
    /**
     * 
     * set a original file name.
     * @see getOriginalFilename
     */
    function setOriginalFilename( $name ){
       $this -> original_filename = $name;
    }
    
    function getErrors(){
        //
        // ErrorsФƤ֤
        //
        $err = parent::getErrors();
        foreach( $this -> items as $i ){
            $err = array_merge( $err, $i -> getErrors() );
        }
        return $err;
    }
    
    function getErrorCodes(){
        //
        // ErrorCodessФƤ֤
        //
        $err = parent::getErrorCodes();
        foreach( $this -> items as $i ){
            $err = array_merge( $err, $i -> getErrorCodes() );
        }
        return $err;
    }
    
    /** return item-independent errors */
    function getNonItemErrors(){
        return parent::getErrors();
    }
    
    /** return item-independent error codes */
    function getNonItemErrorCodes(){
        return parent::getErrorCodes();
    }
    
    /** 
     * 
     * Clean all extrcted files and directories. 
     * @param path would be deleted. if path omitted, zip extracted dir is removed
     * @return true if succeed. false if failed removing files or directories.
     * 
     */
    function cleanFiles($path=null){
        if( is_null( $path ) ){
            $path = $this -> extract_dir;
        }
        foreach( glob( $path . "/*" ) as $file ){
            if( is_dir( $file ) ){
                if( !$this -> cleanFiles( $file ) ) return false;
            }else{
                if( !unlink( $file ) ){
                    $this -> setErrors( E_XOONIPS_FILE_SYSTEM, "can't remove file(${file})" );
                    return false;
                }
            }
        }
        if( !rmdir( $path ) ){
            $this -> setErrors( E_XOONIPS_FILE_SYSTEM, "can't remove directory(${path})" );
            return false;
        }
        return true;
    }
    
    /**
     * 
     * make directory recurcively
     * 
     */
    function mkdir_p( $path, $mode ){
        $dir = ( strncmp( $path, '/', 1 ) == 0 ? '' : '.' ); // set '.' if $path is relative path.
        
        foreach( explode( '/', $path ) as $p ){
            if( empty( $p ) ) continue;
            $dir .= '/' . $p;
            $result = @mkdir( $dir, $mode );
        }
        
        return $result;
    }
    
}
