<?php
//  $Revision: 1.3.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005-2007 RIKEN, Japan. All rights reserved.                  //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include "object.php";

class XooNIpsImportObject extends XooNIpsObject
{
    /**
     * 
     * file name of text that is parsed now.
     * 
     */
    var $filename = null;
    
    /**
     * 
     * directory path that attachment file is stored to
     * 
     */
    var $attachment_dir = null;
    
    /**
     * 
     * array of index id where to items are imported
     * 
     */
    var $base_index_id = array();
    
    /**
     * 
     * uid of importer. It is used as a contributor of imported item.
     * 
     */
    var $importer_uid = null;
    
    /**
     * 
     * stack of parsed tag
     * 
     */
    var $tagstack = array();
    
    
    /**
     * 
     * buffer to hold CDATA for parse
     * 
     */
    var $cdata = array();

    function XooNIpsImportObject(){
        $this->initVar('version', XOBJ_DTYPE_TXTBOX, null, false);
    }
    
    /**
     * get max length of each columns of specified table
     * @param $table_wo_prefix: table name(no prefix)
     * @return array( column1 => max length1(bytes), column2 => max length2(bytes), ... ) or false if failed
     */
    function getColumnMaxLen( $table_wo_prefix ){
        global $xoopsDB;
        $table = $xoopsDB->prefix($table_wo_prefix);
        $result = $xoopsDB->query( "select * from $table limit 1" );
        if ( $result == false )
            return false;

        $ar = array();
        for( $i = 0; $i < mysql_num_fields($result); $i++ ){
            $name = mysql_field_name($result, $i);
            $len = mysql_field_len($result, $i);
            $type = mysql_field_type($result, $i);
            $ar[$name] = $len;
        }
        return $ar;
    }

    function getParserErrorAt( $parser ){
        return " at line ".xml_get_current_line_number( $parser )
            .", column ".xml_get_current_column_number( $parser )
            . (is_null( $this -> filename ) ? "" : ", file " . $this -> filename);
    }
    

    /** strip a surplus string. if it returns empty array, no strings has been stripped
     * @param associative array of column name and max length(bytes)
     * @param associative array of column name and target strings( like $a[ column name ] = target string )
     * @param encoding(default UTF-8)
     * @return associative array of stripped strings only or false if some error.
     * @see getColumnMaxLen
     */
    function stripSurplusString( $maxlengths, $assoc, $encoding = 'UTF-8' ){
        if( !is_array( $maxlengths ) ) return false;
        
        $ret = array();
        foreach( $assoc as $name => $value ){
            if( !array_key_exists( $name, $maxlengths ) ) continue; // if $name is not found in $maxlengths
            $len = $maxlengths[ $name ];
            if( strlen( $assoc[ $name ] ) > $len ){
                $ret[ $name ] = extension_loaded("mbstring")
                    ? mb_strcut( $assoc[ $name ], 0, $len, $encoding )
                    : substr( $assoc[ $name ], 0, $len );
            }
        }
        return $ret;
    }

    /**
     * 
     * return filename of XML(if filename is given in parse)
     * 
     * @return filename string or null
     * 
     */
    function getFilename( ){ return $this -> filename; }
        
        
    /**
     * 
     * 
     * 
     * 
     * 
     * @param true if no invalid values. false if invalid values exist.
     * 
     */
    function cleanVars(){
        return true;
    }

    /**
     * 
     * parse given XML and set variables
     * 
     * - parsing XML file
     * - $importer_uid is used as contributor of impoted items(contributor in xml is overwritten)
     * - $base_index_id is an array of index ids where items should be imported to
     * - if $base_index_id is empty, relative index path is mapped to /Private index
     * - $filename is a file name of $xml(additional information for user)
     * 
     * @param xml XML to be parsed(<item> ... </item>)
     * @param importer_uid uid of contributor
     * @param attachment_dir absolute path to the folder attachment files are placed
     * @param base_index_id array of index ids where items should be imported to
     * @param filename file name of $xml
     * @return bool false if failed
     * 
     */
    function parse( $xml, $importer_uid, $attachment_dir, $base_index_id, $filename=null ){

        //
        // set parameters
        //
        $this -> importer_uid = $importer_uid;
        $this -> filename = $filename;
        $this -> base_index_id = $base_index_id;
        $this -> attachment_dir = $attachment_dir;
        
        $parser = xml_parser_create( "UTF-8" );
        if( !$parser ){
            $this -> setErrors( E_XOONIPS_PARSER, "can't create parser" );
            return false;
        }
        
        xml_set_object( $parser, $this );
        xml_set_element_handler($parser, "startElement", "endElement"); 
        xml_set_character_data_handler($parser, "characterData"); 
        
        if( !xml_parse( $parser, $xml, true ) ){
            $this -> setErrors( E_XOONIPS_PARSER, xml_error_string( xml_get_error_code( $parser ) ). $this -> getParserErrorAt( $parser ) );
            return false;
        }
        parent::setNew();
        
        if (!$this->cleanVars()) {
            // 
            // return false if error in cleanVars 
            // 
            return false;
        }
        
        return true;
    }
    
    /**
     * 
     * parse given XML file and set variables
     * 
     * - open given XML file
     * - parsing XML file
     * - $importer_uid is used as contributor of impoted items(contributor in xml is overwritten)
     * - $base_index_id is an array of index ids where items should be imported to
     * - if $base_index_id is empty, relative index path is mapped to /Private index
     * - $filename is a file name of $xml(additional information for user)
     * 
     * @param filename filepath of the XML to be parsed(<item> ... </item>)
     * @param importer_uid uid of contributor
     * @param attachment_dir absolute path to the folder attachment files are placed
     * @param base_index_id array of index ids where items should be imported to
     * @return bool false if failed
     * 
     */
    function parseFile( $filename, $importer_uid, $attachment_dir, $base_index_id ){
        //
        // set parameters
        //
        $this -> importer_uid = $importer_uid;
        $this -> filename = $filename;
        $this -> base_index_id = $base_index_id;
        $this -> attachment_dir = $attachment_dir;
        
        $parser = xml_parser_create( "UTF-8" );
        if( !$parser ){
            $this -> setErrors( E_XOONIPS_PARSER, "can't create parser" );
            return false;
        }
        
        xml_set_object( $parser, $this );
        xml_set_element_handler($parser, "startElement", "endElement"); 
        xml_set_character_data_handler($parser, "characterData"); 
        
        // 
        // open file
        // 
        $hdl = fopen( $this -> filename, "r" );
        if( !$hdl ){
            $this -> setErrors( E_XOONIPS_OPEN_FILE, "can't open file(" . $this -> filename . ")" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        while( !feof( $hdl ) ){
            $xml = fread( $hdl, 4096 );
            if( !xml_parse( $parser, $xml, feof( $hdl ) ) ){
                $this -> setErrors( E_XOONIPS_PARSER, xml_error_string( xml_get_error_code( $parser ) ). $this -> getParserErrorAt( $parser ) );
                fclose( $hdl );
                return false;
            }
        }
        fclose( $hdl );
        
        parent::setNew();
        
        return true;
    }
    
    /**
     * 
     * insert or update item  
     *   
     * @return false if failed, true if insert successfully or already exists and unchanged.
     *   
     */
    function insert(){
        return $this -> cleanVars();
    }

    function startElement($parser, $name, $attribs){
        array_push( $this -> tagstack, $name );
        $this -> cdata[] = '';
        switch( implode( '/', $this -> tagstack ) ){
        case 'ITEM':
            if( !isset( $attribs['VERSION'] ) )
                $this -> setErrors( E_XOONIPS_ATTR_NOT_FOUND, "VERSION is not declared". $this -> getParserErrorAt( $parser ) );
            else{
                if( encodeMeta2Server( $attribs['VERSION'] ) == '1.00' ){
                    $this -> setVar( 'version', encodeMeta2Server( $attribs['VERSION'] ) );
                }else{
                    $this -> setErrors( E_XOONIPS_INVALID_VERSION,
                                        'unsupported version(' . encodeMeta2Server( $attribs['VERSION'] ) . ')'
                                        . $this -> getParserErrorAt( $parser ) );
                }
            }
            break;
        }
    }
    
    function endElement($parser, $name){
        array_pop( $this -> tagstack );
        //echo 'CDATA='.end($this -> cdata)."\n";
        array_pop( $this -> cdata );
    }
    
    function characterData($parser, $data) {
        $this -> cdata[count( $this -> cdata) - 1] .= $data;
    }
    
    /**
     * importing this item
     * 
     * - if getVar('item_id') has a value and $overwrite is true, update item
     * - if $certify_auto is true and this item is registered to /Public index or its sub indexes, 
     *   certify the registration automatically.
     * 
     * @abstract
     */
    function import( $certify_auto ){
    }

    
    /**
     * 
     * return string of item
     * 
     * @param htmlspecialchars escape html special chars if true.
     * @return string repeat of 'basic.<fieldname>=<value>\n' 
     * 
     * 
     */
    function toString($htmlspecialchars){ return ''; }
}
?>
