<?php
//  $Revision: 1.5.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005-2007 RIKEN, Japan. All rights reserved.                  //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

if (!defined('XOOPS_ROOT_PATH')) {
	exit();
}

define( 'E_XOONIPS_SUCCESS', 'E0000' );
define( 'E_XOONIPS_ERROR', 'E0001' );
define( 'E_XOONIPS_PARSER', 'E0002' );
define( 'E_XOONIPS_USER_NOT_FOUND', 'E0003' );
define( 'E_XOONIPS_DB_QUERY', 'E0004' );
define( 'E_XOONIPS_ATTR_REDUNDANT', 'E0005' );//redundant attributes
define( 'E_XOONIPS_ATTR_NOT_FOUND', 'E0006' );//required attributes is not declared
define( 'E_XOONIPS_ATTR_INVALID_VALUE', 'E0007' );//attribute value is invalid
define( 'E_XOONIPS_DATA_TOO_LONG', 'E0008' );
define( 'E_XOONIPS_INDEX_NOT_FOUND', 'E0009' );
define( 'E_XOONIPS_OPEN_FILE', 'E0010' );
define( 'E_XOONIPS_RELATED_ITEM_IS_NOT_FOUND', 'E0011' );//related item is not found 
define( 'E_XOONIPS_FILE_SYSTEM', 'E0012' );//error in file system
define( 'E_XOONIPS_IMPORT', 'E0013' );//error in importing
define( 'E_XOONIPS_INVALID_VALUE', 'E0014' );//CDATA is in valid(invalid format, unknown values ...)
define( 'E_XOONIPS_VALUE_IS_REQUIRED', 'E0015' );//required value is not given
define( 'E_XOONIPS_NO_PRIVATE_INDEX', 'E0016' );//error if importing item is not registered any private indexes.
define( 'E_XOONIPS_ATTACHMENT_HAS_REDUNDANT', 'E0017' );//more than two attachments are given for an item that requires only one attachment.
define( 'E_XOONIPS_NOT_PERMITTED_ACCESS', 'E0018' );//not permitted access for index, item, ...
define( 'E_XOONIPS_TAG_NOT_FOUND', 'E0019' ); // required tag is omitted
define( 'E_XOONIPS_INVALID_VERSION', 'E0020' ); // unsupported version, format of version is invalid , ...
define( 'E_XOONIPS_PSEUDO_ID_CONFLICT', 'E0021' ); // pseudo_id conflicts
define( 'E_XOONIPS_RELATED_TO_CONFLICTING_ITEM', 'E0022' ); // an item relates to conflicting item
define( 'E_XOONIPS_TAG_REDUNDANT', 'E0023' );//redundant element tags

class XooNIpsObject extends XoopsObject
{
    /**
     * 
     * an array of error codes
     * 
     */
    var $error_codes = array();
    
    /**
     * add an error and error code
     *
     * @param string $err_code error code to add
     * @param string $err_str  error to add
     * @access public
     */
    function setErrors($err_code, $err_str)
    {
        $this -> error_codes[] = $err_code;
        parent::setErrors($err_str);
    }
    
    /**
     * 
     * insert or update item  
     *   
     * @return false if failed, true if insert successfully or already exists and unchanged.
     *   
     */
    function insert(){}

    /**
     * 
     * delete item  
     *   
     * @return false if failed, true if delete successfully
     *   
     */
    function delete(){}
    
    /**
     * return the error codes for this object as an array.
     * 
     * @return array an array of error codes
     * @access public
     */
    function getErrorCodes()
    {
        return $this -> error_codes;
    }
    
    function getErrorAt( $line, $file, $func ){
        return "";
//        return ( $func != null ? " in ${func}" : "" ) . ( $line != null ? " at line ${line}" : "" ) . ( $file != null ? " of ${file}" : "" );
    }



    /**
     * clean values of all variables of the object for storage.
     * also add slashes whereever needed
     * (support mbstring.)
     * @return bool true if successful
     * @access public
     */
    function cleanVars()
    {
        $ts =& MyTextSanitizer::getInstance();
        foreach ($this->vars as $k => $v) {
            $cleanv = $v['value'];
            if (!$v['changed']) {
            } else {
                $cleanv = is_string($cleanv) ? trim($cleanv) : $cleanv;
                switch ($v['data_type']) {
                case XOBJ_DTYPE_TXTBOX:
                    if ($v['required'] && $cleanv != '0' && $cleanv == '') {
                        $this->setErrors(E_XOONIPS_VALUE_IS_REQUIRED, "$k is required.");
                        continue;
                    }
                    if (isset($v['maxlength']) && strlen($cleanv) > intval($v['maxlength'])) {
                        $this->setErrors(E_XOONIPS_DATA_TOO_LONG, "$k must be shorter than ".intval($v['maxlength'])." characters.");
                        $cleanv = extension_loaded("mbstring")
                            ? mb_strcut( $cleanv, 0, $v['maxlength'], _CHARSET )
                            : substr( $cleanv, 0, $v['maxlength'] );
                        //continue;
                    }
                    if (!$v['not_gpc']) {
                        $cleanv = $ts->stripSlashesGPC($ts->censorString($cleanv));
                    } else {
                        $cleanv = $ts->censorString($cleanv);
                    }
                    break;
                case XOBJ_DTYPE_TXTAREA:
                    if ($v['required'] && $cleanv != '0' && $cleanv == '') {
                        $this->setErrors(E_XOONIPS_VALUE_IS_REQUIRED, "$k is required.");
                        continue;
                    }
                    if (isset($v['maxlength']) && strlen($cleanv) > intval($v['maxlength'])) {
                        $this->setErrors(E_XOONIPS_DATA_TOO_LONG, "$k must be shorter than ".intval($v['maxlength'])." characters.");
                        $cleanv = extension_loaded("mbstring")
                            ? mb_strcut( $cleanv, 0, $v['maxlength'], _CHARSET )
                            : substr( $cleanv, 0, $v['maxlength'] );
                        //continue;
                    }
                    if (!$v['not_gpc']) {
                        $cleanv = $ts->stripSlashesGPC($ts->censorString($cleanv));
                    } else {
                        $cleanv = $ts->censorString($cleanv);
                    }
                    break;
                case XOBJ_DTYPE_SOURCE:
                    if (!$v['not_gpc']) {
                        $cleanv = $ts->stripSlashesGPC($cleanv);
                    } else {
                        $cleanv = $cleanv;
                    }
                    break;
                case XOBJ_DTYPE_INT:
                    if ( !ctype_digit( "$cleanv" ) ){
                        $this->setErrors(E_XOONIPS_INVALID_VALUE, "Invalid value of integer($cleanv)");
                        continue;
                    }
                    $cleanv = intval($cleanv);
                    break;
                case XOBJ_DTYPE_EMAIL:
                    if ($v['required'] && $cleanv == '') {
                        $this->setErrors(E_XOONIPS_VALUE_IS_REQUIRED, "$k is required.");
                        continue;
                    }
                    if ($cleanv != '' && !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+([\.][a-z0-9-]+)+$/i",$cleanv)) {
                        $this->setErrors(E_XOONIPS_INVALID_VALUE, "Invalid Email");
                        continue;
                    }
                    if (!$v['not_gpc']) {
                        $cleanv = $ts->stripSlashesGPC($cleanv);
                    }
                    break;
                case XOBJ_DTYPE_URL:
                    if ($v['required'] && $cleanv == '') {
                        $this->setErrors(E_XOONIPS_VALUE_IS_REQUIRED, "$k is required.");
                        continue;
                    }
                    if ($cleanv != '' && !preg_match("/^http[s]*:\/\//i", $cleanv)) {
                        $cleanv = 'http://' . $cleanv;
                    }
                    if (!$v['not_gpc']) {
                        $cleanv =& $ts->stripSlashesGPC($cleanv);
                    }
                    break;
                case XOBJ_DTYPE_ARRAY:
                    $cleanv = serialize($cleanv);
                    break;
                case XOBJ_DTYPE_STIME:
                case XOBJ_DTYPE_MTIME:
                case XOBJ_DTYPE_LTIME:
                    $cleanv = !is_string($cleanv) ? intval($cleanv) : strtotime($cleanv);
                    break;
                default:
                    break;
                }
            }
            $this->cleanVars[$k] =& $cleanv;
            unset($cleanv);
        }
        if (count($this->_errors) > 0) {
            return false;
        }
        $this->unsetDirty();
        return true;
    }
}

?>
