<?php
header( "Content-Type: application/xml" );

include_once "../../mainfile.php";
include_once 'condefs.php';
include_once 'include/lib.php';
include_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];
xnp_get_config_value( 'public_item_target_user', $tree_publicize);

$emails = array();
$member_handler =& xoops_gethandler('member');
$members =& $member_handler->getUsersByGroup(XOOPS_GROUP_ADMIN, false);
foreach( $members as $userid ){
	$user =& $member_handler->getUser($userid);
	$emails[] = $user -> getVar( 'email' );
}

$xml_email = "";
foreach( $emails as $email ) {
	$xml_email .= "<adminEmail>${email}</adminEmail>
";
}
$date = gmdate( "Y-m-d\TH:i:s\Z", time( ) );
$header_val = '<?xml version="1.0" encoding="UTF-8" ?>
<concierge>
<baseURL>'.XOOPS_URL.'/modules/xoonips/concierge.php</baseURL>
'.$xml_email.'
<responseDate>'.$date.'</responseDate>
';
$footer_val = '</concierge>';

echo $header_val;
if( isset( $_GET['itemtype'] ) ){
	echo "<itemTypes>\n";
	echo concierge_get_itemtypes( );
	echo "</itemTypes>\n";
 }else if( isset( $_GET['indextree'] ) ){
	echo "<indexTree>\n";
	echo concierge_get_indextree( $xnpsid, $tree_publicize );
	echo "</indexTree>\n";
 }else {
	echo error( 'badArgument', 'no argument' );
 }
echo $footer_val;

function error( $errorcode, $text ) {
	return "<error code='${errorcode}'>${text}</error>\n";
}

function concierge_get_itemtypes( ) {
	$itemtypes = array();
	if( xnp_get_item_types( $itemtypes ) != RES_OK ){
        redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
        break;
	}

	$xml = "";
	foreach( $itemtypes as $dummy => $itemtype ) {
		if ( $itemtype['name'] != "xoonips_index" && $itemtype['name'] != "xoonips_binder" ){
			$xml .= "<itemType>\n".
			"<name>".$itemtype['name']."</name>\n".
			"<displayName>".$itemtype['display_name']."</displayName>\n".
			"<url>".XOOPS_URL."/modules/".$itemtype['name']."/".$itemtype['name'].".rng</url>\n".
				"</itemType>\n";
		}
	}
	return concierge_convert( $xml );
}

function concierge_get_indextree( $xnpsid, $tree_publicize ) {
	if ($tree_publicize == "all"){
		$indexes = array();
		$criteria = array( 'orders'=>array( array('name'=>'sort_number', 'order'=>'ASC' ) ) );
		$result = xnp_get_indexes( $xnpsid, 3, $criteria, $indexes );
		if ( $result != RES_OK ){
			redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
			exit;
		}
		$xml = "";
		foreach( $indexes as $dummy => $index ) {
			$xml .= "<index title='".$index['titles'][DEFAULT_INDEX_TITLE_OFFSET]."'>".
			concierge_get_indextree_child( $xnpsid, $index['item_id'] )
			."</index>\n";
		}
	}else{
		$xml =  error( 'badPermission', 'permission denied' );
	}
	return concierge_convert( $xml );
}

function concierge_get_indextree_child( $xnpsid, $xid ) {
	$xml = "";
	$indexes = array();
	$criteria = array( 'orders'=>array( array('name'=>'sort_number', 'order'=>'ASC' ) ) );
	$result = xnp_get_indexes( $xnpsid, $xid, $criteria, $indexes );

	if ( $result != RES_OK ){
		redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
		exit;
	}
	foreach( $indexes as $dummy => $index ) {
		$xml .= "<index title='".$index['titles'][DEFAULT_INDEX_TITLE_OFFSET]."'>".
			concierge_get_indextree_child( $xnpsid, $index['item_id'] )
		."</index>\n";
	}

	return concierge_convert( $xml );
}

function concierge_convert( $xml ) {
	if (xnpChkServerLang()) {
		if ( mb_detect_encoding( $xml ) != 'UTF-8' ){
			$xml = mb_convert_encoding( $xml, 'UTF-8', mb_detect_encoding( $xml ) );
		}
	}
	$xml = xnpEntity2Utf8($xml);

	return $xml;
}

?>
