<?php
//  $Revision: 1.16.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

// reserved item_id value
define( 'IID_ROOT', 1 );
define( 'IID_BINDERS', 2 );
define( 'IID_PUBLIC', 3 );
    
// reserved item'_'type'_'id value
define( 'ITID_INDEX', 1 );
define( 'ITID_BINDER', 2 );

    //IDs of item operation
define( 'OP_READ', 1 );
define( 'OP_MODIFY', 2 );
define( 'OP_DELETE', 3 );

define( 'DATETIME_FORMAT', 'M j, Y H:i:s' );
define( 'DATE_FORMAT', 'M j, Y' );
define( 'YEAR_MONTH_FORMAT', 'M, Y' );
define( 'YEAR_FORMAT', 'Y' );

define( 'NOT_CERTIFIED', 0 );
define( 'CERTIFY_REQUIRED', 1 );
define( 'CERTIFIED', 2 );

define( 'OL_PUBLIC', 1 );
define( 'OL_GROUP_ONLY', 2 );
define( 'OL_PRIVATE', 3 );
//
define( 'OP_REGISTER', 1 );
define( 'OP_UNREGISTER', 2 );

// Response of PHP Abstract Layer functions
define( 'RES_OK', 0 );
define( 'RES_ERROR', 1 );
define( 'RES_DB_NOT_INITIALIZED', 2 );
define( 'RES_LOGIN_FAILURE', 3 );
define( 'RES_NO_SUCH_SESSION', 4 );
define( 'RES_NO_SUCH_USER', 5 );
define( 'RES_NO_SUCH_GROUP', 6 );
define( 'RES_DB_QUERY_ERROR', 7 );
define( 'RES_DB_CONNECT_ERROR', 8 );
define( 'RES_DB_INITIALIZE_ERROR', 9 );
define( 'RES_NO_SUCH_ITEM', 10 );
define( 'RES_NO_WRITE_ACCESS_RIGHT', 11 );
define( 'RES_NO_READ_ACCESS_RIGHT', 12 );
define( 'RES_GROUPNAME_ALREADY_EXISTS', 13 );
define( 'RES_PHP_NONREF', 1000 );

define( 'XNPSID_GUEST', 0 ); // xoonips session id for guest 
define( 'UID_GUEST', 0 ); // xoonips user id for guest 
define( 'GID_DEFAULT', 1 );
define( 'SID_GUEST', "0" ); // 

define( 'SESSION_TIMEOUT_SEC', 3600 ); // <-> AL/commonal.h

define( 'ETID_LOGIN_FAILURE'          ,  1 );
define( 'ETID_LOGIN_SUCCESS'          ,  2 );
define( 'ETID_LOGOUT'                 ,  3 );
define( 'ETID_INSERT_ITEM'            ,  4 );
define( 'ETID_UPDATE_ITEM'            ,  5 );
define( 'ETID_DELETE_ITEM'            ,  6 );
define( 'ETID_VIEW_ITEM'              ,  7 );
define( 'ETID_DOWNLOAD_FILE'          ,  8 );
define( 'ETID_REQUEST_CERTIFY_ITEM'   ,  9 );
define( 'ETID_INSERT_INDEX'           , 10 );
define( 'ETID_UPDATE_INDEX'           , 11 );
define( 'ETID_DELETE_INDEX'           , 12 );
define( 'ETID_CERTIFY_ITEM'           , 13 );
define( 'ETID_REJECT_ITEM'            , 14 );
define( 'ETID_REQUEST_INSERT_ACCOUNT' , 15 );
define( 'ETID_CERTIFY_ACCOUNT'        , 16 );
define( 'ETID_INSERT_GROUP'           , 17 );
define( 'ETID_UPDATE_GROUP'           , 18 );
define( 'ETID_DELETE_GROUP'           , 19 );
define( 'ETID_INSERT_GROUP_MEMBER'    , 20 );
define( 'ETID_DELETE_GROUP_MEMBER'    , 21 );
define( 'ETID_VIEW_TOP_PAGE'          , 22 );
define( 'ETID_QUICK_SEARCH'           , 23 );
define( 'ETID_ADVANCED_SEARCH'        , 24 );
define( 'ETID_START_SU'               , 25 );
define( 'ETID_END_SU'                 , 26 );
define( 'ETID_MAX'                    , 26 );

//metadata event id
define( 'ME_CREATED', 1 );
define( 'ME_MODIFIED', 2 );
define( 'ME_DELETED', 3 );

// 
define( 'DESC', 1 );
define( 'ASC', 0 );

// OAI-PMH
define( 'REPOSITORY_RESPONSE_LIMIT_ROW', 100 ); //result rows per a request
define( 'REPOSITORY_RESUMPTION_TOKEN_EXPIRE_TERM', 1000 ); //term which in resumptionToken is available[Sec]

// Pubmed Complete
define( 'PUBMED_EFETCH_URL_BASE', "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&id=");
define( 'PUBMED_ESEARCH_URL_BASE', "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=journals&term=");
define( 'PUBMED_ESUMMARY_URL_BASE', "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=journals&id=");

// XooNIps Configurations
define( 'XNP_CONFIG_CERTIFY_ITEM_KEY',  'certify_item' );
define( 'XNP_CONFIG_CERTIFY_ITEM_AUTO', 'auto' );
define( 'XNP_CONFIG_CERTIFY_ITEM_ON',   'on' );
define( 'XNP_CONFIG_CERTIFY_ITEM_OFF',  'off' );
define( 'XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY',  'public_item_target_user' );
define( 'XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_PLATFORM',  'platform' );
define( 'XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_ALL',  'all' );
define( 'XNP_CONFIG_REPOSITORY_NIJC_CODE', 'repository_nijc_code' );
define( 'XNP_CONFIG_CERTIFY_USER_KEY',  'certify_user' );
define( 'XNP_CONFIG_CERTIFY_USER_AUTO',  'auto' );
define( 'XNP_CONFIG_CERTIFY_USER_ON',  'on' );

define( 'XNP_PRIVATE_INDEX_TITLE', 'Private' );

define( 'XOONIPS_WINDOW_SIZE', 4 ); // using in generating search_text

define( 'DEFAULT_INDEX_TITLE_OFFSET', 0 ); //Define a integer number to specify a index title which to be used for displaying index tree(see xoonips_item_title.title_id)
define( 'DEFAULT_ORDER_TITLE_OFFSET', 0 ); //Define a integer number to specify a title which to be used for sorting for listing item(see xoonips_item_title.title_id)

// Index Tree
define( 'XOONIPS_TREE_SWAP_IMAGE_DIR', 'xoonips_images' );
?>
