<?php
//  $Revision: 1.13 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

/* Downloads attached file with or without compress option
 * 
 * input:
 *    $_GET['file_id']
 * 
 * 1. Temporary file in the download procedure will be made in /tmp.
 * 2. Temporary file and directory will be removed after the download completion.
 * bug: /tmp file will be retain when the httpd terminated abnormally.
 * 
 */

session_cache_limiter('none'); // avoid IE bug1 -> http://jp2.php.net/header  Harry 10-Dec-2004 03:26

include '../../mainfile.php';
require_once 'include/create_session.php';
require_once 'include/lib.php';
require_once 'condefs.php';

function error($message){
	header("HTTP/1.0 500 Internal Server Error");
	echo "error:" . $message;
	exit;
}

function error403(){
	header("HTTP/1.0 403 Forbidden");
	echo "403 Forbidden";
	exit;
}

function error404(){
	header("HTTP/1.0 404 Not Found");
	echo "404 Not Found";
	exit;
}

xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];
if (is_object($xoopsUser))
	$uid = $xoopsUser->getVar('uid');
else
	$uid = UID_GUEST;



// -> fileID
if (empty($_GET['file_id'])){
	error404();
}
$fileID = (int)$_GET['file_id'];


// fileID -> itemID, mid, etc.
$itemTable = $xoopsDB->prefix('xoonips_item_basic');
$itemTypeTable = $xoopsDB->prefix('xoonips_item_type');
$fileTable = $xoopsDB->prefix('xoonips_file');
$fileTypeTable = $xoopsDB->prefix('xoonips_file_type');
$moduleTable = $xoopsDB->prefix('modules');
$sql = "select tf.item_id, tf.file_id, tf.original_file_name, tf.mime_type, tit.item_type_id, tit.name, tit.display_name ".
	" from $fileTable as tf ".
	" left join $fileTypeTable as tft on tf.file_type_id=tft.file_type_id ".
	" left join $moduleTable as tm on tft.mid=tm.mid ".
	" left join $itemTable as ti on ti.item_id=tf.item_id ".
	" left join $itemTypeTable as tit on tit.item_type_id=ti.item_type_id " .
	" where file_id=${fileID}";
$result = $xoopsDB->query($sql);
if ($result == false || $xoopsDB->getRowsNum($result) == 0){
	error404();
}
list($item_id, $fileID, $originalFileName, $mimeType, $item_type_id, $name, $item_type_display_name ) = $xoopsDB->fetchRow($result);

$itemtypes = array();
$result = xnp_get_item_types( $itemtypes );
if ( $result != RES_OK )
	error(_MD_XOONIPS_ITEM_BAD_FILE_TYPE);
foreach ( $itemtypes as $itemtype ){
	if ( $itemtype['item_type_id'] == $item_type_id )
		break;
}
// include view.php
if ("" != $item_type_id){
	include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
	$fname = "${name}GetMetaInformation";
}
else {
	error(_MD_XOONIPS_ITEM_BAD_FILE_TYPE);
}


// Check the access rights.
$item = array();
if (0 != xnp_get_item($xnpsid,$item_id,$item)){
	error403();
}


// Remove the temporary files at the end of this function. 
function onShutdown(){
	global $removeFiles;
	global $removeDir;
	global $lockFile;
	foreach ($removeFiles as $file)
		unlink($file);
	if ($removeDir) rmdir($removeDir);
	if ($lockFile) unlink($lockFile); // delete last.
}

// Check the download limitations. 
include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
$fname_dllimit = "${name}GetAttachmentDownloadLimitOption";
if( function_exists( $fname_dllimit ) && $fname_dllimit( $item_id ) == 1 ){
	// If not a user, redirect to user.php
	// Log in first to download
	if ($uid==UID_GUEST){
		$parsed = parse_url(XOOPS_URL);
        header( "Location:".XOOPS_URL.'/modules/xoonips/user.php?xoops_redirect='.urlencode( $parsed['path']."/modules/xoonips/detail.php?item_id=${item_id}&op=download&download_file_id=${fileID}" ) );
		exit();
    }
}

$lockFile = "";
$removeDirs  = array(); // Directories to remove at the end of the procedures.
$removeFiles = array(); // Files       to remove at the end of the procedures.

register_shutdown_function('onShutdown');

// Bring the attachment file to the working (temporary) directory.
//
// todo: There is a possibility that originalFileName contains illegal charecters.
//       It is necessary to remove these codes.
//       Currently these codes are just avoided by using "urlencode".
//       More effective sanitizing ways should be incorporated.
//
if ( strstr($originalFileName, '..') ){
  error(_MD_XOONIPS_ITEM_BAD_FILE);
 }
//$attachmentFileName = urlencode($originalFileName);
$attachmentFileName = $originalFileName;
if ( substr_count( $_SERVER["HTTP_USER_AGENT"], "Mac" ) > 0 ){
	if (xnpChkServerLang()) {
		if (mb_detect_encoding($attachmentFileName) != 'UTF-8' ){
			$attachmentFileName = mb_convert_encoding($attachmentFileName,'UTF-8',mb_detect_encoding($attachmentFileName));
		}
		if (!xnpChkClientLang()) {
			$attachmentFileName = xnpUtf82Entity($attachmentFileName);
		}
	}
	else {
		if (xnpChkClientLang()) {
			$attachmentFileName = xnpEntity2Utf8($attachmentFileName);
		}
	}
}
elseif ( substr_count( $_SERVER["HTTP_USER_AGENT"], "Windows" ) > 0 ){
	if (xnpChkServerLang()) {
		if (xnpChkClientLang()) {
			if( !preg_match("/MSIE/", $_SERVER["HTTP_USER_AGENT"]) ){
				// plane filename for Firefox : use UTF-8, in other case use Shift-JIS
				$attachmentFileName4plane = mb_convert_encoding($attachmentFileName, 'UTF-8', mb_detect_encoding($attachmentFileName));
				$attachmentFileName4zip = mb_convert_encoding($attachmentFileName,'SJIS',mb_detect_encoding($attachmentFileName));
			} else {
				$attachmentFileName = mb_convert_encoding($attachmentFileName,'SJIS',mb_detect_encoding($attachmentFileName));
			}
		}
		else {
			if (mb_detect_encoding($attachmentFileName) != 'UTF-8' ){
				$attachmentFileName = mb_convert_encoding($attachmentFileName,'UTF-8',mb_detect_encoding($attachmentFileName));
			}
			$attachmentFileName = xnpUtf82Entity($attachmentFileName);
		}
	}
	else {
		if (xnpChkClientLang()) {
			if (!preg_match("/MSIE/", $_SERVER["HTTP_USER_AGENT"])){
				// plane filename for Firefox : use UTF-8, in other case use Shift-JIS
				$attachmentFileName4plane = xnpEntity2Utf8($attachmentFileName);
				$attachmentFileName4zip = xnpEntity2Sjis($attachmentFileName);
			} else {
				$attachmentFileName = xnpEntity2Sjis($attachmentFileName);
			}
		}
	}
}
else {
	if ( substr_count( $_SERVER["HTTP_USER_AGENT"], "Fedora" ) > 0 ){
		if (xnpChkServerLang()) {
			if (mb_detect_encoding($attachmentFileName) != 'UTF-8' ){
				$attachmentFileName = mb_convert_encoding($attachmentFileName,'UTF-8',mb_detect_encoding($attachmentFileName));
			}
			if (!xnpChkClientLang()) {
				$attachmentFileName = xnpUtf82Entity($attachmentFileName);
			}
		}
		else {
			if (xnpChkClientLang()) {
				$attachmentFileName = xnpEntity2Utf8($attachmentFileName);
			}
		}
	}
	else {
		if (xnpChkServerLang()) {
			if (xnpChkClientLang()) {
				if (mb_detect_encoding($attachmentFileName) != 'EUC-JP' ){
					$attachmentFileName = mb_convert_encoding($attachmentFileName,'EUC-JP',mb_detect_encoding($attachmentFileName));
				}
			}
			else {
				if (mb_detect_encoding($attachmentFileName) != 'UTF-8' ){
					$attachmentFileName = mb_convert_encoding($attachmentFileName,'UTF-8',mb_detect_encoding($attachmentFileName));
				}
				$attachmentFileName = xnpUtf82Entity($attachmentFileName);
			}
		}
		else {
			if (xnpChkClientLang()) {
				$attachmentFileName = xnpEntity2Eucjp($attachmentFileName);
			}
		}
	}
}

// Get the download option ON:COMPRESS with METADATA, OFF:UNCOMPRESS
$result = xnp_get_config_value( 'download_file_compression', $download_val);
if ( $result != RES_OK ) error(_MD_XOONIPS_DOWNLOAD_ABNORMAL_CONFIGURATION);


if ($download_val == 'on'){
// Download Zipped file mode
  
  // Prepare the working directory at /tmp/ for generating ZIP
  $removeFiles[] = $lockFile = tempnam('/tmp/', 'XooNIpsDownload');
  if (false === $lockFile){
    error(_MD_XOONIPS_ITEM_CANNOT_CREATE_TMPFILE);
  }
  $removeDir = $baseDir = $lockFile . 'D';
  if (false === mkdir($baseDir)){
    error(_MD_XOONIPS_ITEM_CANNOT_CREATE_TMPFILE);
  }
  chdir($baseDir);

  // Generate temporary filename in /tmp from the sanitized file name.
  $rawFiles = array(); // Files will be zipped.
  if( isset($attachmentFileName4zip) ){
  	$removeFiles[] = $baseDir . '/' . $attachmentFileName4zip;
	$rawFiles[] = $attachmentFileName4zip;
	if( !function_exists('symlink') || false === symlink(xnpGetUploadFilePath($fileID), $attachmentFileName4zip) ){
		if( false == copy(xnpGetUploadFilePath($fileID), $attachmentFileName4zip) ){
			error( _MD_XOONIPS_ITEM_CANNOT_CREATE_TMPFILE );
		}
	}
  } else {
	 $removeFiles[] = $baseDir . '/' . $attachmentFileName;
	 $rawFiles[] = $attachmentFileName;
	 if (!function_exists('symlink') || false === symlink(xnpGetUploadFilePath($fileID), $attachmentFileName)){
	    if (false == copy(xnpGetUploadFilePath($fileID), $attachmentFileName)){
			error(_MD_XOONIPS_ITEM_CANNOT_CREATE_TMPFILE);
		}
	 }
  }

  // Generate attached metadata.
  $meta = $fname($item_id); //return arary('title' => 'title char lists',...)
  $removeFiles[] = $baseDir . '/metainfo.txt';
  $rawFiles[] = 'metainfo.txt';
  $h = fopen('metainfo.txt', "w");
  if (false === $h){
    error(_MD_XOONIPS_ITEM_CANNOT_CREATE_TMPFILE);
  }
/*
  foreach ($meta as $key=>$val){
    fwrite($h, $key);
    $val = str_replace("\r","\n",str_replace("\r\n", "\n", $val));
    $ar = explode("\n", $val);
    if (count($ar) <= 1){
      fwrite($h, ": ");
      fwrite($h, $val);
      fwrite($h, "\r\n");
    }
    else {
      fwrite($h, ": \r\n  ");
      fwrite($h, implode("\r\n  ", $ar));
      fwrite($h, "\r\n");
    }
  }
  fwrite($h, _MD_XOONIPS_ITEM_DETAIL_URL.": ".XOOPS_URL."/modules/xoonips/detail.php?item_id=$item_id\r\n");
*/
  $wk = "";
  foreach ($meta as $key=>$val){
  	$wk .= $key;
  	$val = str_replace("\r","\n",str_replace("\r\n", "\n", $val));
  	$ar = explode("\n", $val);
  	if (count($ar) <= 1){
  		$wk .= ": ";
  		$wk .= $val;
  		$wk .= "\r\n";
  	}
  	else {
  		$wk .= ": \r\n  ";
  		$wk .= implode("\r\n  ", $ar);
  		$wk .= "\r\n";
  	}
  }
  $wk .= _MD_XOONIPS_ITEM_DETAIL_URL.": ".XOOPS_URL."/modules/xoonips/detail.php?item_id=$item_id\r\n";
  if (xnpChkServerLang()) {
  	if (mb_detect_encoding($wk) != 'UTF-8' ) {
  		$wk = mb_convert_encoding($wk,'UTF-8',mb_detect_encoding($wk));
  	}
  	if (!xnpChkClientLang()) {
  		$wk = xnpUtf82Entity($wk);
  	}
  }
  else {
  	if (xnpChkClientLang()) {
  		$wk = xnpEntity2Utf8($wk);
  	}
  }
  fwrite($h, $wk);
  fclose($h);

  // Generate ZIP
  $removeFiles[] = $DownloadFile = $baseDir . '/zip.zip';
  $result = xnp_zip_create($DownloadFile, $rawFiles);
  if (0 != $result){
    var_dump( $DownloadFile );
    var_dump( $rawFiles );
    passthru( "ls -al $baseDir" );
    print_r (get_loaded_extensions());
    print_r (get_extension_funcs ("XNPAL"));
    error(_MD_XOONIPS_ITEM_CANNOT_CREATE_ZIP . "result=$result");
  }
  $DownloadMimeType = 'application/zip';
  $DownloadFileName = "${item_type_display_name}_${fileID}.zip";

 }else if ($download_val == 'off'){
// Download plane file mode (download uncompressed file without metadata)
  $result = xnp_get_config_value( 'upload_dir', $upload_dir_val);
  if ( $result != RES_OK ) error(_MD_XOONIPS_DOWNLOAD_ABNORMAL_CONFIGURATION);
  $DownloadMimeType = $mimeType;
  if( isset($attachmentFileName4plane) ){
  	$DownloadFileName = $attachmentFileName4plane;
  } else {
  	$DownloadFileName = $attachmentFileName;
  }
  $DownloadFile     = $upload_dir_val .'/' . $fileID;

 }else{
  error(_MD_XOONIPS_DOWNLOAD_ABNORMAL_CONFIGURATION);  
 }
$size = filesize($DownloadFile);

// Record download file LOG.
xnp_insert_event( $xnpsid, ETID_DOWNLOAD_FILE, time(), $uid, xnpGetRemoteHost(), array( 'item_id' => $item_id, 'file_id' => $fileID ) );

// If character auto translation ON -> OFF
if (function_exists('mb_http_output')){
	mb_http_output('pass');
}

header("Cache-Control: none");  // avoid IE bug 2
//header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0"); 
// ^^This is the default output of "cache-control"
header("Content-Type: \'${DownloadMimeType}\"");
header("Content-Disposition: attachment; filename=\"${DownloadFileName}\"");
header("Content-Length: $size");
readfile($DownloadFile);
/*
echo $mimeType;
echo $baseDir;
echo "<br>\n";
var_dump($rawFiles);
*/
?>
