<?php
//  $Revision: 1.10 $                                                            //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //


global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xoonips/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xoonips/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xoonips/language/english/main.php' );
}


/** Get DetailInformation from item_id.
  * Return item's array registered in binder specified by $item_id.
  * @return Array => Execution result
  * @return false => Miss
  */
function xoonips_binderGetDetailInformation( $item_id ){
	$xnpsid = $_SESSION['XNPSID'];
    
	global $xoopsDB;
	$result = $xoopsDB->query( "select item_id from " .
		$xoopsDB->prefix("xoonips_binder_item_link").
		" where binder_id=$item_id order by sort_num" );
	if ( $result == false )
		return false;
	
	$ids = array();
	while( $row = $xoopsDB->fetchRow($result) ){
		$ids[] = $row[0];
	}
    
	$items = array();
	$cri = array( );
	if( xnp_get_items( $xnpsid, $ids, $cri, $items ) != RES_OK ){
        //can't retrieve items
        return false;
    }
	
	return $items;
}

function xoonips_binderGetListBlock( $item_basic ){
 	$item_id = $item_basic['item_id'];
	
	// Get DetailInformation from function.
	$items = xoonips_binderGetDetailInformation( $item_id );
	$item_detail = array( 'items' => $items, 'itemcount' => count( $items ) );
	
	// Variables are set to template.
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	// Variables set to $xoopsTpl is copied to $tpl.
	$tpl->assign( $xoopsTpl->get_template_vars() );
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
	
	// Output in HTML.
	return $tpl->fetch( "db:xoonips_list_block.html" );
}


function xoonips_binderGetDetailBlock( $item_id ){
	$xnpsid = $_SESSION['XNPSID'];
	
	// Get Block of BasicInformation / RegisteredItem.
	$basic  = xnpGetBasicInformationDetailBlock( $item_id );
	$index  = xnpGetIndexDetailBlock( $item_id );
	$detail = xnpGetRegisteredItems( $item_id );
	
	// Variables are set to template.
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	// Variables set to $xoopsTpl ( $xoops_url etc.. ) is copied to $tpl.
	$tpl->assign( $xoopsTpl->get_template_vars() );
	
	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'detail', $detail );
	
	// Output in HTML.
	return $tpl->fetch( "db:xoonips_detail_block.html" );
}

function xoonips_binderGetPrinterFriendlyDetailBlock( $item_id ){
	$xnpsid = $_SESSION['XNPSID'];
	
	// Get Block of BasicInformation / RegisteredItem.
	$basic  = xnpGetBasicInformationPrinterFriendlyBlock( $item_id );
	$index  = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$detail = xnpGetRegisteredItems( $item_id );
	
	// Variables are set to template.
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	// Variables set to $xoopsTpl ( $xoops_url etc.. ) is copied to $tpl.
	$tpl->assign( $xoopsTpl->get_template_vars() );
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'detail', $detail );
	
	// Output in HTML.
	return $tpl->fetch( "db:xoonips_detail_block.html" );
}

function xoonips_binderGetRegisterBlock(){
	global $xoopsDB;

	// Get Block of BasicInformation / RegisteredItem.
	$basic   = xnpGetBasicInformationRegisterBlock();
	$index   = xnpGetIndexRegisterBlock();
	$items = xnpGetToBeRegisteredItems();
	
	// Variables are set to template.
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	// Variables set to $xoopsTpl ( $xoops_url etc.. ) is copied to $tpl.
	$tpl->assign( $xoopsTpl->get_template_vars() );
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'detail', $items );
	$tpl->assign( 'jumpto_url', 'register.php' );
	
	// Output in HTML.
	return $tpl->fetch( "db:xoonips_register_block.html" );
}

function xoonips_binderGetEditBlock( $item_id ){
	global $xoopsDB;
	$items = array();
	
	// Get block of BasicInformation / Preview / index
	$basic = xnpGetBasicInformationEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
 	if( !array_key_exists( 'xoonips_item_id', $_GET ) && !array_key_exists( 'xoonips_item_id', $_POST )
        && !(isset($_GET['op']) && $_GET['op'] == 'add_selected_item') && !(isset($_POST['op']) && $_POST['op'] == 'add_selected_item') ){
 		$items = xnpGetRegisteredItems( $item_id );
 	}else{
  		$items = xnpGetToBeRegisteredItems( );
  	}
	
	// Variables are set to template.
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	// Variables set to $xoopsTpl ( $xoops_url etc.. ) is copied to $tpl.
	$tpl->assign( $xoopsTpl->get_template_vars() );

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'detail', $items );
	$tpl->assign( 'jumpto_url', 'edit.php' );
	
	// Output in HTML.
	return $tpl->fetch( "db:xoonips_register_block.html" );
}


function xoonips_binderGetConfirmBlock( $item_id ){
	
	// Get block of BasicInformation / Preview / index
	$basic = xnpGetBasicInformationConfirmBlock( $item_id );
	$index = xnpGetIndexConfirmBlock( $item_id );
	$items = xnpGetToBeRegisteredItems();
	
	// Variables are set to template.
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	// Variables set to $xoopsTpl ( $xoops_url etc.. ) is copied to $tpl.
	$tpl->assign( $xoopsTpl->get_template_vars() );
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'detail', $items );
	
	// Output in HTML.
	return $tpl->fetch( "db:xoonips_confirm_block.html" );
}

function xoonips_binderInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// Insert BasicInformation, Index, Preview, Attachment
	$binder_id = 0;
	$result = xnpInsertBasicInformation( $binder_id );
	if ( $result ){
		$result = xnpUpdateIndex( $binder_id );
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $binder_id );
	}
	if ( !$result )
		return false;
	
	// Insert DetailInformation
	foreach( $_POST['xoonips_item_id'] as $iid ){
		$result = $xoopsDB->queryF( "insert into " . $xoopsDB->prefix("xoonips_binder_item_link")
                                    . " ( binder_id, item_id ) values ( $binder_id, $iid )" );
		if ( $result == false ){
			echo "cannot insert item_detail";
			return false;
		}
	}
	return true;
}

function xoonips_binderUpdateItem( $binder_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// Edit BasicInformation, Index, Preview, Attachment
	$result = xnpUpdateBasicInformation( $binder_id );
	if ( $result ){
		$result = xnpUpdateIndex( $binder_id );
		if ( $result ){
			$result = xnp_insert_change_log( $xnpsid, $binder_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
			$result = !$result;
			if( !$result )
				echo " xnp_insert_change_log failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
    
	// Insert DetailInformation
	$result = $xoopsDB->queryF( "delete from " . $xoopsDB->prefix("xoonips_binder_item_link") . " where binder_id=$binder_id" );
	foreach( $_POST['xoonips_item_id'] as $iid ){
		$result = $xoopsDB->queryF( "insert into " . $xoopsDB->prefix("xoonips_binder_item_link")
                                    . " ( binder_id, item_id ) values ( $binder_id, $iid )" );
		if ( $result == false ){
			echo "cannot insert item_detail";
			return false;
		}
	}
	return true;
}

function xoonips_binderDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// Delete BasicInformation, Index, Preview, Attachment
	if( !xnpDeleteBasicInformation( $item_id ) ){
        echo "cannot delete binder item";
        return false;
	}        
	
	// Delete DetailInformation
    $result = $xoopsDB->queryF( "delete from " . $xoopsDB->prefix("xoonips_binder_item_link") . " where binder_id=$item_id )" );
    
	return true;
}







function xoonips_binderGetSearchBlock( $item_id ){
	// todo: It is not decide yet.
}

/*
 *
 * If item_id registered from now on is given by GET/POST,
 * item's information is read from database and it returns as association_array.
 * op=='delete'  =>  IDs in selected_id[] delete from item_id[].
 *
 * Structure of association_array
 *   array( 'html' => HTML of item's information, 'item_id' => number of item_id )
 *
 */
function xnpGetToBeRegisteredItems( )
{
	$xnpsid = $_SESSION['XNPSID'];
	$items = array();
	$cri = array();
	$selected = array();
	$item_id = array();
	
	if( array_key_exists( 'selected', $_GET ) ){
		$selected = $_GET['selected'];
	}else if( array_key_exists( 'selected', $_POST ) ){
		$selected = $_POST['selected'];
	}
	if( array_key_exists( 'xoonips_item_id', $_GET ) ){
		$item_id = $_GET['xoonips_item_id'];
	}else if( array_key_exists( 'xoonips_item_id', $_POST ) ){
		$item_id = $_POST['xoonips_item_id'];
	}
	
	$op = '';
	if( array_key_exists( 'op', $_GET ) ){
		$op = $_GET['op'];
	}else if( array_key_exists( 'op', $_POST ) ){
		$op = $_POST['op'];
	}
	
	if( $op == 'delete' ){
		$item_id = array_diff( $item_id, $selected ); //delete selected items from item_id
	}else if( $op == 'add_selected_item' ){
		$item_id = array_unique( array_merge( $item_id , $selected ) ); //merge 2 arrays and unique
		$selected = array();
	}
	
	xnp_get_items( $xnpsid, $item_id, $cri, $items );
	$itemtypes = array();//$itemtypes[<item_type_id>]=array( detail of an itemtype );
	$tmp = array();
	if( xnp_get_item_types( $tmp ) != RES_OK ){
		redirect_header(XOOPS_URL.'/modules/xoonips/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
		break;
	}else{
		foreach( $tmp as $i){
			$itemtypes[$i['item_type_id']] = $i;
		}
	}
	
	$item_details = array();
	foreach( $items as $i ){
		if( array_key_exists( $i['item_type_id'], $itemtypes ) ){
			$itemtype = $itemtypes[$i['item_type_id']];
			include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
			eval( "\$body = ".$itemtype['name']."GetListBlock( \$i );" );
			$item_details[]=array('item_id' => $i['item_id'], 'html' => $body );
		}
	}
	return $item_details;
}


/**
 * 
 * Item's information registered in binder specified by $binder_id
 * is read from database and it returns as association_array.
 * 
 * Structure of assciation_array
 *   array( 'html' => HTML of item's information, 'item_id' => number of item_id )
 * 
 * @param binder_id "ID of the binder for processing"
 * @return Array => Execution result
 * @return false => Miss
 *
 */
function xnpGetRegisteredItems( $binder_id )
{
	$xnpsid = $_SESSION['XNPSID'];
	$items = array();
	$cri = array();
	$item_id = array();

	if( xnp_get_item_id_by_binder_id( $xnpsid, $binder_id, $cri, $item_id ) != RES_OK ){
		return false;
	}
	
	if( xnp_get_items( $xnpsid, $item_id, $cri, $items ) != RES_OK ){
		return false;
	}
	
	$itemtypes = array();//$itemtypes[<item_type_id>]=array( detail of an itemtype );
	$tmp = array();
	if( xnp_get_item_types( $tmp ) != RES_OK ){
		redirect_header(XOOPS_URL.'/modules/xoonips/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
		break;
	}else{
		foreach( $tmp as $i){
			$itemtypes[$i['item_type_id']] = $i;
		}
	}
	
	$item_details = array();
	foreach( $items as $i ){
		if( array_key_exists( $i['item_type_id'], $itemtypes ) ){
			$itemtype = $itemtypes[$i['item_type_id']];
			include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
			eval( "\$body = ".$itemtype['name']."GetListBlock( \$i );" );
			$item_details[]=array('item_id' => $i['item_id'], 'html' => $body );
		}
	}
	return $item_details;
}

function xoonips_binderCheckRegisterParameters( &$msg ){
	if( array_key_exists( 'xoonips_item_id', $_POST ) ){
		$xoonips_item_id = $_POST['xoonips_item_id'];
		if( count( $xoonips_item_id ) > 0 ){
            return true;
    	}else{
            $msg = $msg."<br/><font color='#ff0000'>"._MD_XOONIPS_BINDER_ITEM_REQUIRED."</font>";
            return false;
        }
    }
    $msg = $msg."<br/><font color='#ff0000'>"._MD_XOONIPS_BINDER_ITEM_REQUIRED."</font>";
    return false;
}    

function xoonips_binderCheckEditParameters( &$msg ){
	return xoonips_binderCheckRegisterParameters( $msg );
}

function xoonips_binderGetMetaInformation( $item_id )
{
	//binder's meta information is not required.
	return array();
}

function xoonips_binderGetModifiedFields( $item_id )
{
	$ret = array();
	$new_iids = $_POST['xoonips_item_id'];
	$old_iids = array();
	$result = xnp_get_item_id_by_binder_id( $_SESSION['XNPSID'], $item_id, array(), $old_iids );
	if ( $result == RES_OK ){
		$diff = array_diff( $new_iids, $old_iids ) + array_diff( $old_iids, $new_iids );
		if ( count( $diff ) )
			array_push( $ret, _MD_XOONIPS_BINDER_ITEM_LABEL );
	}
	
	return $ret;
}


?>
