<?php
//  $Revision: 1.18.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005-2007 RIKEN, Japan. All rights reserved.                  //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

// include language definition for messages
if ( file_exists(XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/main.php") ) {
    include_once XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/main.php";
} else {
    if ( file_exists(XOOPS_ROOT_PATH."/modules/xoonips/language/english/main.php") ) {
        include_once XOOPS_ROOT_PATH."/modules/xoonips/language/english/main.php";
    }
}
include_once XOOPS_ROOT_PATH.'/modules/xoonips/condefs.php';
include_once XOOPS_ROOT_PATH.'/modules/xoonips/include/AL.php';

/* Functions to load AL, initialize AL, make session. 
 * $Revision: 1.18.2.1 $
 */
	
	/** Load and initialize AL
	 @return 0 succeess
	 @return 1 bad config
	 @return 2 cannot initialize
	 @return 3 cannot dl(); enable_dl is off
	 @return 4 cannot dl(); enable_dl is on
	 @return 5 dsn is empty
	 */
	function xnp_load_al_silent(){
		return 0; // for upper compatibility 
	}
	
	
	/** process the error code in xnp_load_al_silent()
		@param result  error code
		@return nothing
	 */
	function xnp_load_al_error( $result ){
		if ($result > 0) {
			if ($result == 1) {
				redirect_header(XOOPS_URL.'/index.php', 5, _MD_XOONIPS_ACCOUNT_BAD_CONFIG);
			}
			else if ($result == 2) {
				redirect_header(XOOPS_URL.'/index.php', 5, _MD_XOONIPS_ACCOUNT_CANNOT_INITIALIZE_AL);
			}
			else if ($result == 3) {
				redirect_header(XOOPS_URL.'/index.php', 5, "enable_dl off");
			}
			else if ($result == 4) {
				redirect_header(XOOPS_URL.'/index.php', 5, "cannot load");
			}
			else if ($result == 5) {
				redirect_header(XOOPS_URL.'/index.php', 5, _MD_XOONIPS_ACCOUNT_DSN_EMPTY);
			}
			else
				echo "ERROR: $result " . __FILE__ . "/" . __LINE__;
			exit;
		}
	}
	
	/** load and initialize AL. 
		If error occurs, display error messages and move to top page.
		@param nothing
		@return nothing
	 */
	function xnp_load_al(){
		global $xoopsConfig;
		if ( file_exists(XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php') ) {
			require_once XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php';
		} else {
			require_once XOOPS_ROOT_PATH.'/modules/xoonips/language/english/main.php';
		}
		
		$result = xnp_load_al_silent();
		if ($result > 0)
			xnp_load_al_error( $result );
	}
	
	/** load, initialize, and make sessions. 
	 *	Sessions are displayed to $_SESSION '[XNPSID]'.
	 */
	function xnp_load_init_create_session_silent(){
		global $xoopsDB;
		
		$sess_id = session_id();
		if ( xnp_is_valid_session_id( $sess_id ) && isset($_SESSION['xoopsUserId']) && xnp_is_activated(session_id(), $_SESSION['xoopsUserId']) ){
			//XooNIps user
			$_SESSION['XNPSID'] = $sess_id;
			$xoopsDB->queryF( "update " . $xoopsDB->prefix('xoonips_session') . " set updated=now() where sess_id='".addslashes($sess_id)."'" );
		}
		else if( isset($_SESSION['xoopsUserId']) ){
			// log out if this XOOPS user is not XooNIps user
			$_SESSION = array();
			session_destroy();
			if ( isset($xoopsConfig) && $xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
			    setcookie($xoopsConfig['session_name'], '', time()- 3600, '/',  '', 0);
			}
			// clear entry from online users table
			if (isset($xoopsUser) && is_object($xoopsUser)) {
			    $online_handler =& xoops_gethandler('online');
			    $online_handler->destroy($xoopsUser->getVar('uid'));
			}
			redirect_header(XOOPS_URL.'/index.php', 3, _MD_XOONIPS_ACCOUNT_NOT_ACTIVATED);
		}
		else{
			//accept if guest
			$_SESSION['XNPSID'] = SID_GUEST;
		}
		return 0;
	}

	function xnp_load_init_create_session(){
		global $xoopsConfig;
		if ( file_exists(XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php') ) {
			require_once XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php';
		} else {
			require_once XOOPS_ROOT_PATH.'/modules/xoonips/language/english/main.php';
		}
		
		$result = xnp_load_init_create_session_silent();
		if ( $result > 0 )
			xnp_load_al_error( $result );
	}
?>
