<?php
//  $Revision: 1.5 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
function
filesize_private(  )
{
	$iids = array(  );
	if( xnp_get_private_item_id
		( $_SESSION['XNPSID'], $_SESSION['xoopsUserId'], $iids ) != RES_OK ) {
		return 0;
	}
	return filesize_by_item_id( $iids );
}

function
filesize_group( $gid )
{
	$iids = array(  );
	if( xnp_get_group_item_id( $_SESSION['XNPSID'], $gid, $iids ) != RES_OK ) {
		return 0;
	}
	return filesize_by_item_id( $iids );
}

function
filesize_by_item_id( $iids )
{
	$itemtypes = array(  );
	if( xnp_get_item_types( $itemtypes ) != RES_OK ) {
		return 0;
	}

	$ret = 0.0;
	foreach( $itemtypes as $i ) {
		if( $i['item_type_id'] == ITID_INDEX
			|| $i['item_type_id'] == ITID_BINDER )
			continue;
		$modname = $i['name'];
		global $xoopsDB;

		$table = $xoopsDB->prefix( "${modname}_item_detail" );
		$id_name = preg_replace( '/^xnp/', '', $modname )."_id";
		$query =
			"SELECT ${id_name} FROM $table where ${id_name} IN (".implode( ", ",
																		   $iids ).
			")";
		$result = $xoopsDB->query( $query );
		if( $result ) {
			$mod_iids = array(  );
			while( list( $id ) = $xoopsDB->fetchRow( $result ) ) {
				$mod_iids[] = $id;
			}
			include_once "../$modname/include/view.php";
			$fname = "${modname}GetDetailInformationTotalSize";
			if( function_exists( $fname ) ) {
				$ret += $fname( $mod_iids );
			}
		}
	}
	return $ret;
}

/**
 * 
 * how many items can be registered more to private index?
 * 
 * @return available space for register item( in a number of items )
 * 
 */
function available_space_of_private_item(  )
{
	$xnpsid = $_SESSION['XNPSID'];
	$uid = $_SESSION['xoopsUserId'];
	$account = array(  );
	if( xnp_get_account( $xnpsid, $uid, $account ) == RES_OK ) {
		$iids = array(  );
		if( xnp_get_private_item_id( $xnpsid, $uid, $iids ) == RES_OK ) {
			return max( 0, $account['item_number_limit'] - count( $iids ) );
		}
	}
	return 0;
}

/**
 * 
 * private_item_storage_limit <= file size of all attachment files registered in private area(not public)
 * : return false.
 * 
 */
function
check_private_item_storage_limit(  )
{
	$xnpsid = $_SESSION['XNPSID'];
	$uid = $_SESSION['xoopsUserId'];
	$account = array(  );
	if( xnp_get_account( $xnpsid, $uid, $account ) == RES_OK ) {
		if( filesize_private(  ) >= $account['item_storage_limit'] ) {
			return FALSE;
		}
	}
	return TRUE;
}


/**
 * 
 * how many items can be registered more to group index ?
 * 
 * @param gid id of group to be checked
 * @return available space for register item( in a number of items )
 * 
 */
function available_space_of_group_item( $gid )
{
	$xnpsid = $_SESSION['XNPSID'];
	$group = array(  );
	if( xnp_get_group( $xnpsid, $gid, $group ) == RES_OK ) {
		$iids = array(  );
		if( xnp_get_group_item_id( $xnpsid, $gid, $iids ) == RES_OK ) {
			return max( 0, $group['item_number_limit'] - count( $iids ) );
		}
	}
	return 0;
}

/**
 * 
 * groupde_item_storage_limit <= file size of all attachment files registered in group area
 * : return false
 * @param gid id of group to be checked
 * @return true if available space is enough. 
 *
 */
function
check_group_item_storage_limit( $gid )
{
	$xnpsid = $_SESSION['XNPSID'];
	$group = array(  );
	if( xnp_get_group( $xnpsid, $gid, $group ) == RES_OK ) {
		if( filesize_group( $gid ) >= $group['item_storage_limit'] ) {
			return FALSE;
		}
	}
	return TRUE;
}
?>
